/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.service.common;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sip.SipProvider;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbID;
import javax.slee.facilities.Tracer;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;
import net.java.slee.resource.mgcp.JainMgcpProvider;
import net.java.slee.resource.mgcp.MgcpActivityContextInterfaceFactory;
import net.java.slee.resource.sip.SipActivityContextInterfaceFactory;
import org.mobicents.slee.util.CacheException;
import org.mobicents.slee.util.CacheFactory;
import org.mobicents.slee.util.CacheUtility;
import org.mobicents.slee.util.SipUtils;
import org.mobicents.slee.util.SipUtilsFactorySingleton;

public abstract class CommonSbb
implements Sbb {
    public static final String JBOSS_BIND_ADDRESS = System.getProperty("jboss.bind.address", "127.0.0.1");
    public static final int MGCP_PEER_PORT = 2427;
    public static final int MGCP_PORT = 2727;
    private CacheUtility cache;
    private SbbID sbbId;
    private SbbContext sbbContext;
    private NullActivityContextInterfaceFactory nullACIFactory;
    private NullActivityFactory nullActivityFactory;
    private SipUtils sipUtils;
    private SipProvider sipProvider;
    private SipActivityContextInterfaceFactory sipActivityContextInterfaceFactory;
    private MgcpActivityContextInterfaceFactory mgcpActivityContestInterfaceFactory;
    private JainMgcpProvider mgcpProvider;
    private Tracer logger = null;

    public void setSbbContext(SbbContext sbbContext) {
        this.logger = sbbContext.getTracer("Common");
        this.sbbContext = sbbContext;
        this.sbbId = sbbContext.getSbb();
        try {
            this.cache = CacheFactory.getInstance().getCache();
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Got Cache instance!");
            }
            Context ctx = (Context)new InitialContext().lookup("java:comp/env");
            this.nullACIFactory = (NullActivityContextInterfaceFactory)ctx.lookup("slee/nullactivity/activitycontextinterfacefactory");
            this.nullActivityFactory = (NullActivityFactory)ctx.lookup("slee/nullactivity/factory");
            this.sipUtils = SipUtilsFactorySingleton.getInstance().getSipUtils();
            this.sipProvider = (SipProvider)ctx.lookup("slee/resources/jainsip/1.2/provider");
            this.sipActivityContextInterfaceFactory = (SipActivityContextInterfaceFactory)ctx.lookup("slee/resources/jainsip/1.2/acifactory");
            this.mgcpProvider = (JainMgcpProvider)ctx.lookup("slee/resources/jainmgcp/2.0/provider/demo");
            this.mgcpActivityContestInterfaceFactory = (MgcpActivityContextInterfaceFactory)ctx.lookup("slee/resources/jainmgcp/2.0/acifactory/demo");
        }
        catch (NamingException ne) {
            this.logger.severe("NamingException in CommonSbb", (Throwable)ne);
        }
        catch (CacheException ce) {
            this.logger.severe("CacheException while trying to create Cahe", (Throwable)ce);
        }
    }

    public void unsetSbbContext() {
        this.logger.info("CommonSbb: " + this + ": unsetSbbContext() called.");
    }

    public void sbbCreate() throws CreateException {
        this.logger.info("CommonSbb: " + this + ": sbbCreate() called.");
    }

    public void sbbPostCreate() throws CreateException {
        this.logger.info("CommonSbb: " + this + ": sbbPostCreate() called.");
    }

    public void sbbActivate() {
        this.logger.info("CommonSbb: " + this + ": sbbActivate() called.");
    }

    public void sbbPassivate() {
        this.logger.info("CommonSbb: " + this + ": sbbPassivate() called.");
    }

    public void sbbRemove() {
        this.logger.info("CommonSbb: " + this + ": sbbRemove() called.");
    }

    public void sbbLoad() {
        this.logger.info("CommonSbb: " + this + ": sbbLoad() called.");
    }

    public void sbbStore() {
        this.logger.info("CommonSbb: " + this + ": sbbStore() called.");
    }

    public void sbbRolledBack(RolledBackContext rolledBackContext) {
        this.logger.info("CommonSbb: " + this + ": sbbRolledBack() called.");
    }

    public void sbbExceptionThrown(Exception exception, Object obj, ActivityContextInterface activityContextInterface) {
        this.logger.info("CommonSbb: " + this + ": sbbExceptionThrown() called.");
    }

    protected SbbContext getSbbContext() {
        return this.sbbContext;
    }

    protected NullActivityContextInterfaceFactory getNullACIFactory() {
        return this.nullACIFactory;
    }

    protected NullActivityFactory getNullActivityFactory() {
        return this.nullActivityFactory;
    }

    protected SipUtils getSipUtils() {
        return this.sipUtils;
    }

    protected SipProvider getSipProvider() {
        return this.sipProvider;
    }

    protected SipActivityContextInterfaceFactory getSipActivityContextInterfaceFactory() {
        return this.sipActivityContextInterfaceFactory;
    }

    protected CacheUtility getCacheUtility() {
        return this.cache;
    }

    public MgcpActivityContextInterfaceFactory getMgcpActivityContestInterfaceFactory() {
        return this.mgcpActivityContestInterfaceFactory;
    }

    public JainMgcpProvider getMgcpProvider() {
        return this.mgcpProvider;
    }
}

