/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.service.user.delivery;

import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.NotificationRequestResponse;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.sql.Timestamp;
import java.text.ParseException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.header.CallIdHeader;
import javax.sip.header.Header;
import javax.sip.message.Request;
import javax.slee.ActivityContextInterface;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.InitialEventSelector;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.UnrecognizedActivityException;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerID;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.Tracer;
import javax.slee.nullactivity.NullActivity;
import net.java.slee.resource.sip.DialogActivity;
import org.mobicents.examples.convergeddemo.seam.pojo.Order;
import org.mobicents.slee.service.callcontrol.CallControlSbbLocalObject;
import org.mobicents.slee.service.common.CommonSbb;
import org.mobicents.slee.service.events.CustomEvent;
import org.mobicents.slee.util.Session;
import org.mobicents.slee.util.SessionAssociation;

public abstract class OrderDeliverDateSbb
extends CommonSbb {
    private Tracer logger = null;
    private EntityManagerFactory emf;
    private TimerFacility timerFacility = null;
    private final String orderDeliveryDate = "audio/UserOrderDeliveryDate.wav";
    String audioFilePath = null;
    String callerSip = null;

    public void setSbbContext(SbbContext context) {
        this.logger = context.getTracer("OrderDeliverDate");
        super.setSbbContext(context);
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            this.audioFilePath = System.getProperty("jboss.server.data.dir");
            this.callerSip = (String)myEnv.lookup("callerSip");
            this.timerFacility = (TimerFacility)myEnv.lookup("slee/facilities/timer");
            InitialContext newIc = new InitialContext();
            this.emf = (EntityManagerFactory)newIc.lookup("java:/ShoppingDemoSleeEntityManagerFactory");
        }
        catch (NamingException ne) {
            ne.printStackTrace();
        }
    }

    public void onOrderCancelled(CustomEvent event, ActivityContextInterface ac) {
        this.logger.info("======== OrderDeliverDateSbb ORDER_CANCELLED ========");
        if (this.getTimerID() != null) {
            this.timerFacility.cancelTimer(this.getTimerID());
        }
        ActivityContextInterface[] activities = this.getSbbContext().getActivities();
        for (int i = 0; i < activities.length; ++i) {
            if (!(activities[i].getActivity() instanceof NullActivity)) continue;
            activities[i].detach(this.getSbbContext().getSbbLocalObject());
        }
    }

    public void onOrderApproved(CustomEvent event, ActivityContextInterface ac) {
        this.logger.info("======== OrderDeliverDateSbb ORDER_APPROVED ========");
        this.setCustomEvent(event);
        this.setTimer(ac, 30000);
    }

    public void onOrderProcessed(CustomEvent event, ActivityContextInterface ac) {
        this.logger.info("======== OrderDeliverDateSbb ORDER_PROCESSED ========");
        this.setCustomEvent(event);
        this.setTimer(ac, 30000);
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        this.logger.info("Timer fired calling makeCall");
        aci.detach(this.getSbbContext().getSbbLocalObject());
        this.makeCall();
    }

    private void setTimer(ActivityContextInterface ac, int duration) {
        TimerOptions options = new TimerOptions();
        options.setPersistent(true);
        TimerID timerID = this.timerFacility.setTimer(ac, null, System.currentTimeMillis() + (long)duration, options);
        this.setTimerID(timerID);
    }

    private void makeCall() {
        CustomEvent event = this.getCustomEvent();
        this.setDateAndTime("");
        try {
            Address callerAddress = this.getSipUtils().convertURIToAddress(this.callerSip);
            callerAddress.setDisplayName(this.callerSip);
            Address calleeAddress = this.getSipUtils().convertURIToAddress(event.getCustomerPhone());
            Request request = this.getSipUtils().buildInvite(callerAddress, calleeAddress, null, 1);
            ClientTransaction ct = this.getSipProvider().getNewClientTransaction(request);
            Header h = ct.getRequest().getHeader("Call-ID");
            String calleeCallId = ((CallIdHeader)h).getCallId();
            SessionAssociation sa = new SessionAssociation("org.mobicents.slee.service.callcontrol.CallControlSbb$InitialState");
            Session calleeSession = new Session(calleeCallId);
            calleeSession.setSipAddress(calleeAddress);
            calleeSession.setToBeCancelledClientTransaction(ct);
            Dialog dialog = ct.getDialog();
            if (dialog != null && this.logger.isFineEnabled()) {
                this.logger.fine("Obtained dialog from ClientTransaction : automatic dialog support on");
            }
            if (dialog == null) {
                try {
                    dialog = this.getSipProvider().getNewDialog((Transaction)ct);
                    if (this.logger.isFineEnabled()) {
                        this.logger.fine("Obtained dialog for INVITE request to callee with getNewDialog");
                    }
                }
                catch (Exception e) {
                    this.logger.severe("Error getting dialog", (Throwable)e);
                }
            }
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Obtained dialog in onThirdPCCTriggerEvent : callId = " + dialog.getCallId().getCallId());
            }
            ActivityContextInterface sipACI = this.getSipActivityContextInterfaceFactory().getActivityContextInterface((DialogActivity)dialog);
            ActivityContextInterface clientSipACI = this.getSipActivityContextInterfaceFactory().getActivityContextInterface(ct);
            calleeSession.setDialog(dialog);
            sa.setCalleeSession(calleeSession);
            Session callerSession = new Session();
            callerAddress = this.getSipUtils().convertURIToAddress(this.callerSip);
            callerSession.setSipAddress(callerAddress);
            callerSession.setToBeCancelledClientTransaction(null);
            sa.setCallerSession(callerSession);
            this.getCacheUtility().put(calleeCallId, sa);
            ChildRelation relation = this.getCallControlSbbChild();
            CallControlSbbLocalObject child = (CallControlSbbLocalObject)relation.create();
            this.setChildSbbLocalObject(child);
            child.setParent(this.getSbbContext().getSbbLocalObject());
            sipACI.attach((SbbLocalObject)child);
            clientSipACI.attach((SbbLocalObject)child);
            sipACI.attach(this.getSbbContext().getSbbLocalObject());
            ct.sendRequest();
        }
        catch (ParseException parExc) {
            this.logger.severe("Parse Exception while parsing the callerAddess", (Throwable)parExc);
        }
        catch (InvalidArgumentException invalidArgExcep) {
            this.logger.severe("InvalidArgumentException while building Invite Request", (Throwable)invalidArgExcep);
        }
        catch (TransactionUnavailableException tranUnavExce) {
            this.logger.severe("TransactionUnavailableException when trying to getNewClientTransaction", (Throwable)tranUnavExce);
        }
        catch (UnrecognizedActivityException e) {
            this.logger.severe("UnrecognizedActivityException when trying to getActivityContextInterface", (Throwable)e);
        }
        catch (CreateException creaExce) {
            this.logger.severe("CreateException while trying to create Child", (Throwable)creaExce);
        }
        catch (SipException sipExec) {
            this.logger.severe("SipException while trying to send INVITE Request", (Throwable)sipExec);
        }
    }

    public void onNotificationRequestResponse(NotificationRequestResponse event, ActivityContextInterface aci) {
        this.logger.info("onNotificationRequestResponse");
        ReturnCode status = event.getReturnCode();
        switch (status.getValue()) {
            case 200: {
                this.logger.info("The Announcement should have been started");
                break;
            }
            default: {
                ReturnCode rc = event.getReturnCode();
                this.logger.severe("RQNT failed. Value = " + rc.getValue() + " Comment = " + rc.getComment());
                if (!this.getChildSbbLocalObject().getSendBye()) break;
                this.getChildSbbLocalObject().sendBye();
            }
        }
    }

    public void onNotifyRequest(Notify event, ActivityContextInterface aci) {
        this.logger.info("onNotifyRequest");
        NotificationRequestResponse response = new NotificationRequestResponse(event.getSource(), ReturnCode.Transaction_Executed_Normally);
        response.setTransactionHandle(event.getTransactionHandle());
        this.getMgcpProvider().sendMgcpEvents(new JainMgcpEvent[]{response});
        EventName[] observedEvents = event.getObservedEvents();
        boolean success = false;
        block14: for (EventName observedEvent : observedEvents) {
            switch (observedEvent.getEventIdentifier().intValue()) {
                case 62: {
                    this.logger.info("Announcemnet Completed NTFY received");
                    if (!this.getSendBye() || !this.getChildSbbLocalObject().getSendBye()) continue block14;
                    this.getChildSbbLocalObject().sendBye();
                    continue block14;
                }
                case 63: {
                    this.logger.info("Announcemnet Failed received");
                    if (!this.getChildSbbLocalObject().getSendBye()) continue block14;
                    this.getChildSbbLocalObject().sendBye();
                    continue block14;
                }
                case 17: {
                    this.logger.info("You have pressed 0");
                }
                case 18: {
                    this.logger.info("You have pressed 1");
                }
                case 19: {
                    this.logger.info("You have pressed 2");
                }
                case 20: {
                    this.logger.info("You have pressed 3");
                }
                case 21: {
                    this.logger.info("You have pressed 4");
                }
                case 22: {
                    this.logger.info("You have pressed 5");
                }
                case 23: {
                    this.logger.info("You have pressed 6");
                }
                case 24: {
                    this.logger.info("You have pressed 7");
                }
                case 25: {
                    this.logger.info("You have pressed 8");
                }
                case 26: {
                    this.logger.info("You have pressed 9");
                    this.processDtmf(observedEvent);
                }
                default: {
                    this.logger.info("Received undefined event.");
                }
            }
        }
        if (success) {
            this.setSendBye(success);
        }
    }

    private void processDtmf(EventName event) {
        String dateAndTime = this.getDateAndTime();
        boolean success = false;
        switch (event.getEventIdentifier().intValue()) {
            case 17: {
                dateAndTime = dateAndTime + "0";
                break;
            }
            case 18: {
                dateAndTime = dateAndTime + "1";
                break;
            }
            case 19: {
                dateAndTime = dateAndTime + "2";
                break;
            }
            case 20: {
                dateAndTime = dateAndTime + "3";
                break;
            }
            case 21: {
                dateAndTime = dateAndTime + "4";
                break;
            }
            case 22: {
                dateAndTime = dateAndTime + "5";
                break;
            }
            case 23: {
                dateAndTime = dateAndTime + "6";
                break;
            }
            case 24: {
                dateAndTime = dateAndTime + "7";
                break;
            }
            case 25: {
                dateAndTime = dateAndTime + "8";
                break;
            }
            case 26: {
                dateAndTime = dateAndTime + "10";
                break;
            }
            default: {
                this.logger.info("Received undefined DTMF digit().");
            }
        }
        if (dateAndTime.length() == 10) {
            EntityManager mgr = null;
            Order order = null;
            char[] c = dateAndTime.toCharArray();
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("You have selected delivery date to be ");
            String date = "" + c[0] + c[1];
            int iDate = new Integer(date);
            stringBuffer.append(iDate);
            String month = "" + c[2] + c[3];
            int iMonth = new Integer(month);
            String year = "" + c[4] + c[5];
            int iYear = new Integer(year);
            String hour = "" + c[6] + c[7];
            int iHour = new Integer(hour);
            String min = "" + c[8] + c[9];
            int iMin = new Integer(min);
            switch (iMonth) {
                case 1: {
                    month = "January";
                    break;
                }
                case 2: {
                    month = "February";
                    break;
                }
                case 3: {
                    month = "March";
                    break;
                }
                case 4: {
                    month = "April";
                    break;
                }
                case 5: {
                    month = "May";
                    break;
                }
                case 6: {
                    month = "June";
                    break;
                }
                case 7: {
                    month = "July";
                    break;
                }
                case 8: {
                    month = "August";
                    break;
                }
                case 9: {
                    month = "September";
                    break;
                }
                case 10: {
                    month = "October";
                    break;
                }
                case 11: {
                    month = "November";
                    break;
                }
                case 12: {
                    month = "December";
                    break;
                }
            }
            stringBuffer.append(" of ");
            stringBuffer.append(month);
            stringBuffer.append(" ");
            stringBuffer.append(2000 + iYear);
            stringBuffer.append(" at ");
            stringBuffer.append(iHour);
            stringBuffer.append(" hour and ");
            stringBuffer.append(iMin);
            stringBuffer.append(" minute. Thank you. Bye.");
            Timestamp timeStamp = new Timestamp(iYear + 100, iMonth - 1, iDate, iHour, iMin, 0, 0);
            mgr = this.emf.createEntityManager();
            order = (Order)mgr.createQuery("select o from Order o where o.orderId = :orderId").setParameter("orderId", (Object)this.getCustomEvent().getOrderId()).getSingleResult();
            order.setDeliveryDate(timeStamp);
            mgr.flush();
            mgr.close();
            success = true;
            this.getChildSbbLocalObject().sendRQNT(stringBuffer.toString(), null, false);
        } else {
            this.setDateAndTime(dateAndTime);
        }
        if (success) {
            this.setSendBye(success);
        }
    }

    public void onCreateConnectionResponse(CreateConnectionResponse event, ActivityContextInterface aci) {
        if (event.getSecondEndpointIdentifier() != null) {
            String announcementFile = this.getClass().getResource("audio/UserOrderDeliveryDate.wav").toString();
            this.getChildSbbLocalObject().sendRQNT(null, announcementFile, true);
        }
    }

    public InitialEventSelector orderIdSelect(InitialEventSelector ies) {
        Object event = ies.getEvent();
        long orderId = 0L;
        if (!(event instanceof CustomEvent)) {
            ies.setActivityContextSelected(true);
            return ies;
        }
        orderId = ((CustomEvent)event).getOrderId();
        if (this.logger.isFineEnabled()) {
            this.logger.severe("Setting convergence name to: " + orderId);
        }
        ies.setCustomName(String.valueOf(orderId));
        return ies;
    }

    public abstract ChildRelation getCallControlSbbChild();

    public abstract void setCustomEvent(CustomEvent var1);

    public abstract CustomEvent getCustomEvent();

    public abstract void setSendBye(boolean var1);

    public abstract boolean getSendBye();

    public abstract void setDateAndTime(String var1);

    public abstract String getDateAndTime();

    public abstract void setTimerID(TimerID var1);

    public abstract TimerID getTimerID();

    public abstract void setChildSbbLocalObject(CallControlSbbLocalObject var1);

    public abstract CallControlSbbLocalObject getChildSbbLocalObject();
}

