/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.service.user.ship;

import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.NotificationRequestResponse;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.sql.Timestamp;
import java.text.ParseException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.header.CallIdHeader;
import javax.sip.header.Header;
import javax.sip.message.Request;
import javax.slee.ActivityContextInterface;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.UnrecognizedActivityException;
import javax.slee.facilities.Tracer;
import net.java.slee.resource.sip.DialogActivity;
import org.mobicents.examples.convergeddemo.seam.pojo.Order;
import org.mobicents.slee.service.callcontrol.CallControlSbbLocalObject;
import org.mobicents.slee.service.common.CommonSbb;
import org.mobicents.slee.service.events.CustomEvent;
import org.mobicents.slee.util.Session;
import org.mobicents.slee.util.SessionAssociation;

public abstract class OrderShipDateSbb
extends CommonSbb {
    private Tracer logger = null;
    private EntityManagerFactory emf;
    String callerSip = null;

    public void setSbbContext(SbbContext context) {
        this.logger = context.getTracer("OrderShipDate");
        super.setSbbContext(context);
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            this.callerSip = (String)myEnv.lookup("callerSip");
            InitialContext newIc = new InitialContext();
            this.emf = (EntityManagerFactory)newIc.lookup("java:/ShoppingDemoSleeEntityManagerFactory");
        }
        catch (NamingException ne) {
            ne.printStackTrace();
        }
    }

    public void onOrderShipped(CustomEvent event, ActivityContextInterface ac) {
        this.logger.info("======== OrderShipDateSbb ORDER_SHIPPED ========");
        ac.detach(this.getSbbContext().getSbbLocalObject());
        this.makeCall(event, ac);
    }

    private void makeCall(CustomEvent event, ActivityContextInterface ac) {
        EntityManager mgr = null;
        Order order = null;
        this.setCustomEvent(event);
        mgr = this.emf.createEntityManager();
        order = (Order)mgr.createQuery("select o from Order o where o.orderId = :orderId").setParameter("orderId", (Object)this.getCustomEvent().getOrderId()).getSingleResult();
        Timestamp orderDate = order.getDeliveryDate();
        mgr.close();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Welcome ");
        stringBuffer.append(event.getCustomerName());
        stringBuffer.append(". This is a reminedr call for your order number ");
        stringBuffer.append(event.getOrderId());
        stringBuffer.append(". The shippment will be at your door step on .");
        stringBuffer.append(orderDate.getDate());
        stringBuffer.append(" of ");
        String month = null;
        switch (orderDate.getMonth()) {
            case 0: {
                month = "January";
                break;
            }
            case 1: {
                month = "February";
                break;
            }
            case 2: {
                month = "March";
                break;
            }
            case 3: {
                month = "April";
                break;
            }
            case 4: {
                month = "May";
                break;
            }
            case 5: {
                month = "June";
                break;
            }
            case 6: {
                month = "July";
                break;
            }
            case 7: {
                month = "August";
                break;
            }
            case 8: {
                month = "September";
                break;
            }
            case 9: {
                month = "October";
                break;
            }
            case 10: {
                month = "November";
                break;
            }
            case 11: {
                month = "December";
                break;
            }
        }
        stringBuffer.append(month);
        stringBuffer.append(" ");
        stringBuffer.append(1900 + orderDate.getYear());
        stringBuffer.append(" at ");
        stringBuffer.append(orderDate.getHours());
        stringBuffer.append(" hour and ");
        stringBuffer.append(orderDate.getMinutes());
        stringBuffer.append(" minute. Thank you. Bye.");
        this.setTtsString(stringBuffer.toString());
        try {
            Address callerAddress = this.getSipUtils().convertURIToAddress(this.callerSip);
            callerAddress.setDisplayName(this.callerSip);
            Address calleeAddress = this.getSipUtils().convertURIToAddress(event.getCustomerPhone());
            Request request = this.getSipUtils().buildInvite(callerAddress, calleeAddress, null, 1);
            ClientTransaction ct = this.getSipProvider().getNewClientTransaction(request);
            Header h = ct.getRequest().getHeader("Call-ID");
            String calleeCallId = ((CallIdHeader)h).getCallId();
            SessionAssociation sa = new SessionAssociation("org.mobicents.slee.service.callcontrol.CallControlSbb$InitialState");
            Session calleeSession = new Session(calleeCallId);
            calleeSession.setSipAddress(calleeAddress);
            calleeSession.setToBeCancelledClientTransaction(ct);
            Dialog dialog = ct.getDialog();
            if (dialog != null && this.logger.isFineEnabled()) {
                this.logger.fine("Obtained dialog from ClientTransaction : automatic dialog support on");
            }
            if (dialog == null) {
                try {
                    dialog = this.getSipProvider().getNewDialog((Transaction)ct);
                    if (this.logger.isFineEnabled()) {
                        this.logger.fine("Obtained dialog for INVITE request to callee with getNewDialog");
                    }
                }
                catch (Exception e) {
                    this.logger.severe("Error getting dialog", (Throwable)e);
                }
            }
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Obtained dialog in onThirdPCCTriggerEvent : callId = " + dialog.getCallId().getCallId());
            }
            ActivityContextInterface sipACI = this.getSipActivityContextInterfaceFactory().getActivityContextInterface((DialogActivity)dialog);
            ActivityContextInterface clientSipACI = this.getSipActivityContextInterfaceFactory().getActivityContextInterface(ct);
            calleeSession.setDialog(dialog);
            sa.setCalleeSession(calleeSession);
            Session callerSession = new Session();
            callerAddress = this.getSipUtils().convertURIToAddress(this.callerSip);
            callerSession.setSipAddress(callerAddress);
            callerSession.setToBeCancelledClientTransaction(null);
            sa.setCallerSession(callerSession);
            this.getCacheUtility().put(calleeCallId, sa);
            ChildRelation relation = this.getCallControlSbbChild();
            CallControlSbbLocalObject child = (CallControlSbbLocalObject)relation.create();
            this.setChildSbbLocalObject(child);
            child.setParent(this.getSbbContext().getSbbLocalObject());
            sipACI.attach((SbbLocalObject)child);
            clientSipACI.attach((SbbLocalObject)child);
            sipACI.attach(this.getSbbContext().getSbbLocalObject());
            ct.sendRequest();
        }
        catch (ParseException parExc) {
            this.logger.severe("Parse Exception while parsing the callerAddess", (Throwable)parExc);
        }
        catch (InvalidArgumentException invalidArgExcep) {
            this.logger.severe("InvalidArgumentException while building Invite Request", (Throwable)invalidArgExcep);
        }
        catch (TransactionUnavailableException tranUnavExce) {
            this.logger.severe("TransactionUnavailableException when trying to getNewClientTransaction", (Throwable)tranUnavExce);
        }
        catch (UnrecognizedActivityException e) {
            this.logger.severe("UnrecognizedActivityException when trying to getActivityContextInterface", (Throwable)e);
        }
        catch (CreateException creaExce) {
            this.logger.severe("CreateException while trying to create Child", (Throwable)creaExce);
        }
        catch (SipException sipExec) {
            this.logger.severe("SipException while trying to send INVITE Request", (Throwable)sipExec);
        }
    }

    public void onCreateConnectionResponse(CreateConnectionResponse event, ActivityContextInterface aci) {
        if (event.getSecondEndpointIdentifier() != null) {
            this.getChildSbbLocalObject().sendRQNT(this.getTtsString(), null, true);
            this.setTtsString(null);
        }
    }

    public void onNotificationRequestResponse(NotificationRequestResponse event, ActivityContextInterface aci) {
        this.logger.info("onNotificationRequestResponse");
        ReturnCode status = event.getReturnCode();
        switch (status.getValue()) {
            case 200: {
                this.logger.info("The Announcement should have been started");
                break;
            }
            default: {
                ReturnCode rc = event.getReturnCode();
                this.logger.severe("RQNT failed. Value = " + rc.getValue() + " Comment = " + rc.getComment());
                if (!this.getChildSbbLocalObject().getSendBye()) break;
                this.getChildSbbLocalObject().sendBye();
            }
        }
    }

    public void onNotifyRequest(Notify event, ActivityContextInterface aci) {
        EventName[] observedEvents;
        this.logger.info("onNotifyRequest");
        NotificationRequestResponse response = new NotificationRequestResponse(event.getSource(), ReturnCode.Transaction_Executed_Normally);
        response.setTransactionHandle(event.getTransactionHandle());
        this.getMgcpProvider().sendMgcpEvents(new JainMgcpEvent[]{response});
        block4: for (EventName observedEvent : observedEvents = event.getObservedEvents()) {
            switch (observedEvent.getEventIdentifier().intValue()) {
                case 62: {
                    this.logger.info("Announcemnet Completed NTFY received");
                    if (!this.getChildSbbLocalObject().getSendBye()) continue block4;
                    this.getChildSbbLocalObject().sendBye();
                    continue block4;
                }
                case 63: {
                    this.logger.info("Announcemnet Failed received");
                    if (!this.getChildSbbLocalObject().getSendBye()) continue block4;
                    this.getChildSbbLocalObject().sendBye();
                    continue block4;
                }
                default: {
                    this.logger.info("Received undefined event.");
                }
            }
        }
    }

    public abstract ChildRelation getCallControlSbbChild();

    public abstract void setCustomEvent(CustomEvent var1);

    public abstract CustomEvent getCustomEvent();

    public abstract void setChildSbbLocalObject(CallControlSbbLocalObject var1);

    public abstract CallControlSbbLocalObject getChildSbbLocalObject();

    public abstract void setTtsString(String var1);

    public abstract String getTtsString();
}

