/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.util;

import java.io.Serializable;
import org.mobicents.slee.util.Session;
import org.mobicents.slee.util.StateCallback;

public class SessionAssociation
implements Serializable {
    private static final long serialVersionUID = 3618984494431088949L;
    private String state;
    private Session callerSession;
    private Session calleeSession;
    private StateCallback stateCallback;

    public SessionAssociation(String state) {
        this.state = state;
    }

    public Session getSession(String callId) {
        Session retVal = null;
        if (callId == null) {
            throw new IllegalArgumentException("Argument callId must not be null");
        }
        retVal = callId.equals(this.callerSession.getCallId()) ? this.callerSession : this.calleeSession;
        return retVal;
    }

    public Session getPeerSession(String callId) {
        Session retVal = null;
        retVal = this.calleeSession.getCallId().equals(callId) ? this.callerSession : this.calleeSession;
        return retVal;
    }

    public Session getCalleeSession() {
        return this.calleeSession;
    }

    public void setCalleeSession(Session calleeSession) {
        this.calleeSession = calleeSession;
    }

    public Session getCallerSession() {
        return this.callerSession;
    }

    public void setCallerSession(Session callerSession) {
        this.callerSession = callerSession;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String toString() {
        return "SessionAssociation: [state:" + this.state + ", callerSession:" + this.callerSession + ", calleeSession:" + this.calleeSession + "]";
    }

    public StateCallback getStateCallback() {
        return this.stateCallback;
    }

    public void setStateCallback(StateCallback stateCallback) {
        this.stateCallback = stateCallback;
    }
}

