/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.util;

import java.net.URISyntaxException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionUnavailableException;
import javax.sip.TransportNotSupportedException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.AuthorizationHeader;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentLengthHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ProxyAuthenticateHeader;
import javax.sip.header.ProxyAuthorizationHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.header.WWWAuthenticateHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import net.java.slee.resource.sip.SleeSipProvider;
import org.apache.log4j.Logger;
import org.mobicents.slee.util.SipUtils;

public class SipUtilsImpl
implements SipUtils {
    private static Logger log = Logger.getLogger(SipUtilsImpl.class);
    private SleeSipProvider sipProvider;
    private HeaderFactory headerFactory;
    private MessageFactory messageFactory;
    private AddressFactory addressFactory;
    private final char[] toHex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public SipUtilsImpl(SleeSipProvider sipProvider, HeaderFactory headerFactory, MessageFactory messageFactory, AddressFactory addressFactory) {
        this.sipProvider = sipProvider;
        this.headerFactory = headerFactory;
        this.messageFactory = messageFactory;
        this.addressFactory = addressFactory;
    }

    public Dialog getDialog(ResponseEvent event) throws SipException {
        Dialog retVal = null;
        if (event.getDialog() == null) {
            log.error((Object)("responseEvent.getDialog returned null, if AUTOMATIC_DIALOG_SUPPORT is disabled you must obtain a dialog before the first sip response arrives: " + event.getClientTransaction().getDialog()));
            throw new SipException("responseEvent.getDialog returned null, if AUTOMATIC_DIALOG_SUPPORT is disabled you must obtain a dialog before the first sip response arrives");
        }
        retVal = event.getDialog();
        log.debug((Object)"Returning dialog in getDialog(ResponseEvent) obtained directly from ResponseEvent");
        return retVal;
    }

    public Dialog getDialog(RequestEvent event) throws SipException {
        Dialog retVal = null;
        try {
            retVal = event.getDialog() == null ? this.sipProvider.getNewDialog((Transaction)event.getServerTransaction()) : event.getDialog();
        }
        catch (SipException ex) {
            log.error((Object)"Exception in creating a new dialog in getDialog(RequestEvent)", (Throwable)ex);
            throw ex;
        }
        return retVal;
    }

    public String generateTag() {
        String tag = new Integer((int)(Math.random() * 10000.0)).toString();
        return tag;
    }

    private String toHexString(byte[] b) {
        int pos = 0;
        char[] c = new char[b.length * 2];
        for (int i = 0; i < b.length; ++i) {
            c[pos++] = this.toHex[b[i] >> 4 & 0xF];
            c[pos++] = this.toHex[b[i] & 0xF];
        }
        return new String(c);
    }

    private AddressFactory getAddressFactory() {
        AddressFactory addressFactory = null;
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            SleeSipProvider factoryProvider = (SleeSipProvider)myEnv.lookup("slee/resources/jainsip/1.2/provider");
            addressFactory = factoryProvider.getAddressFactory();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return addressFactory;
    }

    public Address convertURIToAddress(String uri) {
        SipURI sipURI = this.convertURIToSipURI(uri);
        return this.getAddressFactory().createAddress((URI)sipURI);
    }

    public SipURI convertURIToSipURI(String uri) {
        String[] sipUserAndHost = null;
        SipURI sipURI = null;
        try {
            sipUserAndHost = this.parseSipUri(uri);
            String sipUser = sipUserAndHost[0];
            String sipHost = sipUserAndHost[1];
            sipURI = this.getAddressFactory().createSipURI(sipUser, sipHost);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return sipURI;
    }

    public String[] parseSipUri(String sipURI) throws URISyntaxException {
        String[] userAndHost = new String[2];
        String sipPrexfix = "sip:";
        String uriSeparator = "@";
        int sipPrefixIndex = sipURI.indexOf("sip:") + 3;
        int uriIndex = sipURI.indexOf("@");
        int nameIndex = sipPrefixIndex + 1;
        int hostIndex = uriIndex + 1;
        if (sipURI.indexOf("sip:") == -1 || sipURI.indexOf("@") == -1 || sipPrefixIndex > uriIndex) {
            throw new URISyntaxException(sipURI, "Malformed URI, the URI must use the format \"sip:user@host\". The incorrect URI was \"" + sipURI + "\".");
        }
        userAndHost[0] = sipURI.substring(nameIndex, uriIndex);
        userAndHost[1] = sipURI.substring(hostIndex);
        return userAndHost;
    }

    public SipURI convertAddressToSipURI(Address address) throws ParseException {
        URI sipURI = address.getURI();
        SipURI retVal = null;
        if (!sipURI.isSipURI()) {
            throw new ParseException("URI was not of type SipURI!", -1);
        }
        retVal = (SipURI)sipURI;
        return retVal;
    }

    public void sendCancel(ClientTransaction ct) throws SipException {
        Request request = ct.createCancel();
        ct = this.sipProvider.getNewClientTransaction(request);
        ct.sendRequest();
    }

    public Request buildInvite(Address fromAddress, Address toAddress, byte[] content, int cSeq) throws ParseException, InvalidArgumentException {
        return this.buildInvite(fromAddress, toAddress, content, cSeq, null);
    }

    public Request buildInvite(Address fromAddress, Address toAddress, byte[] content, int cSeq, String callId) throws ParseException, InvalidArgumentException {
        FromHeader fromHeader = this.headerFactory.createFromHeader(fromAddress, this.generateTag());
        ToHeader toHeader = this.headerFactory.createToHeader(toAddress, null);
        Request request = null;
        CSeqHeader cseqHeader = this.headerFactory.createCSeqHeader(cSeq, "INVITE");
        ArrayList<ViaHeader> viaHeadersList = new ArrayList<ViaHeader>();
        viaHeadersList.add(this.createLocalViaHeader());
        MaxForwardsHeader maxForwardsHeader = this.headerFactory.createMaxForwardsHeader(70);
        SipURI requestURI = this.convertAddressToSipURI(toAddress);
        SipURI fromUri = this.convertAddressToSipURI(fromAddress);
        CallIdHeader callIdHeader = this.sipProvider.getNewCallId();
        if (callId != null && callId.trim().length() > 0) {
            callIdHeader.setCallId(callId);
        }
        request = this.messageFactory.createRequest((URI)requestURI, "INVITE", callIdHeader, cseqHeader, fromHeader, toHeader, viaHeadersList, maxForwardsHeader);
        if (content != null) {
            this.setContent(request, "application", "sdp", content);
        }
        ContactHeader contactHeader = this.createLocalContactHeader(fromUri.getUser());
        request.setHeader((Header)contactHeader);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Contact Header = " + contactHeader));
        }
        return request;
    }

    public ContactHeader createLocalContactHeader(String user) throws ParseException {
        String transport = this.sipProvider.getListeningPoints()[0].getTransport();
        SipURI sipURI = this.sipProvider.getLocalSipURI(transport);
        sipURI.setUser(user);
        sipURI.setTransportParam(transport);
        Address contactAddress = this.addressFactory.createAddress((URI)sipURI);
        ContactHeader contactHeader = this.headerFactory.createContactHeader(contactAddress);
        return contactHeader;
    }

    public ViaHeader createLocalViaHeader() throws ParseException, InvalidArgumentException {
        String transport = this.sipProvider.getListeningPoints()[0].getTransport();
        ViaHeader viaHeader = null;
        try {
            viaHeader = this.sipProvider.getLocalVia(transport, null);
        }
        catch (TransportNotSupportedException e) {
            e.printStackTrace();
        }
        return viaHeader;
    }

    private void setContent(Request request, String contentType, String contentSubType, byte[] content) throws ParseException, InvalidArgumentException {
        ContentTypeHeader contentTypeHeader = this.headerFactory.createContentTypeHeader(contentType, contentSubType);
        request.setContent((Object)content, contentTypeHeader);
        ContentLengthHeader contentLengthHeader = this.headerFactory.createContentLengthHeader(content.length);
        request.setContentLength(contentLengthHeader);
    }

    public Request buildRequestWithAuthorizationHeader(ResponseEvent event, String password) throws TransactionUnavailableException {
        Request request = event.getClientTransaction().getRequest();
        Response response = event.getResponse();
        if (request == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The request that caused the 407 could not be retrieved.");
            }
            return null;
        }
        CSeqHeader cseqHeader = (CSeqHeader)request.getHeader("CSeq");
        FromHeader fromHeaderReq = (FromHeader)request.getHeader("From");
        Address fromAddressReq = fromHeaderReq.getAddress();
        ToHeader toHeader = (ToHeader)request.getHeader("To");
        Address toAddress = toHeader.getAddress();
        Request newRequest = null;
        String callId = ((CallIdHeader)response.getHeader("Call-ID")).getCallId();
        try {
            newRequest = this.buildInvite(fromAddressReq, toAddress, null, cseqHeader.getSequenceNumber() + 1, callId);
        }
        catch (ParseException parseExc) {
            parseExc.printStackTrace();
        }
        catch (InvalidArgumentException invaliArgExc) {
            invaliArgExc.printStackTrace();
        }
        WWWAuthenticateHeader wwwAuthenticateHeader = (WWWAuthenticateHeader)response.getHeader("WWW-Authenticate");
        ProxyAuthenticateHeader proxyAuthenticateHeader = (ProxyAuthenticateHeader)response.getHeader("Proxy-Authenticate");
        String realm = null;
        String nonce = null;
        if (wwwAuthenticateHeader != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"wwwAuthenticateHeader found!");
            }
            realm = wwwAuthenticateHeader.getRealm();
            nonce = wwwAuthenticateHeader.getNonce();
        } else if (proxyAuthenticateHeader != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"ProxyAuthenticateHeader found!");
            }
            realm = proxyAuthenticateHeader.getRealm();
            nonce = proxyAuthenticateHeader.getNonce();
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Neither a ProxyAuthenticateHeader or AuthorizationHeader found!");
            }
            return null;
        }
        String method = cseqHeader.getMethod();
        FromHeader fromHeader = (FromHeader)response.getHeader("From");
        Address address = fromHeader.getAddress();
        String fromHost = null;
        String fromUser = null;
        int fromPort = 0;
        String toHost = null;
        String toUser = null;
        int toPort = 0;
        SipURI fromSipURI = null;
        SipURI toSipURI = null;
        try {
            fromSipURI = this.convertAddressToSipURI(address);
            toSipURI = this.convertAddressToSipURI(toAddress);
        }
        catch (ParseException e2) {
            e2.printStackTrace();
        }
        fromHost = fromSipURI.getHost();
        fromUser = fromSipURI.getUser();
        fromPort = fromSipURI.getPort();
        toHost = toSipURI.getHost();
        toUser = toSipURI.getUser();
        toPort = toSipURI.getPort();
        if (fromPort != -1) {
            fromHost = fromHost + ":" + fromPort;
        }
        SipURI uri = null;
        try {
            uri = this.addressFactory.createSipURI(toUser, toHost);
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        String A1 = fromUser + ":" + realm + ":" + password;
        String A2 = method.toUpperCase() + ":" + uri.toString();
        byte[] mdbytes = md5.digest(A1.getBytes());
        String HA1 = this.toHexString(mdbytes);
        mdbytes = md5.digest(A2.getBytes());
        String HA2 = this.toHexString(mdbytes);
        String KD = HA1 + ":" + nonce + ":" + HA2;
        mdbytes = md5.digest(KD.getBytes());
        if (wwwAuthenticateHeader != null) {
            AuthorizationHeader ah = null;
            try {
                ah = this.headerFactory.createAuthorizationHeader("Digest");
                ah.setUsername(fromUser);
                ah.setRealm(realm);
                ah.setAlgorithm("MD5");
                ah.setURI((URI)uri);
                ah.setNonce(nonce);
                ah.setResponse(this.toHexString(mdbytes));
                newRequest.setHeader((Header)ah);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        } else {
            ProxyAuthorizationHeader pah = null;
            try {
                pah = this.headerFactory.createProxyAuthorizationHeader("Digest");
                pah.setUsername(fromUser);
                pah.setRealm(realm);
                pah.setAlgorithm("MD5");
                pah.setURI((URI)uri);
                pah.setNonce(nonce);
                pah.setResponse(this.toHexString(mdbytes));
                newRequest.setHeader((Header)pah);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
        log.debug((Object)"********* New Request *******************");
        log.debug((Object)newRequest);
        return newRequest;
    }

    public Request buildAck(Dialog dialog, Object content) throws SipException {
        Request ackRequest = null;
        try {
            ackRequest = dialog.createAck(dialog.getLocalSeqNumber());
        }
        catch (InvalidArgumentException invalidArgExc) {
            invalidArgExc.printStackTrace();
        }
        if (content != null) {
            String contentString = null;
            if (content instanceof byte[]) {
                contentString = new String((byte[])content);
            } else if (content instanceof String) {
                contentString = (String)content;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("sendCalleeAck Content = " + contentString));
            }
            byte[] sdpContent = contentString.getBytes();
            try {
                this.setContent(ackRequest, "application", "sdp", sdpContent);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (InvalidArgumentException e) {
                e.printStackTrace();
            }
        }
        return ackRequest;
    }

    public void sendOk(Request request) throws ParseException, SipException {
        Response okResponse = this.messageFactory.createResponse(200, request);
        this.sipProvider.sendResponse(okResponse);
    }

    public void sendStatefulOk(RequestEvent event) throws ParseException, SipException, InvalidArgumentException {
        ServerTransaction tx = event.getServerTransaction();
        Request request = event.getRequest();
        Response response = this.messageFactory.createResponse(200, request);
        tx.sendResponse(response);
    }
}

