/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.service.admin;

import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.NotificationRequestResponse;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.text.ParseException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.header.CallIdHeader;
import javax.sip.header.Header;
import javax.sip.message.Request;
import javax.slee.ActivityContextInterface;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.InitialEventSelector;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.UnrecognizedActivityException;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerID;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.Tracer;
import javax.slee.nullactivity.NullActivity;
import net.java.slee.resource.sip.DialogActivity;
import org.mobicents.examples.convergeddemo.seam.pojo.Order;
import org.mobicents.slee.service.callcontrol.CallControlSbbLocalObject;
import org.mobicents.slee.service.common.CommonSbb;
import org.mobicents.slee.service.events.CustomEvent;
import org.mobicents.slee.util.Session;
import org.mobicents.slee.util.SessionAssociation;

public abstract class AdminSbb
extends CommonSbb {
    private Tracer logger = null;
    private TimerFacility timerFacility = null;
    private EntityManagerFactory emf;
    private final String orderApproved = "audio/AdminOrderApproved.wav";
    private final String orderCancelled = "audio/AdminOrderCancelled.wav";
    private final String orderReConfirm = "audio/AdminReConfirm.wav";
    String audioFilePath = null;
    String callerSip = null;
    String adminSip = null;
    long waitingTime = 0L;

    public void setSbbContext(SbbContext sbbContext) {
        this.logger = sbbContext.getTracer("Admin");
        super.setSbbContext(sbbContext);
        try {
            Context ctx = (Context)new InitialContext().lookup("java:comp/env");
            this.audioFilePath = System.getProperty("jboss.server.data.dir") + "/RecordedAdmin.wav";
            this.callerSip = (String)ctx.lookup("callerSip");
            this.adminSip = (String)ctx.lookup("adminSip");
            this.waitingTime = (Long)ctx.lookup("waitingTiming");
            this.timerFacility = (TimerFacility)ctx.lookup("slee/facilities/timer");
            InitialContext newIc = new InitialContext();
            this.emf = (EntityManagerFactory)newIc.lookup("java:/ShoppingDemoSleeEntityManagerFactory");
        }
        catch (NamingException ne) {
            this.logger.severe("Could not set SBB context: " + ne.toString(), (Throwable)ne);
        }
    }

    public void onOrderPlaced(CustomEvent event, ActivityContextInterface ac) {
        this.logger.info("AdminSbb: " + this + ": received an ORDER_PLACED event. OrderId = " + event.getOrderId() + ". ammount = " + event.getAmmount() + ". Customer Name = " + event.getCustomerName());
        this.setCustomEvent(event);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(event.getCustomerName());
        stringBuffer.append(" has placed an order of $");
        stringBuffer.append(event.getAmmount());
        stringBuffer.append(". Press 1 to approve and 2 to reject.");
        this.setTtsString(stringBuffer.toString());
        this.setSendBye(false);
        this.makeCall(ac);
    }

    public void onOrderCancelled(CustomEvent event, ActivityContextInterface ac) {
        this.logger.info("****** AdminSbb Recieved ORDER_CANCELLED ******");
        this.cancelTimer();
    }

    public void onOrderRejected(CustomEvent event, ActivityContextInterface ac) {
        this.logger.info("****** AdminSbb Recieved ORDER_REJECTED ******* ");
        this.cancelTimer();
    }

    public void onOrderApproved(CustomEvent event, ActivityContextInterface ac) {
        this.logger.info("****** AdminSbb Recieved ORDER_APPROVED ******* ");
        this.cancelTimer();
    }

    public void onBeforeOrderProcessed(CustomEvent event, ActivityContextInterface ac) {
        this.logger.info("AdminSbb: " + this + ": received an BEFORE_ORDER_PROCESSED event. OrderId = " + event.getOrderId() + ". ammount = " + event.getAmmount() + ". Customer Name = " + event.getCustomerName());
        this.setCustomEvent(event);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(event.getCustomerName());
        stringBuffer.append(" has placed an order of $");
        stringBuffer.append(event.getAmmount());
        stringBuffer.append(". Press 1 to approve and 2 to reject.");
        this.setTtsString(stringBuffer.toString());
        this.setTimer(ac);
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        this.logger.info("****** AdminSbb Recieved TimerEvent ******* ");
        this.makeCall(aci);
    }

    private void setTimer(ActivityContextInterface ac) {
        TimerOptions options = new TimerOptions();
        options.setPersistent(true);
        TimerID timerID = this.timerFacility.setTimer(ac, null, System.currentTimeMillis() + this.waitingTime, options);
        this.setTimerID(timerID);
    }

    private void cancelTimer() {
        if (this.getTimerID() != null) {
            this.timerFacility.cancelTimer(this.getTimerID());
        }
        ActivityContextInterface[] activities = this.getSbbContext().getActivities();
        for (int i = 0; i < activities.length; ++i) {
            if (!(activities[i].getActivity() instanceof NullActivity)) continue;
            activities[i].detach(this.getSbbContext().getSbbLocalObject());
        }
    }

    private void makeCall(ActivityContextInterface ac) {
        try {
            Address callerAddress = this.getSipUtils().convertURIToAddress(this.callerSip);
            callerAddress.setDisplayName(this.callerSip);
            Address calleeAddress = this.getSipUtils().convertURIToAddress(this.adminSip);
            Request request = this.getSipUtils().buildInvite(callerAddress, calleeAddress, null, 1);
            ClientTransaction ct = this.getSipProvider().getNewClientTransaction(request);
            Header h = ct.getRequest().getHeader("Call-ID");
            String calleeCallId = ((CallIdHeader)h).getCallId();
            SessionAssociation sa = new SessionAssociation("org.mobicents.slee.service.callcontrol.CallControlSbb$InitialState");
            Session calleeSession = new Session(calleeCallId);
            calleeSession.setSipAddress(calleeAddress);
            calleeSession.setToBeCancelledClientTransaction(ct);
            Dialog dialog = ct.getDialog();
            if (dialog != null && this.logger.isInfoEnabled()) {
                this.logger.info("Obtained dialog from ClientTransaction : automatic dialog support on");
            }
            if (dialog == null) {
                try {
                    dialog = this.getSipProvider().getNewDialog((Transaction)ct);
                    if (this.logger.isInfoEnabled()) {
                        this.logger.info("Obtained dialog for INVITE request to callee with getNewDialog");
                    }
                }
                catch (Exception e) {
                    this.logger.severe("Error getting dialog", (Throwable)e);
                }
            }
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Obtained dialog in makeCall : callId = " + dialog.getCallId().getCallId());
            }
            ActivityContextInterface sipACI = this.getSipActivityContextInterfaceFactory().getActivityContextInterface((DialogActivity)dialog);
            ActivityContextInterface clientSipACI = this.getSipActivityContextInterfaceFactory().getActivityContextInterface(ct);
            calleeSession.setDialog(dialog);
            sa.setCalleeSession(calleeSession);
            Session callerSession = new Session();
            callerAddress = this.getSipUtils().convertURIToAddress(this.callerSip);
            callerSession.setSipAddress(callerAddress);
            callerSession.setToBeCancelledClientTransaction(null);
            sa.setCallerSession(callerSession);
            this.getCacheUtility().put(calleeCallId, sa);
            ChildRelation relation = this.getCallControlSbbChild();
            CallControlSbbLocalObject child = (CallControlSbbLocalObject)relation.create();
            this.setChildSbbLocalObject(child);
            child.setParent(this.getSbbContext().getSbbLocalObject());
            sipACI.attach((SbbLocalObject)child);
            clientSipACI.attach((SbbLocalObject)child);
            sipACI.attach(this.getSbbContext().getSbbLocalObject());
            ac.detach(this.getSbbContext().getSbbLocalObject());
            dialog.sendRequest(ct);
        }
        catch (ParseException parExc) {
            this.logger.severe("Parse Exception while parsing the callerAddess", (Throwable)parExc);
        }
        catch (InvalidArgumentException invalidArgExcep) {
            this.logger.severe("InvalidArgumentException while building Invite Request", (Throwable)invalidArgExcep);
        }
        catch (TransactionUnavailableException tranUnavExce) {
            this.logger.severe("TransactionUnavailableException when trying to getNewClientTransaction", (Throwable)tranUnavExce);
        }
        catch (UnrecognizedActivityException e) {
            this.logger.severe("UnrecognizedActivityException when trying to getActivityContextInterface", (Throwable)e);
        }
        catch (CreateException creaExce) {
            this.logger.severe("CreateException while trying to create Child", (Throwable)creaExce);
        }
        catch (SipException sipExec) {
            this.logger.severe("SipException while trying to send INVITE Request", (Throwable)sipExec);
        }
    }

    public void onNotificationRequestResponse(NotificationRequestResponse event, ActivityContextInterface aci) {
        this.logger.info("onNotificationRequestResponse");
        ReturnCode status = event.getReturnCode();
        switch (status.getValue()) {
            case 200: {
                this.logger.info("The Announcement should start.");
                break;
            }
            default: {
                ReturnCode rc = event.getReturnCode();
                this.logger.severe("RQNT failed. Value = " + rc.getValue() + " Comment = " + rc.getComment());
                this.cancelTimer();
                if (!this.getChildSbbLocalObject().getSendBye()) break;
                this.getChildSbbLocalObject().sendBye();
            }
        }
    }

    public void onNotifyRequest(Notify event, ActivityContextInterface aci) {
        this.logger.info("onNotifyRequest");
        NotificationRequestResponse response = new NotificationRequestResponse(event.getSource(), ReturnCode.Transaction_Executed_Normally);
        response.setTransactionHandle(event.getTransactionHandle());
        this.getMgcpProvider().sendMgcpEvents(new JainMgcpEvent[]{response});
        EventName[] observedEvents = event.getObservedEvents();
        boolean success = false;
        block6: for (EventName observedEvent : observedEvents) {
            switch (observedEvent.getEventIdentifier().intValue()) {
                case 62: {
                    this.logger.info("Announcemnet Completed NTFY received");
                    if (!this.getSendBye() || !this.getChildSbbLocalObject().getSendBye()) continue block6;
                    this.getChildSbbLocalObject().sendBye();
                    continue block6;
                }
                case 63: {
                    this.logger.info("Announcemnet Failed received");
                    if (!this.getChildSbbLocalObject().getSendBye()) continue block6;
                    this.getChildSbbLocalObject().sendBye();
                    continue block6;
                }
                case 18: {
                    this.logger.info("You have pressed 1");
                    success = true;
                    this.onDtmf1();
                    continue block6;
                }
                case 19: {
                    this.logger.info("You have pressed 2");
                    success = true;
                    this.onDtmf2();
                    continue block6;
                }
                default: {
                    this.logger.info("Received undefined DTMF digit(Order approved?).");
                    this.onDefaultDtmf();
                }
            }
        }
        if (success) {
            this.setSendBye(success);
        }
    }

    private void onDtmf1() {
        EntityManager mgr = null;
        Order order = null;
        String audioFile = null;
        audioFile = this.getClass().getResource("audio/AdminOrderApproved.wav").toString();
        mgr = this.emf.createEntityManager();
        order = (Order)mgr.createQuery("select o from Order o where o.orderId = :orderId").setParameter("orderId", (Object)this.getCustomEvent().getOrderId()).getSingleResult();
        order.setStatus(Order.Status.PROCESSING);
        mgr.flush();
        mgr.close();
        this.getChildSbbLocalObject().sendRQNT(null, audioFile, true);
    }

    private void onDtmf2() {
        EntityManager mgr = null;
        Order order = null;
        String audioFile = null;
        audioFile = this.getClass().getResource("audio/AdminOrderCancelled.wav").toString();
        mgr = this.emf.createEntityManager();
        order = (Order)mgr.createQuery("select o from Order o where o.orderId = :orderId").setParameter("orderId", (Object)this.getCustomEvent().getOrderId()).getSingleResult();
        order.setStatus(Order.Status.CANCELLED);
        mgr.flush();
        mgr.close();
        this.getChildSbbLocalObject().sendRQNT(null, audioFile, true);
    }

    private void onDefaultDtmf() {
        String audioFile = this.getClass().getResource("audio/AdminReConfirm.wav").toString();
        this.getChildSbbLocalObject().sendRQNT(null, audioFile, false);
    }

    public void onCreateConnectionResponse(CreateConnectionResponse event, ActivityContextInterface aci) {
        if (event.getSecondEndpointIdentifier() != null) {
            this.getChildSbbLocalObject().sendRQNT(this.getTtsString(), null, true);
            this.setTtsString(null);
        }
    }

    public InitialEventSelector orderIdSelect(InitialEventSelector ies) {
        Object event = ies.getEvent();
        long orderId = 0L;
        if (!(event instanceof CustomEvent)) {
            ies.setActivityContextSelected(true);
            return ies;
        }
        orderId = ((CustomEvent)event).getOrderId();
        if (this.logger.isInfoEnabled()) {
            this.logger.info("Setting convergence name to: " + orderId);
        }
        ies.setCustomName(String.valueOf(orderId));
        return ies;
    }

    public abstract ChildRelation getCallControlSbbChild();

    public abstract void setTimerID(TimerID var1);

    public abstract TimerID getTimerID();

    public abstract void setCustomEvent(CustomEvent var1);

    public abstract CustomEvent getCustomEvent();

    public abstract void setSendBye(boolean var1);

    public abstract boolean getSendBye();

    public abstract void setTtsString(String var1);

    public abstract String getTtsString();

    public abstract void setChildSbbLocalObject(CallControlSbbLocalObject var1);

    public abstract CallControlSbbLocalObject getChildSbbLocalObject();
}

