/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.service.callcontrol;

import gov.nist.javax.sip.header.CSeq;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.CreateConnection;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConflictingParameterException;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.RequestedAction;
import jain.protocol.ip.mgcp.message.parms.RequestedEvent;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import jain.protocol.ip.mgcp.pkg.PackageName;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.SipException;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.address.SipURI;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.Header;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.FactoryException;
import javax.slee.InitialEventSelector;
import javax.slee.RolledBackContext;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.UnrecognizedActivityException;
import javax.slee.facilities.Tracer;
import net.java.slee.resource.mgcp.MgcpConnectionActivity;
import net.java.slee.resource.mgcp.MgcpEndpointActivity;
import net.java.slee.resource.sip.DialogActivity;
import net.java.slee.resource.sip.SleeSipProvider;
import org.mobicents.slee.service.common.CommonSbb;
import org.mobicents.slee.service.common.SimpleCallFlowRequestState;
import org.mobicents.slee.service.common.SimpleCallFlowResponseState;
import org.mobicents.slee.service.common.SimpleCallFlowState;
import org.mobicents.slee.service.events.CustomEvent;
import org.mobicents.slee.util.Session;
import org.mobicents.slee.util.SessionAssociation;
import org.mobicents.slee.util.StateCallback;

public abstract class CallControlSbb
extends CommonSbb {
    private Tracer log = null;
    public static final String ENDPOINT_NAME = "/mobicents/media/packetrelay/$";
    public static final String IVR_ENDPOINT = "/mobicents/media/IVR/$";
    protected String mmsBindAddress;
    private String callControlSipAddress;
    private String password;

    public abstract ResponseEvent getResponseEventCmp();

    public abstract void setResponseEventCmp(ResponseEvent var1);

    public abstract void setParentCmp(SbbLocalObject var1);

    public abstract SbbLocalObject getParentCmp();

    public abstract void setCustomEventCmp(CustomEvent var1);

    public abstract CustomEvent getCustomEventCmp();

    public void setCustomEvent(CustomEvent event) {
        this.setCustomEventCmp(event);
    }

    public void setParent(SbbLocalObject sbbLocalObject) {
        this.setParentCmp(sbbLocalObject);
    }

    public ResponseEvent getResponseEvent() {
        return this.getResponseEventCmp();
    }

    public abstract void setCallIdentifierCmp(CallIdentifier var1);

    public abstract CallIdentifier getCallIdentifierCmp();

    public void setCallIdentifier(CallIdentifier cid) {
        this.setCallIdentifierCmp(cid);
    }

    public CallIdentifier getCallIdentifier() {
        return this.getCallIdentifierCmp();
    }

    public abstract void setSendByeCmp(boolean var1);

    public abstract boolean getSendByeCmp();

    public void setSendBye(boolean isBye) {
        this.setSendByeCmp(isBye);
    }

    public boolean getSendBye() {
        return this.getSendByeCmp();
    }

    public InitialEventSelector callIdSelect(InitialEventSelector ies) {
        this.log.info("***************     callIdSelect     ***************");
        Object event = ies.getEvent();
        String callId = null;
        if (event instanceof ResponseEvent) {
            Response response = ((ResponseEvent)event).getResponse();
            callId = ((CallIdHeader)response.getHeader("Call-ID")).getCallId();
        } else if (event instanceof RequestEvent) {
            Request request = ((RequestEvent)event).getRequest();
            callId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
        } else {
            ies.setActivityContextSelected(true);
            return ies;
        }
        if (this.log.isFineEnabled()) {
            this.log.fine("Setting convergence name to: " + callId);
        }
        ies.setCustomName(callId);
        return ies;
    }

    private void executeRequestState(RequestEvent event) {
        String callId = ((CallIdHeader)event.getRequest().getHeader("Call-ID")).getCallId();
        SessionAssociation sa = (SessionAssociation)this.getCacheUtility().get(callId);
        SimpleCallFlowState simpleCallFlowState = this.getState(sa.getState());
        simpleCallFlowState.execute(event);
    }

    private void executeResponseState(ResponseEvent event) {
        String callId = ((CallIdHeader)event.getResponse().getHeader("Call-ID")).getCallId();
        SessionAssociation sa = (SessionAssociation)this.getCacheUtility().get(callId);
        SimpleCallFlowState simpleCallFlowState = this.getState(sa.getState());
        simpleCallFlowState.execute(event);
    }

    public void onByeEvent(RequestEvent event, ActivityContextInterface aci) {
        this.log.info("************Received BYEEEE**************");
        if (this.log.isFineEnabled()) {
            this.log.fine("Received BYE");
        }
        try {
            this.getSipUtils().sendStatefulOk(event);
            this.setSendBye(false);
            this.releaseMediaConnectionAndDialog();
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        catch (SipException e) {
            e.printStackTrace();
        }
        catch (InvalidArgumentException invalidArgEx) {
            invalidArgEx.printStackTrace();
        }
    }

    public void onClientErrorRespEvent(ResponseEvent event, ActivityContextInterface aci) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Received client error event : " + event.getResponse().getStatusCode());
        }
        this.executeResponseState(event);
    }

    public void onSuccessRespEvent(ResponseEvent event, ActivityContextInterface aci) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Received success response event " + event.getResponse().getStatusCode());
        }
        this.executeResponseState(event);
        if (((CSeq)event.getResponse().getHeader("CSeq")).getMethod().compareTo("BYE") == 0) {
            this.releaseMediaConnectionAndDialog();
        }
        if (((CSeq)event.getResponse().getHeader("CSeq")).getMethod().compareTo("INVITE") == 0) {
            this.setSendByeCmp(true);
        }
    }

    public void onCreateConnectionResponse(CreateConnectionResponse event, ActivityContextInterface aci) {
        this.log.info("Receive CRCX response: " + event);
        ReturnCode status = event.getReturnCode();
        switch (status.getValue()) {
            case 200: {
                this.log.info("Connection created properly.");
                break;
            }
            default: {
                ReturnCode rc = event.getReturnCode();
                this.log.severe("CRCX failed. Value = " + rc.getValue() + " Comment = " + rc.getComment());
                if (this.getSendByeCmp()) {
                    this.sendBye();
                }
                return;
            }
        }
        boolean attachParent = false;
        if (event.getSecondEndpointIdentifier() == null) {
            DialogActivity da = this.getDialogActivity();
            try {
                Request ackRequest = da.createAck(da.getLocalSeqNumber());
                ContentTypeHeader cth = ((SleeSipProvider)this.getSipProvider()).getHeaderFactory().createContentTypeHeader("application", "sdp");
                ackRequest.setContent((Object)event.getLocalConnectionDescriptor().toString(), cth);
                da.sendAck(ackRequest);
            }
            catch (InvalidArgumentException e1) {
                e1.printStackTrace();
            }
            catch (SipException e1) {
                e1.printStackTrace();
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            EndpointIdentifier endpointID = new EndpointIdentifier(IVR_ENDPOINT, this.mmsBindAddress + ":" + 2427);
            CreateConnection createConnection = new CreateConnection((Object)this, this.getCallIdentifier(), endpointID, ConnectionMode.SendRecv);
            int txID = this.getMgcpProvider().getUniqueTransactionHandler();
            createConnection.setTransactionHandle(txID);
            try {
                createConnection.setSecondEndpointIdentifier(event.getSpecificEndpointIdentifier());
            }
            catch (ConflictingParameterException e) {
                e.printStackTrace();
            }
            MgcpConnectionActivity connectionActivity = null;
            try {
                connectionActivity = this.getMgcpProvider().getConnectionActivity(txID, endpointID);
                ActivityContextInterface epnAci = this.getMgcpActivityContestInterfaceFactory().getActivityContextInterface(connectionActivity);
                epnAci.attach(this.getSbbContext().getSbbLocalObject());
            }
            catch (FactoryException ex) {
                ex.printStackTrace();
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
            catch (UnrecognizedActivityException ex) {
                ex.printStackTrace();
            }
            this.getMgcpProvider().sendMgcpEvents(new JainMgcpEvent[]{createConnection});
        } else {
            attachParent = true;
        }
        EndpointIdentifier eid = event.getSpecificEndpointIdentifier();
        this.log.info("Creating endpoint activity on: " + eid);
        MgcpEndpointActivity eActivity = this.getMgcpProvider().getEndpointActivity(eid);
        ActivityContextInterface eAci = this.getMgcpActivityContestInterfaceFactory().getActivityContextInterface(eActivity);
        eAci.attach(this.getSbbContext().getSbbLocalObject());
        if (attachParent) {
            ActivityContextInterface[] acis;
            for (ActivityContextInterface _aci : acis = this.getSbbContext().getActivities()) {
                if (!(_aci.getActivity() instanceof MgcpEndpointActivity) && !(_aci.getActivity() instanceof MgcpConnectionActivity)) continue;
                _aci.attach(this.getParentCmp());
            }
        }
    }

    public void sendRQNT(String textToPlay, String audioFileUrl, boolean detectDtmf) {
        MgcpEvent e;
        MgcpEndpointActivity endpointActivity = this.getEndpointActivity("IVR");
        if (endpointActivity == null) {
            throw new RuntimeException("There is no IVR endpoint activity");
        }
        EndpointIdentifier endpointID = endpointActivity.getEndpointIdentifier();
        MgcpConnectionActivity connectionActivity = this.getConnectionActivity(endpointActivity.getEndpointIdentifier());
        if (connectionActivity == null) {
            throw new RuntimeException("There is no IVR connection endpoint activity");
        }
        ConnectionIdentifier connectionID = new ConnectionIdentifier(connectionActivity.getConnectionIdentifier());
        NotificationRequest notificationRequest = new NotificationRequest((Object)this, endpointID, this.getMgcpProvider().getUniqueRequestIdentifier());
        RequestedAction[] actions = new RequestedAction[]{RequestedAction.NotifyImmediately};
        PackageName auPackageName = PackageName.factory((String)"AU");
        if (textToPlay != null) {
            e = MgcpEvent.factory((String)"ann");
            EventName[] signalRequests = new EventName[]{new EventName(auPackageName, e.withParm("ts(" + textToPlay + ")"), connectionID)};
            notificationRequest.setSignalRequests(signalRequests);
            RequestedEvent[] requestedEvents = new RequestedEvent[]{new RequestedEvent(new EventName(auPackageName, MgcpEvent.oc, connectionID), actions), new RequestedEvent(new EventName(auPackageName, MgcpEvent.of, connectionID), actions)};
            notificationRequest.setRequestedEvents(requestedEvents);
        } else if (audioFileUrl != null) {
            e = MgcpEvent.factory((String)"ann");
            EventName[] signalRequests = new EventName[]{new EventName(auPackageName, e.withParm(audioFileUrl), connectionID)};
            notificationRequest.setSignalRequests(signalRequests);
            RequestedEvent[] requestedEvents = new RequestedEvent[]{new RequestedEvent(new EventName(auPackageName, MgcpEvent.oc, connectionID), actions), new RequestedEvent(new EventName(auPackageName, MgcpEvent.of, connectionID), actions)};
            notificationRequest.setRequestedEvents(requestedEvents);
        }
        if (detectDtmf) {
            RequestedEvent[] requestedEvents = new RequestedEvent[]{new RequestedEvent(new EventName(auPackageName, MgcpEvent.oc, connectionID), actions), new RequestedEvent(new EventName(auPackageName, MgcpEvent.of, connectionID), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf0, connectionID), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf1, connectionID), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf2, connectionID), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf3, connectionID), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf4, connectionID), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf5, connectionID), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf6, connectionID), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf7, connectionID), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf8, connectionID), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf9, connectionID), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmfA, connectionID), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmfB, connectionID), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmfC, connectionID), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmfD, connectionID), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmfStar, connectionID), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmfHash, connectionID), actions)};
            notificationRequest.setRequestedEvents(requestedEvents);
        }
        notificationRequest.setTransactionHandle(this.getMgcpProvider().getUniqueTransactionHandler());
        NotifiedEntity notifiedEntity = new NotifiedEntity(JBOSS_BIND_ADDRESS, JBOSS_BIND_ADDRESS, 2727);
        notificationRequest.setNotifiedEntity(notifiedEntity);
        this.getMgcpProvider().sendMgcpEvents(new JainMgcpEvent[]{notificationRequest});
        this.log.info(" NotificationRequest sent: \n" + notificationRequest);
    }

    private MgcpConnectionActivity getConnectionActivity(EndpointIdentifier eid) {
        for (ActivityContextInterface aci : this.getSbbContext().getActivities()) {
            MgcpConnectionActivity activity;
            if (!(aci.getActivity() instanceof MgcpConnectionActivity) || !(activity = (MgcpConnectionActivity)aci.getActivity()).getEndpointIdentifier().equals(eid)) continue;
            return activity;
        }
        return null;
    }

    private MgcpEndpointActivity getEndpointActivity(String ePartialID) {
        for (ActivityContextInterface aci : this.getSbbContext().getActivities()) {
            MgcpEndpointActivity activity;
            if (!(aci.getActivity() instanceof MgcpEndpointActivity) || !(activity = (MgcpEndpointActivity)aci.getActivity()).getEndpointIdentifier().toString().toLowerCase().contains(ePartialID.toLowerCase())) continue;
            return activity;
        }
        return null;
    }

    private DialogActivity getDialogActivity() {
        for (ActivityContextInterface aci : this.getSbbContext().getActivities()) {
            if (!(aci.getActivity() instanceof DialogActivity)) continue;
            return (DialogActivity)aci.getActivity();
        }
        return null;
    }

    private void releaseMediaConnectionAndDialog() {
        ActivityContextInterface[] activities = this.getSbbContext().getActivities();
        SbbLocalObject sbbLocalObject = this.getSbbContext().getSbbLocalObject();
        for (ActivityContextInterface attachedAci : activities) {
            if (attachedAci.getActivity() instanceof Dialog) {
                attachedAci.detach(sbbLocalObject);
                attachedAci.detach(this.getParentCmp());
            }
            if (attachedAci.getActivity() instanceof MgcpConnectionActivity) {
                attachedAci.detach(sbbLocalObject);
                attachedAci.detach(this.getParentCmp());
            }
            if (!(attachedAci.getActivity() instanceof MgcpEndpointActivity)) continue;
            attachedAci.detach(sbbLocalObject);
            attachedAci.detach(this.getParentCmp());
            MgcpEndpointActivity mgcpEndpoint = (MgcpEndpointActivity)attachedAci.getActivity();
            DeleteConnection deleteConnection = new DeleteConnection((Object)this, mgcpEndpoint.getEndpointIdentifier());
            deleteConnection.setCallIdentifier(this.getCallIdentifier());
            deleteConnection.setTransactionHandle(this.getMgcpProvider().getUniqueTransactionHandler());
            this.getMgcpProvider().sendMgcpEvents(new JainMgcpEvent[]{deleteConnection});
        }
        this.setCallIdentifier(null);
    }

    public void sendBye() {
        try {
            Dialog dialog = this.getSipUtils().getDialog(this.getResponseEventCmp());
            this.sendRequest(dialog, "BYE");
            this.setSendByeCmp(false);
        }
        catch (SipException e) {
            this.log.severe("Error sending BYE", (Throwable)e);
        }
    }

    public void setSbbContext(SbbContext context) {
        this.log = context.getTracer("CallControl");
        super.setSbbContext(context);
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            this.callControlSipAddress = (String)myEnv.lookup("callControlSipAddress");
            this.password = (String)myEnv.lookup("password");
            String passwordDisplay = this.password == null ? "null" : "*******";
            this.mmsBindAddress = (String)myEnv.lookup("server.address");
            if (this.log.isInfoEnabled()) {
                this.log.info("Checking that CallControlSbb callControlSipAddress and password are present : callControlSipAddress = " + this.callControlSipAddress + " password = " + passwordDisplay);
            }
        }
        catch (NamingException ne) {
            ne.printStackTrace();
        }
    }

    public void unsetSbbContext() {
        super.unsetSbbContext();
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbRemove() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
    }

    public void sbbRolledBack(RolledBackContext context) {
    }

    protected SbbContext getSbbContext() {
        return super.getSbbContext();
    }

    private void setToBeCancelledClientTransaction(ClientTransaction ct) {
        String callId = ((CallIdHeader)ct.getRequest().getHeader("Call-ID")).getCallId();
        SessionAssociation sa = (SessionAssociation)this.getCacheUtility().get(callId);
        if (sa != null) {
            Session session = sa.getSession(callId);
            session.setToBeCancelledClientTransaction(ct);
        }
    }

    private SimpleCallFlowState getState(String classNameForState) {
        SimpleCallFlowState simpleCallFlowState = null;
        try {
            Class<?> innerCls = Class.forName(classNameForState);
            Constructor<?> c = innerCls.getDeclaredConstructors()[0];
            simpleCallFlowState = (SimpleCallFlowState)c.newInstance(this);
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return simpleCallFlowState;
    }

    private void setState(SimpleCallFlowState state, String callId) {
        if (this.log.isInfoEnabled()) {
            this.log.info("Setting state to " + state + " for callId " + callId);
        }
        String stateName = state.getClass().getName();
        SessionAssociation sa = (SessionAssociation)this.getCacheUtility().get(callId);
        sa.setState(stateName);
        StateCallback callback = sa.getStateCallback();
        if (callback != null) {
            callback.setSessionState(stateName);
        }
    }

    private void setDialog(Dialog dialog, String callId) {
        SessionAssociation sa = (SessionAssociation)this.getCacheUtility().get(callId);
        Session session = sa.getSession(callId);
        if (this.log.isInfoEnabled()) {
            this.log.info("Setting dialog in session for callId : " + callId);
        }
        session.setDialog(dialog);
    }

    public void sendCallerAck(ResponseEvent event) {
        try {
            Dialog dialog = this.getSipUtils().getDialog(event);
            Request ackRequest = this.getSipUtils().buildAck(dialog, null);
            dialog.sendAck(ackRequest);
        }
        catch (SipException e) {
            e.printStackTrace();
        }
    }

    private void sendCalleeAck(ResponseEvent event) {
        this.log.info("Sending Calee ACK event ResposneEvent = " + event);
        try {
            ClientTransaction ct = event.getClientTransaction();
            String callerCallId = ((CallIdHeader)ct.getRequest().getHeader("Call-ID")).getCallId();
            Dialog calleeDialog = this.getPeerDialog(callerCallId);
            Object content = event.getResponse().getContent();
            this.log.info("Building ACK content = " + content + " Dialog = " + calleeDialog);
            Request ackRequest = this.getSipUtils().buildAck(calleeDialog, content);
            calleeDialog.sendAck(ackRequest);
        }
        catch (SipException e) {
            e.printStackTrace();
        }
    }

    private Dialog getPeerDialog(String callId) {
        SessionAssociation sa = (SessionAssociation)this.getCacheUtility().get(callId);
        Session peerSession = sa.getPeerSession(callId);
        return peerSession.getDialog();
    }

    private Dialog getDialog(String callId) {
        SessionAssociation sa = (SessionAssociation)this.getCacheUtility().get(callId);
        Session session = sa.getSession(callId);
        return session.getDialog();
    }

    private void sendRequestCancel(Dialog dialog) {
        try {
            Session session = this.getSession(dialog);
            ClientTransaction ct = session.getToBeCancelledClientTransaction();
            this.getSipUtils().sendCancel(ct);
        }
        catch (SipException e) {
            e.printStackTrace();
        }
    }

    private void sendRequest(Dialog dialog, String requestType) throws SipException {
        Request request = dialog.createRequest(requestType);
        if ("BYE".equals(requestType)) {
            request.removeHeader("Via");
            request.removeHeader("Contact");
            Address address = dialog.getLocalParty();
            try {
                SipURI sipUri = this.getSipUtils().convertAddressToSipURI(address);
                request.addHeader((Header)this.getSipUtils().createLocalViaHeader());
                request.addHeader((Header)this.getSipUtils().createLocalContactHeader(sipUri.getUser()));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (InvalidArgumentException e) {
                e.printStackTrace();
            }
        }
        try {
            ClientTransaction ct = this.getSipProvider().getNewClientTransaction(request);
            dialog.sendRequest(ct);
        }
        catch (Exception e) {
            this.log.severe("Exception in sendrequest", (Throwable)e);
            throw new SipException("Exception rethrown as SipException in sendRequest", (Throwable)e);
        }
    }

    private void sendRequestWithAuthorizationHeader(ResponseEvent event) {
        ClientTransaction ct = null;
        SessionAssociation sa = null;
        try {
            Request request = this.getSipUtils().buildRequestWithAuthorizationHeader(event, this.getPassword());
            this.log.info("sendRequestWithAuthorizationHeader. request with Auth = " + request);
            ct = this.getSipProvider().getNewClientTransaction(request);
        }
        catch (TransactionUnavailableException e) {
            e.printStackTrace();
        }
        Dialog dialog = ct.getDialog();
        SbbLocalObject sbbLocalObject = this.getSbbContext().getSbbLocalObject();
        if (dialog == null) {
            try {
                dialog = this.getSipProvider().getNewDialog(ct);
                if (this.log.isInfoEnabled()) {
                    this.log.info("Obtained dialog with getNewDialog in sendRequestWithAuthorizationHeader");
                }
            }
            catch (SipException e) {
                this.log.severe("Error getting dialog in sendRequestWithAuthorizationHeader", (Throwable)e);
            }
            ClientTransaction ctOld = event.getClientTransaction();
            Header h = ctOld.getRequest().getHeader("Call-ID");
            String oldCallId = ((CallIdHeader)h).getCallId();
            sa = (SessionAssociation)this.getCacheUtility().get(oldCallId);
            Header hNew = ct.getRequest().getHeader("Call-ID");
            String calleeCallIdNew = ((CallIdHeader)hNew).getCallId();
            Session oldCalleeSession = sa.getSession(oldCallId);
            oldCalleeSession.setCallId(calleeCallIdNew);
            try {
                ActivityContextInterface sipACI = this.getSipActivityContextInterfaceFactory().getActivityContextInterface((DialogActivity)dialog);
                sipACI.attach(sbbLocalObject);
                sipACI.attach(this.getParentCmp());
            }
            catch (UnrecognizedActivityException aci) {
                aci.printStackTrace();
            }
            this.getCacheUtility().put(calleeCallIdNew, sa);
        }
        String callId = dialog.getCallId().getCallId();
        if (this.log.isInfoEnabled()) {
            this.log.info("Obtained dialog from ClientTransaction in sendRequestWithAuthorizationHeader  : dialog callId = " + callId);
        }
        this.setToBeCancelledClientTransaction(ct);
        this.setDialog(dialog, callId);
        ActivityContextInterface ac = null;
        try {
            ac = this.getSipActivityContextInterfaceFactory().getActivityContextInterface(ct);
        }
        catch (FactoryException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        catch (UnrecognizedActivityException e) {
            e.printStackTrace();
        }
        ac.attach(sbbLocalObject);
        try {
            ct.sendRequest();
        }
        catch (SipException e) {
            e.printStackTrace();
        }
    }

    private Session getSession(Dialog dialog) {
        String callId = dialog.getCallId().getCallId();
        SessionAssociation sa = (SessionAssociation)this.getCacheUtility().get(callId);
        Session session = sa.getSession(callId);
        return session;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getCallControlSipAddress() {
        return this.callControlSipAddress;
    }

    public void setCallControlSipAddress(String username) {
        this.callControlSipAddress = username;
    }

    public class TerminationState
    extends SimpleCallFlowResponseState {
        public void execute(ResponseEvent event) {
        }
    }

    public class ExternalTerminationCallerState
    extends SimpleCallFlowResponseState {
        public void execute(ResponseEvent event) {
            Response response = event.getResponse();
            String callId = ((CallIdHeader)response.getHeader("Call-ID")).getCallId();
            CallControlSbb.this.setState(new TerminationState(), callId);
        }
    }

    public class ExternalTerminationCalleeState
    extends SimpleCallFlowResponseState {
        public void execute(ResponseEvent event) {
            Response response = event.getResponse();
            String callId = ((CallIdHeader)response.getHeader("Call-ID")).getCallId();
            Dialog dialog = CallControlSbb.this.getPeerDialog(callId);
            try {
                CallControlSbb.this.sendRequest(dialog, "BYE");
                CallControlSbb.this.setState(new ExternalTerminationCallerState(), callId);
            }
            catch (SipException e) {
                CallControlSbb.this.log.severe("Exception while sending BYE in execute for callId : " + dialog.getCallId().getCallId());
                CallControlSbb.this.setState(new TerminationState(), callId);
            }
        }
    }

    public class ExternalCancellationState
    extends SimpleCallFlowResponseState {
        public void execute(ResponseEvent event) {
            Response response = event.getResponse();
            String callId = ((CallIdHeader)response.getHeader("Call-ID")).getCallId();
            CallControlSbb.this.setState(new TerminationState(), callId);
        }
    }

    public class UATerminationState
    extends SimpleCallFlowResponseState {
        public void execute(ResponseEvent event) {
            Response response = event.getResponse();
            int status = response.getStatusCode();
            String callId = ((CallIdHeader)response.getHeader("Call-ID")).getCallId();
            if (status == 200) {
                CallControlSbb.this.setState(new TerminationState(), callId);
            }
        }
    }

    public class SessionEstablishedState
    extends SimpleCallFlowRequestState {
        public void execute(RequestEvent event) {
            Request request = event.getRequest();
            String method = request.getMethod();
            if (method.equals("BYE")) {
                String callId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
                Dialog dialog = CallControlSbb.this.getPeerDialog(callId);
                try {
                    CallControlSbb.this.getSipUtils().sendOk(request);
                    CallControlSbb.this.sendRequest(dialog, "BYE");
                }
                catch (ParseException e1) {
                    e1.printStackTrace();
                }
                catch (SipException e1) {
                    e1.printStackTrace();
                }
                CallControlSbb.this.setState(new UATerminationState(), callId);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void execute(JainMgcpResponseEvent event) {
            CallControlSbb.this.log.info("SessionEstablishedStateNoMediaPath.execute(JainMgcpResponseEvent");
            if (event instanceof CreateConnectionResponse) {
                CreateConnectionResponse crcxResponse = (CreateConnectionResponse)event;
                if (crcxResponse.getSecondEndpointIdentifier() != null) return;
            }
            CallControlSbb.this.sendBye();
        }
    }

    public class CallerRingingState
    extends AfterCalleeConfirmedAndBeforeCallerConfirmedState {
        public void execute(ResponseEvent event) {
            Response response = event.getResponse();
            int status = response.getStatusCode();
            String callerCallId = ((CallIdHeader)response.getHeader("Call-ID")).getCallId();
            if (status >= 200 && status <= 202) {
                this.handleOK(callerCallId, event);
            } else if (status == 401 || status == 407) {
                this.handleAuthentication(callerCallId, event);
            } else if (status >= 400 && status < 500) {
                this.handleError(callerCallId);
            } else if (status == 603) {
                this.handleDecline(callerCallId);
            }
        }

        public void execute(RequestEvent event) {
            Request request = event.getRequest();
            String calleeCallId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
            String method = request.getMethod();
            if ("BYE".equals(method)) {
                this.handleBye(calleeCallId, request);
            }
        }
    }

    public class CallerTryingState
    extends AfterCalleeConfirmedAndBeforeCallerConfirmedState {
        public void execute(ResponseEvent event) {
            Response response = event.getResponse();
            int status = response.getStatusCode();
            String callerCallId = ((CallIdHeader)response.getHeader("Call-ID")).getCallId();
            if (status >= 180 && status < 200) {
                this.handleRinging(callerCallId, event);
            } else if (status >= 200 && status <= 202) {
                this.handleOK(callerCallId, event);
            } else if (status == 401 || status == 407) {
                this.handleAuthentication(callerCallId, event);
            } else if (status >= 400 && status < 500) {
                this.handleError(callerCallId);
            } else if (status == 603) {
                this.handleDecline(callerCallId);
            }
        }

        public void execute(RequestEvent event) {
            Request request = event.getRequest();
            String calleeCallId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
            String method = request.getMethod();
            if ("BYE".equals(method)) {
                this.handleBye(calleeCallId, request);
            }
        }
    }

    public class CallerInvitedState
    extends AfterCalleeConfirmedAndBeforeCallerConfirmedState {
        public void execute(ResponseEvent event) {
            Response response = event.getResponse();
            int status = response.getStatusCode();
            String callerCallId = ((CallIdHeader)response.getHeader("Call-ID")).getCallId();
            if (status == 100) {
                this.handleTrying(callerCallId, event);
            } else if (status >= 180 && status < 200) {
                this.handleRinging(callerCallId, event);
            } else if (status >= 200 && status <= 202) {
                this.handleOK(callerCallId, event);
            } else if (status == 401 || status == 407) {
                this.handleAuthentication(callerCallId, event);
            } else if (status >= 400 && status < 500) {
                this.handleError(callerCallId);
            } else if (status == 603) {
                this.handleDecline(callerCallId);
            }
        }

        public void execute(RequestEvent event) {
            Request request = event.getRequest();
            String calleeCallId = ((CallIdHeader)request.getHeader("Call-ID")).getCallId();
            String method = request.getMethod();
            if ("BYE".equals(method)) {
                this.handleBye(calleeCallId, request);
            }
        }
    }

    public abstract class AfterCalleeConfirmedAndBeforeCallerConfirmedState
    implements SimpleCallFlowState {
        public void handleTrying(String callerCallId, ResponseEvent event) {
            CallControlSbb.this.setState(new CallerTryingState(), callerCallId);
        }

        public void handleRinging(String callerCallId, ResponseEvent event) {
            CallControlSbb.this.setState(new CallerRingingState(), callerCallId);
        }

        public void handleOK(String callerCallId, ResponseEvent event) {
            try {
                Dialog eventDialog = CallControlSbb.this.getSipUtils().getDialog(event);
                Dialog currentDialog = CallControlSbb.this.getDialog(eventDialog.getCallId().getCallId());
                if (!eventDialog.equals(currentDialog)) {
                    CallControlSbb.this.log.warning("Received 200 response from forked dialog");
                    return;
                }
            }
            catch (SipException sipException) {
                // empty catch block
            }
            CallControlSbb.this.sendCalleeAck(event);
            CallControlSbb.this.sendCallerAck(event);
            CallControlSbb.this.setState(new SessionEstablishedState(), callerCallId);
        }

        public void handleError(String callerCallId) {
            Dialog dialog = CallControlSbb.this.getPeerDialog(callerCallId);
            try {
                CallControlSbb.this.sendRequest(dialog, "BYE");
            }
            catch (SipException e) {
                CallControlSbb.this.log.severe("Error sending BYE", (Throwable)e);
            }
            CallControlSbb.this.setState(new UATerminationState(), callerCallId);
        }

        public void handleDecline(String callerCallId) {
            Dialog dialog = CallControlSbb.this.getPeerDialog(callerCallId);
            try {
                CallControlSbb.this.sendRequest(dialog, "BYE");
            }
            catch (SipException e) {
                CallControlSbb.this.log.severe("Error sending BYE", (Throwable)e);
            }
            CallControlSbb.this.setState(new UATerminationState(), callerCallId);
        }

        public void handleAuthentication(String callerCallId, ResponseEvent event) {
            CallControlSbb.this.sendRequestWithAuthorizationHeader(event);
            CallControlSbb.this.setState(new CallerInvitedState(), callerCallId);
        }

        public void handleBye(String calleeCallId, Request request) {
            try {
                CallControlSbb.this.getSipUtils().sendOk(request);
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            catch (SipException e) {
                e.printStackTrace();
            }
            CallControlSbb.this.sendRequestCancel(CallControlSbb.this.getPeerDialog(calleeCallId));
            CallControlSbb.this.setState(new UATerminationState(), calleeCallId);
        }

        public abstract void execute(RequestEvent var1);

        public abstract void execute(ResponseEvent var1);
    }

    public class CalleeRingingState
    extends BeforeCalleeConfirmedState {
        public void execute(ResponseEvent event) {
            Response response = event.getResponse();
            int status = response.getStatusCode();
            String calleeCallId = ((CallIdHeader)response.getHeader("Call-ID")).getCallId();
            if (status >= 200 && status <= 202) {
                this.handleOK(calleeCallId, event);
            } else if (status == 603) {
                this.handleDecline(calleeCallId, event);
            } else if (status == 401 || status == 407) {
                this.handleAuthentication(calleeCallId, event);
            }
        }
    }

    public class CalleeTryingState
    extends BeforeCalleeConfirmedState {
        public void execute(ResponseEvent event) {
            Response response = event.getResponse();
            int status = response.getStatusCode();
            String calleeCallId = ((CallIdHeader)response.getHeader("Call-ID")).getCallId();
            if (status >= 180 && status < 200) {
                CallControlSbb.this.log.info("CallControlSbb$CalleeTryingState - execute - status >= Response.RINGING && status < Response.OK - calleeCallId = " + calleeCallId);
                this.handleRinging(calleeCallId, event);
            } else if (status >= 200 && status <= 202) {
                CallControlSbb.this.log.info("CallControlSbb$CalleeTryingState - execute - status >= Response.OK && status <= Response.ACCEPTED - calleeCallId = " + calleeCallId);
                this.handleOK(calleeCallId, event);
            } else if (status == 603) {
                CallControlSbb.this.log.info("CallControlSbb$CalleeTryingState - execute - status == Response.DECLINE - calleeCallId = " + calleeCallId);
                this.handleDecline(calleeCallId, event);
            } else if (status == 401 || status == 407) {
                CallControlSbb.this.log.info("CallControlSbb$CalleeTryingState - execute - status == Response.UNAUTHORIZED || status == Response.PROXY_AUTHENTICATION_REQUIRED - calleeCallId = " + calleeCallId);
                this.handleAuthentication(calleeCallId, event);
            }
        }
    }

    public class InitialState
    extends BeforeCalleeConfirmedState {
        public void execute(ResponseEvent event) {
            Response response = event.getResponse();
            int status = response.getStatusCode();
            String calleeCallId = ((CallIdHeader)response.getHeader("Call-ID")).getCallId();
            if (status == 100) {
                CallControlSbb.this.log.info("org.mobicents.slee.service.callcontrol.CallControlSbb$InitialState - execute - status == Response.TRYING - calleeCallId = " + calleeCallId);
                this.handleTrying(calleeCallId, event);
            } else if (status >= 180 && status < 200) {
                CallControlSbb.this.log.info("org.mobicents.slee.service.callcontrol.CallControlSbb$InitialState - execute - status >= Response.RINGING && status < Response.OK - calleeCallId = " + calleeCallId);
                this.handleRinging(calleeCallId, event);
            } else if (status >= 200 && status <= 202) {
                CallControlSbb.this.log.info("org.mobicents.slee.service.callcontrol.CallControlSbb$InitialState - execute - status >= Response.OK && status <= Response.ACCEPTED - calleeCallId = " + calleeCallId);
                this.handleOK(calleeCallId, event);
            } else if (status == 603) {
                CallControlSbb.this.log.info("org.mobicents.slee.service.callcontrol.CallControlSbb$InitialState - execute - status == Response.DECLINE - calleeCallId = " + calleeCallId);
                this.handleDecline(calleeCallId, event);
            } else if (status == 401 || status == 407) {
                CallControlSbb.this.log.info("org.mobicents.slee.service.callcontrol.CallControlSbb$InitialState - execute - status == Response.UNAUTHORIZED || status == Response.PROXY_AUTHENTICATION_REQUIRED - calleeCallId = " + calleeCallId);
                this.handleAuthentication(calleeCallId, event);
            }
        }
    }

    public abstract class BeforeCalleeConfirmedState
    extends SimpleCallFlowResponseState {
        public void handleTrying(String calleeCallId, ResponseEvent event) {
            CallControlSbb.this.setState(new CalleeTryingState(), calleeCallId);
        }

        public void handleRinging(String calleeCallId, ResponseEvent event) {
            CallControlSbb.this.setState(new CalleeRingingState(), calleeCallId);
        }

        public void handleOK(String calleeCallId, ResponseEvent event) {
            CallControlSbb.this.log.info("BeforeCalleeConfirmedState.handleOK");
            CallControlSbb.this.setResponseEventCmp(event);
            Dialog currentDialog = null;
            try {
                Dialog eventDialog = CallControlSbb.this.getSipUtils().getDialog(event);
                currentDialog = CallControlSbb.this.getDialog(eventDialog.getCallId().getCallId());
                if (!eventDialog.equals(currentDialog)) {
                    CallControlSbb.this.log.warning("Received 200 response from forked dialog");
                    return;
                }
            }
            catch (SipException e) {
                CallControlSbb.this.log.severe("SipException while trying to retreive Dialog", (Throwable)e);
            }
            try {
                ActivityContextInterface daci = CallControlSbb.this.getSipActivityContextInterfaceFactory().getActivityContextInterface((DialogActivity)currentDialog);
                daci.attach(CallControlSbb.this.getSbbContext().getSbbLocalObject());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            String sdp = new String(event.getResponse().getRawContent());
            CallControlSbb.this.log.info("BeforeCalleeConfirmedState.handleOK sdpOffer = " + sdp);
            CallIdentifier callID = CallControlSbb.this.getMgcpProvider().getUniqueCallIdentifier();
            CallControlSbb.this.setCallIdentifier(callID);
            EndpointIdentifier endpointID = new EndpointIdentifier(CallControlSbb.ENDPOINT_NAME, CallControlSbb.this.mmsBindAddress + ":" + 2427);
            CreateConnection createConnection = new CreateConnection((Object)this, callID, endpointID, ConnectionMode.SendRecv);
            try {
                createConnection.setRemoteConnectionDescriptor(new ConnectionDescriptor(sdp));
            }
            catch (ConflictingParameterException e) {
                e.printStackTrace();
            }
            int txID = CallControlSbb.this.getMgcpProvider().getUniqueTransactionHandler();
            createConnection.setTransactionHandle(txID);
            MgcpConnectionActivity connectionActivity = null;
            try {
                connectionActivity = CallControlSbb.this.getMgcpProvider().getConnectionActivity(txID, endpointID);
                ActivityContextInterface epnAci = CallControlSbb.this.getMgcpActivityContestInterfaceFactory().getActivityContextInterface(connectionActivity);
                epnAci.attach(CallControlSbb.this.getSbbContext().getSbbLocalObject());
                epnAci.attach(CallControlSbb.this.getParentCmp());
            }
            catch (FactoryException ex) {
                ex.printStackTrace();
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
            catch (UnrecognizedActivityException ex) {
                ex.printStackTrace();
            }
            CallControlSbb.this.getMgcpProvider().sendMgcpEvents(new JainMgcpEvent[]{createConnection});
            CallControlSbb.this.log.info("Creating RTP connection [/mobicents/media/packetrelay/$]\n" + createConnection);
            CallControlSbb.this.setState(new SessionEstablishedState(), calleeCallId);
        }

        public void handleDecline(String calleeCallId, ResponseEvent event) {
            CallControlSbb.this.setState(new TerminationState(), calleeCallId);
        }

        public void handleAuthentication(String calleeCallId, ResponseEvent event) {
            CallControlSbb.this.sendRequestWithAuthorizationHeader(event);
            CallControlSbb.this.setState(new InitialState(), calleeCallId);
        }

        public abstract void execute(ResponseEvent var1);
    }

    public abstract class StateSupport
    implements SimpleCallFlowState {
        private String statusMessage;

        public StateSupport(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        public String getStatusMessage() {
            return this.statusMessage;
        }
    }
}

