/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.service.user;

import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.NotificationRequestResponse;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.text.ParseException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.sip.ClientTransaction;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.TransactionUnavailableException;
import javax.sip.address.Address;
import javax.sip.header.CallIdHeader;
import javax.sip.header.Header;
import javax.sip.message.Request;
import javax.slee.ActivityContextInterface;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.UnrecognizedActivityException;
import javax.slee.facilities.Tracer;
import javax.slee.nullactivity.NullActivity;
import net.java.slee.resource.sip.DialogActivity;
import org.mobicents.examples.convergeddemo.seam.pojo.Order;
import org.mobicents.slee.service.callcontrol.CallControlSbbLocalObject;
import org.mobicents.slee.service.common.CommonSbb;
import org.mobicents.slee.service.events.CustomEvent;
import org.mobicents.slee.util.Session;
import org.mobicents.slee.util.SessionAssociation;

public abstract class UserSbb
extends CommonSbb {
    private Tracer logger = null;
    private EntityManagerFactory emf;
    String audioFilePath = null;
    String callerSip = null;
    private final String orderConfirmed = "audio/UserOrderConfirmed.wav";
    private final String orderCancelled = "audio/UserOrderCancelled.wav";
    private final String orderReConfirm = "audio/UserReConfirm.wav";

    public void setSbbContext(SbbContext context) {
        this.logger = context.getTracer("User");
        super.setSbbContext(context);
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            this.audioFilePath = System.getProperty("jboss.server.data.dir");
            this.callerSip = (String)myEnv.lookup("callerSip");
            InitialContext newIc = new InitialContext();
            this.emf = (EntityManagerFactory)newIc.lookup("java:/ShoppingDemoSleeEntityManagerFactory");
        }
        catch (NamingException ne) {
            ne.printStackTrace();
        }
    }

    public abstract void fireOrderCancelled(CustomEvent var1, ActivityContextInterface var2, javax.slee.Address var3);

    public void onOrderPlaced(CustomEvent event, ActivityContextInterface ac) {
        this.logger.info("UserSbb: " + this + ": received an ORDER_PLACED event. OrderId = " + event.getOrderId() + ". ammount = " + event.getAmmount() + ". Customer Name = " + event.getCustomerName());
        ac.detach(this.getSbbContext().getSbbLocalObject());
        this.setCustomEvent(event);
        StringBuilder stringBuffer = new StringBuilder();
        stringBuffer.append("Welcome ");
        stringBuffer.append(event.getCustomerName());
        stringBuffer.append(". You have placed an order of $");
        stringBuffer.append(event.getAmmount());
        stringBuffer.append(". Press 1 to confirm and 2 to decline.");
        this.setTtsString(stringBuffer.toString());
        try {
            Address callerAddress = this.getSipUtils().convertURIToAddress(this.callerSip);
            callerAddress.setDisplayName(this.callerSip);
            Address calleeAddress = this.getSipUtils().convertURIToAddress(event.getCustomerPhone());
            Request request = this.getSipUtils().buildInvite(callerAddress, calleeAddress, null, 1);
            ClientTransaction ct = this.getSipProvider().getNewClientTransaction(request);
            Header h = ct.getRequest().getHeader("Call-ID");
            String calleeCallId = ((CallIdHeader)h).getCallId();
            SessionAssociation sa = new SessionAssociation("org.mobicents.slee.service.callcontrol.CallControlSbb$InitialState");
            Session calleeSession = new Session(calleeCallId);
            calleeSession.setSipAddress(calleeAddress);
            calleeSession.setToBeCancelledClientTransaction(ct);
            Dialog dialog = ct.getDialog();
            if (dialog != null && this.logger.isFineEnabled()) {
                this.logger.fine("Obtained dialog from ClientTransaction : automatic dialog support on");
            }
            if (dialog == null) {
                try {
                    dialog = this.getSipProvider().getNewDialog((Transaction)ct);
                    if (this.logger.isFineEnabled()) {
                        this.logger.fine("Obtained dialog for INVITE request to callee with getNewDialog");
                    }
                }
                catch (Exception e) {
                    this.logger.severe("Error getting dialog", (Throwable)e);
                }
            }
            ActivityContextInterface sipACI = this.getSipActivityContextInterfaceFactory().getActivityContextInterface((DialogActivity)dialog);
            ActivityContextInterface clientSipACI = this.getSipActivityContextInterfaceFactory().getActivityContextInterface(ct);
            if (this.logger.isFineEnabled()) {
                this.logger.fine("Obtained dialog in onThirdPCCTriggerEvent : callId = " + dialog.getCallId().getCallId());
            }
            dialog.terminateOnBye(true);
            calleeSession.setDialog(dialog);
            sa.setCalleeSession(calleeSession);
            Session callerSession = new Session();
            callerAddress = this.getSipUtils().convertURIToAddress(this.callerSip);
            callerSession.setSipAddress(callerAddress);
            callerSession.setToBeCancelledClientTransaction(null);
            sa.setCallerSession(callerSession);
            this.getCacheUtility().put(calleeCallId, sa);
            ChildRelation relation = this.getCallControlSbbChild();
            CallControlSbbLocalObject child = (CallControlSbbLocalObject)relation.create();
            this.setChildSbbLocalObject(child);
            child.setParent(this.getSbbContext().getSbbLocalObject());
            child.setCustomEvent(event);
            sipACI.attach((SbbLocalObject)child);
            clientSipACI.attach((SbbLocalObject)child);
            sipACI.attach(this.getSbbContext().getSbbLocalObject());
            dialog.sendRequest(ct);
        }
        catch (ParseException parExc) {
            this.logger.severe("Parse Exception while parsing the callerAddess", (Throwable)parExc);
        }
        catch (InvalidArgumentException invalidArgExcep) {
            this.logger.severe("InvalidArgumentException while building Invite Request", (Throwable)invalidArgExcep);
        }
        catch (TransactionUnavailableException tranUnavExce) {
            this.logger.severe("TransactionUnavailableException when trying to getNewClientTransaction", (Throwable)tranUnavExce);
        }
        catch (UnrecognizedActivityException e) {
            this.logger.severe("UnrecognizedActivityException when trying to getActivityContextInterface", (Throwable)e);
        }
        catch (CreateException creaExce) {
            this.logger.severe("CreateException while trying to create Child", (Throwable)creaExce);
        }
        catch (SipException sipExec) {
            this.logger.severe("SipException while trying to send INVITE Request", (Throwable)sipExec);
        }
    }

    public void onNotificationRequestResponse(NotificationRequestResponse event, ActivityContextInterface aci) {
        this.logger.info("onNotificationRequestResponse");
        ReturnCode status = event.getReturnCode();
        switch (status.getValue()) {
            case 200: {
                this.logger.info("The Announcement should start.");
                break;
            }
            default: {
                ReturnCode rc = event.getReturnCode();
                this.logger.severe("RQNT failed. Value = " + rc.getValue() + " Comment = " + rc.getComment());
                if (!this.getChildSbbLocalObject().getSendBye()) break;
                this.getChildSbbLocalObject().sendBye();
            }
        }
    }

    public void onNotifyRequest(Notify event, ActivityContextInterface aci) {
        this.logger.info("onNotifyRequest");
        NotificationRequestResponse response = new NotificationRequestResponse(event.getSource(), ReturnCode.Transaction_Executed_Normally);
        response.setTransactionHandle(event.getTransactionHandle());
        this.getMgcpProvider().sendMgcpEvents(new JainMgcpEvent[]{response});
        EventName[] observedEvents = event.getObservedEvents();
        boolean success = false;
        String audioFile = null;
        block6: for (EventName observedEvent : observedEvents) {
            switch (observedEvent.getEventIdentifier().intValue()) {
                case 62: {
                    this.logger.info("Announcemnet Completed NTFY received");
                    if (!this.getSendBye() || !this.getChildSbbLocalObject().getSendBye()) continue block6;
                    this.getChildSbbLocalObject().sendBye();
                    continue block6;
                }
                case 63: {
                    this.logger.info("Announcemnet Failed received");
                    if (!this.getChildSbbLocalObject().getSendBye()) continue block6;
                    this.getChildSbbLocalObject().sendBye();
                    continue block6;
                }
                case 18: {
                    this.logger.info("You have pressed 1");
                    success = true;
                    audioFile = this.onDtmf1();
                    continue block6;
                }
                case 19: {
                    this.logger.info("You have pressed 2");
                    success = true;
                    audioFile = this.onDtmf2();
                    continue block6;
                }
                default: {
                    this.logger.info("Received undefined DTMF digit(Order approved?).");
                    audioFile = this.onDefaultDtmf();
                }
            }
        }
        if (audioFile != null) {
            CallControlSbbLocalObject child = this.getChildSbbLocalObject();
            child.sendRQNT(null, audioFile, true);
        }
        if (success) {
            this.setSendBye(success);
        }
    }

    private String onDefaultDtmf() {
        return this.getClass().getResource("audio/UserReConfirm.wav").toString();
    }

    private String onDtmf2() {
        String audioFile = this.getClass().getResource("audio/UserOrderCancelled.wav").toString();
        EntityManager mgr = null;
        Order order = null;
        mgr = this.emf.createEntityManager();
        order = (Order)mgr.createQuery("select o from Order o where o.orderId = :orderId").setParameter("orderId", (Object)this.getCustomEvent().getOrderId()).getSingleResult();
        order.setStatus(Order.Status.CANCELLED);
        mgr.flush();
        mgr.close();
        try {
            NullActivity nullActivity = this.getNullActivityFactory().createNullActivity();
            ActivityContextInterface nullActivityContextInterface = this.getNullACIFactory().getActivityContextInterface(nullActivity);
            this.fireOrderCancelled((CustomEvent)this.getCustomEvent().clone(), nullActivityContextInterface, null);
        }
        catch (UnrecognizedActivityException unreActExc) {
            unreActExc.printStackTrace();
        }
        return audioFile;
    }

    private String onDtmf1() {
        EntityManager mgr = null;
        Order order = null;
        String audioFile = this.getClass().getResource("audio/UserOrderConfirmed.wav").toString();
        mgr = this.emf.createEntityManager();
        order = (Order)mgr.createQuery("select o from Order o where o.orderId = :orderId").setParameter("orderId", (Object)this.getCustomEvent().getOrderId()).getSingleResult();
        order.setStatus(Order.Status.OPEN);
        mgr.flush();
        mgr.close();
        return audioFile;
    }

    public void onCreateConnectionResponse(CreateConnectionResponse event, ActivityContextInterface aci) {
        if (event.getSecondEndpointIdentifier() != null) {
            this.getChildSbbLocalObject().sendRQNT(this.getTtsString(), null, true);
            this.setTtsString(null);
        }
    }

    public abstract ChildRelation getCallControlSbbChild();

    public abstract void setCustomEvent(CustomEvent var1);

    public abstract CustomEvent getCustomEvent();

    public abstract void setSendBye(boolean var1);

    public abstract boolean getSendBye();

    public abstract void setTtsString(String var1);

    public abstract String getTtsString();

    public abstract void setChildSbbLocalObject(CallControlSbbLocalObject var1);

    public abstract CallControlSbbLocalObject getChildSbbLocalObject();
}

