/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.util;

import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.log4j.Logger;
import org.mobicents.slee.util.CacheUtility;

public class SharedHashMapCache
implements CacheUtility {
    private static SharedHashMapCache instance;
    private Logger log = Logger.getLogger(SharedHashMapCache.class);
    private static final String CACHE_JNDI_NAME = "java:jayway";

    public SharedHashMapCache() throws NamingException {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            ctx.lookup(CACHE_JNDI_NAME);
            this.rebind();
        }
        catch (NamingException e) {
            this.log.info((Object)"Binding cache to java:jayway");
            try {
                ctx.bind(CACHE_JNDI_NAME, new HashMap());
            }
            catch (NamingException ex) {
                this.log.error((Object)"Error in constructor, could not bind cache", (Throwable)ex);
                throw ex;
            }
        }
    }

    private void rebind() {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext();
            ctx.unbind(CACHE_JNDI_NAME);
            ctx.bind(CACHE_JNDI_NAME, new HashMap());
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    public static synchronized SharedHashMapCache getInstance() throws NamingException {
        if (instance == null) {
            instance = new SharedHashMapCache();
        }
        return instance;
    }

    public void put(String key, Object value) {
        try {
            Map cache = this.getCache();
            cache.put(key, value);
            this.log.debug((Object)("Putting " + value + " in key " + key));
        }
        catch (Exception e) {
            this.log.error((Object)("Exception caught while putting " + key + " + " + value + " into Cache"), (Throwable)e);
        }
    }

    public Object get(String key) {
        Object returnValue = null;
        try {
            Map cache = this.getCache();
            returnValue = cache.get(key);
            this.log.debug((Object)("Getting value " + returnValue + " for key " + key));
        }
        catch (Exception e) {
            this.log.error((Object)("Exception caught while getting key " + key));
        }
        return returnValue;
    }

    private Map getCache() throws NamingException {
        Map cache = null;
        try {
            InitialContext ctx = new InitialContext();
            cache = (Map)ctx.lookup(CACHE_JNDI_NAME);
        }
        catch (NamingException e) {
            this.log.error((Object)"Error looking up cache", (Throwable)e);
            throw e;
        }
        return cache;
    }

    public String toString() {
        Map cache = null;
        try {
            cache = this.getCache();
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
        return cache.toString();
    }
}

