/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.examples.convergeddemo.seam.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.mobicents.examples.convergeddemo.seam.model.Customer;
import org.mobicents.examples.convergeddemo.seam.model.OrderLine;
import org.mobicents.examples.convergeddemo.seam.model.Product;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Entity
@Table(name="ORDERS")
public class Order
implements Serializable {
    private static final long serialVersionUID = -5451107485769007079L;
    public static BigDecimal TAX_RATE = new BigDecimal(".0825");
    long orderId;
    Date orderDate;
    Timestamp deliveryDate;
    Customer customer;
    BigDecimal netAmount = BigDecimal.ZERO;
    BigDecimal tax = BigDecimal.ZERO;
    BigDecimal totalAmount = BigDecimal.ZERO;
    List<OrderLine> orderLines = new ArrayList<OrderLine>();
    Status status = Status.OPEN;
    String trackingNumber;

    @Id
    @GeneratedValue
    @Column(name="ORDERID")
    public long getOrderId() {
        return this.orderId;
    }

    public void setOrderId(long id) {
        this.orderId = id;
    }

    @Column(name="ORDERDATE", nullable=false)
    public Date getOrderDate() {
        return this.orderDate;
    }

    public void setOrderDate(Date date) {
        this.orderDate = date;
    }

    @Column(name="DELIVERYDATE", nullable=true)
    public Timestamp getDeliveryDate() {
        return this.deliveryDate;
    }

    public void setDeliveryDate(Timestamp date) {
        this.deliveryDate = date;
    }

    @Transient
    public boolean isEmpty() {
        return this.orderLines == null || this.orderLines.size() == 0;
    }

    @OneToMany(mappedBy="order", cascade={CascadeType.ALL})
    public List<OrderLine> getOrderLines() {
        return this.orderLines;
    }

    public void setOrderLines(List<OrderLine> lines) {
        this.orderLines = lines;
    }

    public void addProduct(Product product, int quantity) {
        for (OrderLine line : this.orderLines) {
            if (product.getProductId() != line.getProduct().getProductId()) continue;
            line.addQuantity(quantity);
            return;
        }
        OrderLine line = new OrderLine();
        line.setProduct(product);
        line.setQuantity(quantity);
        line.setOrder(this);
        this.orderLines.add(line);
    }

    public void removeProduct(Product product) {
        for (OrderLine line : this.orderLines) {
            if (product.getProductId() != line.getProduct().getProductId()) continue;
            this.orderLines.remove(line);
            return;
        }
    }

    @ManyToOne
    @JoinColumn(name="USERID")
    public Customer getCustomer() {
        return this.customer;
    }

    public void setCustomer(Customer customer) {
        this.customer = customer;
    }

    @Column(name="NETAMOUNT", nullable=false, precision=12, scale=2)
    public BigDecimal getNetAmount() {
        return this.netAmount;
    }

    public void setNetAmount(BigDecimal amount) {
        this.netAmount = amount;
    }

    @Column(name="TAX", nullable=false, precision=12, scale=2)
    public BigDecimal getTax() {
        return this.tax;
    }

    public void setTax(BigDecimal amount) {
        this.tax = amount;
    }

    @Column(name="TOTALAMOUNT", nullable=false, precision=12, scale=2)
    public BigDecimal getTotalAmount() {
        return this.totalAmount;
    }

    public void setTotalAmount(BigDecimal amount) {
        this.totalAmount = amount;
    }

    @Column(name="TRACKING")
    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    @Column(name="STATUS")
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Transient
    public int getStatusCode() {
        return this.status.ordinal();
    }

    public void calculateTotals() {
        BigDecimal total = BigDecimal.ZERO;
        int index = 1;
        for (OrderLine line : this.orderLines) {
            line.setPosition(index++);
            total = total.add(line.getProduct().getPrice().multiply(new BigDecimal(line.getQuantity())));
        }
        this.setNetAmount(total);
        this.setTax(this.round(this.getNetAmount().multiply(TAX_RATE)));
        this.setTotalAmount(this.getNetAmount().add(this.getTax()));
    }

    public void cancel() {
        this.setStatus(Status.CANCELLED);
    }

    public void process() {
        this.setStatus(Status.PROCESSING);
    }

    public void ship(String tracking) {
        this.setStatus(Status.SHIPPED);
        this.setTrackingNumber(tracking);
    }

    private BigDecimal round(BigDecimal amount) {
        return new BigDecimal(amount.movePointRight(2).add(new BigDecimal(".5")).toBigInteger()).movePointLeft(2);
    }

    @Transient
    public boolean isOpen() {
        return this.status == Status.OPEN;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        OPEN,
        CANCELLED,
        PROCESSING,
        SHIPPED;

    }
}

