/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.examples.convergeddemo.seam.action;

import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Resource;
import javax.ejb.Remove;
import javax.ejb.SessionContext;
import javax.ejb.Stateful;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.hibernate.validator.InvalidStateException;
import org.hibernate.validator.InvalidValue;
import org.jboss.seam.annotations.Begin;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Out;
import org.jboss.seam.bpm.Actor;
import org.jboss.seam.contexts.Context;
import org.jboss.seam.faces.FacesMessages;
import org.jboss.seam.security.Identity;
import org.mobicents.examples.convergeddemo.seam.action.EditCustomer;
import org.mobicents.examples.convergeddemo.seam.model.Customer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Stateful
@Name(value="editCustomer")
public class EditCustomerAction
implements EditCustomer {
    @PersistenceContext
    EntityManager em;
    @Resource
    SessionContext ctx;
    @In
    Context sessionContext;
    @In(create=true)
    @Out
    Customer customer;
    @In
    FacesMessages facesMessages;
    @In
    Identity identity;
    String password = null;

    @Override
    public void setPasswordVerify(String password) {
        this.password = password;
    }

    @Override
    public String getPasswordVerify() {
        return this.password;
    }

    @Override
    @Begin(nested=true, pageflow="newuser")
    public void startEdit() {
    }

    @Override
    public boolean isValidNamePassword() {
        boolean ok = true;
        if (!this.isUniqueName()) {
            this.facesMessages.add("userName", new Object[]{"This name is already in use"});
            ok = false;
        }
        if (!this.isPasswordsMatch()) {
            this.facesMessages.add("passwordVerify", new Object[]{"Must match password field"});
            ok = false;
        }
        return ok;
    }

    private boolean isUniqueName() {
        String name = this.customer.getUserName();
        if (name == null) {
            return true;
        }
        List results = this.em.createQuery("select c from Customer c where c.userName = :name").setParameter("name", (Object)name).getResultList();
        return results.size() == 0;
    }

    private boolean isPasswordsMatch() {
        String customerpass = this.customer.getPassword();
        return this.password != null && customerpass != null && customerpass.equals(this.password);
    }

    @Override
    public String saveUser() {
        if (!this.isValidNamePassword()) {
            this.facesMessages.add("User name #{customer.userName} is not unique", new Object[0]);
            return null;
        }
        try {
            this.em.persist((Object)this.customer);
            this.sessionContext.set("currentUser", (Object)this.customer);
            Actor.instance().setId(this.customer.getUserName());
            this.identity.setUsername(this.customer.getUserName());
            this.identity.setPassword(this.customer.getPassword());
            this.identity.login();
            this.facesMessages.addFromResourceBundle("createCustomerSuccess", new Object[0]);
            return "success";
        }
        catch (InvalidStateException e) {
            InvalidValue[] vals;
            for (InvalidValue val : vals = e.getInvalidValues()) {
                this.facesMessages.add(val);
            }
            return null;
        }
        catch (RuntimeException e) {
            this.ctx.setRollbackOnly();
            this.facesMessages.addFromResourceBundle("createCustomerError", new Object[0]);
            return null;
        }
    }

    @Override
    public Map<String, Integer> getCreditCardTypes() {
        TreeMap<String, Integer> map = new TreeMap<String, Integer>();
        for (int i = 1; i <= 5; ++i) {
            map.put(Customer.cctypes[i - 1], i);
        }
        return map;
    }

    @Override
    @Remove
    public void destroy() {
    }
}

