/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.service.httpclientra.example;

import com.sun.syndication.feed.synd.SyndEntryImpl;
import com.sun.syndication.feed.synd.SyndFeed;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.io.SyndFeedInput;
import com.sun.syndication.io.XmlReader;
import java.io.IOException;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.UnrecognizedActivityException;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerID;
import javax.slee.facilities.TimerOptions;
import javax.slee.serviceactivity.ServiceActivity;
import javax.slee.serviceactivity.ServiceActivityFactory;
import javax.slee.serviceactivity.ServiceStartedEvent;
import net.java.client.slee.resource.http.HttpClientActivity;
import net.java.client.slee.resource.http.HttpClientActivityContextInterfaceFactory;
import net.java.client.slee.resource.http.HttpClientResourceAdaptorSbbInterface;
import net.java.client.slee.resource.http.event.Response;
import net.java.client.slee.resource.http.event.ResponseEvent;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.log4j.Logger;

public abstract class HttpClientRAExampleSbb
implements Sbb {
    private static Logger log = Logger.getLogger(HttpClientRAExampleSbb.class);
    private SbbContext sbbContext;
    private TimerFacility timerFacility;
    private HttpClientActivityContextInterfaceFactory httpClientAci;
    private HttpClientResourceAdaptorSbbInterface raSbbInterface;

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void setSbbContext(SbbContext context) {
        log.info((Object)"Called setSbbContext of HttpClientRAExampleSbb");
        this.sbbContext = context;
        try {
            Context ctx = (Context)new InitialContext().lookup("java:comp/env");
            this.httpClientAci = (HttpClientActivityContextInterfaceFactory)ctx.lookup("slee/resources/http-client-ra/http-client-ra-acif");
            this.raSbbInterface = (HttpClientResourceAdaptorSbbInterface)ctx.lookup("slee/resources/http-client-ra/org.mobicents/1.0.00/http-client-ra/sbb2ra");
            this.timerFacility = (TimerFacility)ctx.lookup("slee/facilities/timer");
        }
        catch (NamingException ne) {
            log.error((Object)"Could not set SBB context:", (Throwable)ne);
        }
    }

    public void unsetSbbContext() {
    }

    public void onStartServiceEvent(ServiceStartedEvent event, ActivityContextInterface aci) {
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            ServiceActivity sa = ((ServiceActivityFactory)myEnv.lookup("slee/serviceactivity/factory")).getActivity();
            if (sa.equals(aci.getActivity())) {
                System.out.println("<><><><><> \n onStartServiceEvent of HttpClientRAExampleSbb \n <><><><><><><>");
                System.out.println("Activity = " + aci.getActivity().getClass().getName());
                this.processRssFeed();
                this.setTimer(aci);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void processRssFeed() {
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            String rssFeedString = (String)myEnv.lookup("RSSFeedURL");
            URL rssFeedUrl = new URL(rssFeedString);
            SyndFeedInput input = new SyndFeedInput();
            SyndFeed feed = input.build((Reader)new XmlReader(rssFeedUrl));
            if (feed.hashCode() != this.getFeedHashCode()) {
                log.info((Object)("There is a new entry in the RSS Feed " + rssFeedString));
                this.setFeedHashCode(feed.hashCode());
                List list = feed.getEntries();
                for (SyndEntryImpl syndFeed : list) {
                    log.info((Object)("Getting the Content for URL " + syndFeed.getLink()));
                    HttpMethod httpMethod = this.raSbbInterface.createHttpMethod("GET", syndFeed.getLink());
                    try {
                        HttpClientActivity clientActivity = this.raSbbInterface.createHttpClientActivity(true);
                        ActivityContextInterface clientAci = this.httpClientAci.getActivityContextInterface(clientActivity);
                        clientAci.attach(this.sbbContext.getSbbLocalObject());
                        clientActivity.executeMethod(httpMethod);
                    }
                    catch (UnrecognizedActivityException uaex) {
                        log.error((Object)"Error while creating HttpClientActivity", (Throwable)uaex);
                    }
                }
            } else {
                log.info((Object)("No new entry in the RSS Feed " + rssFeedString));
            }
        }
        catch (NamingException namingEx) {
            log.error((Object)"NamingException", (Throwable)namingEx);
        }
        catch (MalformedURLException malformedEx) {
            log.error((Object)"MalformedURLException", (Throwable)malformedEx);
        }
        catch (IOException ioEx) {
            log.error((Object)"IOException", (Throwable)ioEx);
        }
        catch (FeedException feedEx) {
            log.error((Object)"FeedException", (Throwable)feedEx);
        }
    }

    private void setTimer(ActivityContextInterface aci) {
        TimerOptions options = new TimerOptions();
        options.setPersistent(true);
        try {
            InitialContext initCtx = new InitialContext();
            Context myEnv = (Context)initCtx.lookup("java:comp/env");
            long refreshTime = (Long)myEnv.lookup("RefreshTime");
            TimerID timerID = this.timerFacility.setTimer(aci, null, System.currentTimeMillis() + refreshTime, options);
            this.setTimerID(timerID);
        }
        catch (NamingException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        log.info((Object)"########## HttpClientRAExampleSbb: onTimerEvent ##########");
        this.processRssFeed();
        this.setTimer(aci);
    }

    public void onResponseEvent(ResponseEvent event, ActivityContextInterface aci) {
        Response response = event.getResponse();
        log.info((Object)"********** onResponseEvent **************");
        log.info((Object)("Status Code = " + response.getStatusCode()));
        log.info((Object)("Response Body = " + response.getResponseBodyAsString()));
        log.info((Object)"*****************************************");
    }

    public abstract void setTimerID(TimerID var1);

    public abstract TimerID getTimerID();

    public abstract void setFeedHashCode(int var1);

    public abstract int getFeedHashCode();
}

