/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.mgcp.demo;

import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.message.CreateConnection;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.NotificationRequestResponse;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConflictingParameterException;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.NotifiedEntity;
import jain.protocol.ip.mgcp.message.parms.RequestedAction;
import jain.protocol.ip.mgcp.message.parms.RequestedEvent;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import jain.protocol.ip.mgcp.pkg.PackageName;
import java.text.ParseException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sip.Dialog;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipException;
import javax.sip.Transaction;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ToHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.FactoryException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.UnrecognizedActivityException;
import javax.slee.facilities.Tracer;
import net.java.slee.resource.mgcp.JainMgcpProvider;
import net.java.slee.resource.mgcp.MgcpActivityContextInterfaceFactory;
import net.java.slee.resource.mgcp.MgcpConnectionActivity;
import net.java.slee.resource.mgcp.MgcpEndpointActivity;
import net.java.slee.resource.sip.DialogActivity;
import net.java.slee.resource.sip.SipActivityContextInterfaceFactory;
import net.java.slee.resource.sip.SleeSipProvider;

public abstract class TTSSbb
implements Sbb {
    public static final String ENDPOINT_NAME = "/mobicents/media/IVR/$";
    public static final String JBOSS_BIND_ADDRESS = System.getProperty("jboss.bind.address", "127.0.0.1");
    public static final String WELCOME = "Hello World. This is Mobicents Media Server Text To Speech Demo. Press any button on your touch dial phone.";
    private static final String DTMF_0 = "You have pressed Zero";
    private static final String DTMF_1 = "You have pressed One";
    private static final String DTMF_2 = "You have pressed Two";
    private static final String DTMF_3 = "You have pressed Three";
    private static final String DTMF_4 = "You have pressed Four";
    private static final String DTMF_5 = "You have pressed Five";
    private static final String DTMF_6 = "You have pressed Six";
    private static final String DTMF_7 = "You have pressed Seven";
    private static final String DTMF_8 = "You have pressed Eight";
    private static final String DTMF_9 = "You have pressed Nine";
    private static final String STAR = "You have pressed Star Sign";
    private static final String POUND = "You have pressed Pound Sign";
    private static final String A = "You have pressed A";
    private static final String B = "You have pressed B";
    private static final String C = "You have pressed C";
    private static final String D = "You have pressed D";
    private SbbContext sbbContext;
    private SleeSipProvider provider;
    private AddressFactory addressFactory;
    private HeaderFactory headerFactory;
    private MessageFactory messageFactory;
    private SipActivityContextInterfaceFactory acif;
    private JainMgcpProvider mgcpProvider;
    private MgcpActivityContextInterfaceFactory mgcpAcif;
    public static final int MGCP_PEER_PORT = 2427;
    public static final int MGCP_PORT = 2727;
    private Tracer logger;

    public void onCallCreated(RequestEvent evt, ActivityContextInterface aci) {
        Request request = evt.getRequest();
        FromHeader from = (FromHeader)request.getHeader("From");
        ToHeader to = (ToHeader)request.getHeader("To");
        this.logger.info("Incoming call " + from + " " + to);
        ActivityContextInterface daci = null;
        try {
            Dialog dialog = this.provider.getNewDialog((Transaction)evt.getServerTransaction());
            dialog.terminateOnBye(true);
            daci = this.acif.getActivityContextInterface((DialogActivity)dialog);
            daci.attach(this.sbbContext.getSbbLocalObject());
        }
        catch (Exception e) {
            this.logger.severe("Error during dialog creation", (Throwable)e);
            this.respond(evt, 500);
            return;
        }
        CallIdentifier callID = this.mgcpProvider.getUniqueCallIdentifier();
        this.setCallIdentifier(callID.toString());
        EndpointIdentifier endpointID = new EndpointIdentifier(ENDPOINT_NAME, JBOSS_BIND_ADDRESS + ":" + 2427);
        CreateConnection createConnection = new CreateConnection((Object)this, callID, endpointID, ConnectionMode.SendRecv);
        try {
            String sdp = new String(evt.getRequest().getRawContent());
            createConnection.setRemoteConnectionDescriptor(new ConnectionDescriptor(sdp));
        }
        catch (ConflictingParameterException e) {
            // empty catch block
        }
        int txID = this.mgcpProvider.getUniqueTransactionHandler();
        createConnection.setTransactionHandle(txID);
        MgcpConnectionActivity connectionActivity = null;
        try {
            connectionActivity = this.mgcpProvider.getConnectionActivity(txID, endpointID);
            ActivityContextInterface epnAci = this.mgcpAcif.getActivityContextInterface(connectionActivity);
            epnAci.attach(this.sbbContext.getSbbLocalObject());
        }
        catch (FactoryException ex) {
            ex.printStackTrace();
        }
        catch (NullPointerException ex) {
            ex.printStackTrace();
        }
        catch (UnrecognizedActivityException ex) {
            ex.printStackTrace();
        }
        this.mgcpProvider.sendMgcpEvents(new JainMgcpEvent[]{createConnection});
    }

    public void onCreateConnectionResponse(CreateConnectionResponse event, ActivityContextInterface aci) {
        this.logger.info("Receive CRCX response: " + event.getTransactionHandle());
        ServerTransaction txn = this.getServerTransaction();
        Request request = txn.getRequest();
        ReturnCode status = event.getReturnCode();
        switch (status.getValue()) {
            case 200: {
                this.setEndpointName(event.getSpecificEndpointIdentifier().getLocalEndpointName());
                this.logger.info("***&& " + this.getEndpointName());
                ConnectionIdentifier connectionIdentifier = event.getConnectionIdentifier();
                this.setConnectionIdentifier(connectionIdentifier.toString());
                String sdp = event.getLocalConnectionDescriptor().toString();
                ContentTypeHeader contentType = null;
                try {
                    contentType = this.headerFactory.createContentTypeHeader("application", "sdp");
                }
                catch (ParseException ex) {
                    // empty catch block
                }
                String localAddress = this.provider.getListeningPoints()[0].getIPAddress();
                int localPort = this.provider.getListeningPoints()[0].getPort();
                Address contactAddress = null;
                try {
                    contactAddress = this.addressFactory.createAddress("sip:" + localAddress + ":" + localPort);
                }
                catch (ParseException ex) {
                    // empty catch block
                }
                ContactHeader contact = this.headerFactory.createContactHeader(contactAddress);
                this.sendRQNT(WELCOME, true);
                Response response = null;
                try {
                    response = this.messageFactory.createResponse(200, request, contentType, sdp.getBytes());
                }
                catch (ParseException ex) {
                    this.logger.severe("ParseException while trying to create OK Response", (Throwable)ex);
                }
                response.setHeader((Header)contact);
                try {
                    txn.sendResponse(response);
                }
                catch (InvalidArgumentException ex) {
                    this.logger.severe("InvalidArgumentException while trying to send OK Response", (Throwable)ex);
                }
                catch (SipException ex) {
                    this.logger.severe("SipException while trying to send OK Response", (Throwable)ex);
                }
                break;
            }
            default: {
                try {
                    Response response = this.messageFactory.createResponse(500, request);
                    txn.sendResponse(response);
                    break;
                }
                catch (Exception ex) {
                    this.logger.severe("Exception while trying to send SERVER_INTERNAL_ERROR Response", (Throwable)ex);
                }
            }
        }
    }

    private void sendRQNT(String ttsText, boolean createActivity) {
        EndpointIdentifier endpointID = new EndpointIdentifier(this.getEndpointName(), JBOSS_BIND_ADDRESS + ":" + 2427);
        NotificationRequest notificationRequest = new NotificationRequest((Object)this, endpointID, this.mgcpProvider.getUniqueRequestIdentifier());
        ttsText = "ts(" + ttsText + ")";
        ConnectionIdentifier connectionIdentifier = new ConnectionIdentifier(this.getConnectionIdentifier());
        EventName[] signalRequests = new EventName[]{new EventName(PackageName.Announcement, MgcpEvent.ann.withParm(ttsText), connectionIdentifier)};
        notificationRequest.setSignalRequests(signalRequests);
        RequestedAction[] actions = new RequestedAction[]{RequestedAction.NotifyImmediately};
        RequestedEvent[] requestedEvents = new RequestedEvent[]{new RequestedEvent(new EventName(PackageName.Announcement, MgcpEvent.oc, connectionIdentifier), actions), new RequestedEvent(new EventName(PackageName.Announcement, MgcpEvent.of, connectionIdentifier), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf0, connectionIdentifier), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf1, connectionIdentifier), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf2, connectionIdentifier), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf3, connectionIdentifier), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf4, connectionIdentifier), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf5, connectionIdentifier), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf6, connectionIdentifier), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf7, connectionIdentifier), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf8, connectionIdentifier), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf9, connectionIdentifier), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmfA, connectionIdentifier), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmfB, connectionIdentifier), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmfC, connectionIdentifier), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmfD, connectionIdentifier), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmfStar, connectionIdentifier), actions), new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmfHash, connectionIdentifier), actions)};
        notificationRequest.setRequestedEvents(requestedEvents);
        notificationRequest.setTransactionHandle(this.mgcpProvider.getUniqueTransactionHandler());
        NotifiedEntity notifiedEntity = new NotifiedEntity(JBOSS_BIND_ADDRESS, JBOSS_BIND_ADDRESS, 2727);
        notificationRequest.setNotifiedEntity(notifiedEntity);
        if (createActivity) {
            MgcpEndpointActivity endpointActivity = null;
            try {
                endpointActivity = this.mgcpProvider.getEndpointActivity(endpointID);
                ActivityContextInterface epnAci = this.mgcpAcif.getActivityContextInterface(endpointActivity);
                epnAci.attach(this.sbbContext.getSbbLocalObject());
            }
            catch (FactoryException ex) {
                ex.printStackTrace();
            }
            catch (NullPointerException ex) {
                ex.printStackTrace();
            }
            catch (UnrecognizedActivityException ex) {
                ex.printStackTrace();
            }
        }
        this.mgcpProvider.sendMgcpEvents(new JainMgcpEvent[]{notificationRequest});
        this.logger.info(" NotificationRequest sent");
    }

    public void onNotificationRequestResponse(NotificationRequestResponse event, ActivityContextInterface aci) {
        this.logger.info("onNotificationRequestResponse");
        ReturnCode status = event.getReturnCode();
        switch (status.getValue()) {
            case 200: {
                this.logger.info("The Announcement should have been started");
                break;
            }
            default: {
                ReturnCode rc = event.getReturnCode();
                this.logger.severe("RQNT failed. Value = " + rc.getValue() + " Comment = " + rc.getComment());
            }
        }
    }

    public void onNotifyRequest(Notify event, ActivityContextInterface aci) {
        EventName[] observedEvents;
        this.logger.info("onNotifyRequest");
        NotificationRequestResponse response = new NotificationRequestResponse(event.getSource(), ReturnCode.Transaction_Executed_Normally);
        response.setTransactionHandle(event.getTransactionHandle());
        this.mgcpProvider.sendMgcpEvents(new JainMgcpEvent[]{response});
        block20: for (EventName observedEvent : observedEvents = event.getObservedEvents()) {
            switch (observedEvent.getEventIdentifier().intValue()) {
                case 62: {
                    this.logger.info("Announcemnet Completed NTFY received");
                    continue block20;
                }
                case 63: {
                    this.logger.info("Announcemnet Failed received");
                    continue block20;
                }
                case 17: {
                    this.logger.info("You have pressed 0");
                    this.sendRQNT(DTMF_0, false);
                    continue block20;
                }
                case 18: {
                    this.logger.info("You have pressed 1");
                    this.sendRQNT(DTMF_1, false);
                    continue block20;
                }
                case 19: {
                    this.logger.info("You have pressed 2");
                    this.sendRQNT(DTMF_2, false);
                    continue block20;
                }
                case 20: {
                    this.logger.info("You have pressed 3");
                    this.sendRQNT(DTMF_3, false);
                    continue block20;
                }
                case 21: {
                    this.logger.info("You have pressed 4");
                    this.sendRQNT(DTMF_4, false);
                    continue block20;
                }
                case 22: {
                    this.logger.info("You have pressed 5");
                    this.sendRQNT(DTMF_5, false);
                    continue block20;
                }
                case 23: {
                    this.logger.info("You have pressed 6");
                    this.sendRQNT(DTMF_6, false);
                    continue block20;
                }
                case 24: {
                    this.logger.info("You have pressed 7");
                    this.sendRQNT(DTMF_7, false);
                    continue block20;
                }
                case 25: {
                    this.logger.info("You have pressed 8");
                    this.sendRQNT(DTMF_8, false);
                    continue block20;
                }
                case 26: {
                    this.logger.info("You have pressed 9");
                    this.sendRQNT(DTMF_9, false);
                    continue block20;
                }
                case 27: {
                    this.logger.info(A);
                    this.sendRQNT(A, false);
                    continue block20;
                }
                case 28: {
                    this.logger.info(B);
                    this.sendRQNT(B, false);
                    continue block20;
                }
                case 29: {
                    this.logger.info(C);
                    this.sendRQNT(C, false);
                    continue block20;
                }
                case 30: {
                    this.logger.info(D);
                    this.sendRQNT(D, false);
                    continue block20;
                }
                case 32: {
                    this.logger.info("You have pressed *");
                    this.sendRQNT(STAR, false);
                    continue block20;
                }
                case 31: {
                    this.logger.info(C);
                    this.sendRQNT(POUND, false);
                }
            }
        }
    }

    public void onCallTerminated(RequestEvent evt, ActivityContextInterface aci) {
        EndpointIdentifier endpointID = new EndpointIdentifier(this.getEndpointName(), JBOSS_BIND_ADDRESS + ":" + 2427);
        DeleteConnection deleteConnection = new DeleteConnection((Object)this, endpointID);
        deleteConnection.setTransactionHandle(this.mgcpProvider.getUniqueTransactionHandler());
        this.mgcpProvider.sendMgcpEvents(new JainMgcpEvent[]{deleteConnection});
        ServerTransaction tx = evt.getServerTransaction();
        Request request = evt.getRequest();
        try {
            Response response = this.messageFactory.createResponse(200, request);
            tx.sendResponse(response);
        }
        catch (Exception e) {
            this.logger.severe("Error while sending DLCX ", (Throwable)e);
        }
    }

    private void respond(RequestEvent evt, int cause) {
        Request request = evt.getRequest();
        ServerTransaction tx = evt.getServerTransaction();
        try {
            Response response = this.messageFactory.createResponse(cause, request);
            tx.sendResponse(response);
        }
        catch (Exception e) {
            this.logger.warning("Unexpected error: ", (Throwable)e);
        }
    }

    private ServerTransaction getServerTransaction() {
        ActivityContextInterface[] activities;
        for (ActivityContextInterface activity : activities = this.sbbContext.getActivities()) {
            if (!(activity.getActivity() instanceof ServerTransaction)) continue;
            return (ServerTransaction)activity.getActivity();
        }
        return null;
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
        this.logger = sbbContext.getTracer(TTSSbb.class.getSimpleName());
        try {
            Context ctx = (Context)new InitialContext().lookup("java:comp/env");
            this.provider = (SleeSipProvider)ctx.lookup("slee/resources/jainsip/1.2/provider");
            this.addressFactory = this.provider.getAddressFactory();
            this.headerFactory = this.provider.getHeaderFactory();
            this.messageFactory = this.provider.getMessageFactory();
            this.acif = (SipActivityContextInterfaceFactory)ctx.lookup("slee/resources/jainsip/1.2/acifactory");
            this.mgcpProvider = (JainMgcpProvider)ctx.lookup("slee/resources/jainmgcp/2.0/provider/demo");
            this.mgcpAcif = (MgcpActivityContextInterfaceFactory)ctx.lookup("slee/resources/jainmgcp/2.0/acifactory/demo");
        }
        catch (Exception ne) {
            this.logger.severe("Could not set SBB context:", (Throwable)ne);
        }
    }

    public abstract String getConnectionIdentifier();

    public abstract void setConnectionIdentifier(String var1);

    public abstract String getCallIdentifier();

    public abstract void setCallIdentifier(String var1);

    public abstract String getRemoteSdp();

    public abstract void setRemoteSdp(String var1);

    public abstract String getEndpointName();

    public abstract void setEndpointName(String var1);

    public void unsetSbbContext() {
        this.sbbContext = null;
        this.logger = null;
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbRemove() {
    }

    public void sbbExceptionThrown(Exception exception, Object object, ActivityContextInterface activityContextInterface) {
    }

    public void sbbRolledBack(RolledBackContext rolledBackContext) {
    }
}

