/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.examples.media;

import java.util.List;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.Address;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.UnrecognizedActivityException;
import org.apache.log4j.Logger;
import org.mobicents.media.msc.common.MsLinkMode;
import org.mobicents.media.server.impl.common.events.EventID;
import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsConnectionEvent;
import org.mobicents.mscontrol.MsLink;
import org.mobicents.mscontrol.MsLinkEvent;
import org.mobicents.mscontrol.MsNotifyEvent;
import org.mobicents.mscontrol.MsProvider;
import org.mobicents.mscontrol.MsResource;
import org.mobicents.mscontrol.MsSession;
import org.mobicents.mscontrol.MsSignalGenerator;
import org.mobicents.slee.resource.media.ratype.MediaRaActivityContextInterfaceFactory;

public abstract class AnnouncementSbb
implements Sbb {
    public static final String ANNOUNCEMENT_ENDPOINT = "media/trunk/Announcement/$";
    private SbbContext sbbContext;
    private MsProvider msProvider;
    private MediaRaActivityContextInterfaceFactory mediaAcif;
    private Logger logger = Logger.getLogger(AnnouncementSbb.class);

    public void play(String userEndpoint, List announcements, boolean keepAlive) {
        this.setKeepAlive(keepAlive);
        this.setIndex(0);
        this.setSequence(announcements);
        ActivityContextInterface connectionActivity = this.getUserActivity();
        this.logger.info((Object)("Joining " + userEndpoint + " with " + ANNOUNCEMENT_ENDPOINT));
        MsConnection connection = (MsConnection)connectionActivity.getActivity();
        MsSession session = connection.getSession();
        MsLink link = session.createLink(MsLinkMode.FULL_DUPLEX);
        ActivityContextInterface linkActivity = null;
        try {
            linkActivity = this.mediaAcif.getActivityContextInterface(link);
        }
        catch (UnrecognizedActivityException ex) {
            // empty catch block
        }
        linkActivity.attach(this.sbbContext.getSbbLocalObject());
        link.join(userEndpoint, ANNOUNCEMENT_ENDPOINT);
    }

    public void onLinkCreated(MsLinkEvent evt, ActivityContextInterface aci) {
        MsLink link = evt.getSource();
        String announcementEndpoint = link.getEndpoints()[1];
        this.logger.info((Object)("Announcement endpoint: " + announcementEndpoint));
        this.setAnnouncementEndpoint(announcementEndpoint);
        this.playNext();
    }

    public void onAnnouncementComplete(MsNotifyEvent evt, ActivityContextInterface aci) {
        this.logger.info((Object)("Announcement complete: " + (this.getIndex() - 1)));
        if (this.getIndex() < this.getSequence().size()) {
            this.logger.info((Object)("Playing announcement[" + this.getIndex() + "]"));
            this.playNext();
            return;
        }
        if (this.getIndex() == this.getSequence().size() && !this.getKeepAlive()) {
            this.logger.info((Object)"Releasing link");
            MsLink link = this.getLink();
            link.release();
        } else {
            this.setIndex(0);
            this.playNext();
        }
    }

    public void playNext() {
        String url = (String)this.getSequence().get(this.getIndex());
        MsSignalGenerator generator = this.msProvider.getSignalGenerator(this.getAnnouncementEndpoint());
        try {
            ActivityContextInterface generatorActivity = this.mediaAcif.getActivityContextInterface((MsResource)generator);
            generatorActivity.attach(this.sbbContext.getSbbLocalObject());
            generator.apply(EventID.PLAY, new String[]{url});
            this.setIndex(this.getIndex() + 1);
        }
        catch (UnrecognizedActivityException unrecognizedActivityException) {
            // empty catch block
        }
    }

    public void onLinkReleased(MsLinkEvent evt, ActivityContextInterface aci) {
        this.logger.info((Object)"Link release completed");
        ActivityContextInterface connectionAci = this.getUserActivity();
        if (connectionAci != null && !connectionAci.isEnding()) {
            connectionAci.detach(this.sbbContext.getSbbLocalObject());
            this.fireLinkReleased(evt, connectionAci, null);
        }
    }

    public void onUserDisconnected(MsConnectionEvent evt, ActivityContextInterface aci) {
        this.logger.info((Object)("Disconnecting from " + this.getAnnouncementEndpoint()));
        MsLink link = this.getLink();
        if (link != null) {
            link.release();
        }
    }

    public abstract void fireLinkReleased(MsLinkEvent var1, ActivityContextInterface var2, Address var3);

    public MsLink getLink() {
        ActivityContextInterface[] activities = this.sbbContext.getActivities();
        for (int i = 0; i < activities.length; ++i) {
            if (!(activities[i].getActivity() instanceof MsLink)) continue;
            return (MsLink)activities[i].getActivity();
        }
        return null;
    }

    public ActivityContextInterface getUserActivity() {
        ActivityContextInterface[] activities = this.sbbContext.getActivities();
        for (int i = 0; i < activities.length; ++i) {
            if (!(activities[i].getActivity() instanceof MsConnection)) continue;
            return activities[i];
        }
        return null;
    }

    public abstract String getAnnouncementEndpoint();

    public abstract void setAnnouncementEndpoint(String var1);

    public abstract int getIndex();

    public abstract void setIndex(int var1);

    public abstract List getSequence();

    public abstract void setSequence(List var1);

    public abstract boolean getKeepAlive();

    public abstract void setKeepAlive(boolean var1);

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
        try {
            Context ctx = (Context)new InitialContext().lookup("java:comp/env");
            this.msProvider = (MsProvider)ctx.lookup("slee/resources/media/1.0/provider");
            this.mediaAcif = (MediaRaActivityContextInterfaceFactory)ctx.lookup("slee/resources/media/1.0/acifactory");
        }
        catch (Exception ne) {
            this.logger.error((Object)"Could not set SBB context:", (Throwable)ne);
        }
    }

    public void unsetSbbContext() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbRemove() {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }
}

