/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.examples.media.cnf;

import java.util.ArrayList;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.UnrecognizedActivityException;
import org.apache.log4j.Logger;
import org.mobicents.examples.media.Announcement;
import org.mobicents.media.msc.common.MsLinkMode;
import org.mobicents.mscontrol.MsConnection;
import org.mobicents.mscontrol.MsConnectionEvent;
import org.mobicents.mscontrol.MsLink;
import org.mobicents.mscontrol.MsLinkEvent;
import org.mobicents.mscontrol.MsProvider;
import org.mobicents.mscontrol.MsSession;
import org.mobicents.slee.resource.media.ratype.MediaRaActivityContextInterfaceFactory;

public abstract class ForestSbb
implements Sbb {
    public static final String CNF_ENDPOINT = "media/trunk/Cnf/$";
    public static final String CRICKETS = "http://localhost:8080/msdemo/audio/crickets.wav";
    public static final String MOCKING = "http://localhost:8080/msdemo/audio/mocking.wav";
    public static final String CUCKOO = "http://localhost:8080/msdemo/audio/cuckoo.wav";
    private SbbContext sbbContext;
    private MsProvider msProvider;
    private MediaRaActivityContextInterfaceFactory mediaAcif;
    private Logger logger = Logger.getLogger(ForestSbb.class);

    public void enter(String endpointName) {
        this.logger.info((Object)("Joining " + endpointName + " with " + CNF_ENDPOINT));
        MsConnection connection = (MsConnection)this.getConnectionActivity().getActivity();
        MsSession session = connection.getSession();
        MsLink link = session.createLink(MsLinkMode.FULL_DUPLEX);
        ActivityContextInterface linkActivity = null;
        try {
            linkActivity = this.mediaAcif.getActivityContextInterface(link);
        }
        catch (UnrecognizedActivityException ex) {
            // empty catch block
        }
        linkActivity.attach(this.sbbContext.getSbbLocalObject());
        link.join(endpointName, CNF_ENDPOINT);
    }

    public void onConfBridgeCreated(MsLinkEvent evt, ActivityContextInterface aci) {
        MsLink link = evt.getSource();
        String endpointName = link.getEndpoints()[1];
        this.logger.info((Object)("Created conference bridge: " + endpointName));
        ActivityContextInterface connectionActivity = this.getConnectionActivity();
        ChildRelation childRelation = this.getParticipantSbb();
        try {
            this.logger.info((Object)"Joining crickets: http://localhost:8080/msdemo/audio/crickets.wav");
            Announcement crickets = (Announcement)childRelation.create();
            connectionActivity.attach((SbbLocalObject)crickets);
            ArrayList<String> cricketVoice = new ArrayList<String>();
            cricketVoice.add(CRICKETS);
            crickets.play(endpointName, cricketVoice, true);
            this.logger.info((Object)"Joining mocking: http://localhost:8080/msdemo/audio/mocking.wav");
            ArrayList<String> mockingVoice = new ArrayList<String>();
            mockingVoice.add(MOCKING);
            Announcement mocking = (Announcement)childRelation.create();
            connectionActivity.attach((SbbLocalObject)mocking);
            mocking.play(endpointName, mockingVoice, true);
            this.logger.info((Object)"Joining cuckoo: http://localhost:8080/msdemo/audio/cuckoo.wav");
            Announcement cuckoo = (Announcement)childRelation.create();
            connectionActivity.attach((SbbLocalObject)cuckoo);
            ArrayList<String> cuckooVoice = new ArrayList<String>();
            cuckooVoice.add(CUCKOO);
            cuckoo.play(endpointName, cuckooVoice, true);
        }
        catch (CreateException e) {
            this.logger.error((Object)"Unexpected error", (Throwable)e);
        }
    }

    public void onConfBridgeFailed(MsLinkEvent evt, ActivityContextInterface aci) {
        this.logger.error((Object)("Joining error: cause = " + evt.getCause()));
    }

    public void onUserDisconnected(MsConnectionEvent evt, ActivityContextInterface aci) {
        System.out.println("Finita la commedia");
        ActivityContextInterface[] activities = this.sbbContext.getActivities();
        for (int i = 0; i < activities.length; ++i) {
            if (!(activities[i].getActivity() instanceof MsLink)) continue;
            ((MsLink)activities[i].getActivity()).release();
        }
    }

    public abstract ChildRelation getParticipantSbb();

    public ActivityContextInterface getConnectionActivity() {
        ActivityContextInterface[] activities = this.sbbContext.getActivities();
        for (int i = 0; i < activities.length; ++i) {
            if (!(activities[i].getActivity() instanceof MsConnection)) continue;
            return activities[i];
        }
        return null;
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
        try {
            Context ctx = (Context)new InitialContext().lookup("java:comp/env");
            this.msProvider = (MsProvider)ctx.lookup("slee/resources/media/1.0/provider");
            this.mediaAcif = (MediaRaActivityContextInterfaceFactory)ctx.lookup("slee/resources/media/1.0/acifactory");
        }
        catch (Exception ne) {
            this.logger.error((Object)"Could not set SBB context:", (Throwable)ne);
        }
    }

    public void unsetSbbContext() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbRemove() {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }
}

