/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.example.sip;

import java.text.ParseException;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.Transaction;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.ContactHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.message.MessageFactory;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;
import javax.slee.resource.ResourceAdaptorTypeID;
import javax.slee.serviceactivity.ServiceStartedEvent;
import net.java.slee.resource.sip.DialogActivity;
import net.java.slee.resource.sip.SipActivityContextInterfaceFactory;
import net.java.slee.resource.sip.SleeSipProvider;
import org.mobicents.slee.ActivityContextInterfaceExt;
import org.mobicents.slee.SbbContextExt;

public abstract class SipUASExampleSbb
implements Sbb {
    private static final ResourceAdaptorTypeID sipRATypeID = new ResourceAdaptorTypeID("JAIN SIP", "javax.sip", "1.2");
    private static final String sipRALink = "SipRA";
    private SipActivityContextInterfaceFactory sipActivityContextInterfaceFactory;
    private SleeSipProvider sleeSipProvider;
    private AddressFactory addressFactory;
    private HeaderFactory headerFactory;
    private MessageFactory messageFactory;
    private TimerFacility timerFacility;
    private static ContactHeader contactHeader;
    private static TimerOptions timerOptions;
    private SbbContextExt sbbContext;

    private ContactHeader getContactHeader() throws ParseException {
        if (contactHeader == null) {
            ListeningPoint listeningPoint = this.sleeSipProvider.getListeningPoint("udp");
            SipURI sipURI = this.addressFactory.createSipURI(null, listeningPoint.getIPAddress());
            sipURI.setPort(listeningPoint.getPort());
            sipURI.setTransportParam(listeningPoint.getTransport());
            contactHeader = this.headerFactory.createContactHeader(this.addressFactory.createAddress((URI)sipURI));
        }
        return contactHeader;
    }

    private TimerOptions getTimerOptions() {
        if (timerOptions == null) {
            timerOptions = new TimerOptions();
            timerOptions.setPreserveMissed(TimerPreserveMissed.ALL);
        }
        return timerOptions;
    }

    public void onServiceStartedEvent(ServiceStartedEvent event, ActivityContextInterface aci) {
        this.sbbContext.getTracer(this.getClass().getSimpleName()).warning("Service activated, now execute SIPP script.");
    }

    public void onInviteEvent(RequestEvent requestEvent, ActivityContextInterface aci) {
        SbbLocalObject sbbLocalObject = this.sbbContext.getSbbLocalObject();
        aci.detach(sbbLocalObject);
        ServerTransaction serverTransaction = requestEvent.getServerTransaction();
        try {
            DialogActivity dialog = (DialogActivity)this.sleeSipProvider.getNewDialog((Transaction)serverTransaction);
            ActivityContextInterfaceExt dialogAci = (ActivityContextInterfaceExt)this.sipActivityContextInterfaceFactory.getActivityContextInterface(dialog);
            dialogAci.attach(sbbLocalObject);
            this.timerFacility.setTimer((ActivityContextInterface)dialogAci, null, System.currentTimeMillis() + 60000L, this.getTimerOptions());
            Response response = this.messageFactory.createResponse(180, requestEvent.getRequest());
            response.addHeader((Header)this.getContactHeader());
            serverTransaction.sendResponse(response);
            response = this.messageFactory.createResponse(200, requestEvent.getRequest());
            response.addHeader((Header)this.getContactHeader());
            serverTransaction.sendResponse(response);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        aci.detach(this.sbbContext.getSbbLocalObject());
        DialogActivity dialog = (DialogActivity)aci.getActivity();
        try {
            dialog.sendRequest(dialog.createRequest("BYE"));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void setSbbContext(SbbContext context) {
        this.sbbContext = (SbbContextExt)context;
        this.sipActivityContextInterfaceFactory = (SipActivityContextInterfaceFactory)this.sbbContext.getActivityContextInterfaceFactory(sipRATypeID);
        this.sleeSipProvider = (SleeSipProvider)this.sbbContext.getResourceAdaptorInterface(sipRATypeID, sipRALink);
        this.addressFactory = this.sleeSipProvider.getAddressFactory();
        this.headerFactory = this.sleeSipProvider.getHeaderFactory();
        this.messageFactory = this.sleeSipProvider.getMessageFactory();
        this.timerFacility = this.sbbContext.getTimerFacility();
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbRemove() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
    }

    public void sbbRolledBack(RolledBackContext context) {
    }
}

