/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.example.loadtest;

import java.text.ParseException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sip.ClientTransaction;
import javax.sip.RequestEvent;
import javax.sip.ResponseEvent;
import javax.sip.ServerTransaction;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;
import javax.slee.nullactivity.NullActivity;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;
import org.mobicents.slee.example.loadtest.SimpleCallSetupTerminatedByServerTestChildSbbLocalObject;
import org.mobicents.slee.resource.sip.SipActivityContextInterfaceFactory;
import org.mobicents.slee.resource.sip.SipResourceAdaptorSbbInterface;

public abstract class SimpleCallSetupTerminatedByServerTestSbb
implements Sbb {
    private SipActivityContextInterfaceFactory sipActivityContextInterfaceFactory;
    private SipResourceAdaptorSbbInterface sipFactoryProvider;
    private AddressFactory addressFactory;
    private HeaderFactory headerFactory;
    private MessageFactory messageFactory;
    private NullActivityFactory nullActivityFactory;
    private NullActivityContextInterfaceFactory nullACIFactory;
    private TimerFacility timerFacility;
    private SbbContext sbbContext;

    public abstract ChildRelation getChildRelation();

    public void onInviteEvent(RequestEvent event, ActivityContextInterface aci) {
        try {
            ((ServerTransaction)aci.getActivity()).sendResponse(this.createResponse(event.getRequest(), 200));
            Request bye = (Request)event.getRequest().clone();
            bye.setMethod("BYE");
            FromHeader fromHeader = (FromHeader)event.getRequest().getHeader("From");
            ToHeader toHeader = (ToHeader)event.getRequest().getHeader("To");
            bye.setRequestURI(fromHeader.getAddress().getURI());
            bye.setHeader((Header)this.headerFactory.createToHeader(fromHeader.getAddress(), fromHeader.getTag()));
            bye.setHeader((Header)this.headerFactory.createFromHeader(toHeader.getAddress(), "12345"));
            ((CSeqHeader)event.getRequest().getHeader("CSeq")).setMethod("BYE");
            ViaHeader viaHeader = (ViaHeader)bye.getHeader("Via");
            SipURI sipURI = (SipURI)event.getRequest().getRequestURI();
            viaHeader.setPort(sipURI.getPort());
            viaHeader.setHost(sipURI.getHost());
            ContactHeader contactHeader = (ContactHeader)bye.getHeader("Contact");
            contactHeader.setAddress(toHeader.getAddress());
            ((SimpleCallSetupTerminatedByServerTestChildSbbLocalObject)this.getChildRelation().create()).setBye(bye);
            NullActivity nullActivity = this.nullActivityFactory.createNullActivity();
            ActivityContextInterface nullActivityContextInterface = this.nullACIFactory.getActivityContextInterface(nullActivity);
            nullActivityContextInterface.attach(this.getSbbContext().getSbbLocalObject());
            TimerOptions timerOptions = new TimerOptions();
            timerOptions.setPreserveMissed(TimerPreserveMissed.ALL);
            this.timerFacility.setTimer(nullActivityContextInterface, null, System.currentTimeMillis() + 60000L, timerOptions);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected Response createResponse(Request request, int responseType) throws ParseException {
        SipURI sipUri = (SipURI)request.getRequestURI();
        SipURI sipAddress = this.addressFactory.createSipURI(sipUri.getUser(), sipUri.getHost());
        Response response = this.messageFactory.createResponse(responseType, request);
        response.addHeader((Header)this.headerFactory.createContactHeader(this.addressFactory.createAddress((URI)sipAddress)));
        return response;
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        try {
            ClientTransaction clientTransaction = this.sipFactoryProvider.getSipProvider().getNewClientTransaction(((SimpleCallSetupTerminatedByServerTestChildSbbLocalObject)this.getChildRelation().iterator().next()).getBye());
            this.sipActivityContextInterfaceFactory.getActivityContextInterface(clientTransaction).attach(this.getSbbContext().getSbbLocalObject());
            aci.detach(this.getSbbContext().getSbbLocalObject());
            clientTransaction.sendRequest();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onResponseOkEvent(ResponseEvent event, ActivityContextInterface aci) {
        aci.detach(this.getSbbContext().getSbbLocalObject());
    }

    public void setSbbContext(SbbContext context) {
        this.sbbContext = context;
        try {
            Context ctx = (Context)new InitialContext().lookup("java:comp/env");
            this.sipActivityContextInterfaceFactory = (SipActivityContextInterfaceFactory)ctx.lookup("slee/resources/jainsip/1.2/acifactory");
            this.sipFactoryProvider = (SipResourceAdaptorSbbInterface)ctx.lookup("slee/resources/jainsip/1.2/provider");
            this.addressFactory = this.sipFactoryProvider.getAddressFactory();
            this.headerFactory = this.sipFactoryProvider.getHeaderFactory();
            this.messageFactory = this.sipFactoryProvider.getMessageFactory();
            this.nullACIFactory = (NullActivityContextInterfaceFactory)ctx.lookup("slee/nullactivity/activitycontextinterfacefactory");
            this.nullActivityFactory = (NullActivityFactory)ctx.lookup("slee/nullactivity/factory");
            this.timerFacility = (TimerFacility)ctx.lookup("slee/facilities/timer");
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbRemove() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
    }

    public void sbbRolledBack(RolledBackContext context) {
    }

    protected SbbContext getSbbContext() {
        return this.sbbContext;
    }
}

