/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.services.sip.location.cache;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.URI;
import javax.sip.header.ContactHeader;
import javax.sip.header.HeaderFactory;
import org.mobicents.slee.services.sip.common.RegistrationBinding;

public class RegistrationBindingImpl
implements Serializable,
RegistrationBinding {
    private Date expiry;
    private float qValue;
    private String callId;
    private long cSeq;
    private String comment;
    private String contactAddress;
    private static Logger logger = Logger.getLogger(RegistrationBindingImpl.class.getName());

    public RegistrationBindingImpl(String contactAddress, String comment, long expiresDelta, float q, String id, long seq) {
        this.comment = comment;
        this.contactAddress = contactAddress;
        this.setExpiryDelta(expiresDelta);
        this.qValue = q;
        this.callId = id;
        this.cSeq = seq;
    }

    public long getExpiryAbsolute() {
        return this.expiry.getTime() / 1000L;
    }

    public int getExpiryDelta() {
        int expiryDelta = (int)(this.expiry.getTime() - System.currentTimeMillis());
        return expiryDelta / 1000 + 1;
    }

    public String getContactAddress() {
        return this.contactAddress;
    }

    public float getQValue() {
        return this.qValue;
    }

    public String getCallId() {
        return this.callId;
    }

    public long getCSeq() {
        return this.cSeq;
    }

    public String getComment() {
        return this.comment;
    }

    public void setExpiryAbsolute(long exp) {
        this.expiry = new Date(exp * 1000L);
    }

    public void setExpiryDelta(long exp) {
        Calendar now = Calendar.getInstance();
        now.add(13, (int)exp);
        this.expiry = now.getTime();
    }

    public void setContactAddress(String address) {
        this.contactAddress = address;
    }

    public void setQValue(float q) {
        this.qValue = q;
    }

    public void setCallId(String id) {
        this.callId = id;
    }

    public void setCSeq(long seq) {
        this.cSeq = seq;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    private String getScheme(String contactAddress) {
        int i = contactAddress.indexOf(58);
        if (i != -1) {
            return contactAddress.substring(0, i);
        }
        return null;
    }

    private String getSchemeData(String contactAddress) {
        int i = contactAddress.indexOf(58);
        if (i != -1) {
            return contactAddress.substring(i + 1, contactAddress.length());
        }
        return null;
    }

    public ContactHeader getContactHeader(AddressFactory af, HeaderFactory hf) {
        try {
            long expires = this.getExpiryDelta();
            if (expires <= 0L) {
                return null;
            }
            String contactAddress = this.getContactAddress();
            URI uri = af.createURI(contactAddress);
            Address nameAddress = af.createAddress(uri);
            ContactHeader contact = hf.createContactHeader(nameAddress);
            contact.setExpires(this.getExpiryDelta());
            contact.setQValue(this.getQValue());
            return contact;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to getContactHeader()", e);
            return null;
        }
    }

    public String toString() {
        return "RegistratoinBindingImpl[" + this.contactAddress + "," + this.comment + "," + this.expiry + "," + this.qValue + "," + this.callId + "," + this.cSeq + "]";
    }
}

