/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.services.sip.common;

import javax.sip.address.Address;
import javax.sip.address.URI;
import javax.sip.header.HeaderAddress;
import org.mobicents.slee.services.sip.common.ProxyConfiguration;

public class MessageUtils {
    protected ProxyConfiguration config = null;

    public MessageUtils(ProxyConfiguration config) {
        this.config = config;
    }

    public static String getCanonicalAddress(HeaderAddress header) {
        Address na = header.getAddress();
        URI uri = na.getURI();
        String addr = uri.toString();
        int index = addr.indexOf(58);
        if ((index = addr.indexOf(58, index + 1)) != -1) {
            addr = addr.substring(0, index);
        }
        return addr;
    }

    public boolean isLocalDomain(URI uri) {
        boolean belongs = false;
        String uriDomain = this.getDomain(uri);
        String[] localDomainNames = this.config.getLocalDomainNames();
        for (int i = 0; i < localDomainNames.length && !(belongs = this.belongsToDomain(uriDomain, localDomainNames[i])); ++i) {
        }
        return belongs;
    }

    private boolean belongsToDomain(String uriDomain, String domainSpec) {
        switch (domainSpec.indexOf("*.")) {
            case -1: {
                return domainSpec.equalsIgnoreCase(uriDomain);
            }
            case 0: {
                return uriDomain.toLowerCase().endsWith(domainSpec.substring(2).toLowerCase());
            }
        }
        return false;
    }

    public String getDomain(URI uri) {
        String address = uri.toString();
        int index = address.indexOf(64);
        if (index != -1) {
            address = address.substring(index + 1);
        }
        if ((index = address.indexOf(58)) != -1) {
            address = address.substring(index + 1);
        }
        if ((index = address.indexOf(58)) != -1) {
            address = address.substring(0, index);
        }
        return address;
    }

    public boolean isSupportedURIScheme(URI uri) {
        String uriScheme = uri.getScheme();
        String[] supportedURISchemes = this.config.getSupportedURISchemes();
        for (int i = 0; i < supportedURISchemes.length; ++i) {
            if (!supportedURISchemes[i].equalsIgnoreCase(uriScheme)) continue;
            return true;
        }
        return false;
    }
}

