/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.services.sip.location.cache;

import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.slee.ActivityContextInterface;
import javax.slee.ActivityEndEvent;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbID;
import javax.slee.facilities.ActivityContextNamingFacility;
import javax.slee.facilities.AlarmFacility;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerID;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;
import javax.slee.nullactivity.NullActivity;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;
import javax.slee.serviceactivity.ServiceActivity;
import javax.slee.serviceactivity.ServiceActivityFactory;
import javax.slee.serviceactivity.ServiceStartedEvent;
import javax.transaction.SystemException;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.services.sip.common.LocationInterface;
import org.mobicents.slee.services.sip.common.LocationServiceException;
import org.mobicents.slee.services.sip.common.RegistrationBinding;
import org.mobicents.slee.services.sip.location.cache.CacheLocationActivityContextInterface;
import org.mobicents.slee.services.sip.location.cache.RegistrationBindingImpl;
import org.mobicents.slee.services.sip.location.cache.mbean.LocationService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LocationSbb
implements Sbb,
LocationInterface {
    private static Logger logger = Logger.getLogger(LocationSbb.class.getCanonicalName());
    private SbbContext ctx = null;
    private TimerFacility timerFacility;
    private AlarmFacility alarmFacility;
    private ActivityContextNamingFacility namingFacility;
    private SbbID id;
    private NullActivityFactory nullActivityFactory;
    private NullActivityContextInterfaceFactory nullACIFactory;
    private Context myEnv;
    private static TimerOptions defaultTimerOptions = new TimerOptions(true, 500L, TimerPreserveMissed.LAST);
    private static final String JNDI_SERVICEACTIVITY_FACTORY = "java:comp/env/slee/serviceactivity/factory";
    private static final String JNDI_SERVICEACTIVITYACI_FACTORY = "java:comp/env/slee/serviceactivity/activitycontextinterfacefactory";
    private static final String JNDI_NULL_ACTIVITY_FACTORY = "java:comp/env/slee/nullactivity/factory";
    private static final String JNDI_NULL_ACI_FACTORY = "java:comp/env/slee/nullactivity/activitycontextinterfacefactory";
    private static final String JNDI_ACTIVITY_CONTEXT_NAMING_FACILITY = "java:comp/env/slee/facilities/activitycontextnaming";
    private static final String JNDI_TRACE_FACILITY = "java:comp/env/slee/facilities/trace";
    private static final String JNDI_TIMER_FACILITY_NAME = "java:comp/env/slee/facilities/timer";
    private static final String JNDI_ALARM_FACILITY_NAME = "java:comp/env/slee/facilities/alarm";
    private static final String JNDI_PROFILE_FACILITY_NAME = "java:comp/env/slee/facilities/profile";
    private static Timer tmpTimer = new Timer();

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public abstract CacheLocationActivityContextInterface asSbbActivityContextInterface(ActivityContextInterface var1);

    public void setSbbContext(SbbContext ctx) {
        this.ctx = ctx;
        try {
            this.id = ctx.getSbb();
            this.myEnv = new InitialContext();
            this.timerFacility = (TimerFacility)this.myEnv.lookup(JNDI_TIMER_FACILITY_NAME);
            this.alarmFacility = (AlarmFacility)this.myEnv.lookup(JNDI_ALARM_FACILITY_NAME);
            this.namingFacility = (ActivityContextNamingFacility)this.myEnv.lookup(JNDI_ACTIVITY_CONTEXT_NAMING_FACILITY);
            this.nullACIFactory = (NullActivityContextInterfaceFactory)this.myEnv.lookup(JNDI_NULL_ACI_FACTORY);
            this.nullActivityFactory = (NullActivityFactory)this.myEnv.lookup(JNDI_NULL_ACTIVITY_FACTORY);
        }
        catch (NamingException ne) {
            logger.log(Level.WARNING, "Could not set SBB context: ", ne);
        }
    }

    public void unsetSbbContext() {
        this.ctx = null;
    }

    @Override
    public RegistrationBinding addUserLocation(String sipAddress, String contactAddress, String comment, long expiresDelta, float q, String id, long seq) throws LocationServiceException {
        RegistrationBindingImpl bind = new RegistrationBindingImpl(contactAddress, "", expiresDelta, q, id, seq);
        org.mobicents.slee.services.sip.location.cache.LocationService ls = new org.mobicents.slee.services.sip.location.cache.LocationService();
        Map bindings = ls.getBindings(sipAddress);
        ActivityContextInterface _aci = null;
        if (bindings != null && bindings.containsKey(contactAddress)) {
            ActivityContextInterface[] acis;
            for (ActivityContextInterface aci : acis = this.ctx.getActivities()) {
                if (!(aci.getActivity() instanceof NullActivity)) continue;
                _aci = aci;
                CacheLocationActivityContextInterface local = this.asSbbActivityContextInterface(aci);
                if (local.getTimerID() == null) break;
                try {
                    this.timerFacility.cancelTimer(local.getTimerID());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                local.setTimerID(null);
                break;
            }
        }
        ls.addBinding(sipAddress, bind);
        this.setRegistrationTimer(sipAddress, contactAddress, expiresDelta, id, seq, _aci);
        return bind;
    }

    @Override
    public Set<String> getRegisteredUsers() {
        return new org.mobicents.slee.services.sip.location.cache.LocationService().getRegistered();
    }

    @Override
    public Map<String, RegistrationBinding> getUserBindings(String sipAddress) throws LocationServiceException {
        return new org.mobicents.slee.services.sip.location.cache.LocationService().getBindings(sipAddress);
    }

    @Override
    public void removeBinding(String sipAddress, String contactAddress) throws LocationServiceException {
        org.mobicents.slee.services.sip.location.cache.LocationService ls = new org.mobicents.slee.services.sip.location.cache.LocationService();
        Map bindings = ls.getBindings(sipAddress);
        if (bindings.isEmpty() || !bindings.containsKey(contactAddress)) {
            throw new LocationServiceException("No such contanct!!!!");
        }
        ls.removeBinding(sipAddress, contactAddress);
    }

    void setRegistrationTimer(String sipAddress, String sipContactAddress, long timeout, String callId, long cseq, ActivityContextInterface aci) {
        logger.finest("setRegistrationTimer(" + sipAddress + ", " + sipContactAddress + ", " + timeout + ", " + callId + ", " + cseq + ")");
        try {
            long expireTime = System.currentTimeMillis() + timeout * 1000L;
            ActivityContextInterface nullACI = null;
            if (aci == null) {
                NullActivity nullAC = this.nullActivityFactory.createNullActivity();
                nullACI = this.nullACIFactory.getActivityContextInterface(nullAC);
            } else {
                nullACI = aci;
            }
            CacheLocationActivityContextInterface regACI = this.asSbbActivityContextInterface(nullACI);
            regACI.setSipAddress(sipAddress);
            regACI.setSipContactAddress(sipContactAddress);
            regACI.setCallId(callId);
            regACI.setCSeq(cseq);
            regACI.attach(this.ctx.getSbbLocalObject());
            TimerOptions timerOpts = new TimerOptions();
            timerOpts.setPersistent(true);
            TimerID newTimer = this.timerFacility.setTimer((ActivityContextInterface)regACI, null, expireTime, timerOpts);
            regACI.setTimerID(newTimer);
            logger.fine("set new timer for registration: " + sipAddress + " -> " + sipContactAddress + ", expires in " + timeout + "s");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void expireRegistration(String sipAddress, String sipContactAddress, String callId, long cseq) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("Expire on[" + sipAddress + "][" + sipContactAddress + "][" + callId + "] [" + cseq + "]");
        }
        try {
            org.mobicents.slee.services.sip.location.cache.LocationService ls = new org.mobicents.slee.services.sip.location.cache.LocationService();
            Map bindings = ls.getBindings(sipAddress);
            if (bindings == null) {
                logger.warning("expireRegistration: user " + sipAddress + " not found.");
                return;
            }
            RegistrationBinding binding = (RegistrationBinding)bindings.get(sipContactAddress);
            if (binding == null) {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.warning("expireRegistration: registration for " + sipAddress + " -> " + sipContactAddress + " not found.");
                }
                return;
            }
            if (callId.equals(binding.getCallId()) && cseq == binding.getCSeq()) {
                ls.removeBinding(sipAddress, sipContactAddress);
                if (logger.isLoggable(Level.FINEST)) {
                    logger.finest("expireRegistration: removed binding: " + sipAddress + " -> " + sipContactAddress);
                }
            } else if (logger.isLoggable(Level.FINEST)) {
                logger.finest("expireRegistration: callId/cseq for binding (" + sipAddress + " -> " + sipContactAddress + ") has been updated, not removing");
            }
        }
        catch (LocationServiceException lse) {
            lse.printStackTrace();
        }
    }

    public void onBindingTimeout(TimerEvent timer, ActivityContextInterface aci) {
        CacheLocationActivityContextInterface local = this.asSbbActivityContextInterface(aci);
        this.expireRegistration(local.getSipAddress(), local.getSipContactAddress(), local.getCallId(), local.getCSeq());
        aci.detach(this.ctx.getSbbLocalObject());
    }

    public void onServiceStarted(ServiceStartedEvent serviceEvent, ActivityContextInterface aci) {
        logger.fine("Got a Service Started Event!");
        logger.fine("CREATING CONFIGURRATION");
        this.startMBeanConfigurator();
    }

    public void onActivityEndEvent(ActivityEndEvent event, ActivityContextInterface aci) {
        try {
            Context myEnv;
            ServiceActivity sa;
            Object activity = aci.getActivity();
            if (activity instanceof ServiceActivity && (sa = ((ServiceActivityFactory)(myEnv = (Context)new InitialContext().lookup("java:comp/env")).lookup("slee/serviceactivity/factory")).getActivity()).equals(activity)) {
                logger.finest("Service aci ending, removing mbean");
                this.clearENV();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void startMBeanConfigurator() {
        LocationService lsmb = new LocationService();
        Object confValue = null;
        Context myEnv = null;
        try {
            logger.info("Building Configuration from ENV Entries");
            myEnv = (Context)new InitialContext().lookup("java:comp/env");
            String configurationName = (String)myEnv.lookup("configuration-MBEAN");
            if (configurationName != null) {
                lsmb.setName(configurationName);
            }
        }
        catch (NamingException ne) {
            logger.warning("Could not set SBB context:" + ne.getMessage());
            return;
        }
        lsmb.startService();
    }

    protected void clearENV() {
        try {
            logger.info("Clearing environment, removing mbean");
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            String configurationName = (String)myEnv.lookup("configuration-MBEAN");
            MBeanServer mbs = SleeContainer.lookupFromJndi().getMBeanServer();
            ObjectName on = new ObjectName("slee:siplocationservice=" + configurationName);
            mbs.unregisterMBean(on);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class DebugTimerTask
    extends TimerTask {
        DebugTimerTask() {
        }

        public void run() {
            org.mobicents.slee.services.sip.location.cache.LocationService ls = new org.mobicents.slee.services.sip.location.cache.LocationService();
            System.out.println("=-=-=Registered users:");
            try {
                SleeContainer.getTransactionManager().begin();
            }
            catch (SystemException e1) {
                e1.printStackTrace();
            }
            int i = 0;
            for (Object user : ls.getRegistered()) {
                System.out.println("[" + i++ + "]" + user);
                try {
                    Map bindings = ls.getBindings((String)user);
                    if (bindings.isEmpty()) {
                        System.out.println("THIS SHOULD NOT HAPPEN");
                        continue;
                    }
                    int j = 0;
                    for (Object binding : bindings.values()) {
                        System.out.println("---[" + j++ + "]" + binding);
                    }
                }
                catch (LocationServiceException e) {
                    e.printStackTrace();
                }
            }
            try {
                SleeContainer.getTransactionManager().commit();
            }
            catch (SystemException e) {
                e.printStackTrace();
            }
        }
    }
}

