/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.services.sip.location.cache;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.transaction.SystemException;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.runtime.cache.CacheableMap;
import org.mobicents.slee.runtime.cache.CacheableSet;
import org.mobicents.slee.runtime.transaction.TransactionManagerImpl;
import org.mobicents.slee.services.sip.common.LocationServiceException;
import org.mobicents.slee.services.sip.common.RegistrationBinding;

public class LocationService {
    String tcache = TransactionManagerImpl.RUNTIME_CACHE;
    private Map bindingsMap = null;
    private static transient Logger logger = Logger.getLogger(LocationService.class.getName());
    private Set registered = null;
    private static String ALL_REGISTRATIONS = "ALL_REGISTRATIONS";
    private TransactionManagerImpl txm = (TransactionManagerImpl)SleeContainer.getTransactionManager();

    private Map getMap(String name) {
        CacheableMap map = new CacheableMap((Object)("location:" + name));
        return map;
    }

    private Set getSet(String name) {
        CacheableSet s = new CacheableSet((Object)("location:" + name));
        return s;
    }

    public Map getBindings(String sipAddress) throws LocationServiceException {
        boolean createdTX = false;
        HashMap toReturn = null;
        try {
            createdTX = this.txm.requireTransaction();
            if (this.bindingsMap == null) {
                this.bindingsMap = this.getMap(sipAddress);
            }
            toReturn = this.bindingsMap.isEmpty() ? new HashMap() : new HashMap(this.bindingsMap);
        }
        catch (Exception e) {
            throw new LocationServiceException(e.getLocalizedMessage());
        }
        finally {
            if (createdTX) {
                try {
                    this.txm.commit();
                }
                catch (SystemException e) {
                    e.printStackTrace();
                }
            }
        }
        return toReturn;
    }

    public void setBindings(String sipAddress, Map bindings) throws LocationServiceException {
        logger.info("^^^ public void setBindings(String sipAddress, Map bindings) throws LocationServiceException  { ^^^");
    }

    public void addBinding(String sipAddress, RegistrationBinding binding) throws LocationServiceException {
        logger.info("ADD BINDING[" + sipAddress + "][" + binding + "]");
        boolean createdTX = false;
        try {
            createdTX = this.txm.requireTransaction();
            if (this.bindingsMap == null) {
                this.bindingsMap = this.getMap(sipAddress);
            }
            this.bindingsMap.put(binding.getContactAddress(), binding);
            this.getSet(ALL_REGISTRATIONS).add(sipAddress);
        }
        catch (Exception e) {
            throw new LocationServiceException(e.getLocalizedMessage());
        }
        finally {
            if (createdTX) {
                try {
                    this.txm.commit();
                }
                catch (SystemException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void removeBinding(String sipAddress, String sipContact) throws LocationServiceException {
        boolean createdTX = false;
        try {
            createdTX = this.txm.requireTransaction();
            if (this.bindingsMap == null) {
                this.bindingsMap = this.getMap(sipAddress);
            }
            this.bindingsMap.remove(sipContact);
            if (this.bindingsMap.size() == 0) {
                this.getSet(ALL_REGISTRATIONS).remove(sipAddress);
                ((CacheableMap)this.bindingsMap).remove();
            }
        }
        catch (Exception e) {
            throw new LocationServiceException(e.getLocalizedMessage());
        }
        finally {
            if (createdTX) {
                try {
                    this.txm.commit();
                }
                catch (SystemException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set getRegistered() {
        boolean createdTX = false;
        try {
            createdTX = this.txm.requireTransaction();
            HashSet hashSet = new HashSet(this.getSet(ALL_REGISTRATIONS));
            return hashSet;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (createdTX) {
                try {
                    this.txm.commit();
                }
                catch (SystemException e) {
                    e.printStackTrace();
                }
            }
        }
        return new HashSet();
    }
}

