/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.services.sip.location.cache.mbean;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.services.sip.common.LocationServiceException;
import org.mobicents.slee.services.sip.common.RegistrationBinding;
import org.mobicents.slee.services.sip.location.cache.LocationSbb;
import org.mobicents.slee.services.sip.location.cache.mbean.LocationServiceMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocationService
implements LocationServiceMBean {
    private String name = "v1LocationService";
    private static final org.mobicents.slee.services.sip.location.cache.LocationService ls = new org.mobicents.slee.services.sip.location.cache.LocationService();

    @Override
    public Set<String> getContacts(String record) {
        try {
            return new HashSet<String>(ls.getBindings(record).keySet());
        }
        catch (LocationServiceException e) {
            e.printStackTrace();
            return new HashSet<String>();
        }
    }

    @Override
    public long getExpirationTime(String record, String contact) {
        try {
            Map bindings = ls.getBindings(record);
            RegistrationBinding rb = (RegistrationBinding)bindings.get(contact);
            if (rb != null) {
                return rb.getExpiryDelta();
            }
        }
        catch (LocationServiceException e) {
            e.printStackTrace();
            return Long.MIN_VALUE;
        }
        return 0L;
    }

    @Override
    public Set<String> getRegisteredUsers() {
        return new HashSet<String>(ls.getRegistered());
    }

    @Override
    public int getRegisteredUserCount() {
        return this.getRegisteredUsers().size();
    }

    public boolean startService() {
        MBeanServer mbs = SleeContainer.lookupFromJndi().getMBeanServer();
        ObjectName on = null;
        try {
            on = new ObjectName("slee:siplocationservice=" + this.name);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        try {
            if (mbs.getObjectInstance(on) != null) {
                return false;
            }
        }
        catch (InstanceNotFoundException e) {
            // empty catch block
        }
        try {
            Logger.getLogger(LocationSbb.class.getCanonicalName()).info("Binding LocationMBean to[" + on + "]");
            mbs.registerMBean(this, on);
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            return false;
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            return false;
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }
}

