/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.services.sip.location;

import java.io.Serializable;
import javax.sip.InvalidArgumentException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.header.ContactHeader;
import javax.sip.header.HeaderFactory;

public abstract class RegistrationBinding
implements Serializable {
    public abstract String getCallId();

    public abstract void setCallId(String var1);

    public abstract String getComment();

    public abstract void setComment(String var1);

    public abstract long getCSeq();

    public abstract void setCSeq(long var1);

    public abstract long getExpires();

    public abstract void setExpires(long var1);

    public abstract float getQValue();

    public abstract void setQValue(float var1);

    public abstract long getRegistrationDate();

    public abstract void setRegistrationDate(long var1);

    public abstract Address getContactAddress();

    public abstract String getSipAddress();

    public long getExpiresDelta() {
        return this.getExpires() - (System.currentTimeMillis() - this.getRegistrationDate()) / 1000L;
    }

    public ContactHeader getContactHeader(AddressFactory af, HeaderFactory hf) throws InvalidArgumentException {
        int expiresDelta = (int)this.getExpiresDelta();
        if (expiresDelta <= 0) {
            return null;
        }
        ContactHeader contact = hf.createContactHeader(this.getContactAddress());
        contact.setExpires(expiresDelta);
        contact.setQValue(this.getQValue());
        return contact;
    }

    public String toString() {
        return "RegistrationBinding[sipAddress=" + this.getSipAddress() + ",contactAddress=" + this.getContactAddress().getURI() + ",comment=" + this.getComment() + ",expires=" + this.getExpires() + ",qValue=" + this.getQValue() + ",callId=" + this.getCallId() + ",cSeq=" + this.getCSeq() + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getContactAddress() == null ? 0 : this.getContactAddress().hashCode());
        result = 31 * result + (this.getSipAddress() == null ? 0 : this.getSipAddress().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass() == this.getClass()) {
            RegistrationBinding other = (RegistrationBinding)obj;
            return this.getSipAddress().equals(other.getSipAddress()) && this.getContactAddress().equals(other.getContactAddress());
        }
        return false;
    }
}

