/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.services.sip.location;

import java.util.Map;
import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.facilities.ActivityContextNamingFacility;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerID;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.TimerPreserveMissed;
import javax.slee.nullactivity.NullActivity;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;
import org.apache.log4j.Logger;
import org.mobicents.slee.services.sip.location.LocationSbbLocalObject;
import org.mobicents.slee.services.sip.location.LocationService;
import org.mobicents.slee.services.sip.location.LocationServiceException;
import org.mobicents.slee.services.sip.location.LocationServiceFactory;
import org.mobicents.slee.services.sip.location.RegistrationBinding;
import org.mobicents.slee.services.sip.location.RegistrationBindingActivityContextInterface;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class LocationSbb
implements Sbb,
LocationSbbLocalObject {
    private static Logger logger = Logger.getLogger(LocationSbb.class);
    private static LocationService locationService = null;
    private static TimerOptions defaultTimerOptions = LocationSbb.createDefaultTimerOptions();
    private Context myEnv;
    private SbbContext sbbContext;
    private TimerFacility timerFacility;
    private NullActivityFactory nullActivityFactory;
    private NullActivityContextInterfaceFactory nullACIFactory;
    private ActivityContextNamingFacility activityContextNamingFacility;

    private static TimerOptions createDefaultTimerOptions() {
        TimerOptions timerOptions = new TimerOptions();
        timerOptions.setPreserveMissed(TimerPreserveMissed.ALL);
        return timerOptions;
    }

    public void sbbActivate() {
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbExceptionThrown(Exception arg0, Object arg1, ActivityContextInterface arg2) {
    }

    public void sbbLoad() {
    }

    public void sbbPassivate() {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbRolledBack(RolledBackContext arg0) {
    }

    public void sbbStore() {
    }

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
        try {
            this.myEnv = (Context)new InitialContext().lookup("java:comp/env");
            this.timerFacility = (TimerFacility)this.myEnv.lookup("slee/facilities/timer");
            this.nullACIFactory = (NullActivityContextInterfaceFactory)this.myEnv.lookup("slee/nullactivity/activitycontextinterfacefactory");
            this.nullActivityFactory = (NullActivityFactory)this.myEnv.lookup("slee/nullactivity/factory");
            this.activityContextNamingFacility = (ActivityContextNamingFacility)this.myEnv.lookup("slee/facilities/activitycontextnaming");
            if (locationService == null) {
                locationService = LocationServiceFactory.getLocationService((String)this.myEnv.lookup("LOCATION_SERVICE_CLASS_NAME"));
            }
        }
        catch (Exception ne) {
            logger.error((Object)"Could not set SBB context: ", (Throwable)ne);
        }
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }

    public abstract RegistrationBindingActivityContextInterface asSbbActivityContextInterface(ActivityContextInterface var1);

    private String getACIName(String contactAddress, String sipAddress) {
        return "LocationSbb:aci:ca=" + contactAddress + ",sa=" + sipAddress;
    }

    @Override
    public RegistrationBinding addBinding(String sipAddress, String contactAddress, String comment, long expires, long registrationDate, float qValue, String callId, long cSeq) throws LocationServiceException {
        RegistrationBinding registrationBinding = locationService.addBinding(sipAddress, contactAddress, comment, expires, registrationDate, qValue, callId, cSeq);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("addBinding: " + registrationBinding));
        }
        NullActivity nullActivity = this.nullActivityFactory.createNullActivity();
        ActivityContextInterface aci = null;
        try {
            aci = this.nullACIFactory.getActivityContextInterface(nullActivity);
            this.activityContextNamingFacility.bind(aci, this.getACIName(contactAddress, sipAddress));
        }
        catch (Exception e) {
            throw new LocationServiceException(e.getLocalizedMessage());
        }
        aci.attach(this.sbbContext.getSbbLocalObject());
        TimerID timerID = this.timerFacility.setTimer(aci, null, registrationDate + (expires + 1L) * 1000L, defaultTimerOptions);
        RegistrationBindingActivityContextInterface rgAci = this.asSbbActivityContextInterface(aci);
        rgAci.setTimerID(timerID);
        rgAci.setContactAddress(contactAddress);
        rgAci.setSipAddress(sipAddress);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("added binding: sipAddress=" + sipAddress + ",contactAddress=" + contactAddress));
        }
        return registrationBinding;
    }

    @Override
    public Set<String> getRegisteredUsers() throws LocationServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"getRegisteredUsers");
        }
        return locationService.getRegisteredUsers();
    }

    @Override
    public Map<String, RegistrationBinding> getBindings(String sipAddress) throws LocationServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("getBindings: sipAddress=" + sipAddress));
        }
        return locationService.getBindings(sipAddress);
    }

    @Override
    public void updateBinding(RegistrationBinding registrationBinding) throws LocationServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("updateBinding: registrationBinding=" + registrationBinding));
        }
        ActivityContextInterface aci = this.activityContextNamingFacility.lookup(this.getACIName(registrationBinding.getContactAddress(), registrationBinding.getSipAddress()));
        RegistrationBindingActivityContextInterface rgAci = this.asSbbActivityContextInterface(aci);
        this.timerFacility.cancelTimer(rgAci.getTimerID());
        rgAci.setTimerID(this.timerFacility.setTimer(aci, null, registrationBinding.getRegistrationDate() + (registrationBinding.getExpires() + 1L) * 1000L, defaultTimerOptions));
        locationService.updateBinding(registrationBinding);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("binding updated: sipAddress=" + registrationBinding.getSipAddress() + ",contactAddress=" + registrationBinding.getContactAddress()));
        }
    }

    @Override
    public void removeBinding(String sipAddress, String contactAddress) throws LocationServiceException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("removeBinding: sipAddress=" + sipAddress + ",contactAddress=" + contactAddress));
        }
        try {
            ActivityContextInterface aci = this.activityContextNamingFacility.lookup(this.getACIName(contactAddress, sipAddress));
            if (aci != null) {
                this.timerFacility.cancelTimer(this.asSbbActivityContextInterface(aci).getTimerID());
                this.activityContextNamingFacility.unbind(this.getACIName(contactAddress, sipAddress));
                ((NullActivity)aci.getActivity()).endActivity();
            }
        }
        catch (Exception e) {
            throw new LocationServiceException(e.getLocalizedMessage());
        }
        locationService.removeBinding(sipAddress, contactAddress);
        if (logger.isInfoEnabled()) {
            logger.info((Object)("removed binding: sipAddress=" + sipAddress + ",contactAddress=" + contactAddress));
        }
    }

    public void onTimerEvent(TimerEvent timer, ActivityContextInterface aci) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"onTimerEvent()");
        }
        aci.detach(this.sbbContext.getSbbLocalObject());
        RegistrationBindingActivityContextInterface rgAci = this.asSbbActivityContextInterface(aci);
        String contactAddress = rgAci.getContactAddress();
        String sipAddress = rgAci.getSipAddress();
        try {
            this.activityContextNamingFacility.unbind(this.getACIName(contactAddress, sipAddress));
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        try {
            locationService.removeBinding(sipAddress, contactAddress);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        if (logger.isInfoEnabled()) {
            logger.info((Object)("binding expired: sipAddress=" + sipAddress + ",contactAddress=" + contactAddress));
        }
    }

    @Override
    public void init() {
        try {
            locationService.init();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    @Override
    public void shutdown() {
        try {
            locationService.shutdown();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }
}

