/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.services.sip.proxy.mbean;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Properties;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.mobicents.slee.container.SleeContainer;
import org.mobicents.slee.services.sip.proxy.mbean.ProxyConfiguratorMBean;

public class ProxyConfigurator
implements Serializable,
ProxyConfiguratorMBean,
Cloneable {
    private String name = "only";
    private Set localDomains = new HashSet(5);
    private ArrayList mustPassThrough = new ArrayList();
    private Set supportedUriSchemes = new HashSet(2);
    private String hostName = null;
    private long minExpires;
    private long maxExpires;
    private int port = 5060;
    private double cTimer = 180.0;
    private String[] transports;

    public ProxyConfigurator() {
        String val;
        int value;
        InputStream IS = ProxyConfigurator.class.getResourceAsStream("configuration.properties");
        Properties props = new Properties();
        try {
            props.load(IS);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String d = props.getProperty("domains", "nist.gov,mobicents.org");
        String[] splited = d.split(",");
        for (int i = 0; i < splited.length; ++i) {
            this.localDomains.add(splited[i]);
        }
        String jbossBindingAddress = System.getProperty("bind.address", "127.0.0.1");
        if (!this.localDomains.contains(jbossBindingAddress)) {
            this.localDomains.add(jbossBindingAddress);
        }
        if ((value = Integer.parseInt(val = props.getProperty("min.expires", "60"))) < 60) {
            value = 60;
        }
        this.minExpires = value;
        val = props.getProperty("max.expires", "3660");
        value = Integer.parseInt(val);
        if (value > 3600) {
            value = 3600;
        }
        this.maxExpires = value;
        val = props.getProperty("c.time", "180");
        double v = 0.0;
        v = Double.parseDouble(val);
        if (v < 180.0) {
            v = 180.0;
        }
        this.cTimer = v;
        this.name = val = props.getProperty("configuration.name", "only_human");
    }

    public void addLocalDomain(String localDomainToAdd) {
        this.localDomains.add(localDomainToAdd);
    }

    public void addMustPassThrough(int pos, String host) {
        if (this.mustPassThrough.size() >= pos) {
            this.mustPassThrough.add(host);
        } else {
            this.mustPassThrough.add(pos, host);
        }
    }

    public void addSupportedURIScheme(String schemeToAdd) {
        this.supportedUriSchemes.add(schemeToAdd);
    }

    public String getSipHostName() {
        return this.hostName;
    }

    public void removeLocalDomain(String localDomainToRemove) {
        this.localDomains.remove(localDomainToRemove);
    }

    public void removeMustPassThrough(int pos) {
        this.mustPassThrough.remove(pos);
    }

    public void removeMustPassThrough(String host) {
        this.mustPassThrough.remove(host);
    }

    public void removeSupportedURIScheme(String schemeToRemove) {
        this.supportedUriSchemes.remove(schemeToRemove);
    }

    public void setSipHostName(String sipHostName) {
        if (sipHostName == null || sipHostName.equals("")) {
            throw new IllegalArgumentException("Sip HostName cant be[" + sipHostName + "]");
        }
        this.hostName = sipHostName;
    }

    public void setSipPort(int port) {
        this.port = port;
    }

    public void setSipTransports(String[] transports) {
        if (transports == null) {
            throw new IllegalArgumentException("Sip Transport cant be one of [" + transports + "]");
        }
        this.transports = transports;
    }

    public String[] getLocalDomainNames() {
        String[] tmp = new String[1];
        return this.localDomains.toArray(tmp);
    }

    public String[] getPassThroughList() {
        String[] tmp = new String[1];
        return this.mustPassThrough.toArray(tmp);
    }

    public String getSipHostname() {
        return this.hostName;
    }

    public int getSipPort() {
        return this.port;
    }

    public String[] getSipTransports() {
        return this.transports;
    }

    public String[] getSupportedURISchemes() {
        String[] tmp = new String[1];
        return this.supportedUriSchemes.toArray(tmp);
    }

    public boolean startService() {
        MBeanServer mbs = SleeContainer.lookupFromJndi().getMBeanServer();
        ObjectName on = null;
        try {
            on = new ObjectName("slee:sipproxyconfigurator=" + this.name);
        }
        catch (MalformedObjectNameException e) {
            e.printStackTrace();
        }
        catch (NullPointerException e) {
            e.printStackTrace();
        }
        try {
            if (mbs.getObjectInstance(on) != null) {
                mbs.unregisterMBean(on);
            }
        }
        catch (InstanceNotFoundException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            mbs.registerMBean(this, on);
        }
        catch (InstanceAlreadyExistsException e) {
            e.printStackTrace();
            return false;
        }
        catch (MBeanRegistrationException e) {
            e.printStackTrace();
            return false;
        }
        catch (NotCompliantMBeanException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Object clone() {
        ProxyConfigurator proxy = new ProxyConfigurator();
        proxy.setSipHostName(this.getSipHostname());
        proxy.setSipPort(this.getSipPort());
        proxy.setSipTransports(this.getSipTransports());
        Iterator it = this.localDomains.iterator();
        while (it.hasNext()) {
            proxy.addLocalDomain((String)it.next());
        }
        it = this.supportedUriSchemes.iterator();
        while (it.hasNext()) {
            proxy.addSupportedURIScheme((String)it.next());
        }
        it = this.mustPassThrough.iterator();
        int count = 0;
        while (it.hasNext()) {
            proxy.addMustPassThrough(count++, (String)it.next());
        }
        proxy.name = this.name;
        return proxy;
    }
}

