/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.services.sip.registrar;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipProvider;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContactHeader;
import javax.sip.header.DateHeader;
import javax.sip.header.ExpiresHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderAddress;
import javax.sip.header.HeaderFactory;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbID;
import javax.slee.SbbLocalObject;
import javax.slee.facilities.AlarmFacility;
import javax.slee.facilities.TimerFacility;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;
import javax.slee.serviceactivity.ServiceStartedEvent;
import org.mobicents.slee.resource.sip.SipFactoryProvider;
import org.mobicents.slee.services.sip.common.ConfigurationProvider;
import org.mobicents.slee.services.sip.common.LocationSbbLocalObject;
import org.mobicents.slee.services.sip.common.LocationServiceException;
import org.mobicents.slee.services.sip.common.RegistrationBinding;
import org.mobicents.slee.services.sip.registrar.mbean.RegistrarConfigurator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RegistrarSbb
implements Sbb {
    private static Logger logger = Logger.getLogger(RegistrarSbb.class.getName());
    private SipFactoryProvider factoryProvider;
    private SipFactoryProvider fp;
    private SipProvider provider;
    private AddressFactory addressFactory;
    private HeaderFactory headerFactory;
    private MessageFactory messageFactory;
    private SbbContext context;
    private TimerFacility timerFacility;
    private AlarmFacility alarmFacility;
    private SbbID id;
    private NullActivityFactory nullActivityFactory;
    private NullActivityContextInterfaceFactory nullACIFactory;
    private Context sbbEnv;
    private Context ctx;

    public void onServiceStarted(ServiceStartedEvent serviceEvent, ActivityContextInterface aci) {
        logger.fine("Got a Service Started Event!");
        logger.fine("CREATING CONFIGURRATION");
        this.startMBeanConfigurator();
    }

    public void onRegisterEvent(RequestEvent event, ActivityContextInterface ac) {
        logger.log(Level.FINER, "SipRegistrarSBB: " + this + ": got register event");
        try {
            ServerTransaction serverTransactionId = (ServerTransaction)ac.getActivity();
            Request request = event.getRequest();
            this.processRequest(serverTransactionId, request);
            ac.detach(this.getSbbLocalObject());
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception during onRegisterEvent", e);
        }
    }

    protected void startMBeanConfigurator() {
        String confValue = null;
        Context myEnv = null;
        RegistrarConfigurator config = new RegistrarConfigurator();
        try {
            logger.info("Building Configuration from ENV Entries");
            myEnv = (Context)new InitialContext().lookup("java:comp/env");
        }
        catch (NamingException ne) {
            logger.warning("Could not set SBB context:" + ne.getMessage());
            return;
        }
        confValue = null;
        try {
            confValue = (String)myEnv.lookup("configuration-MAX-EXPIRES");
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (confValue == null) {
            config.setSipRegistrationMaxExpires(3600L);
        } else {
            long i = Long.parseLong(confValue);
            config.setSipRegistrationMaxExpires(i);
        }
        confValue = null;
        try {
            confValue = (String)myEnv.lookup("configuration-MIN-EXPIRES");
        }
        catch (NamingException e) {
            // empty catch block
        }
        if (confValue == null) {
            config.setSipRegistrationMinExpires(100L);
        } else {
            long i = Long.parseLong(confValue);
            config.setSipRegistrationMinExpires(i);
        }
        try {
            String configurationName = (String)myEnv.lookup("configuration-MBEAN");
            if (configurationName != null) {
                config.setName(configurationName);
            }
        }
        catch (NamingException ne) {
            // empty catch block
        }
        config.startService();
    }

    private void processRequest(ServerTransaction serverTransaction, Request request) {
        logger.log(Level.FINEST, "processRequest: request = >>>>>>>>>\n" + request.toString() + "\n<<<<<<<<");
        try {
            ChildRelation children = this.getLocationSbbChild();
            LocationSbbLocalObject handler = null;
            SbbLocalObject slo = null;
            if (children.size() < 1) {
                slo = children.create();
                handler = (LocationSbbLocalObject)slo;
            } else {
                slo = (SbbLocalObject)children.iterator().next();
                handler = (LocationSbbLocalObject)slo;
            }
            this.doRegistration(handler, request, serverTransaction);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception during processRequest", e);
            try {
                serverTransaction.sendResponse(this.getMessageFactory().createResponse(500, request));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void doRegistration(LocationSbbLocalObject handler, Request registerReqeust, ServerTransaction txn) {
        block27: {
            try {
                RegistrarConfigurator config = (RegistrarConfigurator)ConfigurationProvider.getCopy((String)"slee:sipregistrarconfigurator=", (String)"v1RegistrarConf");
                long maxExpires = config.getSipRegistrationMaxExpires();
                long minExpires = config.getSipRegistrationMinExpires();
                if (!this.isLocalDomain(registerReqeust.getRequestURI())) {
                    Response response = this.messageFactory.createResponse(403, registerReqeust);
                    txn.sendResponse(response);
                    return;
                }
                String sipAddressOfRecord = RegistrarSbb.getCanonicalAddress((HeaderAddress)registerReqeust.getHeader("To"));
                logger.finer("address-of-record = " + sipAddressOfRecord);
                String sipAddress = RegistrarSbb.getCanonicalAddress((HeaderAddress)registerReqeust.getHeader("To"));
                Map bindings = handler.getUserBindings(sipAddress);
                if (registerReqeust.getHeader("Contact") == null) {
                    this.sendRegistrationOKResponse(txn, registerReqeust, bindings);
                    return;
                }
                ArrayList newContacts = this.getContactHeaderList(registerReqeust.getHeaders("Contact"));
                ExpiresHeader expiresHeader = null;
                boolean removeAll = false;
                CallIdHeader cidh = (CallIdHeader)registerReqeust.getHeader("Call-ID");
                String callId = cidh.getCallId();
                CSeqHeader cseqh = (CSeqHeader)registerReqeust.getHeader("CSeq");
                long seq = cseqh.getSequenceNumber();
                expiresHeader = registerReqeust.getExpires();
                if (this.hasWildCard(newContacts)) {
                    if (expiresHeader == null || expiresHeader.getExpires() != 0 || newContacts.size() > 1) {
                        txn.sendResponse(this.messageFactory.createResponse(400, registerReqeust));
                        return;
                    }
                    removeAll = true;
                }
                if (removeAll) {
                    logger.fine("Removing bindings");
                    Iterator it = bindings.values().iterator();
                    try {
                        while (it.hasNext()) {
                            RegistrationBinding binding = (RegistrationBinding)it.next();
                            if (callId.equals(binding.getCallId())) {
                                if (seq > binding.getCSeq()) {
                                    it.remove();
                                    handler.removeBinding(sipAddressOfRecord, binding.getContactAddress());
                                    continue;
                                }
                                txn.sendResponse(this.messageFactory.createResponse(400, registerReqeust));
                                return;
                            }
                            it.remove();
                            handler.removeBinding(sipAddressOfRecord, binding.getContactAddress());
                        }
                    }
                    catch (LocationServiceException lse) {
                        lse.printStackTrace();
                        txn.sendResponse(this.messageFactory.createResponse(500, registerReqeust));
                        return;
                    }
                    this.sendRegistrationOKResponse(txn, registerReqeust, bindings);
                    break block27;
                }
                logger.fine("Updating bindings");
                ListIterator li = newContacts.listIterator();
                while (li.hasNext()) {
                    ContactHeader contact = (ContactHeader)li.next();
                    long requestedExpires = 0L;
                    requestedExpires = contact.getExpires() >= 0 ? (long)contact.getExpires() : (expiresHeader != null && expiresHeader.getExpires() >= 0 ? (long)expiresHeader.getExpires() : 3600L);
                    if (requestedExpires > maxExpires) {
                        requestedExpires = maxExpires;
                    } else if (requestedExpires > 0L && requestedExpires < minExpires) {
                        this.sendIntervalTooBriefResponse(txn, registerReqeust, minExpires);
                        return;
                    }
                    float q = 0.0f;
                    if (contact.getQValue() != -1.0f) {
                        q = contact.getQValue();
                    }
                    if (q > 1.0f || q < 0.0f) {
                        txn.sendResponse(this.messageFactory.createResponse(400, registerReqeust));
                        return;
                    }
                    URI uri = contact.getAddress().getURI();
                    String contactAddress = uri.toString();
                    RegistrationBinding binding = (RegistrationBinding)bindings.get(contactAddress);
                    if (binding != null) {
                        if (callId.equals(binding.getCallId()) && seq <= binding.getCSeq()) {
                            txn.sendResponse(this.messageFactory.createResponse(400, registerReqeust));
                            return;
                        }
                        if (requestedExpires == 0L) {
                            logger.fine("Removing binding: " + sipAddressOfRecord + " -> " + contactAddress);
                            bindings.remove(contactAddress);
                            try {
                                handler.removeBinding(sipAddressOfRecord, binding.getContactAddress());
                                continue;
                            }
                            catch (LocationServiceException lse) {
                                lse.printStackTrace();
                                txn.sendResponse(this.messageFactory.createResponse(500, registerReqeust));
                                return;
                            }
                        }
                        logger.fine("Updating binding: " + sipAddressOfRecord + " -> " + contactAddress);
                        logger.fine("contact: " + contact.toString());
                        try {
                            bindings.put(contactAddress, handler.addUserLocation(sipAddress, contactAddress, "", requestedExpires, q, callId, seq));
                            continue;
                        }
                        catch (LocationServiceException lse) {
                            lse.printStackTrace();
                            txn.sendResponse(this.messageFactory.createResponse(500, registerReqeust));
                            return;
                        }
                    }
                    if (requestedExpires == 0L) continue;
                    logger.fine("Adding new binding: " + sipAddressOfRecord + " -> " + contactAddress);
                    logger.fine(contact.toString());
                    try {
                        bindings.put(contactAddress, handler.addUserLocation(sipAddress, contactAddress, "", requestedExpires, q, callId, seq));
                    }
                    catch (LocationServiceException lse) {
                        lse.printStackTrace();
                        txn.sendResponse(this.messageFactory.createResponse(500, registerReqeust));
                        return;
                    }
                }
                this.sendRegistrationOKResponse(txn, registerReqeust, bindings);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getDomain(URI uri) {
        String address = uri.toString();
        int index = address.indexOf(64);
        if (index != -1) {
            address = address.substring(index + 1);
        }
        if ((index = address.indexOf(58)) != -1) {
            address = address.substring(index + 1);
        }
        if ((index = address.indexOf(58)) != -1) {
            address = address.substring(0, index);
        }
        return address;
    }

    private boolean isLocalDomain(URI uri) {
        return true;
    }

    public static String getCanonicalAddress(HeaderAddress header) {
        Address na = header.getAddress();
        URI uri = na.getURI();
        String addr = uri.toString();
        int index = addr.indexOf(58);
        if ((index = addr.indexOf(58, index + 1)) != -1) {
            addr = addr.substring(0, index);
        }
        return addr;
    }

    private void sendRegistrationOKResponse(ServerTransaction txn, Request request, Map<String, RegistrationBinding> bindings) {
        List<ContactHeader> contactHeaders = this.getContactHeaders(bindings.values());
        try {
            Response res = this.messageFactory.createResponse(200, request);
            if (contactHeaders != null && !contactHeaders.isEmpty()) {
                logger.fine("Adding " + contactHeaders.size() + " headers");
                for (int i = 0; i < contactHeaders.size(); ++i) {
                    ContactHeader hdr = contactHeaders.get(i);
                    res.addHeader((Header)hdr);
                }
            }
            DateHeader dateHeader = this.headerFactory.createDateHeader((Calendar)new GregorianCalendar());
            res.setHeader((Header)dateHeader);
            logger.fine("Sending Response:\n" + res.toString());
            txn.sendResponse(res);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to sendRegistrationOKResponse", e);
        }
    }

    private void sendIntervalTooBriefResponse(ServerTransaction txn, Request request, long minExpires) {
        try {
            Response res = this.messageFactory.createResponse(423, request);
            res.setReasonPhrase("Interval Too Brief");
            DateHeader dateHeader = this.headerFactory.createDateHeader((Calendar)new GregorianCalendar());
            res.setHeader((Header)dateHeader);
            Header minExpiresHeader = this.headerFactory.createHeader("Min-Expires", String.valueOf(minExpires));
            res.addHeader(minExpiresHeader);
            logger.fine("Sending Response:\n" + res.toString());
            txn.sendResponse(res);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to sendInternalTooBriefResponse", e);
        }
    }

    private List<ContactHeader> getContactHeaders(Collection<RegistrationBinding> bindings) {
        if (bindings == null) {
            return null;
        }
        ArrayList<ContactHeader> contactHeaders = new ArrayList<ContactHeader>();
        for (RegistrationBinding binding : bindings) {
            ContactHeader header = binding.getContactHeader(this.addressFactory, this.headerFactory);
            if (header == null) continue;
            contactHeaders.add(header);
        }
        return contactHeaders;
    }

    private ArrayList getContactHeaderList(ListIterator it) {
        ArrayList l = new ArrayList();
        while (it.hasNext()) {
            l.add(it.next());
        }
        return l;
    }

    private boolean hasWildCard(ArrayList contactHeaders) {
        for (ContactHeader header : contactHeaders) {
            if (header.toString().indexOf(42) <= 0) continue;
            return true;
        }
        return false;
    }

    public abstract ChildRelation getLocationSbbChild();

    public void setSbbContext(SbbContext context) {
        this.context = context;
        try {
            this.sbbEnv = (Context)new InitialContext().lookup("java:comp/env");
            this.id = context.getSbb();
            this.timerFacility = (TimerFacility)this.sbbEnv.lookup("slee/facilities/timer");
            this.alarmFacility = (AlarmFacility)this.sbbEnv.lookup("slee/facilities/alarm");
            this.nullACIFactory = (NullActivityContextInterfaceFactory)this.sbbEnv.lookup("slee/nullactivity/activitycontextinterfacefactory");
            this.nullActivityFactory = (NullActivityFactory)this.sbbEnv.lookup("slee/nullactivity/factory");
            this.fp = (SipFactoryProvider)this.sbbEnv.lookup("slee/resources/jainsip/1.2/provider");
            this.provider = this.fp.getSipProvider();
            this.addressFactory = this.fp.getAddressFactory();
            this.headerFactory = this.fp.getHeaderFactory();
            this.messageFactory = this.fp.getMessageFactory();
        }
        catch (NamingException ne) {
            logger.log(Level.WARNING, "Could not set SBB context: ", ne);
        }
    }

    public void unsetSbbContext() {
        this.context = null;
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbPassivate() {
    }

    public void sbbActivate() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface aci) {
    }

    public void sbbRolledBack(RolledBackContext context) {
    }

    public SipProvider getSipProvider() {
        return this.provider;
    }

    public AddressFactory getAddressFactory() {
        return this.addressFactory;
    }

    public HeaderFactory getHeaderFactory() {
        return this.headerFactory;
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public NullActivityFactory getNullActivityFactory() {
        return this.nullActivityFactory;
    }

    public final TimerFacility getTimerFacility() {
        return this.timerFacility;
    }

    public NullActivityContextInterfaceFactory getNullACIFactory() {
        return this.nullACIFactory;
    }

    public final SbbLocalObject getSbbLocalObject() {
        return this.context.getSbbLocalObject();
    }
}

