/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.examples.wakeup;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.sip.ClientTransaction;
import javax.sip.InvalidArgumentException;
import javax.sip.RequestEvent;
import javax.sip.ServerTransaction;
import javax.sip.SipProvider;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.header.ContactHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.Header;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.sip.message.Response;
import javax.slee.ActivityContextInterface;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerOptions;
import javax.slee.nullactivity.NullActivity;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;
import org.apache.log4j.Logger;
import org.mobicents.slee.examples.wakeup.WakeUpSbbActivityContextInterface;
import org.mobicents.slee.resource.sip.SipResourceAdaptorSbbInterface;
import org.mobicents.slee.services.sip.common.SipSendErrorResponseException;
import org.mobicents.slee.services.sip.location.LocationSbbLocalObject;
import org.mobicents.slee.services.sip.location.LocationServiceException;
import org.mobicents.slee.services.sip.location.RegistrationBinding;

public abstract class WakeUpSbb
implements Sbb {
    private SbbContext sbbContext;
    private MessageFactory messageFactory;
    private SipProvider provider;
    private SipResourceAdaptorSbbInterface fp;
    private TimerFacility timerFacility;
    private NullActivityContextInterfaceFactory nullACIFactory;
    private NullActivityFactory nullActivityFactory;
    private AddressFactory addressFactory;
    private HeaderFactory headerFactory;
    private static final Logger logger = Logger.getLogger(WakeUpSbb.class);

    public abstract ChildRelation getLocationChildRelation();

    public LocationSbbLocalObject getLocationChildSbb() {
        ChildRelation childRelation = this.getLocationChildRelation();
        Iterator childRelationIterator = childRelation.iterator();
        if (childRelationIterator.hasNext()) {
            return (LocationSbbLocalObject)childRelationIterator.next();
        }
        try {
            return (LocationSbbLocalObject)childRelation.create();
        }
        catch (Exception e) {
            logger.error((Object)"failed to create child sbb", (Throwable)e);
            return null;
        }
    }

    public void onMessageEvent(RequestEvent event, ActivityContextInterface aci) {
        Request request = event.getRequest();
        try {
            ServerTransaction st = (ServerTransaction)aci.getActivity();
            Response response = this.messageFactory.createResponse(200, request);
            st.sendResponse(response);
            String body = new String(request.getRawContent());
            int i = body.indexOf("WAKE UP IN ");
            int j = body.indexOf("s! MSG: ", i + 11);
            int k = body.indexOf("!", j + 8);
            if (i > -1 && j > -1 && k > -1) {
                String timerValue = body.substring(i + 11, j);
                int timer = Integer.parseInt(timerValue);
                String bodyMessage = body.substring(j + 8, k);
                NullActivity timerBus = this.nullActivityFactory.createNullActivity();
                ActivityContextInterface timerBusACI = this.nullACIFactory.getActivityContextInterface(timerBus);
                timerBusACI.attach(this.sbbContext.getSbbLocalObject());
                WakeUpSbbActivityContextInterface myViewOfTimerBusACI = this.asSbbActivityContextInterface(timerBusACI);
                myViewOfTimerBusACI.setBody(bodyMessage);
                FromHeader fromHeader = (FromHeader)request.getHeader("From");
                logger.info((Object)("Received a valid message from " + fromHeader.getAddress() + " requesting a reply containing '" + bodyMessage + "' after " + timerValue + "s"));
                URI contactURI = this.findLocalTarget(fromHeader.getAddress().getURI(), this.getLocationChildSbb());
                Address contactAddress = this.addressFactory.createAddress(contactURI);
                ContactHeader contactHeader = this.headerFactory.createContactHeader(contactAddress);
                myViewOfTimerBusACI.setContact((Header)contactHeader);
                TimerOptions options = new TimerOptions();
                options.setPersistent(true);
                this.timerFacility.setTimer(timerBusACI, null, System.currentTimeMillis() + (long)(timer * 1000), options);
            } else {
                logger.warn((Object)("Ignoring invalid msg " + body));
            }
        }
        catch (Exception e) {
            logger.error((Object)"Exception while processing MESSAGE: ", (Throwable)e);
        }
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        aci.detach(this.sbbContext.getSbbLocalObject());
        WakeUpSbbActivityContextInterface myViewOfACI = this.asSbbActivityContextInterface(aci);
        Header contact = myViewOfACI.getContact();
        String body = myViewOfACI.getBody();
        this.sendWakeUpCall(contact, body);
    }

    private void sendWakeUpCall(Header toContact, String body) {
        String strContact = toContact.toString();
        int beginIndex = strContact.indexOf(60);
        int endIndex = strContact.indexOf(62);
        String toAddressStr = strContact.substring(beginIndex + 1, endIndex);
        try {
            SipURI fromAddress = this.addressFactory.createSipURI("wakeup", System.getProperty("bind.address", "127.0.0.1"));
            Address fromNameAddress = this.addressFactory.createAddress((URI)fromAddress);
            fromNameAddress.setDisplayName("WakeUp");
            FromHeader fromHeader = this.headerFactory.createFromHeader(fromNameAddress, "12345SomeTagID6789");
            Address toNameAddress = this.addressFactory.createAddress(toAddressStr);
            toNameAddress.setDisplayName("Some Sleepy User");
            ToHeader toHeader = this.headerFactory.createToHeader(toNameAddress, null);
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>();
            ViaHeader viaHeader = this.headerFactory.createViaHeader(this.provider.getListeningPoints()[0].getIPAddress(), this.provider.getListeningPoints()[0].getPort(), this.provider.getListeningPoints()[0].getTransport(), null);
            viaHeaders.add(viaHeader);
            MaxForwardsHeader maxForwards = this.headerFactory.createMaxForwardsHeader(70);
            URI uri = this.fp.getAddressFactory().createURI(toAddressStr);
            Request req = this.messageFactory.createRequest(uri, "MESSAGE", this.provider.getNewCallId(), this.headerFactory.createCSeqHeader(1, "MESSAGE"), fromHeader, toHeader, viaHeaders, maxForwards);
            ContentTypeHeader contentType = this.headerFactory.createContentTypeHeader("text", "plain");
            req.setContent((Object)body, contentType);
            ClientTransaction ct = this.provider.getNewClientTransaction(req);
            ct.sendRequest();
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
    }

    public void setSbbContext(SbbContext context) {
        this.sbbContext = context;
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            this.timerFacility = (TimerFacility)myEnv.lookup("slee/facilities/timer");
            this.nullACIFactory = (NullActivityContextInterfaceFactory)myEnv.lookup("slee/nullactivity/activitycontextinterfacefactory");
            this.nullActivityFactory = (NullActivityFactory)myEnv.lookup("slee/nullactivity/factory");
            this.fp = (SipResourceAdaptorSbbInterface)myEnv.lookup("slee/resources/jainsip/1.2/provider");
            this.provider = this.fp.getSipProvider();
            this.addressFactory = this.fp.getAddressFactory();
            this.headerFactory = this.fp.getHeaderFactory();
            this.messageFactory = this.fp.getMessageFactory();
        }
        catch (Exception ne) {
            logger.error((Object)"Failed to set sbb context", (Throwable)ne);
        }
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbRemove() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
    }

    public void sbbRolledBack(RolledBackContext context) {
    }

    public abstract WakeUpSbbActivityContextInterface asSbbActivityContextInterface(ActivityContextInterface var1);

    public URI findLocalTarget(URI uri, LocationSbbLocalObject locationSbbLocalObject) throws SipSendErrorResponseException {
        String addressOfRecord = uri.toString();
        Map bindings = null;
        try {
            bindings = locationSbbLocalObject.getBindings(addressOfRecord);
        }
        catch (LocationServiceException lse) {
            lse.printStackTrace();
        }
        if (bindings == null) {
            throw new SipSendErrorResponseException("User not found", 404);
        }
        if (bindings.isEmpty()) {
            throw new SipSendErrorResponseException("User temporarily unavailable", 480);
        }
        Iterator it = bindings.values().iterator();
        URI target = null;
        while (it.hasNext()) {
            RegistrationBinding binding = (RegistrationBinding)it.next();
            try {
                ContactHeader header = binding.getContactHeader(this.addressFactory, this.headerFactory);
                logger.info((Object)("Message Sender Contact Header: " + header));
                Address na = header.getAddress();
                target = na.getURI();
                break;
            }
            catch (InvalidArgumentException e) {
                logger.warn((Object)e);
            }
        }
        if (target == null) {
            logger.error((Object)("findLocalTarget: No contacts for " + addressOfRecord + " found."));
            throw new SipSendErrorResponseException("User temporarily unavailable", 480);
        }
        return target;
    }
}

