/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.examples.wakeup;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.InitialContext;
import javax.sip.ClientTransaction;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.SipException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.slee.ActivityContextInterface;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.Tracer;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;
import net.java.slee.resource.sip.SleeSipProvider;
import org.mobicents.slee.examples.wakeup.WakeUpSbbActivityContextInterface;
import org.mobicents.slee.services.sip.location.LocationSbbLocalObject;
import org.mobicents.slee.services.sip.location.RegistrationBinding;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class WakeUpSbb
implements Sbb {
    private static TimerOptions TIMER_OPTIONS = new TimerOptions();
    private static final String FIRST_TOKEN = "WAKE UP IN ";
    private static final String MIDDLE_TOKEN = "s! MSG: ";
    private static final String LAST_TOKEN = "!";
    private static final int FIRST_TOKEN_LENGTH = "WAKE UP IN ".length();
    private static final int MIDDLE_TOKEN_LENGTH = "s! MSG: ".length();
    private static List<ViaHeader> VIA_HEADERS = null;
    private static FromHeader FROM_HEADER = null;
    private static MaxForwardsHeader MAX_FORWARDS_HEADER = null;
    private static ContentTypeHeader CONTENT_TYPE_HEADER = null;
    private static CSeqHeader CSEQ_HEADER = null;
    private SbbContext sbbContext;
    private static Tracer logger = null;
    private MessageFactory messageFactory;
    private SleeSipProvider provider;
    private TimerFacility timerFacility;
    private NullActivityContextInterfaceFactory nullACIFactory;
    private NullActivityFactory nullActivityFactory;
    private AddressFactory addressFactory;
    private HeaderFactory headerFactory;

    public void setSbbContext(SbbContext context) {
        this.sbbContext = context;
        if (logger == null) {
            logger = context.getTracer(WakeUpSbb.class.getSimpleName());
        }
        try {
            InitialContext myEnv = new InitialContext();
            this.timerFacility = (TimerFacility)myEnv.lookup("java:comp/env/slee/facilities/timer");
            this.nullACIFactory = (NullActivityContextInterfaceFactory)myEnv.lookup("java:comp/env/slee/nullactivity/activitycontextinterfacefactory");
            this.nullActivityFactory = (NullActivityFactory)myEnv.lookup("java:comp/env/slee/nullactivity/factory");
            this.provider = (SleeSipProvider)myEnv.lookup("java:comp/env/slee/resources/jainsip/1.2/provider");
            this.addressFactory = this.provider.getAddressFactory();
            this.headerFactory = this.provider.getHeaderFactory();
            this.messageFactory = this.provider.getMessageFactory();
        }
        catch (Exception ne) {
            logger.severe("Failed to set sbb context", (Throwable)ne);
        }
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbRemove() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
    }

    public void sbbRolledBack(RolledBackContext context) {
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }

    public abstract ChildRelation getLocationChildRelation();

    public abstract WakeUpSbbActivityContextInterface asSbbActivityContextInterface(ActivityContextInterface var1);

    public void onMessageEvent(RequestEvent event, ActivityContextInterface aci) {
        Request request = event.getRequest();
        try {
            String body = new String(request.getRawContent());
            int firstTokenStart = body.indexOf(FIRST_TOKEN);
            int timerDurationStart = firstTokenStart + FIRST_TOKEN_LENGTH;
            int middleTokenStart = body.indexOf(MIDDLE_TOKEN, timerDurationStart);
            int bodyMessageStart = middleTokenStart + MIDDLE_TOKEN_LENGTH;
            int lastTokenStart = body.indexOf(LAST_TOKEN, bodyMessageStart);
            if (firstTokenStart > -1 && middleTokenStart > -1 && lastTokenStart > -1) {
                int timerDuration = Integer.parseInt(body.substring(timerDurationStart, middleTokenStart));
                ActivityContextInterface timerACI = this.nullACIFactory.getActivityContextInterface(this.nullActivityFactory.createNullActivity());
                timerACI.attach(this.sbbContext.getSbbLocalObject());
                this.timerFacility.setTimer(timerACI, null, System.currentTimeMillis() + (long)(timerDuration * 1000), TIMER_OPTIONS);
                String bodyMessage = body.substring(bodyMessageStart, lastTokenStart);
                WakeUpSbbActivityContextInterface myViewOfTimerACI = this.asSbbActivityContextInterface(timerACI);
                myViewOfTimerACI.setBody(bodyMessage);
                myViewOfTimerACI.setCallId((CallIdHeader)request.getHeader("Call-ID"));
                FromHeader fromHeader = (FromHeader)request.getHeader("From");
                if (logger.isInfoEnabled()) {
                    logger.info("Received a valid message from " + fromHeader.getAddress() + " requesting a reply containing '" + bodyMessage + "' after " + timerDuration + "s");
                }
                myViewOfTimerACI.setSender(fromHeader.getAddress());
                this.sendResponse(event, 200);
            } else {
                logger.warning("Invalid msg '" + body + "' received");
                this.sendResponse(event, 400);
            }
        }
        catch (Throwable e) {
            logger.severe("Exception while processing MESSAGE", e);
            try {
                this.sendResponse(event, 500);
            }
            catch (Exception f) {
                logger.severe("Exception while sending SERVER INTERNAL ERROR", (Throwable)f);
            }
        }
    }

    public void onTimerEvent(TimerEvent event, WakeUpSbbActivityContextInterface aci) {
        aci.detach(this.sbbContext.getSbbLocalObject());
        String body = aci.getBody();
        Address sender = aci.getSender();
        try {
            FromHeader fromHeader = this.getFromHeader();
            List<ViaHeader> viaHeaders = this.getViaHeaders();
            ContentTypeHeader contentTypeHeader = this.getContentTypeHeader();
            CSeqHeader cSeqHeader = this.getCSeqHeader();
            MaxForwardsHeader maxForwardsHeader = this.getMaxForwardsHeader();
            LocationSbbLocalObject locationChildSbb = (LocationSbbLocalObject)this.getLocationChildRelation().create();
            URI requestURI = null;
            Request request = null;
            ClientTransaction clientTransaction = null;
            ToHeader toHeader = null;
            for (RegistrationBinding registration : locationChildSbb.getBindings(sender.getURI().toString()).values()) {
                try {
                    requestURI = this.addressFactory.createURI(registration.getContactAddress());
                    toHeader = this.headerFactory.createToHeader((Address)sender.clone(), null);
                    request = this.messageFactory.createRequest(requestURI, "MESSAGE", aci.getCallId(), cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwardsHeader, contentTypeHeader, (Object)body);
                    clientTransaction = this.provider.getNewClientTransaction(request);
                    clientTransaction.sendRequest();
                }
                catch (Throwable f) {
                    logger.severe(f.getMessage(), f);
                }
            }
        }
        catch (Throwable e) {
            logger.severe(e.getMessage(), e);
        }
    }

    private void sendResponse(RequestEvent event, int responseCode) throws SipException, InvalidArgumentException, ParseException {
        event.getServerTransaction().sendResponse(this.messageFactory.createResponse(responseCode, event.getRequest()));
    }

    private ContentTypeHeader getContentTypeHeader() throws ParseException {
        if (CONTENT_TYPE_HEADER == null) {
            CONTENT_TYPE_HEADER = this.headerFactory.createContentTypeHeader("text", "plain");
        }
        return CONTENT_TYPE_HEADER;
    }

    private CSeqHeader getCSeqHeader() throws ParseException, InvalidArgumentException {
        if (CSEQ_HEADER == null) {
            CSEQ_HEADER = this.headerFactory.createCSeqHeader(2L, "MESSAGE");
        }
        return CSEQ_HEADER;
    }

    private FromHeader getFromHeader() throws ParseException {
        if (FROM_HEADER == null) {
            Address fromNameAddress = this.addressFactory.createAddress("sip:wakeup@mobicents.org");
            fromNameAddress.setDisplayName("Wake Up Service");
            FROM_HEADER = this.headerFactory.createFromHeader(fromNameAddress, "1");
        }
        return FROM_HEADER;
    }

    private List<ViaHeader> getViaHeaders() throws ParseException, InvalidArgumentException {
        if (VIA_HEADERS == null) {
            ListeningPoint listeningPoint = this.provider.getListeningPoints()[0];
            VIA_HEADERS = new ArrayList<ViaHeader>(1);
            ViaHeader viaHeader = this.headerFactory.createViaHeader(listeningPoint.getIPAddress(), listeningPoint.getPort(), listeningPoint.getTransport(), null);
            VIA_HEADERS.add(viaHeader);
        }
        return VIA_HEADERS;
    }

    private MaxForwardsHeader getMaxForwardsHeader() throws InvalidArgumentException {
        if (MAX_FORWARDS_HEADER == null) {
            MAX_FORWARDS_HEADER = this.headerFactory.createMaxForwardsHeader(70);
        }
        return MAX_FORWARDS_HEADER;
    }
}

