/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.examples.wakeup;

import java.text.ParseException;
import java.util.ArrayList;
import javax.naming.InitialContext;
import javax.sip.ClientTransaction;
import javax.sip.InvalidArgumentException;
import javax.sip.ListeningPoint;
import javax.sip.RequestEvent;
import javax.sip.SipException;
import javax.sip.address.Address;
import javax.sip.address.AddressFactory;
import javax.sip.address.URI;
import javax.sip.header.CSeqHeader;
import javax.sip.header.CallIdHeader;
import javax.sip.header.ContentTypeHeader;
import javax.sip.header.FromHeader;
import javax.sip.header.HeaderFactory;
import javax.sip.header.MaxForwardsHeader;
import javax.sip.header.ToHeader;
import javax.sip.header.ViaHeader;
import javax.sip.message.MessageFactory;
import javax.sip.message.Request;
import javax.slee.ActivityContextInterface;
import javax.slee.ChildRelation;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.facilities.TimerEvent;
import javax.slee.facilities.TimerFacility;
import javax.slee.facilities.TimerOptions;
import javax.slee.facilities.Tracer;
import javax.slee.nullactivity.NullActivityContextInterfaceFactory;
import javax.slee.nullactivity.NullActivityFactory;
import net.java.slee.resource.sip.SleeSipProvider;
import org.mobicents.slee.services.sip.location.LocationSbbLocalObject;
import org.mobicents.slee.services.sip.location.RegistrationBinding;

public abstract class WakeUpSbb
implements Sbb {
    private static final String FIRST_TOKEN = "WAKE UP IN ";
    private static final String MIDDLE_TOKEN = "s! MSG: ";
    private static final String LAST_TOKEN = "!";
    private static final int FIRST_TOKEN_LENGTH = "WAKE UP IN ".length();
    private static final int MIDDLE_TOKEN_LENGTH = "s! MSG: ".length();
    private SbbContext sbbContext;
    private Tracer tracer = null;
    private SleeSipProvider sipProvider;
    private TimerFacility timerFacility;
    private NullActivityContextInterfaceFactory nullACIFactory;
    private NullActivityFactory nullActivityFactory;

    public void setSbbContext(SbbContext context) {
        this.sbbContext = context;
        this.tracer = context.getTracer(WakeUpSbb.class.getSimpleName());
        try {
            InitialContext myEnv = new InitialContext();
            this.timerFacility = (TimerFacility)myEnv.lookup("java:comp/env/slee/facilities/timer");
            this.nullACIFactory = (NullActivityContextInterfaceFactory)myEnv.lookup("java:comp/env/slee/nullactivity/activitycontextinterfacefactory");
            this.nullActivityFactory = (NullActivityFactory)myEnv.lookup("java:comp/env/slee/nullactivity/factory");
            this.sipProvider = (SleeSipProvider)myEnv.lookup("java:comp/env/slee/resources/jainsip/1.2/provider");
        }
        catch (Exception e) {
            this.tracer.severe("Failed to set sbb context", (Throwable)e);
        }
    }

    public void sbbCreate() throws CreateException {
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbActivate() {
    }

    public void sbbPassivate() {
    }

    public void sbbRemove() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface activity) {
    }

    public void sbbRolledBack(RolledBackContext context) {
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
        this.tracer = null;
        this.timerFacility = null;
        this.nullACIFactory = null;
        this.nullActivityFactory = null;
        this.sipProvider = null;
    }

    public abstract ChildRelation getLocationChildRelation();

    public abstract void setSender(Address var1);

    public abstract Address getSender();

    public abstract void setCallId(CallIdHeader var1);

    public abstract CallIdHeader getCallId();

    public abstract void setBody(String var1);

    public abstract String getBody();

    public void onMessageEvent(RequestEvent event, ActivityContextInterface aci) {
        Request request = event.getRequest();
        try {
            String body = new String(request.getRawContent());
            int firstTokenStart = body.indexOf(FIRST_TOKEN);
            int timerDurationStart = firstTokenStart + FIRST_TOKEN_LENGTH;
            int middleTokenStart = body.indexOf(MIDDLE_TOKEN, timerDurationStart);
            int bodyMessageStart = middleTokenStart + MIDDLE_TOKEN_LENGTH;
            int lastTokenStart = body.indexOf(LAST_TOKEN, bodyMessageStart);
            if (firstTokenStart > -1 && middleTokenStart > -1 && lastTokenStart > -1) {
                int timerDuration = Integer.parseInt(body.substring(timerDurationStart, middleTokenStart));
                ActivityContextInterface timerACI = this.nullACIFactory.getActivityContextInterface(this.nullActivityFactory.createNullActivity());
                timerACI.attach(this.sbbContext.getSbbLocalObject());
                this.timerFacility.setTimer(timerACI, null, System.currentTimeMillis() + (long)(timerDuration * 1000), new TimerOptions());
                String bodyMessage = body.substring(bodyMessageStart, lastTokenStart);
                this.setBody(bodyMessage);
                this.setCallId((CallIdHeader)request.getHeader("Call-ID"));
                FromHeader fromHeader = (FromHeader)request.getHeader("From");
                if (this.tracer.isInfoEnabled()) {
                    this.tracer.info("Received a valid message from " + fromHeader.getAddress() + " requesting a reply containing '" + bodyMessage + "' after " + timerDuration + "s");
                }
                this.setSender(fromHeader.getAddress());
                this.sendResponse(event, 200);
            } else {
                this.tracer.warning("Invalid msg '" + body + "' received");
                this.sendResponse(event, 400);
            }
        }
        catch (Throwable e) {
            this.tracer.severe("Exception while processing MESSAGE", e);
            try {
                this.sendResponse(event, 500);
            }
            catch (Exception f) {
                this.tracer.severe("Exception while sending SERVER INTERNAL ERROR", (Throwable)f);
            }
        }
    }

    public void onTimerEvent(TimerEvent event, ActivityContextInterface aci) {
        aci.detach(this.sbbContext.getSbbLocalObject());
        String body = this.getBody();
        CallIdHeader callId = this.getCallId();
        Address sender = this.getSender();
        try {
            AddressFactory addressFactory = this.sipProvider.getAddressFactory();
            Address fromNameAddress = addressFactory.createAddress("sip:wakeup@mobicents.org");
            fromNameAddress.setDisplayName("Wake Up Service");
            HeaderFactory headerFactory = this.sipProvider.getHeaderFactory();
            FromHeader fromHeader = headerFactory.createFromHeader(fromNameAddress, null);
            ArrayList<ViaHeader> viaHeaders = new ArrayList<ViaHeader>(1);
            ListeningPoint listeningPoint = this.sipProvider.getListeningPoints()[0];
            ViaHeader viaHeader = this.sipProvider.getHeaderFactory().createViaHeader(listeningPoint.getIPAddress(), listeningPoint.getPort(), listeningPoint.getTransport(), null);
            viaHeaders.add(viaHeader);
            ContentTypeHeader contentTypeHeader = headerFactory.createContentTypeHeader("text", "plain");
            CSeqHeader cSeqHeader = headerFactory.createCSeqHeader(2L, "MESSAGE");
            MaxForwardsHeader maxForwardsHeader = headerFactory.createMaxForwardsHeader(70);
            LocationSbbLocalObject locationChildSbb = (LocationSbbLocalObject)this.getLocationChildRelation().create();
            MessageFactory messageFactory = this.sipProvider.getMessageFactory();
            for (RegistrationBinding registration : locationChildSbb.getBindings(sender.getURI().toString()).values()) {
                try {
                    URI requestURI = addressFactory.createURI(registration.getContactAddress());
                    ToHeader toHeader = headerFactory.createToHeader(sender, null);
                    Request request = messageFactory.createRequest(requestURI, "MESSAGE", callId, cSeqHeader, fromHeader, toHeader, viaHeaders, maxForwardsHeader, contentTypeHeader, (Object)body);
                    ClientTransaction clientTransaction = this.sipProvider.getNewClientTransaction(request);
                    clientTransaction.sendRequest();
                }
                catch (Throwable f) {
                    this.tracer.severe("Failed to create and send message", f);
                }
            }
        }
        catch (Throwable e) {
            this.tracer.severe("Failed to create message headers", e);
        }
    }

    private void sendResponse(RequestEvent event, int responseCode) throws SipException, InvalidArgumentException, ParseException {
        event.getServerTransaction().sendResponse(this.sipProvider.getMessageFactory().createResponse(responseCode, event.getRequest()));
    }
}

