/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.training.example1;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.slee.ActivityContextInterface;
import javax.slee.ComponentID;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbID;
import javax.slee.facilities.Level;
import javax.slee.facilities.TraceFacility;
import org.mobicents.slee.resource.lab.ratype.MessageResourceAdaptorSbbInterface;

public abstract class CommonSbb
implements Sbb {
    private SbbID sbbId;
    private SbbContext sbbContext;
    private TraceFacility traceFacility;
    private MessageResourceAdaptorSbbInterface sbb2ra;

    public void setSbbContext(SbbContext sbbContext) {
        this.sbbContext = sbbContext;
        this.sbbId = sbbContext.getSbb();
        try {
            Context ctx = (Context)new InitialContext().lookup("java:comp/env");
            this.traceFacility = (TraceFacility)ctx.lookup("slee/facilities/trace");
            this.sbb2ra = (MessageResourceAdaptorSbbInterface)ctx.lookup("slee/resources/raframe/1.0/sbb2ra");
        }
        catch (NamingException ne) {
            System.out.println("Could not set SBB context: " + ne.toString());
        }
    }

    public void unsetSbbContext() {
        this.trace(Level.INFO, "BounceSBB: " + this + ": unsetSbbContext() called.");
    }

    public void sbbCreate() throws CreateException {
        this.trace(Level.INFO, "BounceSBB: " + this + ": sbbCreate() called.");
    }

    public void sbbPostCreate() throws CreateException {
        this.trace(Level.INFO, "BounceSBB: " + this + ": sbbPostCreate() called.");
    }

    public void sbbActivate() {
        this.trace(Level.INFO, "BounceSBB: " + this + ": sbbActivate() called.");
    }

    public void sbbPassivate() {
        this.trace(Level.INFO, "BounceSBB: " + this + ": sbbPassivate() called.");
    }

    public void sbbRemove() {
        this.trace(Level.INFO, "BounceSBB: " + this + ": sbbRemove() called.");
    }

    public void sbbLoad() {
        this.trace(Level.INFO, "BounceSBB: " + this + ": sbbLoad() called.");
    }

    public void sbbStore() {
        this.trace(Level.INFO, "BounceSBB: " + this + ": sbbStore() called.");
    }

    public void sbbRolledBack(RolledBackContext rolledBackContext) {
        this.trace(Level.INFO, "BounceSBB: " + this + ": sbbRolledBack() called.");
    }

    public void sbbExceptionThrown(Exception exception, Object obj, ActivityContextInterface activityContextInterface) {
        this.trace(Level.INFO, "BounceSBB: " + this + ": sbbExceptionThrown() called.");
    }

    protected final void trace(Level level, String message) {
        try {
            this.traceFacility.createTrace((ComponentID)this.sbbId, level, "BounceSbb", message, System.currentTimeMillis());
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.out.println("BounceSbb [" + System.currentTimeMillis() + "]: " + message);
    }

    protected final void trace(Level level, String message, Throwable t) {
        try {
            this.traceFacility.createTrace((ComponentID)this.sbbId, level, "BounceSbb", message, t, System.currentTimeMillis());
        }
        catch (Exception e) {
            // empty catch block
        }
        System.out.println("BounceSbb [" + System.currentTimeMillis() + "]: " + message);
    }

    protected MessageResourceAdaptorSbbInterface getMessageResourceAdaptorSbbInterface() {
        return this.sbb2ra;
    }
}

