/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.training.example2;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.slee.ActivityContextInterface;
import org.apache.log4j.Logger;
import org.mobicents.slee.resource.lab.message.Message;
import org.mobicents.slee.resource.lab.message.MessageEvent;
import org.mobicents.slee.resource.lab.ratype.MessageActivity;
import org.mobicents.slee.training.example2.CommonSbb;

public abstract class ChildSbb
extends CommonSbb {
    private Logger logger = Logger.getLogger(ChildSbb.class);

    public void onAnyEvent(MessageEvent event, ActivityContextInterface ac) {
        this.logger.info((Object)("BounceSbb: " + this + ": received an incoming Request. CallID = " + event.getMessage().getId() + ". Command = " + event.getMessage().getCommand()));
        int noOfAnyMessages = this.getNoOfAnyMessages() + 1;
        this.setNoOfAnyMessages(noOfAnyMessages);
        this.logger.info((Object)("This is " + this.getNoOfAnyMessages() + " number of ANY Message"));
        try {
            MessageActivity activity = (MessageActivity)ac.getActivity();
            activity.anyReceived();
            this.logger.info((Object)("ANY Event: INIT:" + activity.getInitCounter() + " ANY:" + activity.getAnyCounter() + " END:" + activity.getEndCounter() + " Valid state: " + activity.isValid(event.getMessage().getCommandId())));
        }
        catch (Exception e) {
            this.logger.warn((Object)"Exception during onAnyEvent: ", (Throwable)e);
        }
        Message answer = this.getMessageResourceAdaptorSbbInterface().getMessageFactory().createMessage(event.getMessage().getId(), this.getCustomMessageFromEnv() + event.getMessage().getCommand());
        this.getMessageResourceAdaptorSbbInterface().send(answer);
    }

    public void synchronousCall() {
        this.logger.info((Object)"synchronousCall of ChildSbb");
    }

    public abstract void setNoOfAnyMessages(int var1);

    public abstract int getNoOfAnyMessages();

    private String getCustomMessageFromEnv() {
        String customMessage = null;
        try {
            InitialContext initCtx = new InitialContext();
            Context myEnv = (Context)initCtx.lookup("java:comp/env");
            customMessage = (String)myEnv.lookup("customMessage");
        }
        catch (NamingException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return customMessage;
    }
}

