/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.slee.training.example8.common;

import javax.naming.Context;
import javax.naming.InitialContext;
import javax.slee.ActivityContextInterface;
import javax.slee.CreateException;
import javax.slee.RolledBackContext;
import javax.slee.Sbb;
import javax.slee.SbbContext;
import javax.slee.SbbLocalObject;
import javax.slee.TransactionRolledbackLocalException;
import javax.slee.facilities.FacilityException;
import javax.slee.profile.AttributeNotIndexedException;
import javax.slee.profile.AttributeTypeMismatchException;
import javax.slee.profile.ProfileFacility;
import javax.slee.profile.ProfileID;
import javax.slee.profile.UnrecognizedAttributeException;
import javax.slee.profile.UnrecognizedProfileNameException;
import javax.slee.profile.UnrecognizedProfileTableNameException;
import org.apache.log4j.Logger;
import org.mobicents.slee.resource.lab.message.Message;
import org.mobicents.slee.resource.lab.ratype.MessageResourceAdaptorSbbInterface;
import org.mobicents.slee.training.example8.profile.EventControlProfileCMP;
import org.mobicents.slee.training.example8.profile.ProfileCreator;

public abstract class SubscriptionProfileSbb
implements Sbb {
    protected static Logger log = Logger.getLogger(SubscriptionProfileSbb.class);
    private MessageResourceAdaptorSbbInterface sbb2ra;
    private SbbContext sbbContext;
    private ProfileFacility profileFacility;

    public void setSbbContext(SbbContext context) {
        this.sbbContext = context;
        try {
            Context myEnv = (Context)new InitialContext().lookup("java:comp/env");
            this.profileFacility = (ProfileFacility)myEnv.lookup("slee/facilities/profile");
            this.sbb2ra = (MessageResourceAdaptorSbbInterface)myEnv.lookup("slee/resources/raframe/1.0/sbb2ra");
        }
        catch (Exception ne) {
            log.error((Object)"COULD NOT LOCATE RESOURCE IN JNDI: Check JNDI TREE or entity-binding for proper path!!!", (Throwable)ne);
        }
    }

    protected EventControlProfileCMP lookup(String activityId) {
        String profileTableName = new String();
        ProfileID profileID = null;
        EventControlProfileCMP event = null;
        try {
            profileTableName = "EventControl";
            profileID = this.getProfileFacility().getProfileByIndexedAttribute(profileTableName, "activityId", (Object)activityId);
            if (profileID != null) {
                event = this.getEventControlProfileCMP(profileID);
            } else {
                Message answer = this.getMessageResourceAdaptorSbbInterface().getMessageFactory().createMessage("ERROR", " specified Activity Id Not Allowed !! ");
                this.getMessageResourceAdaptorSbbInterface().send(answer);
            }
        }
        catch (NullPointerException e) {
            log.error((Object)"Exception using the getProfileByIndexedAttribute method", (Throwable)e);
        }
        catch (UnrecognizedProfileTableNameException e) {
            log.error((Object)"Exception in getting the Profile Specification in getControllerProfileCMP(profileID):The ProfileID object does not identify a Profile Table created from the Profile Specification", (Throwable)e);
        }
        catch (UnrecognizedProfileNameException e) {
            log.error((Object)"Exception in getting the Profile Specification in getControllerProfileCMP(profileID):The ProfileID object does not identify a Profile within the Profile Table", (Throwable)e);
        }
        catch (TransactionRolledbackLocalException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (FacilityException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (UnrecognizedAttributeException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (AttributeNotIndexedException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (AttributeTypeMismatchException e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        return event;
    }

    public void unsetSbbContext() {
        this.sbbContext = null;
    }

    public void sbbCreate() throws CreateException {
        ProfileCreator.createProfiles();
    }

    public void sbbPostCreate() throws CreateException {
    }

    public void sbbRemove() {
    }

    public void sbbPassivate() {
    }

    public void sbbActivate() {
    }

    public void sbbLoad() {
    }

    public void sbbStore() {
    }

    public void sbbExceptionThrown(Exception exception, Object event, ActivityContextInterface aci) {
    }

    public void sbbRolledBack(RolledBackContext context) {
    }

    protected final SbbContext getSbbContext() {
        return this.sbbContext;
    }

    protected final ProfileFacility getProfileFacility() {
        return this.profileFacility;
    }

    protected final SbbLocalObject getSbbLocalObject() {
        return this.sbbContext.getSbbLocalObject();
    }

    public abstract EventControlProfileCMP getEventControlProfileCMP(ProfileID var1) throws UnrecognizedProfileNameException, UnrecognizedProfileTableNameException;

    protected MessageResourceAdaptorSbbInterface getMessageResourceAdaptorSbbInterface() {
        return this.sbb2ra;
    }
}

