
package org.mobicents.slee.training.example8.profile;

import javax.slee.profile.ProfileManagement;
import javax.slee.profile.ProfileVerificationException;

/**
 * EventControlProfileManagementImpl implementation of CMP's with
 * ProfileManagement
 * 
 * @author MoBitE info@mobite.co.in
 * 
 */
public abstract class EventControlProfileManagementImpl implements ProfileManagement, EventControlProfileCMP {

	/**
	 * Initialize the profile with its default values.
	 */
    public void profileInitialize() {
    	setActivityId(null);
    	setAny(false);
    	setInit(false);
    }

    public void profileLoad() {}
    public void profileStore() {}

	/**
	 * Verify the profile's CMP field settings.
	 * @throws ProfileVerificationException if any CMP field contains an invalid value
     */
    public void profileVerify() throws ProfileVerificationException {
    	String action= getActivityId();
    	if(action !=null)verifyAction(action);
    	
    	
    }
    
    public void verifyAction(String value) throws ProfileVerificationException {
    	if(!(value =="100" || value =="101" || value =="102" || value =="103" || value =="104" || value =="105"))
    	{
    		throw new ProfileVerificationException("Invalid Activity ID "+ value +" is not a valid action");
    	}
    }
}
