/*
 * Decompiled with CFR 0.152.
 */
package gov.nist.javax.sip.stack;

import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import gov.nist.javax.sip.stack.SIPServerTransactionImpl;
import gov.nist.javax.sip.stack.SIPTransactionStack;
import java.io.IOException;
import org.mobicents.ext.javax.sip.SipStackExtension;

public class MobicentsSIPServerTransaction
extends SIPServerTransactionImpl {
    public MobicentsSIPServerTransaction(SIPTransactionStack sipStack, MessageChannel newChannelToUse) {
        super(sipStack, newChannelToUse);
    }

    public void map() {
        if (((SipStackExtension)this.sipStack).isSendTryingRightAway()) {
            this.sendTryingRightAway();
        } else {
            super.map();
        }
    }

    protected void sendTryingRightAway() {
        block7: {
            int realState = super.getRealState();
            if (realState < 0 || realState == 1) {
                if (this.isInviteTransaction() && !this.isMapped && this.sipStack.getTimer() != null) {
                    this.isMapped = true;
                    if (this.sipStack.isLoggingEnabled(32)) {
                        this.sipStack.getStackLogger().logDebug(" sending Trying current state = " + realState);
                    }
                    try {
                        this.sendMessage((SIPMessage)this.getOriginalRequest().createResponse(100, "Trying"));
                        if (this.sipStack.isLoggingEnabled(32)) {
                            this.sipStack.getStackLogger().logDebug(" trying sent " + super.getRealState());
                        }
                        break block7;
                    }
                    catch (IOException ex) {
                        if (this.sipStack.isLoggingEnabled()) {
                            this.sipStack.getStackLogger().logError("IO error sending  TRYING");
                        }
                        break block7;
                    }
                }
                this.isMapped = true;
            }
        }
        this.sipStack.removePendingTransaction((SIPServerTransaction)this);
    }

    public void startTransactionTimer() {
        if (!((SipStackExtension)this.sipStack).isSendTryingRightAway() || this.getLastResponseStatusCode() != 100) {
            super.startTransactionTimer();
        }
    }

    public void startTransactionTimerForTrying() {
        super.startTransactionTimer();
    }

    public void setRetransmitTimer(int retransmitTimer) {
        if (retransmitTimer <= 0) {
            throw new IllegalArgumentException("Retransmit timer must be positive!");
        }
        if (!((SipStackExtension)this.sipStack).isSendTryingRightAway() && this.transactionTimerStarted.get()) {
            throw new IllegalStateException("Transaction timer is already started");
        }
        this.baseTimerInterval = retransmitTimer;
    }
}

