/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ext.javax.sip;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.SipProviderImpl;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPClientTransaction;
import gov.nist.javax.sip.stack.SIPMessageValve;
import gov.nist.javax.sip.stack.SIPServerTransaction;
import java.util.Properties;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.sip.PeerUnavailableException;
import javax.sip.ProviderDoesNotExistException;
import javax.sip.SipException;
import org.mobicents.ext.javax.sip.SipProviderFactory;
import org.mobicents.ext.javax.sip.SipStackExtension;
import org.mobicents.ext.javax.sip.SipStackImplMBean;
import org.mobicents.ext.javax.sip.TransactionFactory;

public class SipStackImpl
extends gov.nist.javax.sip.SipStackImpl
implements SipStackExtension,
NotificationListener,
SipStackImplMBean {
    private static StackLogger logger = CommonLogger.getLogger(SipStackImpl.class);
    public static String JAIN_SIP_MBEAN_NAME = "org.mobicents.jain.sip:type=sip-stack,name=";
    protected TransactionFactory transactionFactory = null;
    protected SipProviderFactory sipProviderFactory = null;
    protected boolean sendTryingRightAway;
    ObjectName oname = null;
    MBeanServer mbeanServer = null;
    boolean isMBeanServerNotAvailable = false;

    public SipStackImpl(Properties configurationProperties) throws PeerUnavailableException {
        super(configurationProperties);
        String sipProviderFactoryClassName;
        String transactionFactoryClassName = configurationProperties.getProperty("org.mobicents.ext.java.sip.TRANSACTION_FACTORY");
        if (transactionFactoryClassName != null) {
            try {
                this.transactionFactory = (TransactionFactory)Class.forName(transactionFactoryClassName).newInstance();
                this.transactionFactory.setSipStack(this);
                if (logger.isLoggingEnabled(16)) {
                    logger.logInfo("SIP Stack TransactionFactory set to " + transactionFactoryClassName);
                }
            }
            catch (Exception e) {
                String errmsg = "The TransactionFactory class name: " + transactionFactoryClassName + " could not be instantiated. Ensure the " + "org.mobicents.ext.java.sip.TRANSACTION_FACTORY" + " property has been set correctly and that the class is on the classpath.";
                throw new PeerUnavailableException(errmsg, (Throwable)e);
            }
        }
        if ((sipProviderFactoryClassName = configurationProperties.getProperty("org.mobicents.ext.java.sip.SIP_PROVIDER_FACTORY")) != null) {
            try {
                this.sipProviderFactory = (SipProviderFactory)Class.forName(sipProviderFactoryClassName).newInstance();
                this.sipProviderFactory.setSipStack(this);
                if (logger.isLoggingEnabled(16)) {
                    logger.logInfo("SIP Stack SipProviderFactory set to " + sipProviderFactoryClassName);
                }
            }
            catch (Exception e) {
                String errmsg = "The SipProviderFactory class name: " + sipProviderFactoryClassName + " could not be instantiated. Ensure the " + "org.mobicents.ext.java.sip.SIP_PROVIDER_FACTORY" + " property has been set correctly and that the class is on the classpath.";
                throw new PeerUnavailableException(errmsg, (Throwable)e);
            }
        }
        this.sendTryingRightAway = Boolean.valueOf(configurationProperties.getProperty("org.mobicents.ext.java.sip.SEND_TRYING_RIGHT_AWAY", "false"));
        if (logger.isLoggingEnabled(16)) {
            logger.logInfo("SIP Stack send trying right away " + this.sendTryingRightAway);
        }
    }

    public void start() throws ProviderDoesNotExistException, SipException {
        super.start();
        String mBeanName = JAIN_SIP_MBEAN_NAME + this.stackName;
        try {
            this.oname = new ObjectName(mBeanName);
            if (this.getMBeanServer() != null && !this.getMBeanServer().isRegistered(this.oname)) {
                this.getMBeanServer().registerMBean(this, this.oname);
            }
        }
        catch (Exception e) {
            logger.logError("Could not register the stack as an MBean under the following name", e);
            throw new SipException("Could not register the stack as an MBean under the following name " + mBeanName + ", cause: " + e.getMessage(), (Throwable)e);
        }
    }

    public void stop() {
        String mBeanName = JAIN_SIP_MBEAN_NAME + this.stackName;
        try {
            if (this.oname != null && this.getMBeanServer() != null && this.getMBeanServer().isRegistered(this.oname)) {
                this.getMBeanServer().unregisterMBean(this.oname);
            }
        }
        catch (Exception e) {
            logger.logError("Could not unregister the stack as an MBean under the following name" + mBeanName);
        }
        super.stop();
    }

    public MBeanServer getMBeanServer() throws Exception {
        if (this.mbeanServer == null && !this.isMBeanServerNotAvailable) {
            try {
                this.mbeanServer = MBeanServerFactory.findMBeanServer(null).get(0);
            }
            catch (Exception e) {
                logger.logStackTrace(32);
                logger.logWarning("No Mbean Server available, so JMX statistics won't be available");
                this.isMBeanServerNotAvailable = true;
            }
        }
        return this.mbeanServer;
    }

    public void handleNotification(Notification notification, Object handback) {
        logger.setStackProperties(super.getConfigurationProperties());
    }

    public SIPClientTransaction createClientTransaction(SIPRequest sipRequest, MessageChannel encapsulatedMessageChannel) {
        if (this.transactionFactory == null) {
            return super.createClientTransaction(sipRequest, encapsulatedMessageChannel);
        }
        return this.transactionFactory.createClientTransaction(sipRequest, encapsulatedMessageChannel);
    }

    public SIPServerTransaction createServerTransaction(MessageChannel encapsulatedMessageChannel) {
        if (this.transactionFactory == null) {
            return super.createServerTransaction(encapsulatedMessageChannel);
        }
        return this.transactionFactory.createServerTransaction(encapsulatedMessageChannel);
    }

    public int getNumberOfClientTransactions() {
        return this.getClientTransactionTableSize();
    }

    public int getNumberOfDialogs() {
        return this.dialogTable.size();
    }

    public int getNumberOfEarlyDialogs() {
        return this.earlyDialogTable.size();
    }

    public int getNumberOfServerTransactions() {
        return this.getServerTransactionTableSize();
    }

    public void setSendTryingRightAway(boolean sendTryingRightAway) {
        this.sendTryingRightAway = sendTryingRightAway;
    }

    public boolean isSendTryingRightAway() {
        return this.sendTryingRightAway;
    }

    public void addSipProvider(SipProviderImpl sipProvider) {
        this.sipProviders.add(sipProvider);
    }

    public void removeSipProvider(SipProviderImpl sipProvider) {
        this.sipProviders.remove(sipProvider);
    }

    public SIPMessageValve getSipMessageValve() {
        return this.sipMessageValve;
    }
}

