/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ext.javax.sip.congestion;

import gov.nist.core.CommonLogger;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.message.SIPMessage;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.message.SIPResponse;
import gov.nist.javax.sip.stack.MessageChannel;
import gov.nist.javax.sip.stack.SIPMessageValve;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.sip.SipStack;
import javax.sip.header.Header;
import javax.sip.message.Request;
import javax.sip.message.Response;
import org.mobicents.commons.congestion.CongestionListener;
import org.mobicents.ext.javax.sip.SipStackExtension;
import org.mobicents.ext.javax.sip.congestion.CongestionControlTimerTask;

public class CongestionControlMessageValve
implements SIPMessageValve,
CongestionListener {
    private static StackLogger logger = CommonLogger.getLogger(CongestionControlMessageValve.class);
    protected SipStackExtension sipStack;
    protected transient ScheduledFuture congestionControlTimerFuture;
    private long congestionControlMonitoringInterval;
    private ScheduledThreadPoolExecutor congestionControlThreadPool = null;
    protected int dropResponseStatus;
    private boolean rejectMessages;
    private List<String> blockedList = null;

    public boolean processRequest(SIPRequest request, MessageChannel messageChannel) {
        boolean undropableMethod;
        String requestMethod = request.getMethod();
        boolean bl = undropableMethod = requestMethod.equals("BYE") || requestMethod.equals("ACK") || requestMethod.equals("PRACK") || requestMethod.equals("CANCEL");
        if (!undropableMethod) {
            if (!this.securityCheck((Request)request)) {
                return false;
            }
            if (this.rejectMessages) {
                if (request.getToTag() != null) {
                    return true;
                }
                if (this.dropResponseStatus > 0) {
                    SIPResponse response = request.createResponse(this.dropResponseStatus);
                    this.modifyCongestionResponse(response);
                    try {
                        messageChannel.sendMessage((SIPMessage)response);
                    }
                    catch (IOException e) {
                        logger.logError("Failed to send congestion control error response" + response, (Exception)e);
                    }
                }
                return false;
            }
        }
        return true;
    }

    private boolean securityCheck(Request request) {
        Header userAgentHeader = request.getHeader("User-Agent");
        Header toHeader = request.getHeader("To");
        Header fromHeader = request.getHeader("From");
        for (String blockedValue : this.blockedList) {
            if (userAgentHeader != null && userAgentHeader.toString().toLowerCase().contains(blockedValue.toLowerCase())) {
                return false;
            }
            if (toHeader != null && toHeader.toString().toLowerCase().contains(blockedValue.toLowerCase())) {
                return false;
            }
            if (fromHeader == null || !fromHeader.toString().toLowerCase().contains(blockedValue.toLowerCase())) continue;
            return false;
        }
        return true;
    }

    protected void modifyCongestionResponse(SIPResponse response) {
    }

    public boolean processResponse(Response response, MessageChannel messageChannel) {
        return true;
    }

    public void destroy() {
        logger.logInfo("Destorying the congestion control valve " + this);
        if (this.congestionControlTimerFuture != null) {
            this.congestionControlTimerFuture.cancel(true);
        }
        if (this.congestionControlThreadPool != null) {
            this.congestionControlThreadPool.shutdownNow();
        }
    }

    public void init(SipStack stack) {
        this.sipStack = (SipStackExtension)stack;
        logger.logInfo("Initializing congestion control valve");
        String blockedValues = this.sipStack.getConfigurationProperties().getProperty("org.mobicents.ext.javax.sip.congestion.SIP_SCANNERS", "sipvicious,sipcli,friendly-scanner");
        this.blockedList = new ArrayList<String>(Arrays.asList(blockedValues.split(",")));
        String congestionControlMonitoringIntervalString = this.sipStack.getConfigurationProperties().getProperty("org.mobicents.ext.javax.sip.congestion.CONGESTION_CONTROL_MONITOR_INTERVAL", "30000");
        this.congestionControlMonitoringInterval = new Integer(congestionControlMonitoringIntervalString).intValue();
        if (this.congestionControlTimerFuture == null && this.congestionControlMonitoringInterval > 0L) {
            String dropResponseStatusString = this.sipStack.getConfigurationProperties().getProperty("org.mobicents.ext.javax.sip.congestion.DROP_RESPONSE_STATUS", "503");
            this.dropResponseStatus = new Integer(dropResponseStatusString);
            this.congestionControlThreadPool = new ScheduledThreadPoolExecutor(2, new ThreadPoolExecutor.CallerRunsPolicy());
            this.congestionControlThreadPool.prestartAllCoreThreads();
            CongestionControlTimerTask congestionControlTimerTask = new CongestionControlTimerTask(this, this.sipStack);
            this.congestionControlTimerFuture = this.congestionControlThreadPool.scheduleWithFixedDelay(congestionControlTimerTask, 0L, this.congestionControlMonitoringInterval, TimeUnit.MILLISECONDS);
            if (logger.isLoggingEnabled(16)) {
                logger.logInfo("Congestion control background task started and checking every " + this.congestionControlMonitoringInterval + " milliseconds.");
            }
        } else if (logger.isLoggingEnabled(16)) {
            logger.logInfo("No Congestion control background task started since the checking interval is equals to " + this.congestionControlMonitoringInterval + " milliseconds.");
        }
    }

    public void onCongestionStart(String source) {
        this.rejectMessages = true;
    }

    public void onCongestionFinish(String source) {
        this.rejectMessages = false;
    }

    public boolean isRejectMessages() {
        return this.rejectMessages;
    }
}

