/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ext.javax.sip.congestion;

import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.mobicents.commons.congestion.CongestionListener;
import org.mobicents.commons.congestion.CongestionMonitor;
import org.mobicents.ext.javax.sip.SipStackExtension;

public class DialogCongestionMonitor
implements CongestionMonitor {
    private static final Logger logger = Logger.getLogger(DialogCongestionMonitor.class);
    private static final String SOURCE = "DIALOG";
    protected SipStackExtension sipStack;
    private final FastList<CongestionListener> listeners = new FastList();
    private volatile boolean tooManyDialogs = false;
    private long backToNormalDialogsThreshold;
    private long dialogsThreshold;

    public DialogCongestionMonitor(SipStackExtension sipStack) {
        this.sipStack = sipStack;
    }

    public void monitor() {
        block5: {
            block4: {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Number of Dialogs used = " + this.sipStack.getNumberOfDialogs()));
                }
                if (!this.tooManyDialogs) break block4;
                if ((long)this.sipStack.getNumberOfDialogs() >= this.backToNormalDialogsThreshold) break block5;
                logger.warn((Object)("Number of Dialogs used: " + this.sipStack.getNumberOfDialogs() + " < to the back to normal dialogs : " + this.backToNormalDialogsThreshold));
                this.tooManyDialogs = false;
                FastList.Node n = this.listeners.head();
                FastList.Node end = this.listeners.tail();
                while ((n = n.getNext()) != end) {
                    CongestionListener listener = (CongestionListener)n.getValue();
                    listener.onCongestionFinish(SOURCE);
                }
                break block5;
            }
            if ((long)this.sipStack.getNumberOfDialogs() > this.dialogsThreshold) {
                logger.warn((Object)("Number of Dialogs used: " + this.sipStack.getNumberOfDialogs() + " > to the max dialog : " + this.dialogsThreshold));
                this.tooManyDialogs = true;
                FastList.Node n = this.listeners.head();
                FastList.Node end = this.listeners.tail();
                while ((n = n.getNext()) != end) {
                    CongestionListener listener = (CongestionListener)n.getValue();
                    listener.onCongestionStart(SOURCE);
                }
            }
        }
    }

    public void addCongestionListener(CongestionListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeCongestionListener(CongestionListener listener) {
        this.listeners.remove((Object)listener);
    }

    public String getSource() {
        return SOURCE;
    }

    public long getDialogsThreshold() {
        return this.dialogsThreshold;
    }

    public void setDialogsThreshold(long DialogsThreshold) {
        this.dialogsThreshold = DialogsThreshold;
    }

    public long getBackToNormalDialogsThreshold() {
        return this.backToNormalDialogsThreshold;
    }

    public void setBackToNormalDialogsThreshold(long backToNormalDialogsThreshold) {
        this.backToNormalDialogsThreshold = backToNormalDialogsThreshold;
    }
}

