/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ext.javax.sip.congestion;

import javolution.util.FastList;
import org.apache.log4j.Logger;
import org.mobicents.commons.congestion.CongestionListener;
import org.mobicents.commons.congestion.CongestionMonitor;
import org.mobicents.ext.javax.sip.SipStackExtension;

public class ServerTransactionCongestionMonitor
implements CongestionMonitor {
    private static final Logger logger = Logger.getLogger(ServerTransactionCongestionMonitor.class);
    private static final String SOURCE = "SERVER_TRANSACTION";
    protected SipStackExtension sipStack;
    private final FastList<CongestionListener> listeners = new FastList();
    private volatile boolean tooManyStx = false;
    private long backToNormalServerTransactionsThreshold;
    private long serverTransactionsThreshold;

    public ServerTransactionCongestionMonitor(SipStackExtension sipStack) {
        this.sipStack = sipStack;
    }

    public void monitor() {
        block5: {
            block4: {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Number of Server Transactions used = " + this.sipStack.getNumberOfServerTransactions()));
                }
                if (!this.tooManyStx) break block4;
                if ((long)this.sipStack.getNumberOfServerTransactions() >= this.backToNormalServerTransactionsThreshold) break block5;
                logger.warn((Object)("Number of Server Transactions used: " + this.sipStack.getNumberOfServerTransactions() + " < to the back to normal server transactions : " + this.backToNormalServerTransactionsThreshold));
                this.tooManyStx = false;
                FastList.Node n = this.listeners.head();
                FastList.Node end = this.listeners.tail();
                while ((n = n.getNext()) != end) {
                    CongestionListener listener = (CongestionListener)n.getValue();
                    listener.onCongestionFinish(SOURCE);
                }
                break block5;
            }
            if ((long)this.sipStack.getNumberOfServerTransactions() > this.serverTransactionsThreshold) {
                logger.warn((Object)("Number of Server Transactions used: " + this.sipStack.getNumberOfServerTransactions() + " > to the max server transactions : " + this.serverTransactionsThreshold));
                this.tooManyStx = true;
                FastList.Node n = this.listeners.head();
                FastList.Node end = this.listeners.tail();
                while ((n = n.getNext()) != end) {
                    CongestionListener listener = (CongestionListener)n.getValue();
                    listener.onCongestionStart(SOURCE);
                }
            }
        }
    }

    public void addCongestionListener(CongestionListener listener) {
        this.listeners.add((Object)listener);
    }

    public void removeCongestionListener(CongestionListener listener) {
        this.listeners.remove((Object)listener);
    }

    public String getSource() {
        return SOURCE;
    }

    public long getServerTransactionsThreshold() {
        return this.serverTransactionsThreshold;
    }

    public void setServerTransactionsThreshold(long serverTransactionsThreshold) {
        this.serverTransactionsThreshold = serverTransactionsThreshold;
    }

    public long getBackToNormalServerTransactionsThreshold() {
        return this.backToNormalServerTransactionsThreshold;
    }

    public void setBackToNormalServerTransactionsThreshold(long backToNormalServerTransactionsThreshold) {
        this.backToNormalServerTransactionsThreshold = backToNormalServerTransactionsThreshold;
    }
}

