/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ext.javax.sip.dns;

import gov.nist.core.CommonLogger;
import gov.nist.core.InternalErrorHandler;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.address.GenericURI;
import gov.nist.javax.sip.header.RequestLine;
import gov.nist.javax.sip.header.Route;
import gov.nist.javax.sip.header.RouteList;
import gov.nist.javax.sip.message.SIPRequest;
import gov.nist.javax.sip.stack.DefaultRouter;
import javax.sip.SipException;
import javax.sip.SipStack;
import javax.sip.address.Hop;
import javax.sip.address.SipURI;
import javax.sip.address.URI;
import javax.sip.message.Request;

public class DNSAwareRouter
extends DefaultRouter {
    public static final String DNS_ROUTE = "dns_route";
    private static StackLogger logger = CommonLogger.getLogger(DNSAwareRouter.class);

    public DNSAwareRouter(SipStack sipStack, String defaultRoute) {
        super(sipStack, defaultRoute);
    }

    public Hop getNextHop(Request request) throws SipException {
        SIPRequest sipRequest = (SIPRequest)request;
        RequestLine requestLine = sipRequest.getRequestLine();
        if (requestLine == null) {
            return this.getOutboundProxy();
        }
        GenericURI requestURI = requestLine.getUri();
        if (requestURI == null) {
            throw new IllegalArgumentException("Bad message: Null requestURI");
        }
        RouteList routes = sipRequest.getRouteHeaders();
        if (routes != null) {
            Route route = (Route)routes.getFirst();
            URI uri = route.getAddress().getURI();
            if (uri.isSipURI()) {
                SipURI sipUri = (SipURI)uri;
                if (sipUri.getParameter(DNS_ROUTE) != null) {
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Removing Route added by container to conform to RFC 3263 " + route);
                    }
                    sipRequest.removeFirst("Route");
                }
                if (!sipUri.hasLrParam()) {
                    this.fixStrictRouting(sipRequest);
                    if (logger.isLoggingEnabled(32)) {
                        logger.logDebug("Route post processing fixed strict routing");
                    }
                }
                Hop hop = this.createHop(sipUri, request);
                if (logger.isLoggingEnabled(32)) {
                    logger.logDebug("NextHop based on Route:" + hop);
                }
                return hop;
            }
            throw new SipException("First Route not a SIP URI");
        }
        if (requestURI.isSipURI() && ((SipURI)requestURI).getMAddrParam() != null) {
            Hop hop = this.createHop((SipURI)requestURI, request);
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Using request URI maddr to route the request = " + hop.toString());
            }
            return hop;
        }
        if (this.getOutboundProxy() != null) {
            if (logger.isLoggingEnabled(32)) {
                logger.logDebug("Using outbound proxy to route the request = " + this.getOutboundProxy().toString());
            }
            return this.getOutboundProxy();
        }
        if (requestURI.isSipURI()) {
            Hop hop = this.createHop((SipURI)requestURI, request);
            if (hop != null && logger.isLoggingEnabled(32)) {
                logger.logDebug("Used request-URI for nextHop = " + hop.toString());
            } else if (logger.isLoggingEnabled(32)) {
                logger.logDebug("returning null hop -- loop detected");
            }
            return hop;
        }
        InternalErrorHandler.handleException((String)"Unexpected non-sip URI", (StackLogger)logger);
        return null;
    }
}

