/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ext.javax.sip.dns;

import gov.nist.javax.sip.stack.HopImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import javax.sip.address.Hop;
import org.apache.log4j.Logger;
import org.mobicents.ext.javax.sip.dns.DNSLookupPerformer;
import org.xbill.DNS.AAAARecord;
import org.xbill.DNS.ARecord;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.NAPTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.TextParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultDNSLookupPerformer
implements DNSLookupPerformer {
    private static final Logger logger = Logger.getLogger(DefaultDNSLookupPerformer.class);
    private static int DEFAULT_DNS_TIMEOUT_SECONDS = 1;
    private int dnsTimeout = DEFAULT_DNS_TIMEOUT_SECONDS;

    public DefaultDNSLookupPerformer() {
        Lookup.getDefaultResolver().setTimeout(this.dnsTimeout, 0);
    }

    @Override
    public List<Record> performSRVLookup(String replacement) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("doing SRV lookup for replacement " + replacement));
        }
        Record[] srvRecords = null;
        try {
            Lookup lookup = new Lookup(replacement, 33);
            lookup.getDefaultResolver().setTimeout(this.dnsTimeout);
            lookup.getDefaultResolver().setTimeout(this.dnsTimeout, 0);
            srvRecords = lookup.run();
        }
        catch (TextParseException e) {
            logger.error((Object)"Impossible to parse the parameters for dns lookup", (Throwable)e);
        }
        if (srvRecords != null && srvRecords.length > 0) {
            return Arrays.asList(srvRecords);
        }
        return new ArrayList<Record>(0);
    }

    @Override
    public List<NAPTRRecord> performNAPTRLookup(String domain, boolean isSecure, Set<String> supportedTransports) {
        ArrayList<NAPTRRecord> records = new ArrayList<NAPTRRecord>();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("doing NAPTR lookup for domain " + domain + ", isSecure " + isSecure + ", supportedTransports " + supportedTransports.toString()));
        }
        Record[] naptrRecords = null;
        try {
            Lookup lookup = new Lookup(domain, 35);
            lookup.getDefaultResolver().setTimeout(this.dnsTimeout);
            lookup.getDefaultResolver().setTimeout(this.dnsTimeout, 0);
            naptrRecords = lookup.run();
        }
        catch (TextParseException e) {
            logger.warn((Object)("Couldn't parse domain " + domain), (Throwable)e);
        }
        if (naptrRecords != null) {
            for (Record record : naptrRecords) {
                NAPTRRecord naptrRecord = (NAPTRRecord)record;
                String service = naptrRecord.getService().toUpperCase();
                if (isSecure) {
                    if (!service.startsWith("SIPS")) continue;
                    records.add(naptrRecord);
                    continue;
                }
                if (service.startsWith("SIPS") && (!service.startsWith("SIPS") || !supportedTransports.contains("TLS"))) continue;
                if (service.contains("D2U") && supportedTransports.contains("UDP") || service.contains("D2T") && (supportedTransports.contains("TCP") || supportedTransports.contains("TLS"))) {
                    records.add(naptrRecord);
                    continue;
                }
                if (!service.equals("E2U+SIP")) continue;
                records.add(naptrRecord);
            }
        }
        return records;
    }

    @Override
    public Queue<Hop> locateHopsForNonNumericAddressWithPort(String host, int port, String transport) {
        Lookup lookup;
        LinkedList<Hop> priorityQueue = new LinkedList<Hop>();
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("doing A lookup for host:port/transport = " + host + ":" + port + "/" + transport));
            }
            lookup = new Lookup(host, 1);
            lookup.getDefaultResolver().setTimeout(this.dnsTimeout);
            lookup.getDefaultResolver().setTimeout(this.dnsTimeout, 0);
            Record[] aRecords = lookup.run();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("A lookup results for host:port/transport = " + host + ":" + port + "/" + transport + " => " + aRecords));
            }
            if (aRecords != null && aRecords.length > 0) {
                for (Record aRecord : aRecords) {
                    priorityQueue.add((Hop)new HopImpl(((ARecord)aRecord).getAddress().getHostAddress(), port, transport));
                }
            }
        }
        catch (TextParseException e) {
            logger.warn((Object)("Couldn't parse domain " + host), (Throwable)e);
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("doing AAAA lookup for host:port/transport = " + host + ":" + port + "/" + transport));
            }
            lookup = new Lookup(host, 28);
            lookup.getDefaultResolver().setTimeout(this.dnsTimeout);
            lookup.getDefaultResolver().setTimeout(this.dnsTimeout, 0);
            Record[] aaaaRecords = lookup.run();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("AAAA lookup results for host:port/transport = " + host + ":" + port + "/" + transport + " => " + aaaaRecords));
            }
            if (aaaaRecords != null && aaaaRecords.length > 0) {
                for (Record aaaaRecord : aaaaRecords) {
                    priorityQueue.add((Hop)new HopImpl(((AAAARecord)aaaaRecord).getAddress().getHostAddress(), port, transport));
                }
            }
        }
        catch (TextParseException e) {
            logger.warn((Object)("Couldn't parse domain " + host), (Throwable)e);
        }
        return priorityQueue;
    }

    @Override
    public void setDNSTimeout(int timeout) {
        Lookup.getDefaultResolver().setTimeout(timeout);
        Lookup.getDefaultResolver().setTimeout(timeout, 0);
        this.dnsTimeout = timeout;
        if (logger.isInfoEnabled()) {
            logger.info((Object)("DefaultDNSLookupPerformer will be using timeout of " + this.dnsTimeout + " seconds "));
        }
    }

    @Override
    public int getDNSTimeout() {
        return this.dnsTimeout;
    }
}

