/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ext.javax.sip.timers;

import gov.nist.core.CommonLogger;
import gov.nist.core.NamingThreadFactory;
import gov.nist.core.StackLogger;
import gov.nist.javax.sip.SipStackImpl;
import gov.nist.javax.sip.stack.SIPStackTimerTask;
import gov.nist.javax.sip.stack.timers.SipTimer;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Properties;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class HashedWheelSipTimer
implements SipTimer {
    private static StackLogger logger = CommonLogger.getLogger(HashedWheelSipTimer.class);
    protected SipStackImpl sipStackImpl;
    HashedWheelTimer hashedWheelSipTimer;
    protected AtomicBoolean started = new AtomicBoolean(false);

    public HashedWheelSipTimer() {
        this.hashedWheelSipTimer = new HashedWheelTimer((ThreadFactory)new NamingThreadFactory("hashed_wheel_sip_timer"), 50L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.started.set(false);
        this.hashedWheelSipTimer.stop();
        logger.logStackTrace(32);
        if (logger.isLoggingEnabled(16)) {
            logger.logInfo("the sip stack timer " + this.getClass().getName() + " has been stopped");
        }
    }

    public boolean schedule(SIPStackTimerTask task, long delay) {
        if (!this.started.get()) {
            throw new IllegalStateException("The SIP Stack Timer has been stopped, no new tasks can be scheduled !");
        }
        HashedWheelSipTimerTask timerTask = new HashedWheelSipTimerTask(task, -1L);
        Timeout timeout = this.hashedWheelSipTimer.newTimeout((TimerTask)timerTask, delay, TimeUnit.MILLISECONDS);
        timerTask.setTimeout(timeout);
        return true;
    }

    public boolean scheduleWithFixedDelay(SIPStackTimerTask task, long delay, long period) {
        if (!this.started.get()) {
            throw new IllegalStateException("The SIP Stack Timer has been stopped, no new tasks can be scheduled !");
        }
        HashedWheelSipTimerTask timerTask = new HashedWheelSipTimerTask(task, period);
        Timeout timeout = this.hashedWheelSipTimer.newTimeout((TimerTask)timerTask, delay, TimeUnit.MILLISECONDS);
        timerTask.setTimeout(timeout);
        return true;
    }

    public void start(SipStackImpl sipStack, Properties configurationProperties) {
        this.sipStackImpl = sipStack;
        this.hashedWheelSipTimer.start();
        this.started.set(true);
        if (logger.isLoggingEnabled(16)) {
            logger.logInfo("the sip stack timer " + this.getClass().getName() + " has been started");
        }
    }

    public boolean cancel(SIPStackTimerTask task) {
        return ((HashedWheelSipTimerTask)task.getSipTimerTask()).cancel();
    }

    public boolean isStarted() {
        return this.started.get();
    }

    private class HashedWheelSipTimerTask
    implements TimerTask {
        private SIPStackTimerTask task;
        private Timeout timeout;
        private long period;

        public HashedWheelSipTimerTask(SIPStackTimerTask task, long period) {
            this.task = task;
            task.setSipTimerTask((Object)this);
            this.period = period;
        }

        public void run(Timeout timeout) {
            try {
                if (this.task != null) {
                    this.task.runTask();
                }
                if (this.period > 0L) {
                    timeout = HashedWheelSipTimer.this.hashedWheelSipTimer.newTimeout((TimerTask)this, this.period, TimeUnit.MILLISECONDS);
                }
            }
            catch (Exception e) {
                logger.logError("SIP stack timer task failed due to exception:", e);
            }
        }

        public boolean cancel() {
            if (this.task != null) {
                this.task.cleanUpBeforeCancel();
                this.task = null;
            }
            return this.timeout.cancel();
        }

        public Timeout getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Timeout timeout) {
            this.timeout = timeout;
        }
    }
}

