/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol;

import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.media.mscontrol.MediaConfig;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.MediaGroupConfig;
import javax.media.mscontrol.mixer.MediaMixer;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.networkconnection.NetworkConnectionConfig;
import javax.media.mscontrol.resource.Configuration;
import javax.media.mscontrol.resource.Parameter;
import javax.media.mscontrol.resource.Parameters;
import javax.media.mscontrol.resource.ResourceContainer;
import javax.media.mscontrol.vxml.VxmlDialog;
import org.apache.log4j.Logger;
import org.mobicents.javax.media.mscontrol.MediaConfigFactory;
import org.mobicents.javax.media.mscontrol.mediagroup.MediaGroupImpl;
import org.mobicents.javax.media.mscontrol.mixer.MediaMixerImpl;
import org.mobicents.javax.media.mscontrol.networkconnection.NetworkConnectionImpl;
import org.mobicents.javax.media.mscontrol.resource.ParametersImpl;
import org.mobicents.jsr309.mgcp.MgcpWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MediaSessionImpl
implements MediaSession {
    private static final Logger logger = Logger.getLogger(MediaSessionImpl.class);
    private URI uri = null;
    private MgcpWrapper mgcpWrapper;
    private CallIdentifier callIdentifier = null;
    List<NetworkConnection> netConnList = new ArrayList<NetworkConnection>();
    List<MediaGroup> medGrpList = new ArrayList<MediaGroup>();
    List<MediaMixer> medMxrList = new ArrayList<MediaMixer>();
    private Map attributeMap = new HashMap();

    public MediaSessionImpl(MgcpWrapper mgcpWrapper) {
        this.mgcpWrapper = mgcpWrapper;
        this.callIdentifier = this.mgcpWrapper.getUniqueCallIdentifier();
        try {
            this.uri = new URI("mscontrol://" + this.mgcpWrapper.getPeerIp() + "/" + this.callIdentifier.toString());
        }
        catch (URISyntaxException e) {
            logger.error((Object)e);
        }
    }

    public Parameters createParameters() {
        return new ParametersImpl();
    }

    public Parameters getParameters(Parameter[] params) {
        return null;
    }

    public URI getURI() {
        return this.uri;
    }

    public void release() {
        for (MediaGroup mg : this.medGrpList) {
            mg.release();
        }
        for (MediaMixer mx : this.medMxrList) {
            mx.release();
        }
        for (NetworkConnection nc : this.netConnList) {
            nc.release();
        }
        this.attributeMap.clear();
    }

    public void setParameters(Parameters arg0) {
    }

    public <T extends ResourceContainer<? extends MediaConfig>> T createContainer(Class<T> aClass, Parameters params) throws MsControlException {
        return null;
    }

    public <C extends MediaConfig, T extends ResourceContainer<? extends C>> T createContainer(Configuration<C> predefinedConfig) throws MsControlException {
        return null;
    }

    public <C extends MediaConfig, T extends ResourceContainer<? extends C>> T createContainer(C config, String containerId) throws MsControlException {
        return null;
    }

    public VxmlDialog createVxmlDialog(Parameters parameters) throws MsControlException {
        return null;
    }

    public Object getAttribute(String key) {
        return this.attributeMap.get(key);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributeMap.keySet());
    }

    public void removeAttribute(String key) {
        this.attributeMap.remove(key);
    }

    public void setAttribute(String key, Object arg1) {
        this.attributeMap.put(key, arg1);
    }

    public <C extends MediaConfig> NetworkConnection createNetworkConnection(Configuration<C> predefinedConfig) throws MsControlException {
        NetworkConnectionConfig config = (NetworkConnectionConfig)MediaConfigFactory.getMediaConfig(predefinedConfig);
        NetworkConnectionImpl networkConnectionImpl = new NetworkConnectionImpl(this, this.mgcpWrapper, config);
        this.netConnList.add(networkConnectionImpl);
        return networkConnectionImpl;
    }

    public <C extends MediaConfig> MediaGroup createMediaGroup(Configuration<C> predefinedConfig) throws MsControlException {
        MediaGroupConfig config = (MediaGroupConfig)MediaConfigFactory.getMediaConfig(predefinedConfig);
        MediaGroupImpl mediaGroupImpl = new MediaGroupImpl(this, this.mgcpWrapper, config);
        this.medGrpList.add(mediaGroupImpl);
        return mediaGroupImpl;
    }

    public MediaMixer createMediaMixer() throws MsControlException {
        MediaMixerImpl mediaMixerImpl = new MediaMixerImpl(this, this.mgcpWrapper);
        this.medMxrList.add(mediaMixerImpl);
        return mediaMixerImpl;
    }

    public CallIdentifier getCallIdentifier() {
        return this.callIdentifier;
    }
}

