/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.mediagroup;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.NotificationRequestResponse;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.NotifyResponse;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.RequestedAction;
import jain.protocol.ip.mgcp.message.parms.RequestedEvent;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import jain.protocol.ip.mgcp.pkg.PackageName;
import java.net.URI;
import java.util.LinkedList;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.media.mscontrol.MediaResourceException;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.Player;
import javax.media.mscontrol.mediagroup.PlayerEvent;
import javax.media.mscontrol.resource.Error;
import javax.media.mscontrol.resource.MediaEvent;
import javax.media.mscontrol.resource.MediaEventListener;
import javax.media.mscontrol.resource.Parameters;
import javax.media.mscontrol.resource.RTC;
import javax.media.mscontrol.resource.ResourceEvent;
import javax.media.mscontrol.resource.Symbol;
import org.apache.log4j.Logger;
import org.mobicents.javax.media.mscontrol.MediaObjectState;
import org.mobicents.javax.media.mscontrol.MediaSessionImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.MediaGroupImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.PlayerEventImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.PlayerState;
import org.mobicents.jsr309.mgcp.MgcpWrapper;
import org.mobicents.jsr309.mgcp.Provider;
import org.mobicents.mgcp.stack.JainMgcpExtendedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerImpl
implements Player {
    private static Logger logger = Logger.getLogger(PlayerImpl.class);
    private static PlayerEventImpl playerBusyEvent = null;
    protected MediaGroupImpl mediaGroup = null;
    protected CopyOnWriteArrayList<MediaEventListener<PlayerEvent>> mediaEventListenerList = new CopyOnWriteArrayList();
    protected MediaSessionImpl mediaSession = null;
    protected MgcpWrapper mgcpWrapper = null;
    protected volatile RequestIdentifier reqId = null;
    protected volatile PlayerState state = PlayerState.IDLE;
    private volatile LinkedList<Runnable> txList = new LinkedList();

    protected PlayerImpl(MediaGroupImpl mediaGroup, MgcpWrapper mgcpWrapper) throws MsControlException {
        this.mediaGroup = mediaGroup;
        this.mediaSession = (MediaSessionImpl)mediaGroup.getMediaSession();
        this.mgcpWrapper = mgcpWrapper;
        playerBusyEvent = new PlayerEventImpl((Player)this, Player.ev_PlayComplete, Error.e_Busy, "Player Busy");
    }

    private void updateState() {
        this.state = this.txList.size() == 0 ? PlayerState.IDLE : PlayerState.ACTIVE;
    }

    private void executeNextTx() {
        Runnable nextTx = this.txList.poll();
        if (nextTx != null) {
            this.state = PlayerState.ACTIVE;
            Provider.submit(nextTx);
        }
    }

    public void play(URI[] uris, RTC[] arg1, Parameters params) throws MsControlException {
        if (MediaObjectState.JOINED.equals((Object)this.mediaGroup.getState())) {
            if (this.state == PlayerState.ACTIVE) {
                Object obj = null;
                if (params != null && (obj = params.get((Object)p_IfBusy)) != null) {
                    Symbol action = (Symbol)obj;
                    if (action.equals(Player.v_Queue)) {
                        StartTx tx = new StartTx(this, uris);
                        this.txList.add(tx);
                    } else if (action.equals(Player.v_Stop)) {
                        this.txList.clear();
                        StartTx tx = new StartTx(this, uris);
                        this.txList.add(tx);
                        StopTx tx1 = new StopTx(this);
                        Provider.submit(tx1);
                    } else {
                        if (action.equals(Player.v_Fail)) {
                            throw new MediaResourceException((ResourceEvent)playerBusyEvent);
                        }
                        logger.error((Object)("The Value " + action + " is not recognized for Parameter p_IfBusy. It has to be one of Player.v_Queue, Player.v_Stop or Player.v_Fail"));
                    }
                } else {
                    logger.warn((Object)"The Player is busy and no Parameter p_IfBusy passed to take necessary action");
                }
            } else {
                StartTx tx = new StartTx(this, uris);
                Provider.submit(tx);
            }
        } else {
            throw new MsControlException(this.mediaGroup.getURI() + " Container is not joined to any other container");
        }
        this.state = PlayerState.ACTIVE;
    }

    public void play(URI arg0, RTC[] arg1, Parameters arg2) throws MsControlException {
        this.play(new URI[]{arg0}, arg1, arg2);
    }

    public MediaGroup getContainer() {
        return this.mediaGroup;
    }

    public boolean stop() {
        this.txList.clear();
        if (this.state == PlayerState.ACTIVE) {
            StopTx tx = new StopTx(this);
            Provider.submit(tx);
            return true;
        }
        return false;
    }

    public void addListener(MediaEventListener<PlayerEvent> listener) {
        this.mediaEventListenerList.add(listener);
    }

    public void removeListener(MediaEventListener<PlayerEvent> listener) {
        this.mediaEventListenerList.remove(listener);
    }

    public MediaSession getMediaSession() {
        return this.mediaGroup.getMediaSession();
    }

    protected void update(PlayerEvent anEvent) {
        for (MediaEventListener<PlayerEvent> m : this.mediaEventListenerList) {
            m.onEvent((MediaEvent)anEvent);
        }
    }

    private class StartTx
    implements Runnable,
    JainMgcpExtendedListener {
        private int tx = -1;
        private PlayerImpl player = null;
        private URI[] files = null;
        private int annCompleted = 0;

        StartTx(PlayerImpl player, URI[] files) {
            this.player = player;
            this.files = files;
        }

        public void run() {
            this.tx = PlayerImpl.this.mgcpWrapper.getUniqueTransactionHandler();
            try {
                PlayerImpl.this.mgcpWrapper.addListnere(this.tx, (JainMgcpExtendedListener)this);
                EndpointIdentifier endpointID = new EndpointIdentifier(PlayerImpl.this.mediaGroup.getEndpoint(), PlayerImpl.this.mgcpWrapper.getPeerIp() + ":" + PlayerImpl.this.mgcpWrapper.getPeerPort());
                PlayerImpl.this.reqId = PlayerImpl.this.mgcpWrapper.getUniqueRequestIdentifier();
                PlayerImpl.this.mgcpWrapper.addListnere(PlayerImpl.this.reqId, (JainMgcpExtendedListener)this);
                NotificationRequest notificationRequest = new NotificationRequest((Object)this, endpointID, PlayerImpl.this.reqId);
                ConnectionIdentifier connId = PlayerImpl.this.mediaGroup.thisConnId;
                EventName[] signalRequests = new EventName[this.files.length];
                int count = 0;
                for (URI uri : this.files) {
                    String filePath = uri.toString();
                    signalRequests[count] = new EventName(PackageName.Announcement, MgcpEvent.ann.withParm(filePath));
                    ++count;
                }
                notificationRequest.setSignalRequests(signalRequests);
                RequestedAction[] actions = new RequestedAction[]{RequestedAction.NotifyImmediately};
                RequestedEvent[] requestedEvents = new RequestedEvent[]{new RequestedEvent(new EventName(PackageName.Announcement, MgcpEvent.oc), actions), new RequestedEvent(new EventName(PackageName.Announcement, MgcpEvent.of), actions)};
                notificationRequest.setRequestedEvents(requestedEvents);
                notificationRequest.setTransactionHandle(this.tx);
                notificationRequest.setNotifiedEntity(PlayerImpl.this.mgcpWrapper.getDefaultNotifiedEntity());
                PlayerImpl.this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{notificationRequest});
            }
            catch (Exception e) {
                logger.error((Object)e);
                PlayerImpl.this.updateState();
                PlayerEventImpl event = new PlayerEventImpl((Player)this.player, Player.ev_PlayComplete, Error.e_Unknown, "Error while sending RQNt " + e.getMessage());
                PlayerImpl.this.update(event);
                PlayerImpl.this.executeNextTx();
            }
        }

        public void transactionEnded(int arg0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully completed Tx = " + arg0));
            }
        }

        public void transactionRxTimedOut(JainMgcpCommandEvent arg0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Couldn't send the Tx = " + arg0));
            }
        }

        public void transactionTxTimedOut(JainMgcpCommandEvent cmdEvent) {
            logger.error((Object)("No response from MGW. Tx timed out for RQNT Tx " + this.tx + " For Command sent " + cmdEvent.toString()));
            PlayerImpl.this.mgcpWrapper.removeListener(cmdEvent.getTransactionHandle());
            PlayerImpl.this.mgcpWrapper.removeListener(PlayerImpl.this.reqId);
            PlayerImpl.this.updateState();
            PlayerEventImpl event = new PlayerEventImpl((Player)this.player, Player.ev_PlayComplete, Error.e_Unknown, "No response from MGW for RQNT");
            PlayerImpl.this.update(event);
            PlayerImpl.this.executeNextTx();
        }

        public void processMgcpCommandEvent(JainMgcpCommandEvent command) {
            logger.debug((Object)(" The NTFY received " + command.toString()));
            PlayerEventImpl event = null;
            switch (command.getObjectIdentifier()) {
                case 108: {
                    EventName[] observedEvents;
                    Notify notify = (Notify)command;
                    block7: for (EventName observedEvent : observedEvents = notify.getObservedEvents()) {
                        ++this.annCompleted;
                        switch (observedEvent.getEventIdentifier().intValue()) {
                            case 62: {
                                if (this.annCompleted != this.files.length) continue block7;
                                PlayerImpl.this.mgcpWrapper.removeListener(notify.getRequestIdentifier());
                                PlayerImpl.this.updateState();
                                event = new PlayerEventImpl((Player)this.player, Player.ev_PlayComplete, Player.q_EndOfData, null);
                                PlayerImpl.this.update(event);
                                PlayerImpl.this.executeNextTx();
                                continue block7;
                            }
                            case 63: {
                                if (this.annCompleted != this.files.length) {
                                    // empty if block
                                }
                                PlayerImpl.this.mgcpWrapper.removeListener(notify.getRequestIdentifier());
                                PlayerImpl.this.updateState();
                                event = new PlayerEventImpl((Player)this.player, Player.ev_PlayComplete, Error.e_Unknown, "Player failed on Server");
                                PlayerImpl.this.update(event);
                                PlayerImpl.this.executeNextTx();
                            }
                        }
                    }
                    NotifyResponse response = new NotifyResponse(notify.getSource(), ReturnCode.Transaction_Executed_Normally);
                    response.setTransactionHandle(notify.getTransactionHandle());
                    PlayerImpl.this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{response});
                    break;
                }
                default: {
                    logger.error((Object)("Expected NTFY cmd. Received " + command));
                    PlayerImpl.this.updateState();
                    event = new PlayerEventImpl((Player)this.player, Player.ev_PlayComplete, Error.e_Unknown, "Player failed on Server");
                    PlayerImpl.this.update(event);
                    PlayerImpl.this.executeNextTx();
                }
            }
        }

        public void processMgcpResponseEvent(JainMgcpResponseEvent respEvent) {
            switch (respEvent.getObjectIdentifier()) {
                case 207: {
                    this.processReqNotificationResponse((NotificationRequestResponse)respEvent);
                    break;
                }
                default: {
                    PlayerImpl.this.mgcpWrapper.removeListener(respEvent.getTransactionHandle());
                    PlayerImpl.this.mgcpWrapper.removeListener(PlayerImpl.this.reqId);
                    PlayerImpl.this.updateState();
                    logger.warn((Object)(" This RESPONSE is unexpected " + respEvent));
                    PlayerEventImpl event = new PlayerEventImpl((Player)this.player, Player.ev_PlayComplete, Error.e_Unknown, "RQNT Failed.  Look at logs " + respEvent.getReturnCode().getComment());
                    PlayerImpl.this.update(event);
                    PlayerImpl.this.executeNextTx();
                }
            }
        }

        private void processReqNotificationResponse(NotificationRequestResponse responseEvent) {
            PlayerEventImpl event = null;
            ReturnCode returnCode = responseEvent.getReturnCode();
            switch (returnCode.getValue()) {
                case 100: {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("Transaction " + this.tx + "is being executed. Response received = " + responseEvent));
                    break;
                }
                case 200: {
                    PlayerImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    break;
                }
                case 502: {
                    PlayerImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    PlayerImpl.this.mgcpWrapper.removeListener(PlayerImpl.this.reqId);
                    PlayerImpl.this.updateState();
                    event = new PlayerEventImpl((Player)this.player, Player.ev_PlayComplete, Error.e_ResourceUnavailable, "RQNT Failed.  Look at logs " + responseEvent.getReturnCode().getComment());
                    PlayerImpl.this.update(event);
                    PlayerImpl.this.executeNextTx();
                    break;
                }
                default: {
                    logger.error((Object)(" SOMETHING IS BROKEN = " + responseEvent));
                    PlayerImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    PlayerImpl.this.mgcpWrapper.removeListener(PlayerImpl.this.reqId);
                    PlayerImpl.this.updateState();
                    event = new PlayerEventImpl((Player)this.player, Player.ev_PlayComplete, Error.e_Unknown, "RQNT Failed.  Look at logs " + responseEvent.getReturnCode().getComment());
                    PlayerImpl.this.update(event);
                    PlayerImpl.this.executeNextTx();
                }
            }
        }
    }

    private class StopTx
    implements Runnable,
    JainMgcpExtendedListener {
        private int tx = -1;
        private PlayerImpl player = null;

        StopTx(PlayerImpl player) {
            this.player = player;
        }

        public void run() {
            try {
                this.tx = PlayerImpl.this.mgcpWrapper.getUniqueTransactionHandler();
                PlayerImpl.this.mgcpWrapper.addListnere(this.tx, (JainMgcpExtendedListener)this);
                PlayerImpl.this.mgcpWrapper.addListnere(PlayerImpl.this.reqId, (JainMgcpExtendedListener)this);
                EndpointIdentifier endpointID = new EndpointIdentifier(PlayerImpl.this.mediaGroup.getEndpoint(), PlayerImpl.this.mgcpWrapper.getPeerIp() + ":" + PlayerImpl.this.mgcpWrapper.getPeerPort());
                NotificationRequest notificationRequest = new NotificationRequest((Object)this, endpointID, PlayerImpl.this.reqId);
                notificationRequest.setTransactionHandle(this.tx);
                notificationRequest.setNotifiedEntity(PlayerImpl.this.mgcpWrapper.getDefaultNotifiedEntity());
                PlayerImpl.this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{notificationRequest});
            }
            catch (Exception e) {
                logger.error((Object)e);
                PlayerEventImpl event = new PlayerEventImpl(this.player, Player.ev_PlayComplete, Player.q_Stop, null, Error.e_Unknown, "Error " + e.getMessage());
                PlayerImpl.this.update(event);
                PlayerImpl.this.executeNextTx();
            }
        }

        public void transactionEnded(int arg0) {
        }

        public void transactionRxTimedOut(JainMgcpCommandEvent cmdEvent) {
        }

        public void transactionTxTimedOut(JainMgcpCommandEvent cmdEvent) {
            logger.error((Object)("No response from MGW. Tx timed out for RQNT Tx " + this.tx + " For Command sent " + cmdEvent.toString()));
            PlayerImpl.this.mgcpWrapper.removeListener(cmdEvent.getTransactionHandle());
            PlayerImpl.this.mgcpWrapper.removeListener(PlayerImpl.this.reqId);
            PlayerEventImpl event = new PlayerEventImpl(this.player, Player.ev_PlayComplete, Player.q_Stop, null, Error.e_Unknown, "No response from MGW for RQNT");
            PlayerImpl.this.update(event);
            PlayerImpl.this.executeNextTx();
        }

        public void processMgcpCommandEvent(JainMgcpCommandEvent arg0) {
        }

        public void processMgcpResponseEvent(JainMgcpResponseEvent respEvent) {
            switch (respEvent.getObjectIdentifier()) {
                case 207: {
                    this.processReqNotificationResponse((NotificationRequestResponse)respEvent);
                    break;
                }
                default: {
                    PlayerImpl.this.mgcpWrapper.removeListener(respEvent.getTransactionHandle());
                    PlayerImpl.this.mgcpWrapper.removeListener(PlayerImpl.this.reqId);
                    logger.warn((Object)(" This RESPONSE is unexpected " + respEvent));
                    PlayerImpl.this.updateState();
                    PlayerEventImpl event = new PlayerEventImpl(this.player, Player.ev_PlayComplete, Player.q_Stop, null, Error.e_Unknown, "RQNT Failed.  Look at logs " + respEvent.getReturnCode().getComment());
                    PlayerImpl.this.update(event);
                    PlayerImpl.this.executeNextTx();
                }
            }
        }

        private void processReqNotificationResponse(NotificationRequestResponse responseEvent) {
            PlayerEventImpl event = null;
            ReturnCode returnCode = responseEvent.getReturnCode();
            switch (returnCode.getValue()) {
                case 100: {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("Transaction " + this.tx + "is being executed. Response received = " + responseEvent));
                    break;
                }
                case 200: {
                    PlayerImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    PlayerImpl.this.mgcpWrapper.removeListener(PlayerImpl.this.reqId);
                    PlayerImpl.this.updateState();
                    event = new PlayerEventImpl((Player)this.player, Player.ev_PlayComplete, Player.q_Stop, null);
                    PlayerImpl.this.update(event);
                    PlayerImpl.this.executeNextTx();
                    break;
                }
                default: {
                    logger.error((Object)(" SOMETHING IS BROKEN = " + responseEvent));
                    PlayerImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    PlayerImpl.this.mgcpWrapper.removeListener(PlayerImpl.this.reqId);
                    PlayerImpl.this.updateState();
                    event = new PlayerEventImpl(this.player, Player.ev_PlayComplete, Player.q_Stop, null, Error.e_Unknown, "RQNT Failed.  Look at logs " + responseEvent.getReturnCode().getComment());
                    PlayerImpl.this.update(event);
                    PlayerImpl.this.executeNextTx();
                }
            }
        }
    }
}

