/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.mediagroup.signals;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.NotificationRequestResponse;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.NotifyResponse;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.RequestedAction;
import jain.protocol.ip.mgcp.message.parms.RequestedEvent;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import jain.protocol.ip.mgcp.pkg.MgcpEvent;
import jain.protocol.ip.mgcp.pkg.PackageName;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.signals.SignalDetector;
import javax.media.mscontrol.mediagroup.signals.SignalDetectorEvent;
import javax.media.mscontrol.resource.Error;
import javax.media.mscontrol.resource.MediaEvent;
import javax.media.mscontrol.resource.MediaEventListener;
import javax.media.mscontrol.resource.Parameter;
import javax.media.mscontrol.resource.Parameters;
import javax.media.mscontrol.resource.RTC;
import javax.media.mscontrol.resource.symbols.ParameterEnum;
import org.apache.log4j.Logger;
import org.mobicents.javax.media.mscontrol.MediaSessionImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.MediaGroupImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.signals.SignalDetectorEventImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.signals.SignalDetectorState;
import org.mobicents.jsr309.mgcp.MgcpWrapper;
import org.mobicents.jsr309.mgcp.Provider;
import org.mobicents.mgcp.stack.JainMgcpExtendedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignalDetectorImpl
implements SignalDetector {
    private static Logger logger = Logger.getLogger(SignalDetectorImpl.class);
    protected CopyOnWriteArrayList<MediaEventListener<SignalDetectorEvent>> mediaEventListenerList = new CopyOnWriteArrayList();
    protected MediaGroupImpl mediaGroup = null;
    protected MediaSessionImpl mediaSession = null;
    protected MgcpWrapper mgcpWrapper = null;
    protected volatile RequestIdentifier reqId = null;
    protected volatile SignalDetectorState state = SignalDetectorState.IDLE;
    private List<String> buffer = null;

    public SignalDetectorImpl(MediaGroupImpl mediaGroup, MgcpWrapper mgcpWrapper) {
        this.mediaGroup = mediaGroup;
        this.mgcpWrapper = mgcpWrapper;
        this.mediaSession = (MediaSessionImpl)mediaGroup.getMediaSession();
        this.buffer = new ArrayList<String>();
    }

    public void flushBuffer() throws MsControlException {
        this.buffer.clear();
    }

    public void receiveSignals(int numSignals, Parameter[] patterns, RTC[] rtc, Parameters optargs) throws MsControlException {
        StartTx tx = new StartTx(this, patterns, optargs);
        Provider.submit(tx);
        this.state = SignalDetectorState.DETECTING;
    }

    public MediaGroup getContainer() {
        return this.mediaGroup;
    }

    public boolean stop() {
        if (this.state == SignalDetectorState.DETECTING) {
            StopTx tx = new StopTx(this);
            Provider.submit(tx);
            return true;
        }
        return false;
    }

    public void addListener(MediaEventListener<SignalDetectorEvent> listener) {
        this.mediaEventListenerList.add(listener);
    }

    public MediaSession getMediaSession() {
        return this.mediaSession;
    }

    public void removeListener(MediaEventListener<SignalDetectorEvent> listener) {
        this.mediaEventListenerList.remove(listener);
    }

    protected void update(SignalDetectorEvent anEvent) {
        for (MediaEventListener<SignalDetectorEvent> m : this.mediaEventListenerList) {
            m.onEvent((MediaEvent)anEvent);
        }
    }

    private class StartTx
    implements Runnable,
    JainMgcpExtendedListener {
        private int tx = -1;
        private SignalDetectorImpl detector = null;
        private Parameter[] patterns = null;
        private Parameters optargs = null;
        String[] regExp = null;
        String digitMap = null;
        String digitDetected = "";

        StartTx(SignalDetectorImpl detector, Parameter[] patterns, Parameters optargs) {
            this.detector = detector;
            this.patterns = patterns;
            this.optargs = optargs;
            boolean first = true;
            if (optargs != null) {
                this.regExp = new String[31];
                for (Parameter p : optargs.keySet()) {
                    ParameterEnum pE = (ParameterEnum)p;
                    String regExtmp = (String)optargs.get((Object)p);
                    regExtmp = regExtmp.replaceAll("x", "\\\\d");
                    regExtmp = regExtmp.replaceAll("\\*", "\\\\*");
                    regExtmp = regExtmp.replaceAll("\\.", "{0,}");
                    switch (pE) {
                        case SD_PATTERN_0: {
                            this.regExp[0] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_0 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_1: {
                            this.regExp[1] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_1 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_2: {
                            this.regExp[2] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_2 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_3: {
                            this.regExp[3] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_3 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_4: {
                            this.regExp[4] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_4 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_5: {
                            this.regExp[5] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_5 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_6: {
                            this.regExp[6] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_6 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_7: {
                            this.regExp[7] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_7 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_8: {
                            this.regExp[8] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_8 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_9: {
                            this.regExp[9] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_9 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_10: {
                            this.regExp[10] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_10 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_11: {
                            this.regExp[11] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_11 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_12: {
                            this.regExp[12] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_12 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_13: {
                            this.regExp[13] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_13 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_14: {
                            this.regExp[14] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_14 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_15: {
                            this.regExp[15] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_15 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_16: {
                            this.regExp[16] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_16 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_17: {
                            this.regExp[17] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_17 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_18: {
                            this.regExp[18] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_18 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_19: {
                            this.regExp[19] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_19 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_20: {
                            this.regExp[20] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_20 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_21: {
                            this.regExp[21] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_21 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_22: {
                            this.regExp[22] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_22 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_23: {
                            this.regExp[23] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_23 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_24: {
                            this.regExp[24] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_24 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_25: {
                            this.regExp[25] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_25 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_26: {
                            this.regExp[26] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_26 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_27: {
                            this.regExp[27] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_27 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_28: {
                            this.regExp[28] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_28 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_29: {
                            this.regExp[29] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_29 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_30: {
                            this.regExp[30] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_30 = " + regExtmp));
                            break;
                        }
                        case SD_PATTERN_31: {
                            this.regExp[31] = regExtmp;
                            if (!logger.isDebugEnabled()) break;
                            logger.debug((Object)("The Reg Exp for SD_PATTERN_31 = " + regExtmp));
                        }
                    }
                    if (first) {
                        first = false;
                        this.digitMap = regExtmp;
                        continue;
                    }
                    this.digitMap = "|" + regExtmp;
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("DigitMap formed is " + this.digitMap));
                }
            }
            if (this.digitMap == null) {
                this.digitMap = "[0-9, A,B,C,D,*,#]";
            }
        }

        public void run() {
            this.tx = SignalDetectorImpl.this.mgcpWrapper.getUniqueTransactionHandler();
            try {
                SignalDetectorImpl.this.mgcpWrapper.addListnere(this.tx, (JainMgcpExtendedListener)this);
                EndpointIdentifier endpointID = new EndpointIdentifier(SignalDetectorImpl.this.mediaGroup.getEndpoint(), SignalDetectorImpl.this.mgcpWrapper.getPeerIp() + ":" + SignalDetectorImpl.this.mgcpWrapper.getPeerPort());
                SignalDetectorImpl.this.reqId = SignalDetectorImpl.this.mgcpWrapper.getUniqueRequestIdentifier();
                SignalDetectorImpl.this.mgcpWrapper.addListnere(SignalDetectorImpl.this.reqId, (JainMgcpExtendedListener)this);
                NotificationRequest notificationRequest = new NotificationRequest((Object)this, endpointID, SignalDetectorImpl.this.reqId);
                notificationRequest.setNotifiedEntity(SignalDetectorImpl.this.mgcpWrapper.getDefaultNotifiedEntity());
                ConnectionIdentifier connId = SignalDetectorImpl.this.mediaGroup.thisConnId;
                RequestedAction[] dtmfActions = new RequestedAction[]{RequestedAction.NotifyImmediately};
                RequestedEvent dtmf0 = new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf0, connId), dtmfActions);
                RequestedEvent dtmf1 = new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf1, connId), dtmfActions);
                RequestedEvent dtmf2 = new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf2, connId), dtmfActions);
                RequestedEvent dtmf3 = new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf3, connId), dtmfActions);
                RequestedEvent dtmf4 = new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf4, connId), dtmfActions);
                RequestedEvent dtmf5 = new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf5, connId), dtmfActions);
                RequestedEvent dtmf6 = new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf6, connId), dtmfActions);
                RequestedEvent dtmf7 = new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf7, connId), dtmfActions);
                RequestedEvent dtmf8 = new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf8, connId), dtmfActions);
                RequestedEvent dtmf9 = new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmf9, connId), dtmfActions);
                RequestedEvent dtmfA = new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmfA, connId), dtmfActions);
                RequestedEvent dtmfB = new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmfB, connId), dtmfActions);
                RequestedEvent dtmfC = new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmfC, connId), dtmfActions);
                RequestedEvent dtmfD = new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmfD, connId), dtmfActions);
                RequestedEvent dtmfStar = new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmfStar, connId), dtmfActions);
                RequestedEvent dtmfHash = new RequestedEvent(new EventName(PackageName.Dtmf, MgcpEvent.dtmfHash, connId), dtmfActions);
                RequestedEvent[] requestedEvents = new RequestedEvent[]{dtmf0, dtmf1, dtmf2, dtmf3, dtmf4, dtmf5, dtmf6, dtmf7, dtmf8, dtmf9, dtmfA, dtmfB, dtmfC, dtmfD, dtmfStar, dtmfHash};
                notificationRequest.setRequestedEvents(requestedEvents);
                notificationRequest.setTransactionHandle(this.tx);
                SignalDetectorImpl.this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{notificationRequest});
            }
            catch (Exception e) {
                logger.error((Object)e);
                SignalDetectorImpl.this.state = SignalDetectorState.IDLE;
            }
        }

        public void transactionEnded(int arg0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully completed Tx = " + arg0));
            }
        }

        public void transactionRxTimedOut(JainMgcpCommandEvent arg0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Couldn't send the Tx = " + arg0));
            }
        }

        public void transactionTxTimedOut(JainMgcpCommandEvent cmdEvent) {
            logger.error((Object)("No response from MGW. Tx timed out for RQNT Tx " + this.tx + " For Command sent " + cmdEvent.toString()));
            SignalDetectorImpl.this.mgcpWrapper.removeListener(cmdEvent.getTransactionHandle());
            SignalDetectorImpl.this.mgcpWrapper.removeListener(SignalDetectorImpl.this.reqId);
            SignalDetectorEventImpl event = new SignalDetectorEventImpl(this.detector, SignalDetector.ev_ReceiveSignals, Error.e_Unknown, "No response from MGW for RQNT");
            SignalDetectorImpl.this.update(event);
        }

        public void processMgcpCommandEvent(JainMgcpCommandEvent command) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)(" The NTFY received " + command.toString()));
            }
            Notify notify = (Notify)command;
            NotifyResponse response = new NotifyResponse(notify.getSource(), ReturnCode.Transaction_Executed_Normally);
            response.setTransactionHandle(notify.getTransactionHandle());
            SignalDetectorImpl.this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{response});
            SignalDetectorImpl.this.mgcpWrapper.removeListener(notify.getRequestIdentifier());
            EventName[] observedEvents = notify.getObservedEvents();
            SignalDetectorEventImpl event = null;
            block18: for (EventName observedEvent : observedEvents) {
                switch (observedEvent.getEventIdentifier().intValue()) {
                    case 17: {
                        this.digitDetected = this.digitDetected + 0;
                        continue block18;
                    }
                    case 18: {
                        this.digitDetected = this.digitDetected + 1;
                        continue block18;
                    }
                    case 19: {
                        this.digitDetected = this.digitDetected + 2;
                        continue block18;
                    }
                    case 20: {
                        this.digitDetected = this.digitDetected + 3;
                        continue block18;
                    }
                    case 21: {
                        this.digitDetected = this.digitDetected + 4;
                        continue block18;
                    }
                    case 22: {
                        this.digitDetected = this.digitDetected + 5;
                        continue block18;
                    }
                    case 23: {
                        this.digitDetected = this.digitDetected + 6;
                        continue block18;
                    }
                    case 24: {
                        this.digitDetected = this.digitDetected + 7;
                        continue block18;
                    }
                    case 25: {
                        this.digitDetected = this.digitDetected + 8;
                        continue block18;
                    }
                    case 26: {
                        this.digitDetected = this.digitDetected + 9;
                        continue block18;
                    }
                    case 27: {
                        this.digitDetected = this.digitDetected + "A";
                        continue block18;
                    }
                    case 28: {
                        this.digitDetected = this.digitDetected + "B";
                        continue block18;
                    }
                    case 29: {
                        this.digitDetected = this.digitDetected + "C";
                        continue block18;
                    }
                    case 30: {
                        this.digitDetected = this.digitDetected + "D";
                        continue block18;
                    }
                    case 31: {
                        this.digitDetected = this.digitDetected + "#";
                        continue block18;
                    }
                    case 32: {
                        this.digitDetected = this.digitDetected + "*";
                        continue block18;
                    }
                    default: {
                        logger.error((Object)("Detected unexpected MGCP Event " + observedEvent.getEventIdentifier().toString()));
                    }
                }
            }
            event = new SignalDetectorEventImpl(this.detector, SignalDetector.ev_SignalDetected, this.digitDetected);
            SignalDetectorImpl.this.update(event);
        }

        public void processMgcpResponseEvent(JainMgcpResponseEvent respEvent) {
            switch (respEvent.getObjectIdentifier()) {
                case 207: {
                    this.processReqNotificationResponse((NotificationRequestResponse)respEvent);
                    break;
                }
                default: {
                    SignalDetectorImpl.this.mgcpWrapper.removeListener(respEvent.getTransactionHandle());
                    SignalDetectorImpl.this.mgcpWrapper.removeListener(SignalDetectorImpl.this.reqId);
                    logger.warn((Object)(" This RESPONSE is unexpected " + respEvent));
                    SignalDetectorEventImpl event = new SignalDetectorEventImpl(this.detector, SignalDetector.ev_ReceiveSignals, Error.e_Unknown, "RQNT Failed.  Look at logs " + respEvent.getReturnCode().getComment());
                    SignalDetectorImpl.this.update(event);
                }
            }
        }

        private void processReqNotificationResponse(NotificationRequestResponse responseEvent) {
            SignalDetectorEventImpl event = null;
            ReturnCode returnCode = responseEvent.getReturnCode();
            switch (returnCode.getValue()) {
                case 100: {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("Transaction " + this.tx + "is being executed. Response received = " + responseEvent));
                    break;
                }
                case 200: {
                    SignalDetectorImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    break;
                }
                case 502: {
                    SignalDetectorImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    SignalDetectorImpl.this.mgcpWrapper.removeListener(SignalDetectorImpl.this.reqId);
                    event = new SignalDetectorEventImpl(this.detector, SignalDetector.ev_ReceiveSignals, Error.e_Unknown, "RQNT Failed.  Look at logs " + responseEvent.getReturnCode().getComment());
                    SignalDetectorImpl.this.update(event);
                    break;
                }
                default: {
                    logger.error((Object)(" SOMETHING IS BROKEN = " + responseEvent));
                    SignalDetectorImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    SignalDetectorImpl.this.mgcpWrapper.removeListener(SignalDetectorImpl.this.reqId);
                    event = new SignalDetectorEventImpl(this.detector, SignalDetector.ev_ReceiveSignals, Error.e_Unknown, "RQNT Failed.  Look at logs " + responseEvent.getReturnCode().getComment());
                    SignalDetectorImpl.this.update(event);
                }
            }
        }
    }

    private class StopTx
    implements Runnable,
    JainMgcpExtendedListener {
        private int tx = -1;
        private SignalDetectorImpl detector = null;

        StopTx(SignalDetectorImpl detector) {
            this.detector = detector;
        }

        public void run() {
            try {
                this.tx = SignalDetectorImpl.this.mgcpWrapper.getUniqueTransactionHandler();
                SignalDetectorImpl.this.mgcpWrapper.addListnere(this.tx, (JainMgcpExtendedListener)this);
                SignalDetectorImpl.this.mgcpWrapper.addListnere(SignalDetectorImpl.this.reqId, (JainMgcpExtendedListener)this);
                EndpointIdentifier endpointID = new EndpointIdentifier(SignalDetectorImpl.this.mediaGroup.getEndpoint(), SignalDetectorImpl.this.mgcpWrapper.getPeerIp() + ":" + SignalDetectorImpl.this.mgcpWrapper.getPeerPort());
                NotificationRequest notificationRequest = new NotificationRequest((Object)this, endpointID, SignalDetectorImpl.this.reqId);
                notificationRequest.setNotifiedEntity(SignalDetectorImpl.this.mgcpWrapper.getDefaultNotifiedEntity());
                notificationRequest.setTransactionHandle(this.tx);
                SignalDetectorImpl.this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{notificationRequest});
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }

        public void transactionEnded(int arg0) {
        }

        public void transactionRxTimedOut(JainMgcpCommandEvent cmdEvent) {
        }

        public void transactionTxTimedOut(JainMgcpCommandEvent cmdEvent) {
            logger.error((Object)("No response from MGW. Tx timed out for RQNT Tx " + this.tx + " For Command sent " + cmdEvent.toString()));
            SignalDetectorImpl.this.mgcpWrapper.removeListener(cmdEvent.getTransactionHandle());
            SignalDetectorImpl.this.mgcpWrapper.removeListener(SignalDetectorImpl.this.reqId);
            SignalDetectorImpl.this.state = SignalDetectorState.IDLE;
        }

        public void processMgcpCommandEvent(JainMgcpCommandEvent jainmgcpcommandevent) {
        }

        public void processMgcpResponseEvent(JainMgcpResponseEvent respEvent) {
            switch (respEvent.getObjectIdentifier()) {
                case 207: {
                    this.processReqNotificationResponse((NotificationRequestResponse)respEvent);
                    break;
                }
                default: {
                    SignalDetectorImpl.this.mgcpWrapper.removeListener(respEvent.getTransactionHandle());
                    SignalDetectorImpl.this.mgcpWrapper.removeListener(SignalDetectorImpl.this.reqId);
                    SignalDetectorImpl.this.state = SignalDetectorState.IDLE;
                    logger.warn((Object)(" This RESPONSE is unexpected " + respEvent));
                }
            }
        }

        private void processReqNotificationResponse(NotificationRequestResponse responseEvent) {
            ReturnCode returnCode = responseEvent.getReturnCode();
            switch (returnCode.getValue()) {
                case 100: {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("Transaction " + this.tx + "is being executed. Response received = " + responseEvent));
                    break;
                }
                case 200: {
                    SignalDetectorImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    SignalDetectorImpl.this.mgcpWrapper.removeListener(SignalDetectorImpl.this.reqId);
                    SignalDetectorImpl.this.state = SignalDetectorState.IDLE;
                    break;
                }
                default: {
                    logger.error((Object)(" SOMETHING IS BROKEN = " + responseEvent));
                    SignalDetectorImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    SignalDetectorImpl.this.mgcpWrapper.removeListener(SignalDetectorImpl.this.reqId);
                    SignalDetectorImpl.this.state = SignalDetectorState.IDLE;
                }
            }
        }
    }
}

