/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.networkconnection;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.CreateConnection;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.DeleteConnectionResponse;
import jain.protocol.ip.mgcp.message.ModifyConnection;
import jain.protocol.ip.mgcp.message.ModifyConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConflictingParameterException;
import jain.protocol.ip.mgcp.message.parms.ConnectionDescriptor;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.media.mscontrol.Joinable;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.networkconnection.NetworkConnection;
import javax.media.mscontrol.networkconnection.NetworkConnectionConfig;
import javax.media.mscontrol.networkconnection.NetworkConnectionEvent;
import javax.media.mscontrol.networkconnection.NetworkConnectionException;
import javax.media.mscontrol.networkconnection.ResourceNotAvailableException;
import javax.media.mscontrol.resource.Action;
import javax.media.mscontrol.resource.Error;
import javax.media.mscontrol.resource.MediaEvent;
import javax.media.mscontrol.resource.MediaEventListener;
import javax.media.mscontrol.resource.Parameter;
import javax.media.mscontrol.resource.Parameters;
import javax.sdp.SdpFactory;
import org.apache.log4j.Logger;
import org.mobicents.javax.media.mscontrol.AbstractJoinableContainer;
import org.mobicents.javax.media.mscontrol.AudioJoinableStream;
import org.mobicents.javax.media.mscontrol.MediaObjectState;
import org.mobicents.javax.media.mscontrol.MediaSessionImpl;
import org.mobicents.javax.media.mscontrol.networkconnection.NetworkConnectionEventImpl;
import org.mobicents.javax.media.mscontrol.resource.ParametersImpl;
import org.mobicents.jsr309.mgcp.MgcpWrapper;
import org.mobicents.jsr309.mgcp.Provider;
import org.mobicents.mgcp.stack.JainMgcpExtendedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkConnectionImpl
extends AbstractJoinableContainer
implements NetworkConnection {
    public static Logger logger = Logger.getLogger(NetworkConnectionImpl.class);
    private URI uri = null;
    private EndpointIdentifier endpointIdentifier = null;
    private ConnectionIdentifier connectionIdentifier = null;
    private byte[] remoteSessionDescription = null;
    private byte[] localSessionDescription = null;
    private NetworkConnectionException networkConnectionException = null;
    private ResourceNotAvailableException resourceNotAvailableException = null;
    private Parameters parameters = null;
    private static final String PR_ENDPOINT_NAME = "/mobicents/media/packetrelay/$";
    private transient SdpFactory sdpFactory = SdpFactory.getInstance();
    private NetworkConnectionConfig config = null;
    protected CopyOnWriteArrayList<MediaEventListener<? extends MediaEvent<?>>> mediaEventListenerList = new CopyOnWriteArrayList();

    public NetworkConnectionImpl(MediaSessionImpl mediaSession, MgcpWrapper mgcpWrapper, NetworkConnectionConfig config) {
        super(mediaSession, mgcpWrapper, 1, PR_ENDPOINT_NAME);
        this.config = config;
        try {
            this.uri = new URI(mediaSession.getURI().toString() + "/NetworkConnection." + this.id);
        }
        catch (URISyntaxException e) {
            // empty catch block
        }
    }

    public byte[] getLocalSessionDescription() throws NetworkConnectionException {
        if (this.localSessionDescription == null) {
            throw new NetworkConnectionException("No local session description is available");
        }
        return this.localSessionDescription;
    }

    public byte[] getRemoteSessionDescription() throws NetworkConnectionException {
        if (this.remoteSessionDescription == null) {
            throw new NetworkConnectionException("No remote session description is available");
        }
        return this.remoteSessionDescription;
    }

    public void modify(byte[] localSessionDescription, byte[] remoteSessionDescription) throws NetworkConnectionException {
        this.checkState();
        if (localSessionDescription == null && remoteSessionDescription == null) {
            return;
        }
        this.remoteSessionDescription = remoteSessionDescription;
        this.networkConnectionException = null;
        this.resourceNotAvailableException = null;
        Runnable tx = this.endpointIdentifier == null ? new CreateTx(this) : new ModifyTx(this);
        Provider.submit(tx);
    }

    public void confirm() throws MsControlException {
        this.checkState();
        throw new MsControlException("Operation not yet supported");
    }

    public NetworkConnectionConfig getConfig() {
        return this.config;
    }

    public <R> R getResource(Class<R> resource) throws MsControlException {
        return null;
    }

    public void triggerRTC(Action rtca) {
    }

    public Parameters createParameters() {
        return new ParametersImpl();
    }

    public Parameters getParameters(Parameter[] params) {
        Parameters tmpParameters = this.createParameters();
        if (this.parameters != null) {
            if (params != null && params.length > 0) {
                for (Parameter p : this.parameters.keySet()) {
                    for (Parameter pArg : params) {
                        if (!p.equals(pArg)) continue;
                        tmpParameters.put((Object)p, this.parameters.get((Object)p));
                    }
                }
            } else {
                tmpParameters.putAll((Map)this.parameters);
            }
        }
        return tmpParameters;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    public void release() {
        this.checkState();
        if (this.endpointIdentifier != null) {
            DeleteTx tx = new DeleteTx(this);
            Provider.submit(tx);
        }
        try {
            Joinable[] joinableArray;
            for (Joinable joinable : joinableArray = this.getJoinees()) {
                this.unjoinInitiate(joinable, (Serializable)((Object)this));
            }
        }
        catch (MsControlException e) {
            logger.error((Object)"release of NetworkConnection failed ", (Throwable)e);
        }
        this.state = MediaObjectState.RELEASED;
    }

    public void setParameters(Parameters params) {
        this.parameters = params;
    }

    public void addListener(MediaEventListener<NetworkConnectionEvent> listener) {
        this.mediaEventListenerList.add(listener);
    }

    public void removeListener(MediaEventListener<NetworkConnectionEvent> listener) {
        this.mediaEventListenerList.remove(listener);
    }

    protected void update(NetworkConnectionEvent anEvent) {
        for (MediaEventListener<? extends MediaEvent<?>> mediaEventListener : this.mediaEventListenerList) {
            mediaEventListener.onEvent((MediaEvent)anEvent);
        }
    }

    @Override
    protected void resetContainer() {
        if (this.endpointIdentifier == null) {
            this.audioJoinableStream = null;
            this.endpoint = PR_ENDPOINT_NAME;
        }
    }

    @Override
    protected void checkState() {
        if (this.state.equals((Object)MediaObjectState.RELEASED)) {
            throw new IllegalStateException("State of container " + this.getURI() + " is released");
        }
    }

    @Override
    protected void joined(ConnectionIdentifier thisConnId, ConnectionIdentifier otherConnId) {
    }

    @Override
    protected void unjoined(ConnectionIdentifier thisConnId, ConnectionIdentifier otherConnId) {
    }

    @Override
    protected MediaObjectState getState() {
        return this.state;
    }

    static /* synthetic */ byte[] access$1502(NetworkConnectionImpl x0, byte[] x1) {
        x0.localSessionDescription = x1;
        return x1;
    }

    private class DeleteTx
    implements Runnable,
    JainMgcpExtendedListener {
        private NetworkConnectionImpl networkConnectionImpl;
        private int tx = -1;

        public DeleteTx(NetworkConnectionImpl networkConnectionImpl2) {
            this.networkConnectionImpl = networkConnectionImpl2;
        }

        public void run() {
            try {
                this.tx = NetworkConnectionImpl.this.mgcpWrapper.getUniqueTransactionHandler();
                NetworkConnectionImpl.this.mgcpWrapper.addListnere(this.tx, (JainMgcpExtendedListener)this);
                CallIdentifier callId = NetworkConnectionImpl.this.mediaSession.getCallIdentifier();
                DeleteConnection deleteConnection = new DeleteConnection((Object)this, callId, NetworkConnectionImpl.this.endpointIdentifier, NetworkConnectionImpl.this.connectionIdentifier);
                deleteConnection.setTransactionHandle(this.tx);
                NetworkConnectionImpl.this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{deleteConnection});
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }

        public void transactionEnded(int arg0) {
        }

        public void transactionRxTimedOut(JainMgcpCommandEvent arg0) {
        }

        public void transactionTxTimedOut(JainMgcpCommandEvent arg0) {
        }

        public void processMgcpCommandEvent(JainMgcpCommandEvent arg0) {
        }

        public void processMgcpResponseEvent(JainMgcpResponseEvent response) {
            if (response.getTransactionHandle() != this.tx) {
                return;
            }
            switch (response.getObjectIdentifier()) {
                case 204: {
                    this.processDeleteConnectionResponse((DeleteConnectionResponse)response);
                    break;
                }
                default: {
                    NetworkConnectionImpl.this.mgcpWrapper.removeListener(response.getTransactionHandle());
                    logger.warn((Object)(" DLCX of Netwrok connction failed RESPONSE is unexpected " + response));
                }
            }
        }

        private void processDeleteConnectionResponse(DeleteConnectionResponse responseEvent) {
            ReturnCode returnCode = responseEvent.getReturnCode();
            Object joinEvent = null;
            switch (returnCode.getValue()) {
                case 100: {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("Transaction " + responseEvent.getTransactionHandle() + "is being executed. Response received = " + responseEvent));
                    break;
                }
                case 200: {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("DLCX executed successfully for Tx = " + responseEvent.getTransactionHandle()));
                    break;
                }
                default: {
                    logger.error((Object)(" SOMETHING IS BROKEN = " + responseEvent));
                }
            }
        }
    }

    private class ModifyTx
    implements Runnable,
    JainMgcpExtendedListener {
        private NetworkConnectionImpl networkConnectionImpl;
        private int tx = -1;

        public ModifyTx(NetworkConnectionImpl networkConnectionImpl2) {
            this.networkConnectionImpl = networkConnectionImpl2;
        }

        public void run() {
            try {
                this.tx = NetworkConnectionImpl.this.mgcpWrapper.getUniqueTransactionHandler();
                NetworkConnectionImpl.this.mgcpWrapper.addListnere(this.tx, (JainMgcpExtendedListener)this);
                CallIdentifier callId = NetworkConnectionImpl.this.mediaSession.getCallIdentifier();
                ModifyConnection modifyConnection = new ModifyConnection((Object)this, callId, NetworkConnectionImpl.this.endpointIdentifier, NetworkConnectionImpl.this.connectionIdentifier);
                if (NetworkConnectionImpl.this.remoteSessionDescription != null) {
                    modifyConnection.setRemoteConnectionDescriptor(new ConnectionDescriptor(new String(NetworkConnectionImpl.this.remoteSessionDescription)));
                }
                modifyConnection.setTransactionHandle(this.tx);
                modifyConnection.setNotifiedEntity(NetworkConnectionImpl.this.mgcpWrapper.getDefaultNotifiedEntity());
                NetworkConnectionImpl.this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{modifyConnection});
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }

        public void transactionEnded(int arg0) {
        }

        public void transactionRxTimedOut(JainMgcpCommandEvent arg0) {
        }

        public void transactionTxTimedOut(JainMgcpCommandEvent jainMgcpCommandEvent) {
            logger.error((Object)("No response from MGW. Tx timed out for MGCP Tx " + this.tx + " For Command sent " + jainMgcpCommandEvent.toString()));
            NetworkConnectionImpl.this.mgcpWrapper.removeListener(jainMgcpCommandEvent.getTransactionHandle());
            NetworkConnectionEventImpl networkConnectionEvent = new NetworkConnectionEventImpl(this.networkConnectionImpl, NetworkConnection.ev_Modify, Error.e_Unknown, "No response from MGW for modify");
            NetworkConnectionImpl.this.update(networkConnectionEvent);
        }

        public void processMgcpCommandEvent(JainMgcpCommandEvent arg0) {
        }

        public void processMgcpResponseEvent(JainMgcpResponseEvent jainmgcpresponseevent) {
            switch (jainmgcpresponseevent.getObjectIdentifier()) {
                case 206: {
                    this.processMofiyConnectionResponse((ModifyConnectionResponse)jainmgcpresponseevent);
                    break;
                }
                default: {
                    NetworkConnectionImpl.this.mgcpWrapper.removeListener(jainmgcpresponseevent.getTransactionHandle());
                    logger.warn((Object)(" This RESPONSE is unexpected " + jainmgcpresponseevent));
                    NetworkConnectionEventImpl networkConnectionEvent = new NetworkConnectionEventImpl(this.networkConnectionImpl, NetworkConnection.ev_Modify, Error.e_Unknown, "modify failed. Look at logs ");
                    NetworkConnectionImpl.this.update(networkConnectionEvent);
                }
            }
        }

        private void processMofiyConnectionResponse(ModifyConnectionResponse responseEvent) {
            logger.debug((Object)" processMofiyConnectionResponse() ");
            NetworkConnectionEventImpl networkConnectionEvent = null;
            ReturnCode returnCode = responseEvent.getReturnCode();
            switch (returnCode.getValue()) {
                case 100: {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("Transaction " + this.tx + "is being executed. Response received = " + responseEvent));
                    break;
                }
                case 200: {
                    NetworkConnectionImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(" MDCX TRANSACTION_EXECUTED_NORMALLY for connectionIdentifier = " + NetworkConnectionImpl.this.connectionIdentifier + "endpointID = " + NetworkConnectionImpl.this.endpointIdentifier));
                    }
                    if (responseEvent.getLocalConnectionDescriptor() != null) {
                        NetworkConnectionImpl.access$1502(NetworkConnectionImpl.this, responseEvent.getLocalConnectionDescriptor().toString().getBytes());
                    }
                    networkConnectionEvent = new NetworkConnectionEventImpl(this.networkConnectionImpl, NetworkConnection.ev_Modify);
                    NetworkConnectionImpl.this.update(networkConnectionEvent);
                    break;
                }
                case 502: {
                    NetworkConnectionImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    networkConnectionEvent = new NetworkConnectionEventImpl(this.networkConnectionImpl, NetworkConnection.ev_Modify, Error.e_ResourceUnavailable, returnCode.getComment());
                    NetworkConnectionImpl.this.update(networkConnectionEvent);
                    break;
                }
                default: {
                    NetworkConnectionImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    logger.error((Object)(" SOMETHING IS BROKEN = " + responseEvent));
                    networkConnectionEvent = new NetworkConnectionEventImpl(this.networkConnectionImpl, NetworkConnection.ev_Modify, Error.e_Unknown, returnCode.getComment());
                    NetworkConnectionImpl.this.update(networkConnectionEvent);
                }
            }
        }
    }

    private class CreateTx
    implements Runnable,
    JainMgcpExtendedListener {
        private NetworkConnectionImpl networkConnectionImpl;
        private int tx = -1;

        public CreateTx(NetworkConnectionImpl networkConnectionImpl2) {
            this.networkConnectionImpl = networkConnectionImpl2;
        }

        public void run() {
            try {
                this.tx = NetworkConnectionImpl.this.mgcpWrapper.getUniqueTransactionHandler();
                NetworkConnectionImpl.this.mgcpWrapper.addListnere(this.tx, (JainMgcpExtendedListener)this);
                CallIdentifier callId = NetworkConnectionImpl.this.mediaSession.getCallIdentifier();
                EndpointIdentifier endpointID = new EndpointIdentifier(NetworkConnectionImpl.this.endpoint, NetworkConnectionImpl.this.mgcpWrapper.getPeerIp() + ":" + NetworkConnectionImpl.this.mgcpWrapper.getPeerPort());
                CreateConnection createConnection = new CreateConnection((Object)this, callId, endpointID, ConnectionMode.SendRecv);
                if (NetworkConnectionImpl.this.remoteSessionDescription != null) {
                    createConnection.setRemoteConnectionDescriptor(new ConnectionDescriptor(new String(NetworkConnectionImpl.this.remoteSessionDescription)));
                }
                createConnection.setTransactionHandle(this.tx);
                createConnection.setNotifiedEntity(NetworkConnectionImpl.this.mgcpWrapper.getDefaultNotifiedEntity());
                NetworkConnectionImpl.this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{createConnection});
            }
            catch (ConflictingParameterException e) {
                e.printStackTrace();
            }
        }

        public void transactionEnded(int arg0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully completed Tx = " + arg0));
            }
        }

        public void transactionRxTimedOut(JainMgcpCommandEvent arg0) {
        }

        public void transactionTxTimedOut(JainMgcpCommandEvent jainMgcpCommandEvent) {
            logger.error((Object)("No response from MGW. Tx timed out for MGCP Tx " + this.tx + " For Command sent " + jainMgcpCommandEvent.toString()));
            NetworkConnectionImpl.this.mgcpWrapper.removeListener(jainMgcpCommandEvent.getTransactionHandle());
            NetworkConnectionEventImpl networkConnectionEvent = new NetworkConnectionEventImpl(this.networkConnectionImpl, NetworkConnection.ev_Modify, Error.e_Unknown, "No response from MGW for modify");
            NetworkConnectionImpl.this.update(networkConnectionEvent);
        }

        public void processMgcpCommandEvent(JainMgcpCommandEvent arg0) {
        }

        public void processMgcpResponseEvent(JainMgcpResponseEvent jainmgcpresponseevent) {
            switch (jainmgcpresponseevent.getObjectIdentifier()) {
                case 203: {
                    this.processCreateConnectionResponse((CreateConnectionResponse)jainmgcpresponseevent);
                    break;
                }
                default: {
                    NetworkConnectionImpl.this.mgcpWrapper.removeListener(jainmgcpresponseevent.getTransactionHandle());
                    logger.warn((Object)(" This RESPONSE is unexpected " + jainmgcpresponseevent));
                    NetworkConnectionEventImpl networkConnectionEvent = new NetworkConnectionEventImpl(this.networkConnectionImpl, NetworkConnection.ev_Modify, Error.e_Unknown, "modify failed. Look at logs " + jainmgcpresponseevent.getReturnCode().getComment());
                    NetworkConnectionImpl.this.update(networkConnectionEvent);
                }
            }
        }

        private void processCreateConnectionResponse(CreateConnectionResponse responseEvent) {
            logger.debug((Object)" processCreateConnectionResponse() ");
            NetworkConnectionEventImpl networkConnectionEvent = null;
            ReturnCode returnCode = responseEvent.getReturnCode();
            switch (returnCode.getValue()) {
                case 100: {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("Transaction " + this.tx + "is being executed. Response received = " + responseEvent));
                    break;
                }
                case 200: {
                    NetworkConnectionImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    NetworkConnectionImpl.this.connectionIdentifier = responseEvent.getConnectionIdentifier();
                    NetworkConnectionImpl.this.endpointIdentifier = responseEvent.getSpecificEndpointIdentifier();
                    NetworkConnectionImpl.this.endpoint = NetworkConnectionImpl.this.endpointIdentifier.getLocalEndpointName();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(" TRANSACTION_EXECUTED_NORMALLY for connectionIdentifier = " + NetworkConnectionImpl.this.connectionIdentifier + " endpointID = " + NetworkConnectionImpl.this.endpointIdentifier));
                    }
                    NetworkConnectionImpl.access$1502(NetworkConnectionImpl.this, responseEvent.getLocalConnectionDescriptor().toString().getBytes());
                    if (NetworkConnectionImpl.this.audioJoinableStream == null) {
                        NetworkConnectionImpl.this.audioJoinableStream = new AudioJoinableStream(this.networkConnectionImpl);
                    }
                    networkConnectionEvent = new NetworkConnectionEventImpl(this.networkConnectionImpl, NetworkConnection.ev_Modify);
                    NetworkConnectionImpl.this.update(networkConnectionEvent);
                    break;
                }
                case 502: {
                    NetworkConnectionImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    networkConnectionEvent = new NetworkConnectionEventImpl(this.networkConnectionImpl, NetworkConnection.ev_Modify, Error.e_ResourceUnavailable, returnCode.getComment());
                    NetworkConnectionImpl.this.update(networkConnectionEvent);
                    break;
                }
                default: {
                    logger.error((Object)(" SOMETHING IS BROKEN = " + responseEvent));
                    NetworkConnectionImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    networkConnectionEvent = new NetworkConnectionEventImpl(this.networkConnectionImpl, NetworkConnection.ev_Modify, Error.e_Unknown, returnCode.getComment());
                    NetworkConnectionImpl.this.update(networkConnectionEvent);
                }
            }
        }
    }
}

