/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol;

import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import java.io.Serializable;
import java.net.URI;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.join.JoinEvent;
import javax.media.mscontrol.join.JoinEventListener;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.join.JoinableStream;
import org.mobicents.javax.media.mscontrol.AudioJoinableStream;
import org.mobicents.javax.media.mscontrol.MediaObjectState;
import org.mobicents.javax.media.mscontrol.MediaSessionImpl;
import org.mobicents.jsr309.mgcp.MgcpWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractJoinableContainer
implements JoinableContainer {
    protected final String id = new UID().toString();
    protected MediaSessionImpl mediaSession = null;
    protected CopyOnWriteArrayList<JoinEventListener> jointEventListenerList = new CopyOnWriteArrayList();
    protected AudioJoinableStream audioJoinableStream = null;
    protected String endpoint = null;
    protected MgcpWrapper mgcpWrapper;
    protected volatile MediaObjectState state = MediaObjectState.IDLE;
    protected int maxJoinees = 1;

    protected String getId() {
        return this.id;
    }

    public JoinableStream getJoinableStream(JoinableStream.StreamType value) throws MsControlException {
        this.checkState();
        if (value.equals((Object)JoinableStream.StreamType.audio)) {
            return this.audioJoinableStream;
        }
        return null;
    }

    public JoinableStream[] getJoinableStreams() throws MsControlException {
        this.checkState();
        if (this.audioJoinableStream != null) {
            return new JoinableStream[]{this.audioJoinableStream};
        }
        return new JoinableStream[0];
    }

    public Joinable[] getJoinees() throws MsControlException {
        this.checkState();
        Joinable[] j = null;
        if (this.audioJoinableStream != null) {
            j = new Joinable[this.audioJoinableStream.audJoinStrVsDirMap.size()];
            int count = 0;
            for (AudioJoinableStream ajs : this.audioJoinableStream.audJoinStrVsDirMap.keySet()) {
                j[count] = ajs.getContainer();
                ++count;
            }
        } else {
            j = new Joinable[]{};
        }
        return j;
    }

    public Joinable[] getJoinees(Joinable.Direction direction) throws MsControlException {
        this.checkState();
        if (this.audioJoinableStream == null) {
            return new Joinable[0];
        }
        ArrayList<JoinableContainer> absJoiCon = new ArrayList<JoinableContainer>();
        for (AudioJoinableStream key : this.audioJoinableStream.audJoinStrVsDirMap.keySet()) {
            Joinable.Direction d = this.audioJoinableStream.audJoinStrVsDirMap.get(key);
            if (!d.equals((Object)direction) && !d.equals((Object)Joinable.Direction.DUPLEX)) continue;
            absJoiCon.add(key.getContainer());
        }
        Joinable[] j = new Joinable[absJoiCon.size()];
        int count = 0;
        for (JoinableContainer a : absJoiCon) {
            j[count] = a;
            ++count;
        }
        return j;
    }

    public void join(Joinable.Direction direction, Joinable other) throws MsControlException {
        throw new MsControlException("Not supported yet. Use joinInitiate()");
    }

    public void joinInitiate(Joinable.Direction direction, Joinable other, Serializable context) throws MsControlException {
        this.checkState();
        AbstractJoinableContainer absJoiConOther = (AbstractJoinableContainer)other;
        absJoiConOther.checkState();
        if (other.equals(this)) {
            throw new MsControlException("Container " + this.getURI() + " cannot join to itself");
        }
        if (this.audioJoinableStream == null) {
            this.audioJoinableStream = new AudioJoinableStream(this);
        }
        if (absJoiConOther.audioJoinableStream == null) {
            absJoiConOther.audioJoinableStream = new AudioJoinableStream(absJoiConOther);
        }
        this.audioJoinableStream.joinInitiate(direction, (Joinable)absJoiConOther.audioJoinableStream, context);
    }

    public void unjoin(Joinable other) throws MsControlException {
        throw new MsControlException("Not supported yet. Use unjoinInitiate()");
    }

    public void unjoinInitiate(Joinable other, Serializable context) throws MsControlException {
        if (!this.state.equals((Object)MediaObjectState.RELEASED)) {
            AbstractJoinableContainer absJoiConOther = (AbstractJoinableContainer)other;
            if (!absJoiConOther.state.equals((Object)MediaObjectState.RELEASED)) {
                if (this.audioJoinableStream == null) {
                    throw new MsControlException("No stream present with this container" + this.getURI() + " for unjoin");
                }
                if (absJoiConOther.audioJoinableStream == null) {
                    throw new MsControlException("No stream present with other container " + absJoiConOther.getURI() + "for unjoin");
                }
                this.audioJoinableStream.unjoinInitiate((Joinable)absJoiConOther.audioJoinableStream, context);
            }
        }
    }

    public void addListener(JoinEventListener listener) {
        this.jointEventListenerList.add(listener);
    }

    public MediaSession getMediaSession() {
        return this.mediaSession;
    }

    public void removeListener(JoinEventListener listener) {
        this.jointEventListenerList.remove(listener);
    }

    public CopyOnWriteArrayList<JoinEventListener> getStatusEventListenerList() {
        return this.jointEventListenerList;
    }

    private void update(JoinEvent anEvent) {
        for (JoinEventListener s : this.jointEventListenerList) {
            s.onEvent(anEvent);
        }
    }

    protected void updateJoined(JoinEvent anEvent, ConnectionIdentifier thisConnId, ConnectionIdentifier otherConnId, AbstractJoinableContainer otheContainer, boolean error) {
        if (!error) {
            this.state = MediaObjectState.JOINED;
            otheContainer.state = MediaObjectState.JOINED;
            this.joined(thisConnId, otherConnId);
            otheContainer.joined(otherConnId, thisConnId);
        }
        this.update(anEvent);
    }

    protected void updateUnjoined(JoinEvent anEvent, ConnectionIdentifier thisConnId, ConnectionIdentifier otherConnId, AbstractJoinableContainer otheContainer, boolean error) {
        if (!error) {
            if (this.audioJoinableStream.audJoinStrVsDirMap.size() == 0) {
                if (!this.state.equals((Object)MediaObjectState.RELEASED)) {
                    this.state = MediaObjectState.IDLE;
                }
                this.resetContainer();
            }
            if (otheContainer.audioJoinableStream.audJoinStrVsDirMap.size() == 0) {
                if (!otheContainer.state.equals((Object)MediaObjectState.RELEASED)) {
                    otheContainer.state = MediaObjectState.IDLE;
                }
                otheContainer.resetContainer();
            }
            this.unjoined(thisConnId, otherConnId);
            otheContainer.unjoined(otherConnId, thisConnId);
        }
        this.update(anEvent);
    }

    protected ConnectionIdentifier getConnectionIdentifier(AudioJoinableStream audioJoiStreamOther) {
        ConnectionIdentifier connId = null;
        if (this.audioJoinableStream != null) {
            connId = this.audioJoinableStream.getConnectionIdentifier(audioJoiStreamOther);
        }
        return connId;
    }

    protected abstract void joined(ConnectionIdentifier var1, ConnectionIdentifier var2);

    protected abstract void unjoined(ConnectionIdentifier var1, ConnectionIdentifier var2);

    protected abstract void checkState();

    protected abstract MediaObjectState getState();

    protected abstract void resetContainer();

    protected abstract URI getURI();

    public String toString() {
        return this.getURI() + " Endpoint = " + this.endpoint;
    }
}

