/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.resource.enums.EventTypeEnum;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mobicents.javax.media.mscontrol.DefaultEventGeneratorFactory;
import org.mobicents.javax.media.mscontrol.MediaConfigImpl;
import org.mobicents.javax.media.mscontrol.ParametersImpl;
import org.mobicents.javax.media.mscontrol.SupportedFeaturesImpl;
import org.mobicents.javax.media.mscontrol.TagNames;
import org.mobicents.javax.media.mscontrol.mediagroup.PlayerEventDetectorFactory;
import org.mobicents.javax.media.mscontrol.mediagroup.RecorderEventDetectorFactory;
import org.mobicents.javax.media.mscontrol.mediagroup.signals.SignalDetectorEventDetectorFactory;
import org.mobicents.javax.media.mscontrol.resource.ExtendedParameter;
import org.mobicents.jsr309.mgcp.MgcpWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLParser
implements TagNames {
    private static final String LINE_SEPARATOR = "\n";
    public static Map<String, Parameter> strvsParameter = new HashMap<String, Parameter>();
    public static Map<String, EventType> strvsEventType = new HashMap<String, EventType>();

    private void populatePlayer(NodeList playerNodeList, MediaConfigImpl medConfimpl) {
        for (int i = 0; i < playerNodeList.getLength(); ++i) {
            ArrayList<DefaultEventGeneratorFactory> generatorList = new ArrayList<DefaultEventGeneratorFactory>();
            ArrayList<PlayerEventDetectorFactory> detectorList = new ArrayList<PlayerEventDetectorFactory>();
            Node player = playerNodeList.item(i);
            NodeList sigAndEves = player.getChildNodes();
            for (int j = 0; j < sigAndEves.getLength(); ++j) {
                Node onEndpointNode;
                Node mgcpPackageNode;
                Node mgcpEventNode;
                NodeList signalsList;
                Node sigOrEve = sigAndEves.item(j);
                if ("signal".compareTo(sigOrEve.getNodeName()) == 0) {
                    signalsList = sigOrEve.getChildNodes();
                    mgcpEventNode = signalsList.item(0);
                    mgcpPackageNode = signalsList.item(1);
                    onEndpointNode = signalsList.item(2);
                    generatorList.add(new DefaultEventGeneratorFactory(mgcpPackageNode.getTextContent(), mgcpEventNode.getTextContent(), Boolean.parseBoolean(onEndpointNode.getTextContent())));
                    continue;
                }
                if ("event".compareTo(sigOrEve.getNodeName()) != 0) continue;
                signalsList = sigOrEve.getChildNodes();
                mgcpEventNode = signalsList.item(0);
                mgcpPackageNode = signalsList.item(1);
                onEndpointNode = signalsList.item(2);
                Node eventTypeNode = signalsList.item(3);
                detectorList.add(new PlayerEventDetectorFactory(mgcpPackageNode.getTextContent(), mgcpEventNode.getTextContent(), Boolean.parseBoolean(onEndpointNode.getTextContent()), strvsEventType.get(eventTypeNode.getTextContent())));
            }
            medConfimpl.setPlayerDetFactList(detectorList);
            medConfimpl.setPlayerGeneFactList(generatorList);
            medConfimpl.setPlayer(true);
        }
    }

    private void populateRecorder(NodeList recorderNodeList, MediaConfigImpl medConfimpl) {
        for (int i = 0; i < recorderNodeList.getLength(); ++i) {
            ArrayList<DefaultEventGeneratorFactory> generatorList = new ArrayList<DefaultEventGeneratorFactory>();
            ArrayList<RecorderEventDetectorFactory> detectorList = new ArrayList<RecorderEventDetectorFactory>();
            Node recorder = recorderNodeList.item(i);
            NodeList sigAndEves = recorder.getChildNodes();
            for (int j = 0; j < sigAndEves.getLength(); ++j) {
                Node onEndpointNode;
                Node mgcpPackageNode;
                Node mgcpEventNode;
                NodeList signalsList;
                Node sigOrEve = sigAndEves.item(j);
                if ("signal".compareTo(sigOrEve.getNodeName()) == 0) {
                    signalsList = sigOrEve.getChildNodes();
                    mgcpEventNode = signalsList.item(0);
                    mgcpPackageNode = signalsList.item(1);
                    onEndpointNode = signalsList.item(2);
                    generatorList.add(new DefaultEventGeneratorFactory(mgcpPackageNode.getTextContent(), mgcpEventNode.getTextContent(), Boolean.parseBoolean(onEndpointNode.getTextContent())));
                    continue;
                }
                if ("event".compareTo(sigOrEve.getNodeName()) != 0) continue;
                signalsList = sigOrEve.getChildNodes();
                mgcpEventNode = signalsList.item(0);
                mgcpPackageNode = signalsList.item(1);
                onEndpointNode = signalsList.item(2);
                Node eventTypeNode = signalsList.item(3);
                detectorList.add(new RecorderEventDetectorFactory(mgcpPackageNode.getTextContent(), mgcpEventNode.getTextContent(), Boolean.parseBoolean(onEndpointNode.getTextContent()), strvsEventType.get(eventTypeNode.getTextContent())));
            }
            medConfimpl.setRecorderDetFactList(detectorList);
            medConfimpl.setRecorderGeneFactList(generatorList);
            medConfimpl.setRecorder(true);
        }
    }

    private void populateSignalDetector(NodeList sigDetNodeList, MediaConfigImpl medConfimpl) {
        for (int i = 0; i < sigDetNodeList.getLength(); ++i) {
            ArrayList<DefaultEventGeneratorFactory> generatorList = new ArrayList<DefaultEventGeneratorFactory>();
            ArrayList<SignalDetectorEventDetectorFactory> detectorList = new ArrayList<SignalDetectorEventDetectorFactory>();
            Node sigDet = sigDetNodeList.item(i);
            NodeList sigAnEves = sigDet.getChildNodes();
            for (int j = 0; j < sigAnEves.getLength(); ++j) {
                Node onEndpointNode;
                Node mgcpPackageNode;
                Node mgcpEventNode;
                NodeList signalsList;
                Node sigOrEve = sigAnEves.item(j);
                if ("signal".compareTo(sigOrEve.getNodeName()) == 0) {
                    signalsList = sigOrEve.getChildNodes();
                    mgcpEventNode = signalsList.item(0);
                    mgcpPackageNode = signalsList.item(1);
                    onEndpointNode = signalsList.item(2);
                    generatorList.add(new DefaultEventGeneratorFactory(mgcpPackageNode.getTextContent(), mgcpEventNode.getTextContent(), Boolean.parseBoolean(onEndpointNode.getTextContent())));
                    continue;
                }
                if ("event".compareTo(sigOrEve.getNodeName()) != 0) continue;
                signalsList = sigOrEve.getChildNodes();
                mgcpEventNode = signalsList.item(0);
                mgcpPackageNode = signalsList.item(1);
                onEndpointNode = signalsList.item(2);
                Node eventTypeNode = signalsList.item(3);
                detectorList.add(new SignalDetectorEventDetectorFactory(mgcpPackageNode.getTextContent(), mgcpEventNode.getTextContent(), Boolean.parseBoolean(onEndpointNode.getTextContent()), strvsEventType.get(eventTypeNode.getTextContent())));
            }
            medConfimpl.setSigDeteEveDetFactList(detectorList);
            medConfimpl.setSigDeteEveGeneFactList(generatorList);
            medConfimpl.setSignaldetector(true);
        }
    }

    protected MediaConfigImpl parse(MgcpWrapper mgcpWrapper, InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        NodeList sigDetNodeList;
        NodeList recorderNodeList;
        MediaConfigImpl medConfimpl = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document document = builder.parse(stream);
        Element root = document.getDocumentElement();
        NodeList params = root.getElementsByTagName("parameter");
        ParametersImpl parameters = new ParametersImpl();
        for (int i = 0; i < params.getLength(); ++i) {
            Node n = params.item(i);
            NodeList childs = n.getChildNodes();
            String key = childs.item(0).getTextContent();
            String value = childs.item(1).getTextContent();
            parameters.put(strvsParameter.get(key), (Object)value);
        }
        SupportedFeaturesImpl suppfetImpl = new SupportedFeaturesImpl();
        suppfetImpl.setParameter(parameters.keySet());
        medConfimpl = new MediaConfigImpl(mgcpWrapper);
        medConfimpl.setParameters(parameters);
        medConfimpl.setSupportedFeatures(suppfetImpl);
        NodeList playerNodeList = root.getElementsByTagName("player");
        if (playerNodeList.getLength() > 0) {
            this.populatePlayer(playerNodeList, medConfimpl);
        }
        if ((recorderNodeList = root.getElementsByTagName("recorder")).getLength() > 0) {
            this.populateRecorder(recorderNodeList, medConfimpl);
        }
        if ((sigDetNodeList = root.getElementsByTagName("signal-detector")).getLength() > 0) {
            this.populateSignalDetector(sigDetNodeList, medConfimpl);
        }
        return medConfimpl;
    }

    public String serialize(MediaConfigImpl mediaConfig) {
        StringBuffer b = new StringBuffer();
        b.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        b.append(LINE_SEPARATOR);
        b.append("<");
        b.append("resource-container");
        b.append(">");
        b.append(LINE_SEPARATOR);
        if (mediaConfig.getParameters() != null) {
            for (Parameter parameter : mediaConfig.getParameters().keySet()) {
                b.append("<").append("parameter").append(">");
                b.append(LINE_SEPARATOR);
                b.append("<").append("key").append(">");
                b.append(parameter.toString());
                b.append("</").append("key").append(">");
                b.append(LINE_SEPARATOR);
                b.append("<").append("value").append(">");
                b.append(mediaConfig.getParameters().get(parameter).toString());
                b.append("</").append("value").append(">");
                b.append(LINE_SEPARATOR);
                b.append("</").append("parameter").append(">");
                b.append(LINE_SEPARATOR);
            }
        }
        if (mediaConfig.isPlayer()) {
            b.append("<").append("player").append(">");
            b.append(LINE_SEPARATOR);
            for (DefaultEventGeneratorFactory defaultEventGeneratorFactory : mediaConfig.getPlayerGeneFactList()) {
                b.append("<").append("signal").append(">");
                b.append(LINE_SEPARATOR);
                b.append("<").append("mgcp-event").append(">");
                b.append(defaultEventGeneratorFactory.getEventName());
                b.append("</").append("mgcp-event").append(">");
                b.append(LINE_SEPARATOR);
                b.append("<").append("mgcp-package").append(">");
                b.append(defaultEventGeneratorFactory.getPkgName());
                b.append("</").append("mgcp-package").append(">");
                b.append(LINE_SEPARATOR);
                b.append("<").append("on-endpoint").append(">");
                b.append(defaultEventGeneratorFactory.isOnEndpoint());
                b.append("</").append("on-endpoint").append(">");
                b.append(LINE_SEPARATOR);
                b.append("</").append("signal").append(">");
                b.append(LINE_SEPARATOR);
            }
            if (mediaConfig.getPlayerDetFactList() != null) {
                for (PlayerEventDetectorFactory playerEventDetectorFactory : mediaConfig.getPlayerDetFactList()) {
                    b.append("<").append("event").append(">");
                    b.append(LINE_SEPARATOR);
                    b.append("<").append("mgcp-event").append(">");
                    b.append(playerEventDetectorFactory.getEventName());
                    b.append("</").append("mgcp-event").append(">");
                    b.append(LINE_SEPARATOR);
                    b.append("<").append("mgcp-package").append(">");
                    b.append(playerEventDetectorFactory.getPkgName());
                    b.append("</").append("mgcp-package").append(">");
                    b.append(LINE_SEPARATOR);
                    b.append("<").append("on-endpoint").append(">");
                    b.append(playerEventDetectorFactory.isOnEndpoint());
                    b.append("</").append("on-endpoint").append(">");
                    b.append(LINE_SEPARATOR);
                    b.append("<").append("media-event").append(">");
                    b.append(playerEventDetectorFactory.getMediaEventType().toString());
                    b.append("</").append("media-event").append(">");
                    b.append(LINE_SEPARATOR);
                    b.append("</").append("event").append(">");
                    b.append(LINE_SEPARATOR);
                }
            }
            b.append("</").append("player").append(">");
            b.append(LINE_SEPARATOR);
        }
        if (mediaConfig.isRecorder()) {
            b.append("<").append("recorder").append(">");
            b.append(LINE_SEPARATOR);
            for (DefaultEventGeneratorFactory defaultEventGeneratorFactory : mediaConfig.getRecorderGeneFactList()) {
                b.append("<").append("signal").append(">");
                b.append(LINE_SEPARATOR);
                b.append("<").append("mgcp-event").append(">");
                b.append(defaultEventGeneratorFactory.getEventName());
                b.append("</").append("mgcp-event").append(">");
                b.append(LINE_SEPARATOR);
                b.append("<").append("mgcp-package").append(">");
                b.append(defaultEventGeneratorFactory.getPkgName());
                b.append("</").append("mgcp-package").append(">");
                b.append(LINE_SEPARATOR);
                b.append("<").append("on-endpoint").append(">");
                b.append(defaultEventGeneratorFactory.isOnEndpoint());
                b.append("</").append("on-endpoint").append(">");
                b.append(LINE_SEPARATOR);
                b.append("</").append("signal").append(">");
                b.append(LINE_SEPARATOR);
            }
            if (mediaConfig.getRecorderDetFactList() != null) {
                for (RecorderEventDetectorFactory recorderEventDetectorFactory : mediaConfig.getRecorderDetFactList()) {
                    b.append("<").append("event").append(">");
                    b.append(LINE_SEPARATOR);
                    b.append("<").append("mgcp-event").append(">");
                    b.append(recorderEventDetectorFactory.getEventName());
                    b.append("</").append("mgcp-event").append(">");
                    b.append(LINE_SEPARATOR);
                    b.append("<").append("mgcp-package").append(">");
                    b.append(recorderEventDetectorFactory.getPkgName());
                    b.append("</").append("mgcp-package").append(">");
                    b.append(LINE_SEPARATOR);
                    b.append("<").append("on-endpoint").append(">");
                    b.append(recorderEventDetectorFactory.isOnEndpoint());
                    b.append("</").append("on-endpoint").append(">");
                    b.append(LINE_SEPARATOR);
                    b.append("<").append("media-event").append(">");
                    b.append(recorderEventDetectorFactory.getMediaEventType().toString());
                    b.append("</").append("media-event").append(">");
                    b.append(LINE_SEPARATOR);
                    b.append("</").append("event").append(">");
                    b.append(LINE_SEPARATOR);
                }
            }
            b.append("</").append("recorder").append(">");
            b.append(LINE_SEPARATOR);
        }
        if (mediaConfig.isSignaldetector()) {
            b.append("<").append("signal-detector").append(">");
            b.append(LINE_SEPARATOR);
            for (SignalDetectorEventDetectorFactory signalDetectorEventDetectorFactory : mediaConfig.getSigDeteEveDetFactList()) {
                b.append("<").append("event").append(">");
                b.append(LINE_SEPARATOR);
                b.append("<").append("mgcp-event").append(">");
                b.append(signalDetectorEventDetectorFactory.getEventName());
                b.append("</").append("mgcp-event").append(">");
                b.append(LINE_SEPARATOR);
                b.append("<").append("mgcp-package").append(">");
                b.append(signalDetectorEventDetectorFactory.getPkgName());
                b.append("</").append("mgcp-package").append(">");
                b.append(LINE_SEPARATOR);
                b.append("<").append("on-endpoint").append(">");
                b.append(signalDetectorEventDetectorFactory.isOnEndpoint());
                b.append("</").append("on-endpoint").append(">");
                b.append(LINE_SEPARATOR);
                b.append("<").append("media-event").append(">");
                b.append(signalDetectorEventDetectorFactory.getMediaEventType().toString());
                b.append("</").append("media-event").append(">");
                b.append(LINE_SEPARATOR);
                b.append("</").append("event").append(">");
                b.append(LINE_SEPARATOR);
            }
            b.append("</").append("signal-detector").append(">");
            b.append(LINE_SEPARATOR);
        }
        b.append("</").append("resource-container").append(">");
        return b.toString();
    }

    static {
        strvsParameter.put(ExtendedParameter.ENDPOINT_LOCAL_NAME.toString(), ExtendedParameter.ENDPOINT_LOCAL_NAME);
        strvsEventType.put(EventTypeEnum.PLAY_COMPLETED.toString(), (EventType)EventTypeEnum.PLAY_COMPLETED);
        strvsEventType.put(EventTypeEnum.SIGNAL_DETECTED.toString(), (EventType)EventTypeEnum.SIGNAL_DETECTED);
    }
}

