/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol.mediagroup;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.NotificationRequest;
import jain.protocol.ip.mgcp.message.NotificationRequestResponse;
import jain.protocol.ip.mgcp.message.Notify;
import jain.protocol.ip.mgcp.message.NotifyResponse;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.EventName;
import jain.protocol.ip.mgcp.message.parms.RequestIdentifier;
import jain.protocol.ip.mgcp.message.parms.RequestedAction;
import jain.protocol.ip.mgcp.message.parms.RequestedEvent;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.MediaEvent;
import javax.media.mscontrol.MediaEventListener;
import javax.media.mscontrol.MediaSession;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.Parameters;
import javax.media.mscontrol.Value;
import javax.media.mscontrol.mediagroup.MediaGroup;
import javax.media.mscontrol.mediagroup.Player;
import javax.media.mscontrol.mediagroup.PlayerEvent;
import javax.media.mscontrol.resource.RTC;
import javax.media.mscontrol.resource.ResourceEvent;
import org.apache.log4j.Logger;
import org.mobicents.javax.media.mscontrol.DefaultEventGeneratorFactory;
import org.mobicents.javax.media.mscontrol.MediaConfigImpl;
import org.mobicents.javax.media.mscontrol.MediaObjectState;
import org.mobicents.javax.media.mscontrol.MediaSessionImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.MediaGroupImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.PlayerEventDetectorFactory;
import org.mobicents.javax.media.mscontrol.mediagroup.PlayerEventImpl;
import org.mobicents.javax.media.mscontrol.mediagroup.PlayerState;
import org.mobicents.jsr309.mgcp.MgcpWrapper;
import org.mobicents.jsr309.mgcp.Provider;
import org.mobicents.mgcp.stack.JainMgcpExtendedListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PlayerImpl
implements Player {
    private static Logger logger = Logger.getLogger(PlayerImpl.class);
    protected MediaGroupImpl mediaGroup = null;
    protected CopyOnWriteArrayList<MediaEventListener<PlayerEvent>> mediaEventListenerList = new CopyOnWriteArrayList();
    protected MediaSessionImpl mediaSession = null;
    protected MgcpWrapper mgcpWrapper = null;
    private MediaConfigImpl config = null;
    protected volatile RequestIdentifier reqId = null;
    protected volatile PlayerState state = PlayerState.IDLE;
    private volatile LinkedList<Runnable> txList = new LinkedList();
    private List<EventName> eveNames = new ArrayList<EventName>();

    protected PlayerImpl(MediaGroupImpl mediaGroup, MgcpWrapper mgcpWrapper, MediaConfigImpl config) throws MsControlException {
        this.mediaGroup = mediaGroup;
        this.mediaSession = (MediaSessionImpl)mediaGroup.getMediaSession();
        this.mgcpWrapper = mgcpWrapper;
        this.config = config;
    }

    private void updateState() {
        this.state = this.txList.size() == 0 ? PlayerState.IDLE : PlayerState.ACTIVE;
    }

    private void executeNextTx() {
        Runnable nextTx = this.txList.poll();
        if (nextTx != null) {
            this.state = PlayerState.ACTIVE;
            Provider.submit(nextTx);
        }
    }

    public void play(URI[] uris, RTC[] arg1, Parameters params) throws MsControlException {
        for (URI uri : uris) {
            this.play(uri, arg1, params);
        }
    }

    public void play(URI uri, RTC[] arg1, Parameters params) throws MsControlException {
        if (MediaObjectState.JOINED.equals((Object)this.mediaGroup.getState())) {
            if (this.state == PlayerState.ACTIVE) {
                Object obj = null;
                if (params != null && (obj = params.get((Object)BEHAVIOUR_IF_BUSY)) != null) {
                    Value action = (Value)obj;
                    if (action == Player.QUEUE_IF_BUSY) {
                        StartTx tx = new StartTx(this, uri);
                        this.txList.add(tx);
                    } else if (action == Player.STOP_IF_BUSY) {
                        this.txList.clear();
                        StartTx tx = new StartTx(this, uri);
                        this.txList.add(tx);
                        StopTx tx1 = new StopTx(this);
                        Provider.submit(tx1);
                    } else {
                        if (action == Player.FAIL_IF_BUSY) {
                            throw new MsControlException("Player is busy");
                        }
                        logger.error((Object)("The Value " + action + " is not recognized for Parameter p_IfBusy. It has to be one of Player.v_Queue, Player.v_Stop or Player.v_Fail"));
                    }
                } else {
                    logger.warn((Object)"The Player is busy and no Parameter BEHAVIOUR_IF_BUSY passed to take necessary action");
                }
            } else {
                StartTx tx = new StartTx(this, uri);
                Provider.submit(tx);
            }
        } else {
            throw new MsControlException(this.mediaGroup.getURI() + " Container is not joined to any other container");
        }
        this.state = PlayerState.ACTIVE;
    }

    public MediaGroup getContainer() {
        return this.mediaGroup;
    }

    public boolean stop() {
        this.txList.clear();
        if (this.state == PlayerState.ACTIVE) {
            StopTx tx = new StopTx(this);
            Provider.submit(tx);
            return true;
        }
        return false;
    }

    public void addListener(MediaEventListener<PlayerEvent> listener) {
        this.mediaEventListenerList.add(listener);
    }

    public void removeListener(MediaEventListener<PlayerEvent> listener) {
        this.mediaEventListenerList.remove(listener);
    }

    public MediaSession getMediaSession() {
        return this.mediaGroup.getMediaSession();
    }

    protected void update(PlayerEvent anEvent) {
        for (MediaEventListener<PlayerEvent> m : this.mediaEventListenerList) {
            m.onEvent((MediaEvent)anEvent);
        }
    }

    private class StartTx
    implements Runnable,
    JainMgcpExtendedListener {
        private int tx = -1;
        private PlayerImpl player = null;
        private URI file = null;

        StartTx(PlayerImpl player, URI file) {
            this.player = player;
            this.file = file;
        }

        public void run() {
            this.tx = PlayerImpl.this.mgcpWrapper.getUniqueTransactionHandler();
            try {
                PlayerImpl.this.mgcpWrapper.addListnere(this.tx, (JainMgcpExtendedListener)this);
                EndpointIdentifier endpointID = new EndpointIdentifier(PlayerImpl.this.mediaGroup.getEndpoint(), PlayerImpl.this.mgcpWrapper.getPeerIp() + ":" + PlayerImpl.this.mgcpWrapper.getPeerPort());
                PlayerImpl.this.reqId = PlayerImpl.this.mgcpWrapper.getUniqueRequestIdentifier();
                PlayerImpl.this.mgcpWrapper.addListnere(PlayerImpl.this.reqId, (JainMgcpExtendedListener)this);
                NotificationRequest notificationRequest = new NotificationRequest((Object)this, endpointID, PlayerImpl.this.reqId);
                ConnectionIdentifier connId = PlayerImpl.this.mediaGroup.thisConnId;
                EventName[] signalRequests = null;
                for (DefaultEventGeneratorFactory genfact : PlayerImpl.this.config.getPlayerGeneFactList()) {
                    if (genfact.getEventName().compareTo("ann") == 0) {
                        String filePath = this.file.toString();
                        PlayerImpl.this.eveNames.add(genfact.generateMgcpEvent(filePath, connId));
                        continue;
                    }
                    PlayerImpl.this.eveNames.add(genfact.generateMgcpEvent(null, connId));
                }
                signalRequests = new EventName[PlayerImpl.this.eveNames.size()];
                PlayerImpl.this.eveNames.toArray(signalRequests);
                PlayerImpl.this.eveNames.clear();
                notificationRequest.setSignalRequests(signalRequests);
                RequestedAction[] actions = new RequestedAction[]{RequestedAction.NotifyImmediately};
                for (PlayerEventDetectorFactory detfact : PlayerImpl.this.config.getPlayerDetFactList()) {
                    PlayerImpl.this.eveNames.add(detfact.generateMgcpEvent(null, connId));
                }
                RequestedEvent[] requestedEvents = new RequestedEvent[PlayerImpl.this.eveNames.size()];
                for (int i = 0; i < requestedEvents.length; ++i) {
                    requestedEvents[i] = new RequestedEvent((EventName)PlayerImpl.this.eveNames.get(i), actions);
                }
                PlayerImpl.this.eveNames.clear();
                notificationRequest.setRequestedEvents(requestedEvents);
                notificationRequest.setTransactionHandle(this.tx);
                notificationRequest.setNotifiedEntity(PlayerImpl.this.mgcpWrapper.getDefaultNotifiedEntity());
                PlayerImpl.this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{notificationRequest});
            }
            catch (Exception e) {
                logger.error((Object)e);
                PlayerImpl.this.mgcpWrapper.removeListener(this.tx);
                PlayerImpl.this.mgcpWrapper.removeListener(PlayerImpl.this.reqId);
                PlayerImpl.this.updateState();
                PlayerEventImpl event = new PlayerEventImpl((Player)this.player, PlayerEvent.PLAY_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "Error while sending RQNt " + e.getMessage());
                PlayerImpl.this.update(event);
                PlayerImpl.this.executeNextTx();
            }
        }

        public void transactionEnded(int arg0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully completed Tx = " + arg0));
            }
        }

        public void transactionRxTimedOut(JainMgcpCommandEvent arg0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Couldn't send the Tx = " + arg0));
            }
        }

        public void transactionTxTimedOut(JainMgcpCommandEvent cmdEvent) {
            logger.error((Object)("No response from MGW. Tx timed out for RQNT Tx " + this.tx + " For Command sent " + cmdEvent.toString()));
            PlayerImpl.this.mgcpWrapper.removeListener(cmdEvent.getTransactionHandle());
            PlayerImpl.this.mgcpWrapper.removeListener(PlayerImpl.this.reqId);
            PlayerImpl.this.updateState();
            PlayerEventImpl event = new PlayerEventImpl((Player)this.player, PlayerEvent.PLAY_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "No response from MGW for RQNT");
            PlayerImpl.this.update(event);
            PlayerImpl.this.executeNextTx();
        }

        public void processMgcpCommandEvent(JainMgcpCommandEvent command) {
            logger.debug((Object)(" The NTFY received " + command.toString()));
            PlayerEventImpl event = null;
            Notify notify = (Notify)command;
            PlayerImpl.this.mgcpWrapper.removeListener(notify.getRequestIdentifier());
            switch (command.getObjectIdentifier()) {
                case 108: {
                    EventName[] observedEvents = notify.getObservedEvents();
                    PlayerImpl.this.updateState();
                    for (EventName observedEvent : observedEvents) {
                        for (PlayerEventDetectorFactory detfact : PlayerImpl.this.config.getPlayerDetFactList()) {
                            if (detfact.getPkgName().compareTo(observedEvent.getPackageName().toString()) != 0 || detfact.getEventName().compareTo(observedEvent.getEventIdentifier().getName()) != 0) continue;
                            event = (PlayerEventImpl)detfact.generateMediaEvent();
                            event.setPlayer(this.player);
                            event.setSuccessful(true);
                            event.setQualifier(ResourceEvent.STANDARD_COMPLETION);
                            PlayerImpl.this.update(event);
                            PlayerImpl.this.executeNextTx();
                        }
                    }
                    NotifyResponse response = new NotifyResponse(notify.getSource(), ReturnCode.Transaction_Executed_Normally);
                    response.setTransactionHandle(notify.getTransactionHandle());
                    PlayerImpl.this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{response});
                    break;
                }
                default: {
                    logger.error((Object)("Expected NTFY cmd. Received " + command));
                    PlayerImpl.this.updateState();
                    event = new PlayerEventImpl((Player)this.player, PlayerEvent.PLAY_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "Player failed on Server");
                    PlayerImpl.this.update(event);
                    PlayerImpl.this.executeNextTx();
                }
            }
        }

        public void processMgcpResponseEvent(JainMgcpResponseEvent respEvent) {
            switch (respEvent.getObjectIdentifier()) {
                case 207: {
                    this.processReqNotificationResponse((NotificationRequestResponse)respEvent);
                    break;
                }
                default: {
                    PlayerImpl.this.mgcpWrapper.removeListener(respEvent.getTransactionHandle());
                    PlayerImpl.this.mgcpWrapper.removeListener(PlayerImpl.this.reqId);
                    PlayerImpl.this.updateState();
                    logger.warn((Object)(" This RESPONSE is unexpected " + respEvent));
                    PlayerEventImpl event = new PlayerEventImpl((Player)this.player, PlayerEvent.PLAY_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "RQNT Failed.  Look at logs " + respEvent.getReturnCode().getComment());
                    PlayerImpl.this.update(event);
                    PlayerImpl.this.executeNextTx();
                }
            }
        }

        private void processReqNotificationResponse(NotificationRequestResponse responseEvent) {
            PlayerEventImpl event = null;
            ReturnCode returnCode = responseEvent.getReturnCode();
            switch (returnCode.getValue()) {
                case 100: {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("Transaction " + this.tx + "is being executed. Response received = " + responseEvent));
                    break;
                }
                case 200: {
                    PlayerImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    break;
                }
                case 502: {
                    PlayerImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    PlayerImpl.this.mgcpWrapper.removeListener(PlayerImpl.this.reqId);
                    PlayerImpl.this.updateState();
                    event = new PlayerEventImpl((Player)this.player, PlayerEvent.PLAY_COMPLETED, false, MediaErr.RESOURCE_UNAVAILABLE, "RQNT Failed.  Look at logs " + responseEvent.getReturnCode().getComment());
                    PlayerImpl.this.update(event);
                    PlayerImpl.this.executeNextTx();
                    break;
                }
                default: {
                    logger.error((Object)(" SOMETHING IS BROKEN = " + responseEvent));
                    PlayerImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    PlayerImpl.this.mgcpWrapper.removeListener(PlayerImpl.this.reqId);
                    PlayerImpl.this.updateState();
                    event = new PlayerEventImpl((Player)this.player, PlayerEvent.PLAY_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "RQNT Failed.  Look at logs " + responseEvent.getReturnCode().getComment());
                    PlayerImpl.this.update(event);
                    PlayerImpl.this.executeNextTx();
                }
            }
        }
    }

    private class StopTx
    implements Runnable,
    JainMgcpExtendedListener {
        private int tx = -1;
        private PlayerImpl player = null;

        StopTx(PlayerImpl player) {
            this.player = player;
        }

        public void run() {
            try {
                this.tx = PlayerImpl.this.mgcpWrapper.getUniqueTransactionHandler();
                PlayerImpl.this.mgcpWrapper.addListnere(this.tx, (JainMgcpExtendedListener)this);
                PlayerImpl.this.mgcpWrapper.addListnere(PlayerImpl.this.reqId, (JainMgcpExtendedListener)this);
                EndpointIdentifier endpointID = new EndpointIdentifier(PlayerImpl.this.mediaGroup.getEndpoint(), PlayerImpl.this.mgcpWrapper.getPeerIp() + ":" + PlayerImpl.this.mgcpWrapper.getPeerPort());
                NotificationRequest notificationRequest = new NotificationRequest((Object)this, endpointID, PlayerImpl.this.reqId);
                notificationRequest.setTransactionHandle(this.tx);
                notificationRequest.setNotifiedEntity(PlayerImpl.this.mgcpWrapper.getDefaultNotifiedEntity());
                PlayerImpl.this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{notificationRequest});
            }
            catch (Exception e) {
                logger.error((Object)e);
                PlayerImpl.this.mgcpWrapper.removeListener(this.tx);
                PlayerImpl.this.mgcpWrapper.removeListener(PlayerImpl.this.reqId);
                PlayerImpl.this.updateState();
                PlayerEventImpl event = new PlayerEventImpl((Player)this.player, PlayerEvent.PLAY_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "Error " + e.getMessage());
                PlayerImpl.this.update(event);
                PlayerImpl.this.executeNextTx();
            }
        }

        public void transactionEnded(int arg0) {
        }

        public void transactionRxTimedOut(JainMgcpCommandEvent cmdEvent) {
        }

        public void transactionTxTimedOut(JainMgcpCommandEvent cmdEvent) {
            logger.error((Object)("No response from MGW. Tx timed out for RQNT Tx " + this.tx + " For Command sent " + cmdEvent.toString()));
            PlayerImpl.this.mgcpWrapper.removeListener(cmdEvent.getTransactionHandle());
            PlayerImpl.this.mgcpWrapper.removeListener(PlayerImpl.this.reqId);
            PlayerEventImpl event = new PlayerEventImpl((Player)this.player, PlayerEvent.PLAY_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "No response from MGW for RQNT");
            PlayerImpl.this.update(event);
            PlayerImpl.this.executeNextTx();
        }

        public void processMgcpCommandEvent(JainMgcpCommandEvent arg0) {
        }

        public void processMgcpResponseEvent(JainMgcpResponseEvent respEvent) {
            switch (respEvent.getObjectIdentifier()) {
                case 207: {
                    this.processReqNotificationResponse((NotificationRequestResponse)respEvent);
                    break;
                }
                default: {
                    PlayerImpl.this.mgcpWrapper.removeListener(respEvent.getTransactionHandle());
                    PlayerImpl.this.mgcpWrapper.removeListener(PlayerImpl.this.reqId);
                    logger.warn((Object)(" This RESPONSE is unexpected " + respEvent));
                    PlayerImpl.this.updateState();
                    PlayerEventImpl event = new PlayerEventImpl((Player)this.player, PlayerEvent.PLAY_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "RQNT Failed.  Look at logs " + respEvent.getReturnCode().getComment());
                    PlayerImpl.this.update(event);
                    PlayerImpl.this.executeNextTx();
                }
            }
        }

        private void processReqNotificationResponse(NotificationRequestResponse responseEvent) {
            PlayerEventImpl event = null;
            ReturnCode returnCode = responseEvent.getReturnCode();
            switch (returnCode.getValue()) {
                case 100: {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("Transaction " + this.tx + "is being executed. Response received = " + responseEvent));
                    break;
                }
                case 200: {
                    PlayerImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    PlayerImpl.this.mgcpWrapper.removeListener(PlayerImpl.this.reqId);
                    PlayerImpl.this.updateState();
                    event = new PlayerEventImpl((Player)this.player, PlayerEvent.PLAY_COMPLETED, true, ResourceEvent.STOPPED, null);
                    PlayerImpl.this.update(event);
                    PlayerImpl.this.executeNextTx();
                    break;
                }
                default: {
                    logger.error((Object)(" SOMETHING IS BROKEN = " + responseEvent));
                    PlayerImpl.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    PlayerImpl.this.mgcpWrapper.removeListener(PlayerImpl.this.reqId);
                    PlayerImpl.this.updateState();
                    event = new PlayerEventImpl((Player)this.player, PlayerEvent.PLAY_COMPLETED, false, MediaErr.UNKNOWN_ERROR, "RQNT Failed.  Look at logs " + responseEvent.getReturnCode().getComment());
                    PlayerImpl.this.update(event);
                    PlayerImpl.this.executeNextTx();
                }
            }
        }
    }
}

