/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol;

import jain.protocol.ip.mgcp.JainMgcpCommandEvent;
import jain.protocol.ip.mgcp.JainMgcpEvent;
import jain.protocol.ip.mgcp.JainMgcpResponseEvent;
import jain.protocol.ip.mgcp.message.CreateConnection;
import jain.protocol.ip.mgcp.message.CreateConnectionResponse;
import jain.protocol.ip.mgcp.message.DeleteConnection;
import jain.protocol.ip.mgcp.message.DeleteConnectionResponse;
import jain.protocol.ip.mgcp.message.ModifyConnection;
import jain.protocol.ip.mgcp.message.ModifyConnectionResponse;
import jain.protocol.ip.mgcp.message.parms.CallIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConflictingParameterException;
import jain.protocol.ip.mgcp.message.parms.ConnectionIdentifier;
import jain.protocol.ip.mgcp.message.parms.ConnectionMode;
import jain.protocol.ip.mgcp.message.parms.EndpointIdentifier;
import jain.protocol.ip.mgcp.message.parms.ReturnCode;
import java.io.Serializable;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentHashMap;
import javax.media.mscontrol.MediaErr;
import javax.media.mscontrol.MediaObject;
import javax.media.mscontrol.MsControlException;
import javax.media.mscontrol.join.JoinEvent;
import javax.media.mscontrol.join.Joinable;
import javax.media.mscontrol.join.JoinableContainer;
import javax.media.mscontrol.join.JoinableStream;
import javax.media.mscontrol.join.TooManyJoineesException;
import javax.media.mscontrol.resource.ResourceContainer;
import org.apache.log4j.Logger;
import org.mobicents.javax.media.mscontrol.AbstractJoinableContainer;
import org.mobicents.javax.media.mscontrol.JoinEventImpl;
import org.mobicents.javax.media.mscontrol.MediaObjectState;
import org.mobicents.javax.media.mscontrol.MediaSessionImpl;
import org.mobicents.jsr309.mgcp.MgcpWrapper;
import org.mobicents.jsr309.mgcp.Provider;
import org.mobicents.mgcp.stack.JainMgcpExtendedListener;

public class AudioJoinableStream
implements JoinableStream {
    private static final Logger logger = Logger.getLogger(AudioJoinableStream.class);
    private AbstractJoinableContainer container = null;
    private final String id = new UID().toString();
    protected ConcurrentHashMap<AudioJoinableStream, Joinable.Direction> audJoinStrVsDirMap = new ConcurrentHashMap();
    protected ConcurrentHashMap<AudioJoinableStream, ConnectionIdentifier> audJoinStrVsConnIdMap = new ConcurrentHashMap();
    protected int maxJoinees = 1;
    private MgcpWrapper mgcpWrapper = null;
    private MediaSessionImpl mediaSession = null;

    public AudioJoinableStream(AbstractJoinableContainer container) {
        this.container = container;
        this.mediaSession = (MediaSessionImpl)container.getMediaSession();
        this.mgcpWrapper = container.mgcpWrapper;
        this.maxJoinees = container.maxJoinees;
    }

    protected String getId() {
        return this.id;
    }

    public JoinableContainer getContainer() {
        return this.container;
    }

    public JoinableStream.StreamType getType() {
        return JoinableStream.StreamType.audio;
    }

    protected ConnectionIdentifier getConnectionIdentifier(AudioJoinableStream audioJoiStreamOther) {
        ConnectionIdentifier connId = null;
        connId = this.audJoinStrVsConnIdMap.get(audioJoiStreamOther);
        return connId;
    }

    public Joinable[] getJoinees() throws MsControlException {
        this.container.checkState();
        Joinable[] j = new Joinable[this.audJoinStrVsDirMap.size()];
        int count = 0;
        for (AudioJoinableStream a : this.audJoinStrVsDirMap.keySet()) {
            j[count] = a;
            ++count;
        }
        return j;
    }

    public Joinable[] getJoinees(Joinable.Direction direction) throws MsControlException {
        this.container.checkState();
        ArrayList<AudioJoinableStream> audioJoiStreList = new ArrayList<AudioJoinableStream>();
        for (AudioJoinableStream key : this.audJoinStrVsDirMap.keySet()) {
            Joinable.Direction d = this.audJoinStrVsDirMap.get(key);
            if (!d.equals((Object)direction) && !d.equals((Object)Joinable.Direction.DUPLEX)) continue;
            audioJoiStreList.add(key);
        }
        Joinable[] j = new Joinable[audioJoiStreList.size()];
        int count = 0;
        for (AudioJoinableStream a : audioJoiStreList) {
            j[count] = a;
            ++count;
        }
        return j;
    }

    public void join(Joinable.Direction direction, Joinable other) throws MsControlException {
        throw new MsControlException("Not supported yet. Use joinInitiate()");
    }

    public void joinInitiate(Joinable.Direction direction, Joinable other, Serializable context) throws MsControlException {
        this.container.checkState();
        AudioJoinableStream audioJoiStreamOther = (AudioJoinableStream)other;
        audioJoiStreamOther.container.checkState();
        if (other.equals(this)) {
            throw new MsControlException("Stream cannot join to itself");
        }
        Joinable.Direction thisDir = this.audJoinStrVsDirMap.get(audioJoiStreamOther);
        Runnable tx = null;
        if (thisDir != null) {
            if (!thisDir.equals((Object)direction)) {
                ConnectionIdentifier thisConnId = this.getConnectionIdentifier(audioJoiStreamOther);
                ConnectionIdentifier otherConnId = audioJoiStreamOther.getConnectionIdentifier(this);
                tx = new ModifyTx(this, thisConnId, direction, audioJoiStreamOther, otherConnId);
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)"Requested to join already joined stream with same Direction again. Ignore");
            }
        } else {
            if (this.audJoinStrVsDirMap.size() == this.maxJoinees) {
                throw new TooManyJoineesException("Already joined " + this.maxJoinees + " times. Unjoin first and then call join");
            }
            if (audioJoiStreamOther.audJoinStrVsDirMap.size() == audioJoiStreamOther.maxJoinees) {
                throw new TooManyJoineesException("Other already joined " + audioJoiStreamOther.maxJoinees + " times. Unjoin first and then call join");
            }
            tx = new JoinTx(this, direction, audioJoiStreamOther);
        }
        Provider.submit(tx);
    }

    public void unjoin(Joinable other) throws MsControlException {
        throw new MsControlException("Not supported yet. Use unjoinInitiate()");
    }

    public void unjoinInitiate(Joinable other, Serializable context) throws MsControlException {
        if (!this.container.state.equals((Object)MediaObjectState.RELEASED)) {
            AudioJoinableStream audioJoiStreamOther = (AudioJoinableStream)other;
            if (!audioJoiStreamOther.container.state.equals((Object)MediaObjectState.RELEASED)) {
                ConnectionIdentifier thisConnId = this.getConnectionIdentifier(audioJoiStreamOther);
                if (thisConnId == null) {
                    throw new MsControlException("This stream is not connected to other stream");
                }
                ConnectionIdentifier otherConnId = audioJoiStreamOther.getConnectionIdentifier(this);
                if (otherConnId == null) {
                    throw new MsControlException("Other stream is not connected to this stream. This is Error/Leak condition");
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("UnJoinTx() with thisConnId = " + thisConnId + " and otherConnId = " + otherConnId));
                }
                UnJoinTx tx = new UnJoinTx(this, thisConnId, audioJoiStreamOther, otherConnId);
                Provider.submit(tx);
            }
        }
    }

    private ConnectionMode getConnectionMode(Joinable.Direction direction) {
        ConnectionMode mode = null;
        switch (direction) {
            case DUPLEX: {
                mode = ConnectionMode.SendRecv;
                break;
            }
            case SEND: {
                mode = ConnectionMode.SendOnly;
                break;
            }
            case RECV: {
                mode = ConnectionMode.RecvOnly;
            }
        }
        return mode;
    }

    private class JoinTx
    implements Runnable,
    JainMgcpExtendedListener,
    Serializable {
        private AudioJoinableStream thisAudJoiStr = null;
        private AudioJoinableStream otherAudJoiStr = null;
        private Joinable.Direction thisDir = null;
        private int tx = -1;

        JoinTx(AudioJoinableStream thisAudJoiStr, Joinable.Direction thisDir, AudioJoinableStream otherAudJoiStr) {
            this.thisAudJoiStr = thisAudJoiStr;
            this.thisDir = thisDir;
            this.otherAudJoiStr = otherAudJoiStr;
        }

        public void run() {
            this.tx = AudioJoinableStream.this.mgcpWrapper.getUniqueTransactionHandler();
            try {
                AudioJoinableStream.this.mgcpWrapper.addListnere(this.tx, (JainMgcpExtendedListener)this);
                CallIdentifier callId = AudioJoinableStream.this.mediaSession.getCallIdentifier();
                EndpointIdentifier endpointID = new EndpointIdentifier(((AudioJoinableStream)this.thisAudJoiStr).container.endpoint, AudioJoinableStream.this.mgcpWrapper.getPeerIp() + ":" + AudioJoinableStream.this.mgcpWrapper.getPeerPort());
                EndpointIdentifier secondEndpointID = new EndpointIdentifier(((AudioJoinableStream)this.otherAudJoiStr).container.endpoint, AudioJoinableStream.this.mgcpWrapper.getPeerIp() + ":" + AudioJoinableStream.this.mgcpWrapper.getPeerPort());
                CreateConnection createConnection = new CreateConnection((Object)this, callId, endpointID, ConnectionMode.SendRecv);
                createConnection.setSecondEndpointIdentifier(secondEndpointID);
                createConnection.setMode(AudioJoinableStream.this.getConnectionMode(this.thisDir));
                createConnection.setTransactionHandle(this.tx);
                createConnection.setNotifiedEntity(AudioJoinableStream.this.mgcpWrapper.getDefaultNotifiedEntity());
                AudioJoinableStream.this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{createConnection});
            }
            catch (ConflictingParameterException e) {
                e.printStackTrace();
            }
        }

        public void transactionEnded(int arg0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully completed Tx = " + arg0));
            }
        }

        public void transactionRxTimedOut(JainMgcpCommandEvent arg0) {
        }

        public void transactionTxTimedOut(JainMgcpCommandEvent jainMgcpCommandEvent) {
            logger.error((Object)("No response from MGW. Tx timed out for MGCP Tx " + this.tx + " For Command sent " + jainMgcpCommandEvent.toString()));
            AudioJoinableStream.this.mgcpWrapper.removeListener(jainMgcpCommandEvent.getTransactionHandle());
            JoinEventImpl joinEvent = new JoinEventImpl((MediaObject)((ResourceContainer)AudioJoinableStream.this.container), this, (Joinable)this.otherAudJoiStr.container, (Joinable)AudioJoinableStream.this.container, JoinEvent.JOINED, false, MediaErr.TIMEOUT, " Request timedout. No response from MGW");
            AudioJoinableStream.this.container.updateJoined(joinEvent, null, null, this.otherAudJoiStr.container, true);
        }

        public void processMgcpCommandEvent(JainMgcpCommandEvent arg0) {
        }

        public void processMgcpResponseEvent(JainMgcpResponseEvent jainmgcpresponseevent) {
            if (jainmgcpresponseevent.getTransactionHandle() != this.tx) {
                return;
            }
            switch (jainmgcpresponseevent.getObjectIdentifier()) {
                case 203: {
                    this.processCreateConnectionResponse((CreateConnectionResponse)jainmgcpresponseevent);
                    break;
                }
                default: {
                    AudioJoinableStream.this.mgcpWrapper.removeListener(jainmgcpresponseevent.getTransactionHandle());
                    logger.warn((Object)(" This RESPONSE is unexpected " + jainmgcpresponseevent));
                    JoinEventImpl joinEvent = new JoinEventImpl((MediaObject)((ResourceContainer)AudioJoinableStream.this.container), this, (Joinable)this.otherAudJoiStr.container, (Joinable)AudioJoinableStream.this.container, JoinEvent.JOINED, false, MediaErr.UNKNOWN_ERROR, jainmgcpresponseevent.getReturnCode().getComment());
                    AudioJoinableStream.this.container.updateJoined(joinEvent, null, null, this.otherAudJoiStr.container, true);
                }
            }
        }

        private void processCreateConnectionResponse(CreateConnectionResponse responseEvent) {
            logger.debug((Object)" processCreateConnectionResponse() ");
            ReturnCode returnCode = responseEvent.getReturnCode();
            JoinEventImpl joinEvent = null;
            switch (returnCode.getValue()) {
                case 100: {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("Transaction " + this.tx + "is being executed. Response received = " + responseEvent));
                    break;
                }
                case 200: {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("joinInitiate() executed successfully for this.endpoint = " + responseEvent.getSpecificEndpointIdentifier() + " this.other.endpoint = " + responseEvent.getSecondEndpointIdentifier()));
                    }
                    AudioJoinableStream.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    EndpointIdentifier thisEndpointIdentifier = responseEvent.getSpecificEndpointIdentifier();
                    ((AudioJoinableStream)this.thisAudJoiStr).container.endpoint = thisEndpointIdentifier.getLocalEndpointName();
                    ConnectionIdentifier thisConnId = responseEvent.getConnectionIdentifier();
                    this.thisAudJoiStr.audJoinStrVsConnIdMap.put(this.otherAudJoiStr, thisConnId);
                    EndpointIdentifier otherEndpointIdentifier = responseEvent.getSecondEndpointIdentifier();
                    ((AudioJoinableStream)this.otherAudJoiStr).container.endpoint = otherEndpointIdentifier.getLocalEndpointName();
                    ConnectionIdentifier otherConnId = responseEvent.getSecondConnectionIdentifier();
                    this.otherAudJoiStr.audJoinStrVsConnIdMap.put(this.thisAudJoiStr, otherConnId);
                    switch (this.thisDir) {
                        case SEND: {
                            this.thisAudJoiStr.audJoinStrVsDirMap.put(this.otherAudJoiStr, Joinable.Direction.SEND);
                            this.otherAudJoiStr.audJoinStrVsDirMap.put(this.thisAudJoiStr, Joinable.Direction.RECV);
                            break;
                        }
                        case RECV: {
                            this.thisAudJoiStr.audJoinStrVsDirMap.put(this.otherAudJoiStr, Joinable.Direction.RECV);
                            this.otherAudJoiStr.audJoinStrVsDirMap.put(this.thisAudJoiStr, Joinable.Direction.SEND);
                            break;
                        }
                        case DUPLEX: {
                            this.thisAudJoiStr.audJoinStrVsDirMap.put(this.otherAudJoiStr, Joinable.Direction.DUPLEX);
                            this.otherAudJoiStr.audJoinStrVsDirMap.put(this.thisAudJoiStr, Joinable.Direction.DUPLEX);
                        }
                    }
                    joinEvent = new JoinEventImpl((MediaObject)((ResourceContainer)AudioJoinableStream.this.container), this, (Joinable)this.otherAudJoiStr.container, (Joinable)AudioJoinableStream.this.container, JoinEvent.JOINED, true);
                    AudioJoinableStream.this.container.updateJoined(joinEvent, thisConnId, otherConnId, this.otherAudJoiStr.container, false);
                    break;
                }
                case 502: {
                    AudioJoinableStream.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    logger.warn((Object)("joinInitiate() executed un-successfully for this.endpoint = " + ((AudioJoinableStream)this.thisAudJoiStr).container.endpoint + " this.other.endpoint = " + ((AudioJoinableStream)this.otherAudJoiStr).container.endpoint + " " + responseEvent.getReturnCode().getComment()));
                    joinEvent = new JoinEventImpl((MediaObject)((ResourceContainer)AudioJoinableStream.this.container), this, (Joinable)this.otherAudJoiStr.container, (Joinable)AudioJoinableStream.this.container, JoinEvent.JOINED, false, MediaErr.RESOURCE_UNAVAILABLE, responseEvent.getReturnCode().getComment());
                    AudioJoinableStream.this.container.updateJoined(joinEvent, null, null, this.otherAudJoiStr.container, true);
                    break;
                }
                default: {
                    AudioJoinableStream.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    logger.error((Object)(" SOMETHING IS BROKEN = " + responseEvent));
                    joinEvent = new JoinEventImpl((MediaObject)((ResourceContainer)AudioJoinableStream.this.container), this, (Joinable)this.otherAudJoiStr.container, (Joinable)AudioJoinableStream.this.container, JoinEvent.JOINED, false, MediaErr.UNKNOWN_ERROR, responseEvent.getReturnCode().getComment());
                    AudioJoinableStream.this.container.updateJoined(joinEvent, null, null, this.otherAudJoiStr.container, true);
                }
            }
        }
    }

    private class ModifyTx
    implements Runnable,
    JainMgcpExtendedListener,
    Serializable {
        private AudioJoinableStream thisAudJoiStr = null;
        private ConnectionIdentifier thisConnId = null;
        private Joinable.Direction thisDir = null;
        private AudioJoinableStream otherAudJoiStr = null;
        private ConnectionIdentifier otherConnId = null;
        private int tx = -1;

        ModifyTx(AudioJoinableStream thisAudJoiStr, ConnectionIdentifier thisConnId, Joinable.Direction thisDir, AudioJoinableStream otherAudJoiStr, ConnectionIdentifier otherConnId) {
            this.thisAudJoiStr = thisAudJoiStr;
            this.thisConnId = thisConnId;
            this.thisDir = thisDir;
            this.otherAudJoiStr = otherAudJoiStr;
            this.otherConnId = otherConnId;
        }

        public void run() {
            try {
                this.tx = AudioJoinableStream.this.mgcpWrapper.getUniqueTransactionHandler();
                AudioJoinableStream.this.mgcpWrapper.addListnere(this.tx, (JainMgcpExtendedListener)this);
                CallIdentifier callId = AudioJoinableStream.this.mediaSession.getCallIdentifier();
                EndpointIdentifier thisEndID = new EndpointIdentifier(((AudioJoinableStream)this.thisAudJoiStr).container.endpoint, AudioJoinableStream.this.mgcpWrapper.getPeerIp() + ":" + AudioJoinableStream.this.mgcpWrapper.getPeerPort());
                ModifyConnection modifyConnection = new ModifyConnection((Object)this, callId, thisEndID, this.thisConnId);
                modifyConnection.setMode(AudioJoinableStream.this.getConnectionMode(this.thisDir));
                modifyConnection.setTransactionHandle(this.tx);
                modifyConnection.setNotifiedEntity(AudioJoinableStream.this.mgcpWrapper.getDefaultNotifiedEntity());
                AudioJoinableStream.this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{modifyConnection});
            }
            catch (Exception e) {
                logger.error((Object)e);
            }
        }

        public void transactionEnded(int arg0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully completed Tx = " + arg0));
            }
        }

        public void transactionRxTimedOut(JainMgcpCommandEvent arg0) {
        }

        public void transactionTxTimedOut(JainMgcpCommandEvent arg0) {
            AudioJoinableStream.this.mgcpWrapper.removeListener(arg0.getTransactionHandle());
            JoinEventImpl joinEvent = new JoinEventImpl((MediaObject)((ResourceContainer)AudioJoinableStream.this.container), this, (Joinable)this.otherAudJoiStr.container, (Joinable)AudioJoinableStream.this.container, JoinEvent.JOINED, false, MediaErr.TIMEOUT, "No response from MGW. Tx timed out " + arg0.toString());
            AudioJoinableStream.this.container.updateJoined(joinEvent, this.thisConnId, this.otherConnId, this.otherAudJoiStr.container, true);
        }

        public void processMgcpCommandEvent(JainMgcpCommandEvent arg0) {
        }

        public void processMgcpResponseEvent(JainMgcpResponseEvent jainmgcpresponseevent) {
            switch (jainmgcpresponseevent.getObjectIdentifier()) {
                case 206: {
                    this.processMofiyConnectionResponse((ModifyConnectionResponse)jainmgcpresponseevent);
                    break;
                }
                default: {
                    AudioJoinableStream.this.mgcpWrapper.removeListener(jainmgcpresponseevent.getTransactionHandle());
                    logger.warn((Object)(" This RESPONSE is unexpected " + jainmgcpresponseevent));
                    JoinEventImpl joinEvent = new JoinEventImpl((MediaObject)((ResourceContainer)AudioJoinableStream.this.container), this, (Joinable)this.otherAudJoiStr.container, (Joinable)AudioJoinableStream.this.container, JoinEvent.JOINED, false, MediaErr.UNKNOWN_ERROR, "Received unexpected Response " + jainmgcpresponseevent.toString());
                    AudioJoinableStream.this.container.updateJoined(joinEvent, this.thisConnId, this.otherConnId, this.otherAudJoiStr.container, true);
                }
            }
        }

        private void processMofiyConnectionResponse(ModifyConnectionResponse responseEvent) {
            logger.debug((Object)" processMofiyConnectionResponse() ");
            JoinEventImpl joinEvent = null;
            ReturnCode returnCode = responseEvent.getReturnCode();
            switch (returnCode.getValue()) {
                case 100: {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("Transaction " + this.tx + "is being executed. Response received = " + responseEvent));
                    break;
                }
                case 200: {
                    AudioJoinableStream.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)(" MDCX TRANSACTION_EXECUTED_NORMALLY for connectionIdentifier = " + this.thisConnId + "endpointID = " + ((AudioJoinableStream)this.thisAudJoiStr).container.endpoint));
                    }
                    switch (this.thisDir) {
                        case SEND: {
                            this.thisAudJoiStr.audJoinStrVsDirMap.put(this.otherAudJoiStr, Joinable.Direction.SEND);
                            this.otherAudJoiStr.audJoinStrVsDirMap.put(this.thisAudJoiStr, Joinable.Direction.RECV);
                            break;
                        }
                        case RECV: {
                            this.thisAudJoiStr.audJoinStrVsDirMap.put(this.otherAudJoiStr, Joinable.Direction.RECV);
                            this.otherAudJoiStr.audJoinStrVsDirMap.put(this.thisAudJoiStr, Joinable.Direction.SEND);
                            break;
                        }
                        case DUPLEX: {
                            this.thisAudJoiStr.audJoinStrVsDirMap.put(this.otherAudJoiStr, Joinable.Direction.DUPLEX);
                            this.otherAudJoiStr.audJoinStrVsDirMap.put(this.thisAudJoiStr, Joinable.Direction.DUPLEX);
                        }
                    }
                    joinEvent = new JoinEventImpl((MediaObject)((ResourceContainer)AudioJoinableStream.this.container), this, (Joinable)this.otherAudJoiStr.container, (Joinable)AudioJoinableStream.this.container, JoinEvent.JOINED, true);
                    AudioJoinableStream.this.container.updateJoined(joinEvent, this.thisConnId, this.otherConnId, this.otherAudJoiStr.container, false);
                    break;
                }
                default: {
                    AudioJoinableStream.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    logger.error((Object)(" SOMETHING IS BROKEN = " + responseEvent));
                    joinEvent = new JoinEventImpl((MediaObject)((ResourceContainer)AudioJoinableStream.this.container), this, (Joinable)this.otherAudJoiStr.container, (Joinable)AudioJoinableStream.this.container, JoinEvent.JOINED, false, MediaErr.UNKNOWN_ERROR, responseEvent.getReturnCode().getComment());
                    AudioJoinableStream.this.container.updateJoined(joinEvent, this.thisConnId, this.otherConnId, this.otherAudJoiStr.container, true);
                }
            }
        }
    }

    private class UnJoinTx
    implements Runnable,
    JainMgcpExtendedListener,
    Serializable {
        private AudioJoinableStream thisAudJoiStr = null;
        private AudioJoinableStream otherAudJoiStr = null;
        ConnectionIdentifier thisConnId = null;
        ConnectionIdentifier otherConnId = null;
        private int thisTx = -1;
        private int otherTx = -1;
        private volatile int noOfRespReceived = 0;
        private volatile boolean error = false;
        private volatile String errorTxt = null;

        UnJoinTx(AudioJoinableStream thisAudJoiStr, ConnectionIdentifier thisConnId, AudioJoinableStream otherAudJoiStr, ConnectionIdentifier otherConnId) {
            this.thisAudJoiStr = thisAudJoiStr;
            this.thisConnId = thisConnId;
            this.otherAudJoiStr = otherAudJoiStr;
            this.otherConnId = otherConnId;
        }

        public void run() {
            CallIdentifier callId = AudioJoinableStream.this.mediaSession.getCallIdentifier();
            this.thisTx = AudioJoinableStream.this.mgcpWrapper.getUniqueTransactionHandler();
            this.otherTx = AudioJoinableStream.this.mgcpWrapper.getUniqueTransactionHandler();
            try {
                AudioJoinableStream.this.mgcpWrapper.addListnere(this.thisTx, (JainMgcpExtendedListener)this);
                EndpointIdentifier thisEndID = new EndpointIdentifier(((AudioJoinableStream)this.thisAudJoiStr).container.endpoint, AudioJoinableStream.this.mgcpWrapper.getPeerIp() + ":" + AudioJoinableStream.this.mgcpWrapper.getPeerPort());
                DeleteConnection thisDLCX = new DeleteConnection((Object)this, callId, thisEndID, this.thisConnId);
                thisDLCX.setTransactionHandle(this.thisTx);
                AudioJoinableStream.this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{thisDLCX});
            }
            catch (Exception e) {
                logger.error((Object)"Exception ", (Throwable)e);
                AudioJoinableStream.this.mgcpWrapper.removeListener(this.thisTx);
                JoinEventImpl joinEvent = new JoinEventImpl((MediaObject)((ResourceContainer)AudioJoinableStream.this.container), this, (Joinable)this.otherAudJoiStr.container, (Joinable)AudioJoinableStream.this.container, JoinEvent.UNJOINED, false, MediaErr.UNKNOWN_ERROR, e.getMessage());
                AudioJoinableStream.this.container.updateUnjoined(joinEvent, this.thisConnId, this.otherConnId, this.otherAudJoiStr.container, true);
                return;
            }
            try {
                AudioJoinableStream.this.mgcpWrapper.addListnere(this.otherTx, (JainMgcpExtendedListener)this);
                EndpointIdentifier otherEndID = new EndpointIdentifier(((AudioJoinableStream)this.otherAudJoiStr).container.endpoint, AudioJoinableStream.this.mgcpWrapper.getPeerIp() + ":" + AudioJoinableStream.this.mgcpWrapper.getPeerPort());
                DeleteConnection otherDLCX = new DeleteConnection((Object)this, callId, otherEndID, this.otherConnId);
                otherDLCX.setTransactionHandle(this.otherTx);
                AudioJoinableStream.this.mgcpWrapper.sendMgcpEvents(new JainMgcpEvent[]{otherDLCX});
            }
            catch (Exception e) {
                logger.error((Object)"Exception ", (Throwable)e);
                this.errorTxt = this.errorTxt + " - " + e.getMessage();
                ++this.noOfRespReceived;
            }
        }

        public void transactionEnded(int arg0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Successfully completed Tx = " + arg0));
            }
        }

        public void transactionRxTimedOut(JainMgcpCommandEvent arg0) {
        }

        public void transactionTxTimedOut(JainMgcpCommandEvent jainMgcpComdEve) {
            this.error = true;
            this.errorTxt = this.errorTxt + " - No response from MGW. Tx timed out for DLCX Command sent " + jainMgcpComdEve.toString();
            logger.error((Object)this.errorTxt);
            ++this.noOfRespReceived;
            AudioJoinableStream.this.mgcpWrapper.removeListener(jainMgcpComdEve.getTransactionHandle());
            if (this.noOfRespReceived == 2) {
                JoinEventImpl joinEvent = new JoinEventImpl((MediaObject)((ResourceContainer)AudioJoinableStream.this.container), this, (Joinable)this.otherAudJoiStr.container, (Joinable)AudioJoinableStream.this.container, JoinEvent.UNJOINED, false, MediaErr.TIMEOUT, this.errorTxt);
                AudioJoinableStream.this.container.updateUnjoined(joinEvent, this.thisConnId, this.otherConnId, this.otherAudJoiStr.container, true);
            }
        }

        public void processMgcpCommandEvent(JainMgcpCommandEvent arg0) {
        }

        public void processMgcpResponseEvent(JainMgcpResponseEvent respoEve) {
            int respoTx = respoEve.getTransactionHandle();
            ++this.noOfRespReceived;
            switch (respoEve.getObjectIdentifier()) {
                case 204: {
                    this.processDeleteConnectionResponse((DeleteConnectionResponse)respoEve);
                    break;
                }
                default: {
                    logger.warn((Object)(" This RESPONSE is unexpected " + respoEve));
                    this.errorTxt = this.errorTxt + " Unexpected response";
                    this.error = true;
                    AudioJoinableStream.this.mgcpWrapper.removeListener(respoTx);
                    if (this.noOfRespReceived != 2) break;
                    JoinEventImpl joinEvent = new JoinEventImpl((MediaObject)((ResourceContainer)AudioJoinableStream.this.container), this, (Joinable)this.otherAudJoiStr.container, (Joinable)AudioJoinableStream.this.container, JoinEvent.JOINED, false, MediaErr.UNKNOWN_ERROR, this.errorTxt);
                    AudioJoinableStream.this.container.updateUnjoined(joinEvent, this.thisConnId, this.otherConnId, this.otherAudJoiStr.container, true);
                }
            }
        }

        private void processDeleteConnectionResponse(DeleteConnectionResponse responseEvent) {
            ReturnCode returnCode = responseEvent.getReturnCode();
            JoinEventImpl joinEvent = null;
            switch (returnCode.getValue()) {
                case 100: {
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("Transaction " + responseEvent.getTransactionHandle() + "is being executed. Response received = " + responseEvent));
                    break;
                }
                case 200: {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("DLCX executed successfully for Tx = " + responseEvent.getTransactionHandle()));
                    }
                    AudioJoinableStream.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    if (this.noOfRespReceived != 2) break;
                    if (!this.error) {
                        this.thisAudJoiStr.audJoinStrVsConnIdMap.remove(this.otherAudJoiStr);
                        this.otherAudJoiStr.audJoinStrVsConnIdMap.remove(this.thisAudJoiStr);
                        this.thisAudJoiStr.audJoinStrVsDirMap.remove(this.otherAudJoiStr);
                        this.otherAudJoiStr.audJoinStrVsDirMap.remove(this.thisAudJoiStr);
                        joinEvent = new JoinEventImpl((MediaObject)((ResourceContainer)AudioJoinableStream.this.container), this, (Joinable)this.otherAudJoiStr.container, (Joinable)AudioJoinableStream.this.container, JoinEvent.UNJOINED, true);
                        AudioJoinableStream.this.container.updateUnjoined(joinEvent, this.thisConnId, this.otherConnId, this.otherAudJoiStr.container, false);
                        break;
                    }
                    joinEvent = new JoinEventImpl((MediaObject)((ResourceContainer)AudioJoinableStream.this.container), this, (Joinable)this.otherAudJoiStr.container, (Joinable)AudioJoinableStream.this.container, JoinEvent.UNJOINED, false, MediaErr.UNKNOWN_ERROR, this.errorTxt);
                    AudioJoinableStream.this.container.updateUnjoined(joinEvent, this.thisConnId, this.otherConnId, this.otherAudJoiStr.container, true);
                    break;
                }
                default: {
                    logger.error((Object)(" SOMETHING IS BROKEN = " + responseEvent));
                    this.error = true;
                    this.errorTxt = this.errorTxt + " - " + responseEvent.getReturnCode().getComment();
                    AudioJoinableStream.this.mgcpWrapper.removeListener(responseEvent.getTransactionHandle());
                    if (this.noOfRespReceived != 2) break;
                    joinEvent = new JoinEventImpl((MediaObject)((ResourceContainer)AudioJoinableStream.this.container), this, (Joinable)this.otherAudJoiStr.container, (Joinable)AudioJoinableStream.this.container, JoinEvent.UNJOINED, false, MediaErr.UNKNOWN_ERROR, this.errorTxt);
                    AudioJoinableStream.this.container.updateUnjoined(joinEvent, this.thisConnId, this.otherConnId, this.otherAudJoiStr.container, true);
                }
            }
        }
    }
}

