/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.javax.media.mscontrol;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.media.mscontrol.EventType;
import javax.media.mscontrol.Parameter;
import javax.media.mscontrol.resource.enums.EventTypeEnum;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mobicents.javax.media.mscontrol.DefaultEventGeneratorFactory;
import org.mobicents.javax.media.mscontrol.MediaConfigImpl;
import org.mobicents.javax.media.mscontrol.ParametersImpl;
import org.mobicents.javax.media.mscontrol.TagNames;
import org.mobicents.javax.media.mscontrol.resource.ExtendedParameter;
import org.mobicents.jsr309.mgcp.MgcpWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XMLParser
implements TagNames {
    private static final String LINE_SEPARATOR = "\n";
    public static Map<String, Parameter> strvsParameter = new HashMap<String, Parameter>();
    public static Map<String, EventType> strvsEventType = new HashMap<String, EventType>();

    private void populatePlayer(NodeList playerNodeList, MediaConfigImpl medConfimpl) {
        for (int i = 0; i < playerNodeList.getLength(); ++i) {
            ArrayList<DefaultEventGeneratorFactory> generatorList = new ArrayList<DefaultEventGeneratorFactory>();
            ArrayList detectorList = new ArrayList();
            Node player = playerNodeList.item(i);
            NodeList sigAndEves = player.getChildNodes();
            for (int j = 0; j < sigAndEves.getLength(); ++j) {
                Node onEndpointNode;
                Node mgcpPackageNode;
                Node mgcpEventNode;
                NodeList signalsList;
                Node sigOrEve = sigAndEves.item(j);
                if ("signal".compareTo(sigOrEve.getNodeName()) == 0) {
                    signalsList = sigOrEve.getChildNodes();
                    mgcpEventNode = signalsList.item(0);
                    mgcpPackageNode = signalsList.item(1);
                    onEndpointNode = signalsList.item(2);
                    generatorList.add(new DefaultEventGeneratorFactory(mgcpPackageNode.getTextContent(), mgcpEventNode.getTextContent(), Boolean.parseBoolean(onEndpointNode.getTextContent())));
                    continue;
                }
                if ("event".compareTo(sigOrEve.getNodeName()) != 0) continue;
                signalsList = sigOrEve.getChildNodes();
                mgcpEventNode = signalsList.item(0);
                mgcpPackageNode = signalsList.item(1);
                onEndpointNode = signalsList.item(2);
                Node eventTypeNode = signalsList.item(3);
            }
        }
    }

    private void populateRecorder(NodeList recorderNodeList, MediaConfigImpl medConfimpl) {
        for (int i = 0; i < recorderNodeList.getLength(); ++i) {
            ArrayList<DefaultEventGeneratorFactory> generatorList = new ArrayList<DefaultEventGeneratorFactory>();
            ArrayList detectorList = new ArrayList();
            Node recorder = recorderNodeList.item(i);
            NodeList sigAndEves = recorder.getChildNodes();
            for (int j = 0; j < sigAndEves.getLength(); ++j) {
                Node onEndpointNode;
                Node mgcpPackageNode;
                Node mgcpEventNode;
                NodeList signalsList;
                Node sigOrEve = sigAndEves.item(j);
                if ("signal".compareTo(sigOrEve.getNodeName()) == 0) {
                    signalsList = sigOrEve.getChildNodes();
                    mgcpEventNode = signalsList.item(0);
                    mgcpPackageNode = signalsList.item(1);
                    onEndpointNode = signalsList.item(2);
                    generatorList.add(new DefaultEventGeneratorFactory(mgcpPackageNode.getTextContent(), mgcpEventNode.getTextContent(), Boolean.parseBoolean(onEndpointNode.getTextContent())));
                    continue;
                }
                if ("event".compareTo(sigOrEve.getNodeName()) != 0) continue;
                signalsList = sigOrEve.getChildNodes();
                mgcpEventNode = signalsList.item(0);
                mgcpPackageNode = signalsList.item(1);
                onEndpointNode = signalsList.item(2);
                Node eventTypeNode = signalsList.item(3);
            }
        }
    }

    private void populateSignalDetector(NodeList sigDetNodeList, MediaConfigImpl medConfimpl) {
        for (int i = 0; i < sigDetNodeList.getLength(); ++i) {
            ArrayList<DefaultEventGeneratorFactory> generatorList = new ArrayList<DefaultEventGeneratorFactory>();
            ArrayList detectorList = new ArrayList();
            Node sigDet = sigDetNodeList.item(i);
            NodeList sigAnEves = sigDet.getChildNodes();
            for (int j = 0; j < sigAnEves.getLength(); ++j) {
                Node onEndpointNode;
                Node mgcpPackageNode;
                Node mgcpEventNode;
                NodeList signalsList;
                Node sigOrEve = sigAnEves.item(j);
                if ("signal".compareTo(sigOrEve.getNodeName()) == 0) {
                    signalsList = sigOrEve.getChildNodes();
                    mgcpEventNode = signalsList.item(0);
                    mgcpPackageNode = signalsList.item(1);
                    onEndpointNode = signalsList.item(2);
                    generatorList.add(new DefaultEventGeneratorFactory(mgcpPackageNode.getTextContent(), mgcpEventNode.getTextContent(), Boolean.parseBoolean(onEndpointNode.getTextContent())));
                    continue;
                }
                if ("event".compareTo(sigOrEve.getNodeName()) != 0) continue;
                signalsList = sigOrEve.getChildNodes();
                mgcpEventNode = signalsList.item(0);
                mgcpPackageNode = signalsList.item(1);
                onEndpointNode = signalsList.item(2);
                Node eventTypeNode = signalsList.item(3);
            }
        }
    }

    protected MediaConfigImpl parse(MgcpWrapper mgcpWrapper, InputStream stream) throws ParserConfigurationException, SAXException, IOException {
        NodeList sigDetNodeList;
        NodeList recorderNodeList;
        MediaConfigImpl medConfimpl = null;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = dbf.newDocumentBuilder();
        Document document = builder.parse(stream);
        Element root = document.getDocumentElement();
        NodeList params = root.getElementsByTagName("parameter");
        ParametersImpl parameters = new ParametersImpl();
        for (int i = 0; i < params.getLength(); ++i) {
            Node n = params.item(i);
            NodeList childs = n.getChildNodes();
            String key = childs.item(0).getTextContent();
            String value = childs.item(1).getTextContent();
            parameters.put(strvsParameter.get(key), (Object)value);
        }
        NodeList playerNodeList = root.getElementsByTagName("player");
        if (playerNodeList.getLength() > 0) {
            this.populatePlayer(playerNodeList, medConfimpl);
        }
        if ((recorderNodeList = root.getElementsByTagName("recorder")).getLength() > 0) {
            this.populateRecorder(recorderNodeList, medConfimpl);
        }
        if ((sigDetNodeList = root.getElementsByTagName("signal-detector")).getLength() > 0) {
            this.populateSignalDetector(sigDetNodeList, medConfimpl);
        }
        return medConfimpl;
    }

    public String serialize(MediaConfigImpl mediaConfig) {
        StringBuffer b = new StringBuffer();
        b.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        b.append(LINE_SEPARATOR);
        b.append("<");
        b.append("resource-container");
        b.append(">");
        b.append(LINE_SEPARATOR);
        return b.toString();
    }

    static {
        strvsParameter.put(ExtendedParameter.ENDPOINT_LOCAL_NAME.toString(), ExtendedParameter.ENDPOINT_LOCAL_NAME);
        strvsEventType.put(EventTypeEnum.PLAY_COMPLETED.toString(), (EventType)EventTypeEnum.PLAY_COMPLETED);
        strvsEventType.put(EventTypeEnum.SIGNAL_DETECTED.toString(), (EventType)EventTypeEnum.SIGNAL_DETECTED);
    }
}

